#include "tgroupfilter.h"

//*********************************************************************************
//                                  TFilterItem
//*********************************************************************************

TFilterItem::TFilterItem() {
    StatSOLog = NULL;
    ServerLog = NULL;
    FilterLog = NULL;
    FnStatisticsLog = NULL;
    score = 0;
    dnrules = "";
    storagetype = STORAGE_INTERNAL;
    max_mess_count_from_login = 0;
    //Store                      = NULL;
    MainStore = NULL;
    use_external_store = false;
    FilterObj = NULL;
    m_central_renginepool = false;
    m_use_long_ipbasa = false;
#ifndef DISABLE_LONGSTORDATA
    LONGIPBASA = NULL;
#endif //DISABLE_LONGSTORDATA
}

TFilterItem::~TFilterItem() {
#ifndef DISABLE_LONGSTORDATA
    if (LONGIPBASA != NULL) {
        delete LONGIPBASA;
        LONGIPBASA = NULL;
    }
#endif //DISABLE_LONGSTORDATA

    if ((FilterObj != NULL) && (!m_central_renginepool)) {
        delete FilterObj;
        FilterObj = NULL;
    }
}

bool TFilterItem::Init(TStoreBase* main_store, STORAGETYPE storagetypeA, TString IdentA, TLogsGroupCF* LogsGroupA, TKConfig* IniFileA, TString dnrulesA, float scoreA, int renginecountA, int mintreshold, int maxtreshold, bool srvcdisabled, TRenginePoolCF* CentralFilterObj, int max_mess_count_from_loginA) {
    bool res = false;
    TLogClass* top20_log = NULL;

    Ident = IdentA;
    filtercount = renginecountA;
    storagetype = storagetypeA;
    max_mess_count_from_login = max_mess_count_from_loginA;

    use_external_store = true;
    MainStore = main_store;

    if (LogsGroupA) {
        top20_log = LogsGroupA->GetTop20Log()->GetLog(Ident);
        StatSOLog = LogsGroupA->GetStatSOLog()->GetLog(Ident);
        ServerLog = LogsGroupA->GetServerLog();
        ControlLog = LogsGroupA->GetControlLog()->GetLog(Ident);
        FilterLog = LogsGroupA->GetFilterLog();
        FnStatisticsLog = LogsGroupA->GetFnStatisticsLog();
    }
    dnrules = dnrulesA;
    score = scoreA;

    top20list.Init(top20_log, Ident);

    if ((mintreshold == 0) && (maxtreshold == 0)) {
        mintreshold = 1000;
        maxtreshold = 1500;
    }
    if ((mintreshold > 0) || (maxtreshold > 0)) {
        if (maxtreshold >= mintreshold)
            TRControl.Init(mintreshold, maxtreshold, true, srvcdisabled);
        else
            TRControl.Init(maxtreshold, mintreshold, true, srvcdisabled);
    } else
        TRControl.Init(0, 0, false, srvcdisabled);

    if (CentralFilterObj == NULL) {
        m_central_renginepool = false;
        if (FilterObj == NULL)
            FilterObj = new TRenginePoolCF();
        if (FilterObj != NULL)
            res = FilterObj->Init(ServerLog, FilterLog, FnStatisticsLog, LogsGroupA, Ident, renginecountA, dnrules, score, true);
    } else {
        m_central_renginepool = true;
        FilterObj = CentralFilterObj;
        res = true;
    }

    //long ip basa
    m_use_long_ipbasa = IniFileA->ReadBool("***" + Ident, "ipbasa_enable", false);
#ifndef DISABLE_LONGSTORDATA
    if ((IniFileA != NULL) && (m_use_long_ipbasa)) {
        ui32 ipbasa_recmaxcount = IniFileA->ReadInteger("***" + Ident, "ipbasa_recmaxcount", 0);
        ui32 ipbasa_liveday = IniFileA->ReadInteger("***" + Ident, "ipbasa_liveday", 0);
        TString ipbasa_dumpfilename = IniFileA->ReadStroka("***" + Ident, "ipbasa_dumpfilename", "");
        ui32 ipbasa_queuecapacity = IniFileA->ReadInteger("***" + Ident, "ipbasa_queuecapacity", 0);

        LONGIPBASA = new TIPBasaClass();
        if (LONGIPBASA != NULL) {
            LONGIPBASA->InitBeforeFork(Ident, IniFileA, LogsGroupA, ipbasa_recmaxcount, ipbasa_liveday, ipbasa_dumpfilename, ipbasa_queuecapacity, false);
            LONGIPBASA->InitAfterFork();
        }
    }
#endif //DISABLE_LONGSTORDATA

    return res;
}

void TFilterItem::Lock() {
    m_Mutex.Acquire();
}

void TFilterItem::UnLock() {
    m_Mutex.Release();
}

TResetResponceCF TFilterItem::Reset(const bool getreturn) {
    TResetResponceCF res;
    bool ok = false;

    Lock();

    if ((FilterObj != NULL) && (!m_central_renginepool))
        res = FilterObj->Reset(ok, getreturn);

    UnLock();

    return res;
}

TResetResponceCF TFilterItem::Reset2(const TString& dnrulesA, float scoreA) {
    TResetResponceCF res;
    bool ok = false;

    Lock();

    dnrules = dnrulesA;
    score = scoreA;

    if ((FilterObj != NULL) && (!m_central_renginepool))
        res = FilterObj->Reset2(ok, dnrulesA, scoreA);

    UnLock();

    return res;
}

/*void TFilterItem::AddStatSpam(bool spam, ui16 rcpt_count)
{
   if (MainStore != NULL)
       MainStore->AddStatSpam(Ident, spam, rcpt_count);
}*/

/*void TFilterItem::AddStatError(ui16 rcpt_count)
{
   if (MainStore != NULL)
       MainStore->AddStatError(Ident, rcpt_count);
}*/

void TFilterItem::TickEvent() {
    TString dop_stat = "";

    TRControl.CalcCPS();
    dop_stat = TRControl.GetStatistLog();

    if ((FilterObj != NULL) && (!m_central_renginepool))
        FilterObj->GetCPSList();

    top20list.EventTick();
}

bool TFilterItem::Midnight() {
    bool res = true;

    TRControl.Midnight();

#ifndef DISABLE_LONGSTORDATA
    if ((m_use_long_ipbasa) && (LONGIPBASA != NULL))
        LONGIPBASA->Midnight();
#endif //DISABLE_LONGSTORDATA

    return res;
}

void TFilterItem::Close() {
}

void TFilterItem::CleanStore() {
}

TFilterItemStat TFilterItem::GetStat1(bool include_longipbasa_stat) {
    TFilterItemStat res;

    //Lock();

    res.Ident = Ident;
    res.filter_count = filtercount;
    res.filters_cps_list = GetFiltersCPSList();
    if (MainStore != NULL) {
        //MainStore->Get(res.all_request, res.all5min, res.spam5min, res.error5min, res.all_day, res.spam_day, res.error_day, res.all_yesterday, res.spam_yesterday, res.error_yesterday);
        //MainStore->GetRCPT(res.all_request_rcpt, res.all5min_rcpt, res.spam5min_rcpt, res.error5min_rcpt, res.all_day_rcpt, res.spam_day_rcpt, res.error_day_rcpt, res.all_yesterday_rcpt, res.spam_yesterday_rcpt, res.error_yesterday_rcpt);
        res.cps = 0;                  //MainStore->CPS();
        res.storestat = TStoreStat(); //MainStore->GetStat1();
    }
    if (StatSOLog != NULL) {
        res.statsolog = StatSOLog->GetTekFilename();
        res.statsoenabled = StatSOLog->GetWriteStatus();
        res.statso_fflush = StatSOLog->FFlushStatus();
    }
    if (ControlLog != NULL) {
        res.controllog = ControlLog->GetTekFilename();
        res.controlenabled = ControlLog->GetWriteStatus();
        res.control_fflush = ControlLog->FFlushStatus();
    }
    res.score = score;
    res.ruls = dnrules;
    res.central_filter_pool = m_central_renginepool;
    res.max_mess_count_from_login = max_mess_count_from_login;

    res.in_cps = TRControl.GetInMPS();
    res.rcv_cps = TRControl.GetRcvMPS();
    res.srvc_disabled = false; //TRControl.GetSrvcDisabled();
    res.control_disabled = !TRControl.GetSkeepRegime();
    res.view_cps_str = TRControl.GetStatistMin();
    res.view_cps_str_full = TRControl.GetStatist();
    res.koef = TRControl.GetKoef();

    if (include_longipbasa_stat) {
#ifndef DISABLE_LONGSTORDATA
        if (LONGIPBASA != NULL) {
            res.longipbasa_enable = true;
            res.ipbasa_queue_stat = LONGIPBASA->GetIPQueueStat();
            res.ipbasa_stat = LONGIPBASA->GetIPHashStat();
        }
#endif //DISABLE_LONGSTORDATA
    }

    //UnLock();

    return res;
}

TFilterItemMonStat TFilterItem::GetMonStat() {
    TFilterItemMonStat res;

    res.Ident = Ident;
    res.workcount = m_rcv_counter.GetDiff();
    res.blacklogin = m_blacklogin_counter.GetDiff();
    res.whitelogin = m_whitelogin_counter.GetDiff();
    res.maxrequestfromlogin = m_maxrequestfromlogin_counter.GetDiff();
    res.skeep = m_skeep_counter.GetDiff();

    return res;
}

THashMap<TString, TString> TFilterItem::GetExtendedStat() {
    if (MainStore != NULL)
        return THashMap<TString, TString>(); //MainStore->GetExtendedStat();
    else {
        THashMap<TString, TString> empty;
        return empty;
    }
}

TString TFilterItem::GetFiltersCPSList() {
    TString res = "";

    if (FilterObj != NULL) //���������� ��� ��� ����������, ��� � ��� ������������ ���� ��������
        res = FilterObj->GetCPSList();

    return res;
}

bool TFilterItem::Skeep() {
    return TRControl.Skeep();
}

//*********************************************************************************
//                                  TGroupFilter
//*********************************************************************************

TGroupFilter::TGroupFilter() {
    delaysstorage = NULL;
    LogsGroup = NULL;
    ServerLog = NULL;
    FilterLog = NULL;
    FnStatisticsLog = NULL;
    dumppath = "";
    last_write_dump = 0;
    storagetype = STORAGE_INTERNAL;
    CentralRenginePool = NULL;
    central_rengine_pool_dnrules = "";
    central_rengine_pool_score = 0;
    central_rengine_pool_filter_count = 1;
    savetime = time(NULL);
    //#ifdef MONGO_STORAGE
    //   CommonStore       = new TMongoStore();
    //#else
    //   CommonStore       = new TStoreLock();
    //#endif
}

TGroupFilter::~TGroupFilter() {
    Lock();

    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            delete (*it).second;
            (*it).second = NULL;
        }
        ++it;
    }
    data.clear();

    if (MainStore != NULL) {
        delete MainStore;
        MainStore = NULL;
    }

    if (CentralRenginePool != NULL) {
        delete CentralRenginePool;
        CentralRenginePool = NULL;
    }

    UnLock();
}

void TGroupFilter::Init(TServiceType servicetypeA,
                        STORAGETYPE /*storagetypeA*/,
                        const TString& server_hostname,
                        const TString& server_code,
                        const TString& server_start_time,
                        const TString& server_version,
                        TLogsGroupCF* LogsGroupA,
                        TAllowService* AllowServiceA,
                        TKConfig* IniFileA,
                        TDelaysStorageMain* delaysstorageA) {
    TString srvr_storage = "HASH";

    delaysstorage = delaysstorageA;
    IniFile = IniFileA;
    LogsGroup = LogsGroupA;
    AllowService = AllowServiceA;
    if (LogsGroup != NULL) {
        ServerLog = LogsGroup->GetServerLog();
        FilterLog = LogsGroup->GetFilterLog();
        FnStatisticsLog = LogsGroup->GetFnStatisticsLog();
    }

    if (IniFile != NULL) {
        srvr_storage = Trim(IniFile->ReadStroka("server", "storage", "HASH"));
        if (!srvr_storage.empty())
            srvr_storage.to_upper(0, srvr_storage.length() - 1);
        dumppath = IniFile->ReadPath("server", "dumppath", "");
        load_at_startup = IniFile->ReadBool("server", "load_at_startup", false);
        write_dump = IniFile->ReadBool("server", "write_dump", false);
        last_write_dump = time(NULL);

        central_rengine_pool_dnrules = IniFile->ReadStroka("filter", "dnRules", "");
        central_rengine_pool_score = IniFile->ReadFloat("filter", "score", DEFAULT_SCORE);
        central_rengine_pool_filter_count = IniFile->ReadInteger("filter", "filtercount", DEFAULT_RENGINE_COUNT);
        CentralRenginePool = new TRenginePoolCF();
        if (CentralRenginePool != NULL) {
            CentralRenginePool->Init(ServerLog, FilterLog, FnStatisticsLog, LogsGroup, "central_pool", central_rengine_pool_filter_count, central_rengine_pool_dnrules, central_rengine_pool_score, false);
        }

        if (srvr_storage == "POSTGRE")
            MainStore = new TDataBasaPostgre();
        else
            MainStore = new TDataBasaHash();
        if (MainStore != NULL) {
            MainStore->InitBeforeFork(servicetypeA, server_hostname, server_code, server_start_time, server_version, LogsGroupA, IniFileA);
        }
    }

    if (AllowService != NULL) {
        TServiceListT servicelist;
        TServiceListTIt it;

        AllowService->ServiceList(servicelist);

        Lock();

        it = servicelist.begin();
        while (it != servicelist.end()) {
            GetItem((*it), 0);
            ++it;
        }

        //if (IniFile != NULL)
        //   IniFile->RewriteDiskFile();

        UnLock();
    }
}

void TGroupFilter::InitAfterFork() {
    if (MainStore != NULL)
        MainStore->InitAfterFork();
}

void TGroupFilter::RemoveItem() {
    TFilterItemHashIt it, itdel;

    itdel = data.end();
    it = data.begin();
    while (it != data.end()) {
        if (itdel != data.end()) {
            if ((*itdel).second != NULL) {
                delete (*itdel).second;
                (*itdel).second = NULL;
            }
            data.erase(itdel);
        }
        if (!AllowService->ExistsService((*it).first))
            itdel = it;

        ++it;
    }
    if (itdel != data.end()) {
        if ((*itdel).second != NULL) {
            delete (*itdel).second;
            (*itdel).second = NULL;
        }
        data.erase(itdel);
    }
}

/*bool TGroupFilter::ReloadService()
{
   bool res = false;

   if (AllowService != NULL)
   {
      TServiceListT   servicelist;
      TServiceListTIt it;
   TString         servicesstr = "";

      if (IniFile != NULL)
      {
         IniFile->ReloadAll();
         servicesstr = IniFile->ReadStroka("server", "allowservices", "");
      }
      if (!servicesstr.empty())
         AllowService->LoadServices(servicesstr);
      AllowService->ServiceList(servicelist);

      Lock();

      //RemoveItem();
      it = servicelist.begin();
      while (it != servicelist.end())
      {
         GetItemByReloadServices((*it), 0);
         ++it;
      }

      //if (IniFile != NULL)
      //   IniFile->RewriteDiskFile();

      UnLock();

      res = true;
   }
   return res;
}*/

void TGroupFilter::Lock() {
    m_Mutex.Acquire();
}

void TGroupFilter::UnLock() {
    m_Mutex.Release();
}

TFilterItem* TGroupFilter::GetItem(const TString& Ident, ui64 NumbRequest) {
    TFilterItem* res = NULL;
    TFilterItemHashIt it;
    TString rid = "";
    TString Ident_up = "";
    bool exists = false;

    if (NumbRequest > 0)
        rid = "##" + UI64ToStroka(NumbRequest);
    else
        rid = "-";

    Ident_up = Ident;
    Ident_up.to_upper(0, Ident_up.length());

    it = data.find(Ident_up);
    if (it != data.end()) {
        res = (*it).second;

    } else {
        if (AllowService->ExistsService(Ident_up)) {
            res = CreateServiceBase(Ident_up, exists, false, "", "");

        } else {
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\tUnknown service: %s", rid.c_str(), Ident_up.c_str());
        }
    }

    return res;
}

TFilterItem* TGroupFilter::GetItemByReloadServices(const TString& Ident, ui64 NumbRequest) {
    TFilterItem* res = NULL;
    TString rid = "";
    TString Ident_up = "";
    bool exists = false;

    if (NumbRequest > 0)
        rid = "##" + UI64ToStroka(NumbRequest);
    else
        rid = "-";

    Ident_up = Ident;
    Ident_up.to_upper(0, Ident_up.length());

    if (AllowService->ExistsService(Ident_up)) {
        res = CreateServiceBase(Ident_up, exists, false, "", "");
        if (exists && (res != NULL)) {
            TString dnRules = "";
            float Score = DEFAULT_SCORE;
            TString dnRules_t = "";
            float Score_t = DEFAULT_SCORE;

            dnRules_t = IniFile->ReadStroka("filter", "rules", "");
            Score_t = IniFile->ReadFloat("filter", "score", DEFAULT_SCORE);

            dnRules = IniFile->ReadStroka("***" + Ident, "rules", dnRules_t);
            Score = IniFile->ReadFloat("***" + Ident, "score", Score_t);

            if ((dnRules != res->GetRules()) || (Score != res->GetScore())) {
                if (res->Reset2(dnRules, Score).flag_ok) {
                    if (ServerLog != NULL)
                        ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\tReload service: %s - OK", rid.c_str(), Ident_up.c_str());
                } else {
                    if (ServerLog != NULL)
                        ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\tFAILED: Reload service: %s", rid.c_str(), Ident_up.c_str());
                }
            }
        }
    } else {
        if (ServerLog != NULL)
            ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\tUnknown service: %s", rid.c_str(), Ident_up.c_str());
    }

    return res;
}

TFilterItem* TGroupFilter::GetFilterItem(const TString& Ident, const TString& NumbRequest) {
    TFilterItem* res = NULL;
    TFilterItemHashIt it;
    TString rid = "";

    rid = NumbRequest;

    //Lock();

    it = data.find(Ident);
    if (it != data.end()) {
        res = (*it).second;
    } else {
        if (ServerLog != NULL)
            ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\tUnknown service: %s", rid.c_str(), Ident.c_str());
        it = data.find(UNKNOWNSERVICE);
        if (it != data.end())
            res = (*it).second;
    }

    //UnLock();

    return res;
}

bool TGroupFilter::IsUnknownService(const TString& Ident) {
    bool res = false;
    TFilterItemHashIt it;

    //Lock();

    it = data.find(Ident);
    if (it != data.end()) {
        res = false;
    } else {
        it = data.find(UNKNOWNSERVICE);
        if (it != data.end())
            res = true;
    }

    //UnLock();

    return res;
}

bool TGroupFilter::Midnight() {
    bool res = true;

    //Lock();

    if (MainStore != NULL)
        MainStore->Midnight();

    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            if (!(*it).second->Midnight())
                res = false;
        }
        ++it;
    }

    //UnLock();

    return res;
}

bool TGroupFilter::Reset() {
    bool res = true;

    //Lock();

    if (CentralRenginePool != NULL) {
        bool ok = false;

        res = CentralRenginePool->Reset(ok, false).flag_ok;
    }

    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            if (!(*it).second->Reset(false).flag_ok)
                res = false;
        }
        ++it;
    }

    //UnLock();

    return res;
}

TResetResponceCF TGroupFilter::ReloadRules() {
    TResetResponceCF res;
    TResetResponceCF res_t;
    std::list<TString> rulespathlist;
    std::list<TString>::iterator rulespathlistit;
    TString rulespath = "";
    bool exists = false;
    bool ok = false;

    res.flag_ok = true;
    //����������� ���
    if (CentralRenginePool != NULL) {
        rulespath = Trim(central_rengine_pool_dnrules);
        rulespath.to_upper(0, rulespath.size());
        rulespathlist.push_back(rulespath);
        res_t = CentralRenginePool->Reset(ok, true);
        if (!res_t.flag_ok)
            res.flag_ok = false;
        res.text = res.text + res_t.text + "\n";
        res.filterres = res.filterres + "<br><br><font color='green'><b>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</b><br><b>RULES PATH \"" + rulespath + "\":</b><br><b>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</b><br></font><br>" + res_t.filterres + "<br>\n";
    }
    //�� ���������
    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            rulespath = Trim((*it).second->GetRules());
            rulespath.to_upper(0, rulespath.size());
            exists = false;
            rulespathlistit = rulespathlist.begin();
            while (rulespathlistit != rulespathlist.end()) {
                if (rulespath == (*rulespathlistit)) {
                    exists = true;
                    break;
                }

                ++rulespathlistit;
            }
            if (!exists) {
                rulespathlist.push_back(rulespath);
                res_t = (*it).second->Reset(true);
                if (!res_t.flag_ok)
                    res.flag_ok = false;

                res.text = res.text + res_t.text + "\n";
                res.filterres = res.filterres + "<br><br><font color='green'><b>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</b><br><b>RULES PATH \"" + rulespath + "\":</b><br><b>!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!</b><br></font><br>" + res_t.filterres + "<br>\n";

            } else {
                if (!(*it).second->Reset(false).flag_ok)
                    res.flag_ok = false;
            }
        }
        ++it;
    }

    return res;
}

void TGroupFilter::Close() {
    //Lock();

    if (MainStore != NULL)
        MainStore->Clear();

    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL)
            (*it).second->Close();

        ++it;
    }

    //UnLock();
}

void TGroupFilter::CleanStore() {
    //Lock();

    if (MainStore != NULL)
        MainStore->Clear();

    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL)
            (*it).second->CleanStore();

        ++it;
    }

    //UnLock();
}

void TGroupFilter::TickEvent() {
    //Lock();

    if (CentralRenginePool != NULL) {
        CentralRenginePool->GetCPSList();
        WriteStatCentralFilterPoool();
    }

    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL)
            (*it).second->TickEvent();

        ++it;
    }

    if (MainStore != NULL)
        MainStore->EventTick();

    //UnLock();
}

TFilterItemStat TGroupFilter::GetSummaryStoreStatistik1() {
    TFilterItemStat res;

    if (MainStore != NULL) {
        res.Ident = MainStore->GetIdent();
        res.storestat = TStoreStat(); //MainStore->GetStat1();
    }

    return res;
}

TFilterItemMonStat TGroupFilter::GetSummaryStoreMonStatistik() {
    TFilterItemMonStat res;

    //if (CommonStore != NULL)
    //   res = CommonStore->GetMonStat();

    return res;
}

int TGroupFilter::GetStatist(TStatList& statlist) {
    int res = 0;
    TFilterItemStat stat;

    //Lock();

    statlist.clear();
    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            stat = (*it).second->GetStat1(true);
            //stat.extstat = (*it).second->GetExtendedStat();
            statlist.push_back(stat);
        }

        ++it;
    }
    statlist.push_back(GetSummaryStoreStatistik1());
    res = statlist.size();

    //UnLock();

    return res;
}

int TGroupFilter::GetMonStatist(TMonStatList& statlist) {
    int res = 0;
    TFilterItemMonStat stat;

    //Lock();

    statlist.clear();
    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            stat = (*it).second->GetMonStat();
            statlist.push_back(stat);
        }

        ++it;
    }
    //statlist.push_back(GetSummaryStoreMonStatistik());
    res = statlist.size();

    //UnLock();

    return res;
}

THashMap<TString, TString> TGroupFilter::GetCommonExtendedStatist() {
    if (MainStore != NULL)
        return THashMap<TString, TString>(); //MainStore->GetExtendedStat();
    else {
        THashMap<TString, TString> empty;
        return empty;
    }
}

int TGroupFilter::CreateServiceF(TString& ServiceName, TString& score, TString& rules) {
    int res = -1;
    bool exists = false;
    TString tstr = "";

    tstr = ServiceName;
    if (!tstr.empty()) {
        tstr.to_upper(0, tstr.length());
        if ((tstr == UNKNOWNSERVICE) || (tstr == UNKNOWNSERVICE_DIR))
            return -1;
    }
    if (CreateServiceBase(ServiceName, exists, true, score, rules) != NULL) {
        if (exists)
            res = 1;
        else
            res = 0;
    }

    return res;
}

bool ForceDirecories(TString dir) {
    bool res = false;

    try {
        MakePathIfNotExist(dir.c_str());
        res = true;
    } catch (const yexception&) {
        res = false;
    }

    return res;
}

TFilterItem* TGroupFilter::CreateServiceBase(TString& ServiceName, bool& exists, bool /*writereaddisk*/, const TString& /*score*/, const TString& /*rules*/) {
    TFilterItem* res = NULL;
    TString Ident = "";
    TFilterItemHashIt it;
    TString rid = "";

    exists = false;
    Ident = ServiceName;
    Ident.to_upper(0, Ident.length());
    it = data.find(Ident);
    if (it == data.end()) {
        TFilterItem* fi = NULL;
        TBaseLogClass* StatSOLog = NULL;
        TBaseLogClass* ControlLog = NULL;
        TString deliverylog_st = "FAILED";
        TString statsolog_st = "FAILED";
        TString controllog_st = "FAILED";
        TString mainlogpath = "";
        TString mainlogpath2 = "";
        TString servicesstr = "";
        TString dnRules = "";
        int renginecount = 1;
        int renginecount_t = 1;
        float Score = DEFAULT_SCORE;
        TString dnRules_t = "";
        float Score_t = DEFAULT_SCORE;
        TAllowService as;
        TString st = "";
        TString sident = "";
        int mintreshold = 0;
        int maxtreshold = 0;
        bool srvcdisabled = false;
        bool central_rengine_pool = true;
        bool init_ok = false;
        int max_mess_count_from_login = 0;
        bool service_notfound = false;
        bool service_conf_notfound = false;

        if (IniFile != NULL) {
            //if (writereaddisk)
            //   IniFile->ReloadAll();

            dnRules_t = IniFile->ReadStroka("filter", "rules", "");
            Score_t = IniFile->ReadFloat("filter", "score", DEFAULT_SCORE);
            renginecount_t = IniFile->ReadInteger("filter", "filtercount", DEFAULT_RENGINE_COUNT);

            //create service directory
            if (Ident == UNKNOWNSERVICE)
                sident = UNKNOWNSERVICE_DIR;
            else
                sident = Ident;

            mainlogpath = IniFile->ReadPath("logs", "mainlogpath", "");
#ifdef _win_
            mainlogpath2 = mainlogpath + sident + "\\";
#else
            mainlogpath2 = mainlogpath + sident + "/";
#endif
            ForceDirecories(mainlogpath2);
            if (!IniFile->SectionExists("***" + Ident)) {
                /*IniFile->WriteStroka("***" + Ident, "delivery_log", mainlogpath2 + "delivery.log");
            IniFile->WriteStroka("***" + Ident, "statso_log", mainlogpath2 + "statso.log");
            IniFile->WriteBool("***" + Ident, "statso_enable", true);
            IniFile->WriteStroka("***" + Ident, "control_log", mainlogpath2 + "control.log");
            IniFile->WriteBool("***" + Ident, "control_enable", true);
            IniFile->WriteInteger("***" + Ident, "mintreshold", 0);
            IniFile->WriteInteger("***" + Ident, "maxtreshold", 0);
            IniFile->WriteBool("***" + Ident, "srvcdisabled", false);
            IniFile->WriteInteger("***" + Ident, "max_mess_count_from_login", 0);

            if (!score.empty())
            {
               st = FloatToStr(Score_t);
               if (st != score)
                  IniFile->WriteStroka("***" + Ident, "score", score);
            }

            if (!rules.empty())
            {
               if (rules != dnRules_t)
                  IniFile->WriteStroka("***" + Ident, "rules", rules);
            }

            writeflag = true;*/

                service_conf_notfound = true;
            }

            servicesstr = IniFile->ReadStroka("server", "allowservices", "");
            as.LoadServices(servicesstr);
            if (!as.ExistsService(Ident)) {
                /*if (!servicesstr.empty())
                servicesstr = servicesstr + ", " + Ident;
             else
                servicesstr = Ident;
             IniFile->WriteStroka("server", "allowservices", servicesstr);
             writeflag = true;*/

                service_notfound = true;
            }

            /*if (writeflag && writereaddisk)
            IniFile->RewriteDiskFile();*/

            central_rengine_pool = ((!IniFile->KeyExists("***" + Ident, "rules")) || (!IniFile->KeyExists("***" + Ident, "score")));
            if (!central_rengine_pool) {
                dnRules = IniFile->ReadStroka("***" + Ident, "rules", dnRules_t);
                Score = IniFile->ReadFloat("***" + Ident, "score", Score_t);
            } else {
                dnRules = dnRules_t;
                Score = Score_t;
            }
            renginecount = IniFile->ReadInteger("***" + Ident, "filtercount", renginecount_t);
            mintreshold = IniFile->ReadInteger("***" + Ident, "mintreshold", 0);
            maxtreshold = IniFile->ReadInteger("***" + Ident, "maxtreshold", 0);
            srvcdisabled = IniFile->ReadBool("***" + Ident, "srvcdisabled", false);
            max_mess_count_from_login = IniFile->ReadInteger("***" + Ident, "max_mess_count_from_login", 0);
        }

        if (service_notfound) {
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\tFAILED: service not found: %s", rid.c_str(), Ident.c_str());

        } else if (service_conf_notfound) {
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\tFAILED: service config not found: %s", rid.c_str(), Ident.c_str());

        } else {
            if ((LogsGroup != NULL) && (LogsGroup->GetStatSOLog() != NULL))
                StatSOLog = LogsGroup->GetStatSOLog()->GetLog(Ident);

            if ((LogsGroup != NULL) && (LogsGroup->GetControlLog() != NULL))
                ControlLog = LogsGroup->GetControlLog()->GetLog(Ident);

            if (StatSOLog != NULL) {
                statsolog_st = StatSOLog->GetTekFilename();

                if (StatSOLog->IsOpenFile())
                    statsolog_st += ", OPEN";
                else
                    statsolog_st += ", CLOSE";

                statsolog_st += ", " + StatSOLog->FFlushStatus();
            }

            if (ControlLog != NULL) {
                controllog_st = ControlLog->GetTekFilename();

                if (ControlLog->IsOpenFile())
                    controllog_st += ", OPEN";
                else
                    controllog_st += ", CLOSE";

                controllog_st += ", " + ControlLog->FFlushStatus();
            }

            fi = new TFilterItem();
            if (fi != NULL) {
                if (central_rengine_pool)
                    init_ok = fi->Init(MainStore, storagetype, Ident, LogsGroup, IniFile, dnRules, Score, renginecount, mintreshold, maxtreshold, srvcdisabled, CentralRenginePool, max_mess_count_from_login);
                else
                    init_ok = fi->Init(MainStore, storagetype, Ident, LogsGroup, IniFile, dnRules, Score, renginecount, mintreshold, maxtreshold, srvcdisabled, NULL, max_mess_count_from_login);

            } else {
                init_ok = false;
            }

            if (delaysstorage != NULL)
                delaysstorage->AddSrvc(Ident);

            if (init_ok) {
                data[Ident] = fi;
                res = fi;
                if (ServerLog != NULL) {
                    ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%15s\tCREATE NEW ITEM: %s", rid.c_str(), Ident.c_str());
                    ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\tCreate delivery log for item %s: %s", rid.c_str(), Ident.c_str(), deliverylog_st.c_str());
                    ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\tCreate statso log for item %s: %s", rid.c_str(), Ident.c_str(), statsolog_st.c_str());
                    ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\tCreate control log for item %s: %s", rid.c_str(), Ident.c_str(), controllog_st.c_str());
                }
            } else {
                if (fi != NULL) {
                    delete fi;
                    fi = NULL;
                }

                if (ServerLog != NULL)
                    ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\tFAILED: create new item: %s", rid.c_str(), Ident.c_str());
            }
        }

    } else {
        res = (*it).second;
        exists = true;
    }

    return res;
}

bool TGroupFilter::CompareTM(tm& tb, tm& te) {
    bool res = false;

    if ((tb.tm_year == te.tm_year) && (tb.tm_mon == te.tm_mon) && (tb.tm_mday == te.tm_mday) && (tb.tm_hour == te.tm_hour) && (tb.tm_min == te.tm_min))
        res = true;

    return res;
}

void TGroupFilter::WriteStatCentralFilterPoool() {
    if ((CentralRenginePool != NULL) && (LogsGroup != NULL) && (LogsGroup->GetCPFStatLog() != NULL)) {
        tm t1, t2;
        time_t currenttime = time(NULL);
        TString datas = "";

        t1 = *localtime(&currenttime);
        t2 = *localtime(&savetime);
        if (((t1.tm_min % 5) == 0) && (!CompareTM(t1, t2))) {
            datas = CentralRenginePool->GetServiceCalcData();
            LogsGroup->GetCPFStatLog()->WriteMessage("%4u.%02u.%02u\t%02u:%02u:00\t%s\n", t1.tm_year + 1900, t1.tm_mon + 1, t1.tm_mday, t1.tm_hour, t1.tm_min, datas.c_str());
            savetime = currenttime;
        }
    }
}

void TGroupFilter::GetServicesList(TServiceFullStatList& srvc_list) {
    srvc_list.clear();

    TFilterItemHashIt it = data.begin();
    while (it != data.end()) {
        /*if ((*it).second != NULL)
        {

        }*/
        srvc_list.push_back(TServiceFullStat(it->first));

        ++it;
    }
}
