#pragma once

#include "util/system/mutex.h"
#include "util/generic/string.h"
#include "util/generic/hash.h"
#include "util/folder/dirut.h"
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/sp/spamstop.h>
#include "tlogsgroup_cf.h"
#include "tallowservice.h"
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include "tstorebase.h"
#include "tdelaysstorage.h"
#include "top20list.h"
#include "tcheckform_types.h"
#include "trenginepool_cf.h"
#include "tdatabasa_hash.h"
#include "tparams.h"
#include "tdatabasa_postgre.h"

#define DISABLE_LONGSTORDATA
//*********************************************************************************
//                                  TFilterItem
//*********************************************************************************

struct TFilterItemStat {
    TString Ident;
    float cps;
    int filter_count;
    TString filters_cps_list;

    float in_cps;
    float rcv_cps;
    bool srvc_disabled;
    bool control_disabled;
    TString view_cps_str;
    TString view_cps_str_full;
    ui32 koef;

    ui64 all_request;
    ui32 all5min;
    ui32 spam5min;
    ui32 error5min;
    ui32 all_day;
    ui32 spam_day;
    ui32 error_day;
    ui32 all_yesterday;
    ui32 spam_yesterday;
    ui32 error_yesterday;

    ui64 all_request_rcpt;
    ui32 all5min_rcpt;
    ui32 spam5min_rcpt;
    ui32 error5min_rcpt;
    ui32 all_day_rcpt;
    ui32 spam_day_rcpt;
    ui32 error_day_rcpt;
    ui32 all_yesterday_rcpt;
    ui32 spam_yesterday_rcpt;
    ui32 error_yesterday_rcpt;

    TStoreStat storestat;
    THashMap<TString, TString> extstat;
    TString statsolog;
    TString controllog;
    bool statsoenabled;
    bool controlenabled;
    TString statso_fflush;
    TString control_fflush;
    TString ruls;
    float score;
    bool central_filter_pool;
    int max_mess_count_from_login;

    bool longipbasa_enable;
    TString ipbasa_queue_stat;
    TString ipbasa_stat;

    TFilterItemStat() {
        clear();
    }

    void clear() {
        Ident = "";
        cps = 0;
        filter_count = 0;
        filters_cps_list = "";
        in_cps = 0;
        rcv_cps = 0;
        srvc_disabled = false;
        control_disabled = false;
        view_cps_str = "";
        view_cps_str_full = "";
        koef = 0;
        all_request = 0;
        all5min = 0;
        spam5min = 0;
        error5min = 0;
        all_day = 0;
        spam_day = 0;
        error_day = 0;
        all_yesterday = 0;
        spam_yesterday = 0;
        error_yesterday = 0;
        all_request_rcpt = 0;
        all5min_rcpt = 0;
        spam5min_rcpt = 0;
        error5min_rcpt = 0;
        all_day_rcpt = 0;
        spam_day_rcpt = 0;
        error_day_rcpt = 0;
        all_yesterday_rcpt = 0;
        spam_yesterday_rcpt = 0;
        error_yesterday_rcpt = 0;
        storestat.clear();
        extstat.clear();
        statsolog = "";
        controllog = "";
        statsoenabled = false;
        controlenabled = false;
        statso_fflush = "";
        control_fflush = "";
        ruls = "";
        score = 0;
        central_filter_pool = false;
        max_mess_count_from_login = 0;
        longipbasa_enable = false;
        ipbasa_queue_stat = "";
        ipbasa_stat = "";
    }
};

struct TFilterItemMonStat {
    TString Ident;
    ui32 workcount;
    ui32 blacklogin;
    ui32 whitelogin;
    ui32 maxrequestfromlogin;
    ui32 skeep;

    TFilterItemMonStat() {
        Clear();
    }

    void Clear() {
        Ident = "";
        workcount = 0;
        blacklogin = 0;
        whitelogin = 0;
        maxrequestfromlogin = 0;
        skeep = 0;
    }

    TString GetText() {
        TString res = "";

        res = "<SRVC: ident='" + Ident + "' wc='" + IntToStroka(workcount) + "' fltr='" + IntToStroka(blacklogin) + "," + IntToStroka(whitelogin) + "," + IntToStroka(maxrequestfromlogin) + "," + IntToStroka(skeep) + "'>";

        return res;
    }
};

class TFilterItem {
private:
    TMutex m_Mutex;
    TString Ident;
    int filtercount;
    TBaseLogClass* StatSOLog;
    TBaseLogClass* ServerLog;
    TBaseLogClass* ControlLog;
    TBaseLogClass* FilterLog;
    TBaseLogClass* FnStatisticsLog;
    TRenginePoolCF* FilterObj; //��� ��������
    TStoreBase* MainStore;
    bool use_external_store;
    float score;
    TString dnrules;
    TTrafficControl TRControl;
    STORAGETYPE storagetype;
    int max_mess_count_from_login;
    bool m_central_renginepool; //������������ ������� ��� ��������
    TDiffCounter m_rcv_counter;
    TDiffCounter m_blacklogin_counter;
    TDiffCounter m_whitelogin_counter;
    TDiffCounter m_maxrequestfromlogin_counter;
    TDiffCounter m_skeep_counter;
    bool m_use_long_ipbasa;
    TTop20List top20list;

public:
    TFilterItem();
    ~TFilterItem();

    bool Init(TStoreBase* main_store, STORAGETYPE storagetypeA, TString IdentA, TLogsGroupCF* LogsGroupA, TKConfig* IniFileA, TString dnrulesA, float scoreA, int renginecountA, int mintreshold, int maxtreshold, bool srvcdisabled, TRenginePoolCF* CentralFilterObj, int max_mess_count_from_loginA);

    void Lock();
    void UnLock();
    TString GetIdent() {
        return Ident;
    }
    TResetResponceCF Reset(const bool getreturn); //getreturn true - ���������� ��������� �������, false - �� ����������
    TResetResponceCF Reset2(const TString& dnrulesA, float scoreA);
    //void              AddStatSpam(bool spam, ui16 rcpt_count);
    //void              AddStatError(ui16 rcpt_count);
    void TickEvent();
    bool Midnight();
    void Close();
    void CleanStore();
    TRenginePoolCF* GetFilterPointer() {
        return FilterObj;
    }
    TFilterItemStat GetStat1(bool include_longipbasa_stat);
    TFilterItemMonStat GetMonStat();
    THashMap<TString, TString> GetExtendedStat();
    TStoreBase* GetStore() {
        return MainStore;
    }
    TBaseLogClass* GetControlLog() {
        return ControlLog;
    }
    float GetScore() {
        return score;
    }
    TString GetRules() {
        return dnrules;
    }
    TString GetFiltersCPSList();
    bool Skeep();
    int GetMaxMessCountFromLogin() {
        return max_mess_count_from_login;
    }
    bool IsCentralRenginePool() {
        return m_central_renginepool;
    }
    void AddWorkEvent() {
        m_rcv_counter.Increment();
    }
    void AddBlackLoginEvent() {
        m_blacklogin_counter.Increment();
    }
    void AddWhiteLoginEvent() {
        m_whitelogin_counter.Increment();
    }
    void AddMaxRequestFromLoginEvent() {
        m_maxrequestfromlogin_counter.Increment();
    }
    void AddSkeepEvent() {
        m_skeep_counter.Increment();
    }
    void AddStatToTop20List(const TString& field_name, const TString& value) {
        top20list.AddValue(field_name, value);
    }
};

//*********************************************************************************
//                                  TGroupFilter
//*********************************************************************************

typedef THashMap<TString, TFilterItem*> TFilterItemHash;
typedef TFilterItemHash::iterator TFilterItemHashIt;

typedef std::list<TFilterItemStat> TStatList;
typedef TStatList::iterator TStatListIt;

typedef std::list<TFilterItemMonStat> TMonStatList;
typedef TMonStatList::iterator TMonStatListIt;

class TGroupFilter {
public:
    static const ui32 DELAYAUTOWRITEDUMP = 3600;
    static const int DEFAULT_SCORE = 1;
    static const int DEFAULT_RENGINE_COUNT = 1;

private:
    TFilterItemHash data;
    TMutex m_Mutex;
    TLogsGroupCF* LogsGroup;
    TBaseLogClass* ServerLog;
    TBaseLogClass* FilterLog;
    TBaseLogClass* FnStatisticsLog;
    TAllowService* AllowService;
    TDelaysStorageMain* delaysstorage;
    TStoreBase* MainStore;
    TKConfig* IniFile;
    TString dumppath;
    bool load_at_startup;
    bool write_dump;
    time_t last_write_dump;
    STORAGETYPE storagetype;
    TRenginePoolCF* CentralRenginePool;
    TString central_rengine_pool_dnrules;
    float central_rengine_pool_score;
    int central_rengine_pool_filter_count;
    time_t savetime;

    TDiffCounter m_blacklogin_counter;
    TDiffCounter m_whitelogin_counter;
    TDiffCounter m_maxrequestfromlogin_counter;

    void Lock();
    void UnLock();

    void RemoveItem();
    TFilterItem* GetItem(const TString& Ident, ui64 NumbRequest);
    TFilterItem* GetItemByReloadServices(const TString& Ident, ui64 NumbRequest);
    TFilterItemStat GetSummaryStoreStatistik1();
    TFilterItemMonStat GetSummaryStoreMonStatistik();
    bool CompareTM(tm& tb, tm& te);
    void WriteStatCentralFilterPoool(); //�������� ���������� ������������ ���� �������� � ���
public:
    TGroupFilter();
    ~TGroupFilter();

    void Init(TServiceType servicetypeA, STORAGETYPE storagetypeA, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version,
              TLogsGroupCF* LogsGroupA, TAllowService* AllowServiceA, TKConfig* IniFileA, TDelaysStorageMain* delaysstorageA);
    void InitAfterFork();

    //bool ReloadService();

    TFilterItem* GetFilterItem(const TString& Ident, const TString& NumbRequest);
    bool Midnight();
    bool Reset();
    TResetResponceCF ReloadRules();
    void Close();
    void CleanStore();
    void TickEvent();
    int GetStatist(TStatList& statlist);
    int GetMonStatist(TMonStatList& statlist);
    THashMap<TString, TString> GetCommonExtendedStatist();
    TStoreBase* GetCommonStore() {
        return MainStore;
    }
    int CreateServiceF(TString& ServiceName, TString& score, TString& rules);
    TFilterItem* CreateServiceBase(TString& ServiceName, bool& exists, bool writereaddisk, const TString& score, const TString& rules);
    bool IsUnknownService(const TString& Ident);
    TRenginePoolCF* GetCentralRenginePool() {
        return CentralRenginePool;
    }

    void AddBlackLogin() {
        m_blacklogin_counter.Increment();
    }
    ui32 GetBlackLogin() {
        return m_blacklogin_counter.GetDiff();
    }
    void AddWhiteLogin() {
        m_whitelogin_counter.Increment();
    }
    ui32 GetWhiteLogin() {
        return m_whitelogin_counter.GetDiff();
    }
    void AddMaxRequestFromLogin() {
        m_maxrequestfromlogin_counter.Increment();
    }
    ui32 GetMaxRequestFromLogin() {
        return m_maxrequestfromlogin_counter.GetDiff();
    }

    void GetServicesList(TServiceFullStatList& srvc_list);
};

//**********************************************************************************
