#include <mail/so/spamstop/tools/so-common/shtime.h>
#include "theavystat.h"

//*********************************************************************************************************************************
//                                                    THeavyStatItem(
//*********************************************************************************************************************************

THeavyStatItem::THeavyStatItem() {
    data = NULL;
    m_name = "";
    m_log = NULL;
}

THeavyStatItem::~THeavyStatItem() {
    if (data != NULL) {
        delete data;
        data = NULL;
    }
}

void THeavyStatItem::Lock() {
    m_Mutex.Acquire();
}

void THeavyStatItem::UnLock() {
    m_Mutex.Release();
}

void THeavyStatItem::Init(const TString& name, TLogClass* log) {
    m_name = name;
    m_log = log;
}

bool THeavyStatItem::AddData(ui64 shingle, const TString& text, TCountersStatEx currentcounter, TKIPv6 ip, const TString& suid, const TString& geo) {
    bool res = false;
    THeavyStatStruct value;
    THeavyStatStructHashIt it;
    time_t current_time = time(NULL);
    TKSuidHashIt sit;
    ui64 tshingle = 0;

    Lock();

    if (data == NULL)
        data = new THeavyStatStructHash();
    if (data != NULL) {
        if (shingle != 0) {
            it = data->find(shingle);
            if (it != data->end()) {
                (*it).second.m_geo = geo;
                //today data
                (*it).second.m_today.m_spam = currentcounter.today_spam;
                (*it).second.m_today.m_ham = currentcounter.today_ham;
                if ((*it).second.m_today.m_iphash.size() < MAX_IPHASH_SIZE)
                    (*it).second.m_today.m_iphash.emplace(ip, 0);
                if ((*it).second.m_today.m_suidhash.size() < MAX_SUIDHASH_SIZE) {
                    tshingle = ShingleFromStroka(suid);
                    if (tshingle != 0) {
                        sit = (*it).second.m_today.m_suidhash.find(tshingle);
                        if (sit == (*it).second.m_today.m_suidhash.end())
                            (*it).second.m_today.m_suidhash[tshingle] = 0;
                    }
                }
                //yesterday data
                (*it).second.m_yesterday.m_spam = currentcounter.yesterday_spam;
                (*it).second.m_yesterday.m_ham = currentcounter.yesterday_ham;
                //both
                (*it).second.m_lasttime = current_time;
                //rps
                (*it).second.CalcRPS(current_time, false);

            } else
                (*data)[shingle] = THeavyStatStruct(current_time, currentcounter, text, ip, suid, geo);
        }
    }

    UnLock();

    return res;
}

void THeavyStatItem::Midnight() {
    THeavyStatStructHashIt it;
    THeavyStatStructHash* newdata = NULL;
    THeavyStatStructHash* t_data = NULL;
    ui32 alltime = 0;
    ui32 lockwait_time = 0;
    ui32 midnighttime = 0;
    ui32 deloldhashtime = 0;
    ui32 deletecount = 0;
    ui32 remaincount = 0;

    deletecount = 0;
    remaincount = 0;

    alltime = CShingleTime::GetMs();

    lockwait_time = CShingleTime::GetMs();
    Lock();
    lockwait_time = CShingleTime::GetMs() - lockwait_time;

    midnighttime = CShingleTime::GetMs();
    if (data != NULL) {
        newdata = new THeavyStatStructHash();
        it = data->begin();
        while (it != data->end()) {
            (*it).second.Midnight();
            if (!(*it).second.IsEmpty()) {
                (*newdata)[(*it).first] = (*it).second;
                remaincount = IncMax32(remaincount, 1);

            } else {
                deletecount = IncMax32(deletecount, 1);
            }

            ++it;
        }

        t_data = data;
        data = newdata;
    }
    midnighttime = CShingleTime::GetMs() - midnighttime;

    UnLock();

    deloldhashtime = CShingleTime::GetMs();
    if (t_data != NULL) {
        delete t_data;
        t_data = NULL;
    }
    deloldhashtime = CShingleTime::GetMs() - deloldhashtime;

    alltime = CShingleTime::GetMs() - alltime;

    if (m_log != NULL)
        m_log->WriteMessageAndDataStatus(KMESSAGE, "%s: Midnight compleate to %u msec (delete=%u, remain=%u, lockwait=%u ms, midnighttime=%u ms, deloldhash=%u ms)", m_name.c_str(), alltime, deletecount, remaincount, lockwait_time, midnighttime, deloldhashtime);
}

ui32 THeavyStatItem::GetReportData(THeavyStatDisplayList& datalist, ui32 min_treshold, THeavyStatDisplay::TSortType sort_type) {
    ui32 res = 0;
    ui32 calc_treshold = 0;
    ui32 current_time = time(NULL);
    THeavyStatStructHashIt it;

    Lock();

    if (data != NULL) {
        it = data->begin();
        while (it != data->end()) {
            calc_treshold = IncMax32((*it).second.Ham(), (*it).second.Spam());
            if (calc_treshold >= min_treshold) {
                (*it).second.CalcRPS(current_time, true);
                datalist.push_back(THeavyStatDisplay((*it).first, (*it).second, sort_type));
            }

            ++it;
        }
        res = data->size();
    }

    UnLock();

    return res;
}

//*********************************************************************************************************************************
//                                                    THeavyStat
//*********************************************************************************************************************************

THeavyStat::THeavyStat() {
    addtreshold = 0;
}

THeavyStat::~THeavyStat() {
}

void THeavyStat::Init(const TString& nameA, TLogClass* log, i32 addtresholdA) {
    name = nameA;
    if (addtresholdA < 0)
        addtreshold = DEFAULT_ADDTRESHOLD;
    else
        addtreshold = addtresholdA;
    for (int i = 0; i < ELEMENT_COUNT; i++)
        arraydata[i].Init(nameA + "_" + IntToStroka2(i), log);
}

int THeavyStat::GetIndex(ui64 shingle) {
    return shingle % ELEMENT_COUNT;
}

bool THeavyStat::AddData(TCountersStatEx currentcounter, const TString& text, bool spam, TKIPv6 ip, const TString& suid, const TString& geo) {
    bool res = false;
    int index = -1;
    TString t_text = "";
    ui64 shingle = 0;
    TCountersStatEx currentcounter_v = currentcounter;

    if (spam) //��������� �������, �.�. � currentcounter ���������� �������� �� ���� �� ����������� ���� ���� ��� ���
        currentcounter_v.IncTodaySpam();
    else
        currentcounter_v.IncTodayHam();

    if (currentcounter_v.All() >= addtreshold) {
        t_text = Trim(text);
        shingle = ShingleFromStroka(t_text);
        if (shingle != 0) {
            index = GetIndex(shingle);
            if ((index >= 0) && (index < ELEMENT_COUNT))
                res = arraydata[index].AddData(shingle, text, currentcounter_v, ip, suid, geo);
        }
    } else
        res = true;

    return res;
}

void THeavyStat::Midnight() {
    for (int i = 0; i < ELEMENT_COUNT; i++)
        arraydata[i].Midnight();
}

TString THeavyStat::CreateLink(const TString& label, const TString& prefix_url, ui32 max_display_record, ui32 min_treshold, THeavyStatDisplay::TSortType sort_type, const TString& text) {
    TString res = "";

    res = "<a href='" + prefix_url + "statname=" + label + "&sorttype=" + IntToStroka(sort_type) + "&mintr=" + IntToStroka(min_treshold) + "&displrec=" + IntToStroka(max_display_record) + "'><b>" + text + "<b></a>";

    return res;
}

TString THeavyStat::GetReport(const TString& label, const TString& prefix_url, ui32 max_display_record, ui32 min_treshold, THeavyStatDisplay::TSortType sort_type, const TString& textlink) {
    THeavyStatDisplayList datalist;
    ui32 display_count = 0;
    ui32 current_display_count = 0;
    THeavyStatDisplayListIt it;
    ui32 currenttime = 0;
    TString text = "";
    const int labelcount = 10;
    TString label_buff[labelcount];
    ui32 all_count = 0;
    TString textlink_s = "";

    for (int i = 0; i < ELEMENT_COUNT; i++)
        all_count = IncMax32(all_count, arraydata[i].GetReportData(datalist, min_treshold, sort_type));

    datalist.sort();
    if (max_display_record == 0) {
        display_count = datalist.size();

    } else {
        display_count = (max_display_record < datalist.size()) ? max_display_record : datalist.size();
    }

    for (int i = 0; i < labelcount; i++)
        label_buff[i] = "";

    switch (sort_type) {
        case THeavyStatDisplay::SRT_TEXT:
            label_buff[0] = "*";
            break;
        case THeavyStatDisplay::SRT_FIRSTTIME:
            label_buff[1] = "*";
            break;
        case THeavyStatDisplay::SRT_LASTTIME:
            label_buff[2] = "*";
            break;
        case THeavyStatDisplay::SRT_HAM_TODAY:
            label_buff[3] = "*";
            break;
        case THeavyStatDisplay::SRT_SPAMTODAY:
            label_buff[4] = "*";
            break;
        case THeavyStatDisplay::SRT_HAM:
            label_buff[5] = "*";
            break;
        case THeavyStatDisplay::SRT_SPAM:
            label_buff[6] = "*";
            break;
        case THeavyStatDisplay::SRT_ALL_TODAY:
            label_buff[7] = "*";
            break;
        case THeavyStatDisplay::SRT_ALL_YESTERDAY:
            label_buff[8] = "*";
            break;
        case THeavyStatDisplay::SRT_RPS:
            label_buff[9] = "*";
            break;
    };

    currenttime = time(NULL);

    text = text + "Heavy statistik for " + label + ", ";
    text = text + "found: " + IntToStroka(datalist.size()) + " record, ";
    text = text + "view: " + IntToStroka(display_count) + " record, ";
    text = text + "add_treshold: " + IntToStroka(addtreshold) + ", ";
    text = text + "all: " + IntToStroka(all_count) + " record";
    text = text + "<br>";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
    text = text + "<tr valign='top'>";
    text = text + "<td width='%30' style='word-wrap: break-word; word-break: break-all'>" + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_TEXT, label_buff[0] + /*"TEXT"*/ label) + "</td>";
    text = text + "<td width='%7'>IP(t/y)</td>";
    text = text + "<td width='%7'>SUID(t/y)</td>";
    text = text + "<td width='%8'>" + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_ALL_TODAY, label_buff[7] + "TODAYALL") + "</td>";
    text = text + "<td width='%8'>" + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_ALL_YESTERDAY, label_buff[8] + "YESTERALL") + "</td>";
    text = text + "<td width='%8'>" + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_FIRSTTIME, label_buff[1] + "FIRSTTIME") + "</td>";
    text = text + "<td width='%8'>" + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_LASTTIME, label_buff[2] + "LASTTIME") + "</td>";
    text = text + "<td width='%8'>" + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_HAM_TODAY, label_buff[3] + "TODAY") + " / " + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_HAM, label_buff[5] + "ALL HAM") + "</td>";
    text = text + "<td width='%8'>" + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_SPAMTODAY, label_buff[4] + "TODAY") + " / " + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_SPAM, label_buff[6] + "ALL SPAM") + "</td>";
    text = text + "<td width='%8'>" + CreateLink(label, prefix_url, max_display_record, min_treshold, THeavyStatDisplay::SRT_RPS, label_buff[9] + "RPS") + "</td>";
    text = text + "</tr>\n";

    it = datalist.begin();
    while (it != datalist.end()) {
        current_display_count++;
        if (current_display_count > display_count)
            break;

        text = text + "<tr valign='top'>";
        if (label == "IPSTAT") {
            textlink_s = "<A href=" + textlink + (*it).data.m_text + " target=_blank>" + (*it).data.m_text + " (" + (*it).data.m_geo + ")</A>";
            text = text + "<td width='%30' style='word-wrap: break-word; word-break: break-all'>" + textlink_s + "</td>";
        } else {
            text = text + "<td width='%30' style='word-wrap: break-word; word-break: break-all'>" + (*it).data.m_text + "</td>";
        }
        text = text + "<td>" + IntToStroka((*it).data.m_today.m_ip_uniq_count) + " / " + IntToStroka((*it).data.m_yesterday.m_ip_uniq_count) + "</td>";
        text = text + "<td>" + IntToStroka((*it).data.m_today.m_suid_uniq_count) + " / " + IntToStroka((*it).data.m_yesterday.m_suid_uniq_count) + "</td>";
        text = text + "<td>" + IntToStroka((*it).data.m_today.All()) + "</td>";
        text = text + "<td>" + IntToStroka((*it).data.m_yesterday.All()) + "</td>";
        text = text + "<td>" + TimeToStr((*it).data.m_firsttime) + "</td>";
        text = text + "<td>" + TimeToStr((*it).data.m_lasttime) + " (" + IntToHourMinSec2(currenttime - (*it).data.m_lasttime) + ")</td>";
        text = text + "<td>" + IntToStroka((*it).data.m_today.m_ham) + " / " + IntToStroka((*it).data.Ham()) + "</td>";
        text = text + "<td>" + IntToStroka((*it).data.m_today.m_spam) + " / " + IntToStroka((*it).data.Spam()) + "</td>";
        text = text + "<td>" + FloatToStr((*it).data.m_rps) + " (" + IntToStroka((*it).data.m_diff_calc_rps) + ")</td>";
        text = text + "</tr>\n";

        ++it;
    }

    text = text + "</table>\n";

    return text;
}

ui32 THeavyStat::Count() {
    ui32 res = 0;

    for (int i = 0; i < ELEMENT_COUNT; i++)
        res = IncMax32(res, arraydata[i].Count());

    return res;
}

//*********************************************************************************************************************************
