#include <mail/so/spamstop/tools/so-common/shtime.h>
#include "tipcache.h"

//***********************************************************************************************************************************************
//                                                 TIPCacheIPv6
//***********************************************************************************************************************************************

TIPCacheIPv6::TIPCacheIPv6() = default;

TIPCacheIPv6::~TIPCacheIPv6() {
    WriteDump();
}

void TIPCacheIPv6::Init(TLogsGroupCF* LogsGroupA, TString& dump_filenameA) {
    LogsGroup = LogsGroupA;
    m_dump_filename = dump_filenameA;
    ReadDump();
}

bool TIPCacheIPv6::GetInfo(TKIPv6 ip, TIPInfoItemIPv6& ipinf) {
    bool res = false;
    time_t current_time = time(NULL);

    TReadGuard g(m_Mutex);

    if (auto value = MapFindPtr(data, ip)) {
        ipinf = *value;
        if ((current_time - ipinf.m_firsttime) <= LIVE_TIME)
            res = true;
        else {
            ipinf.Clear();
            res = false;
        }
    }

    return res;
}

void TIPCacheIPv6::AddInfo(TKIPv6 ip, const TIPInfoItemIPv6& ipinf) {
    TWriteGuard g(m_Mutex);

    data.emplace(ip, ipinf);
}

void TIPCacheIPv6::Midnight() {
    time_t current_time = time(NULL);
    TIPInfoHashIPv6 datanew;
    ui32 tmetka = 0;
    ui32 deletecount = 0;
    ui32 remaincount = 0;
    TKIPv6 ip = TKIPv6();
    TIPInfoItemIPv6 value;

    {
        TWriteGuard g(m_Mutex);
        tmetka = CShingleTime::GetMs();

        for (const auto& [ip, value] : data) {
            if ((current_time - value.m_firsttime) <= LIVE_TIME) {
                datanew.emplace(ip, value);
            } else {
                if (deletecount < 0xFFFFFFFF)
                    deletecount++;
            }
        }

        data = std::move(datanew);
        remaincount = data.size();

        tmetka = CShingleTime::GetMs() - tmetka;
    }

    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "IPCACHE: midnight to %u msec, delete %u record, remain %u record.", tmetka, deletecount, remaincount);
}

bool TIPCacheIPv6::ReadDumpA(const TString& Filename) {
    bool res = true;

    TWriteGuard g(m_Mutex);

    if ((Filename.size() > 0)) {
        size_t count1 = 0, count4 = 0;
        char* BUFF;
        size_t BuffSize = 0;
        ui32 crc32 = 0, crc32_a = 0;
        TString ident = "KBI";
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;
        char ShapBuff[1600];
        char* SPEEDBUFF = NULL;
        ui32 SPEEDBUFFSize = MAXREADDUMPBUFFERU;
        ui32 inSPEEDBUFF = 0;
        ui32 SPEEDBUFFpos = 0;
        TKIPv6 ip = TKIPv6();
        TIPInfoItemIPv6 value;

        FILE* yfhandle = fopen(Filename.c_str(), "rb");
        if (yfhandle != NULL) {
            SPEEDBUFF = new char[SPEEDBUFFSize];
            SPEEDBUFFpos = 0;
            while (!feof(yfhandle)) {
                if ((SPEEDBUFFSize - inSPEEDBUFF) > 0) {
                    count4 = fread(SPEEDBUFF + inSPEEDBUFF, 1, SPEEDBUFFSize - inSPEEDBUFF, yfhandle);
                    inSPEEDBUFF += count4;
                }
                if (inSPEEDBUFF > 0) {
                    prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);
                    while ((inSPEEDBUFF - SPEEDBUFFpos) > 0) {
                        if ((inSPEEDBUFF - SPEEDBUFFpos) < prefix_size)
                            break;
                        memcpy(ShapBuff, SPEEDBUFF + SPEEDBUFFpos, prefix_size);
                        if (memcmp(ShapBuff, ident.c_str(), ident.size()) == 0) {
                            memcpy(&bodysize, ShapBuff + ident.size(), sizeof(bodysize));
                            memcpy(&crc32, ShapBuff + ident.size() + sizeof(bodysize), sizeof(crc32));
                            memcpy(&keysize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32), sizeof(keysize));
                            memcpy(&valsize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), sizeof(valsize));
                            if ((bodysize > 0) && (bodysize < 100000000) && (bodysize == (keysize + valsize))) //������ �� ����
                            {
                                if ((inSPEEDBUFF - SPEEDBUFFpos) < (prefix_size + bodysize))
                                    break;
                                BuffSize = bodysize;
                                BUFF = new char[BuffSize];
                                try {
                                    memcpy(BUFF, SPEEDBUFF + SPEEDBUFFpos + prefix_size, bodysize);
                                    SPEEDBUFFpos += prefix_size + bodysize;

                                    crc32_a = 0;
                                    for (int i = 0; i < (int)BuffSize; i++)
                                        crc32_a += BUFF[i];
                                    if (crc32 == crc32_a) {
                                        if (keysize == sizeof(ip)) {
                                            memcpy(&ip, BUFF, keysize);
                                            data.emplace(ip, TIPInfoItemIPv6(BUFF + keysize, valsize));

                                        } else
                                            res = false;

                                    } else
                                        res = false;

                                    delete[] BUFF;
                                    BUFF = NULL;
                                } catch (...) {
                                    delete[] BUFF;
                                    BUFF = NULL;
                                }
                                if (res == false)
                                    goto MEND;
                            } else {
                                res = false;
                                goto MEND;
                            }
                        }
                    }
                }
                count1 = inSPEEDBUFF - SPEEDBUFFpos;
                if (count1 > 0) {
                    char* tbuff = new char[count1];
                    try {
                        memcpy(tbuff, SPEEDBUFF + SPEEDBUFFpos, count1);
                        memcpy(SPEEDBUFF, tbuff, count1);
                        inSPEEDBUFF = count1;
                        SPEEDBUFFpos = 0;

                        delete[] tbuff;
                        tbuff = NULL;
                    } catch (...) {
                        delete[] tbuff;
                        tbuff = NULL;
                    }
                } else {
                    inSPEEDBUFF = 0;
                    SPEEDBUFFpos = 0;
                }
            }
        MEND:
            fclose(yfhandle);
            if (SPEEDBUFF != NULL) {
                delete[] SPEEDBUFF;
                SPEEDBUFF = NULL;
                inSPEEDBUFF = 0;
            }
        }
    }

    return res;
}

bool TIPCacheIPv6::WriteDumpA(TString& Filename, ui32& reccount) {
    bool res = true;

    TReadGuard g(m_Mutex);

    reccount = 0;
    if ((Filename.size() > 0)) {
        size_t t1 = 0, t2 = 0;
        size_t count1 = 0, count2 = 0, count3 = 0;
        char* BUFF = NULL;
        size_t BuffSize = 0;
        ui32 crc32 = 0;
        TString ident = "KBI";
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;
        TKIPv6 ip = TKIPv6();
        TIPInfoItemIPv6 value;

        FILE* yfhandle = fopen(Filename.c_str(), "wb");
        if (yfhandle != NULL) {
            for (const auto& [ip, value]: data) {
                t1 = sizeof(ip);
                t2 = value.size();
                keysize = t1;
                valsize = t2;
                bodysize = t1 + t2;
                prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);

                BuffSize = prefix_size + t1 + t2;
                if (BuffSize > 0) {
                    BUFF = new char[BuffSize];
                    try {
                        if ((BuffSize - prefix_size) >= sizeof(ip)) {
                            memcpy(BUFF + prefix_size, &ip, sizeof(ip));
                            count1 = sizeof(ip);
                        } else
                            count1 = 0;
                        if (count1 == t1) {
                            count2 = value.GetBuffer(BUFF + prefix_size + count1, BuffSize - prefix_size - count1);
                            if (count2 == t2) {
                                memcpy(BUFF, ident.c_str(), ident.size());
                                memcpy(BUFF + ident.size(), &bodysize, sizeof(bodysize));
                                crc32 = 0;
                                for (int i = prefix_size; i < (int)BuffSize; i++)
                                    crc32 += BUFF[i];
                                memcpy(BUFF + ident.size() + sizeof(bodysize), &crc32, sizeof(crc32));
                                memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32), &keysize, sizeof(keysize));
                                memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), &valsize, sizeof(valsize));

                                count3 = fwrite(BUFF, 1, BuffSize, yfhandle);
                                if (count3 != BuffSize) {
                                    res = false;
                                    break;
                                } else {
                                    reccount++;
                                }
                            }
                        }

                        delete[] BUFF;
                        BUFF = NULL;
                    } catch (...) {
                        delete[] BUFF;
                        BUFF = NULL;
                    }
                }
            }

            fclose(yfhandle);
        }
    }

    return res;
}

bool TIPCacheIPv6::ReadDump() {
    bool res = false;

    if (!m_dump_filename.empty()) {
        res = ReadDumpA(m_dump_filename);
        if (res) {
            ui32 record_count = 0;

            record_count = data.size();
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "IPCACHE: read dump complete, read %u record!", record_count);

        } else {
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "IPCACHE: read dump failed!");
        }
    } else {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "IPCACHE: no defined dump filename!");
    }

    return res;
}

bool TIPCacheIPv6::WriteDump() {
    bool res = false;

    if (!m_dump_filename.empty()) {
        ui32 record_count = 0;

        res = WriteDumpA(m_dump_filename, record_count);
        if (res) {
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "IPCACHE: write dump complete, write %u record!", record_count);

        } else {
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "IPCACHE: write dump failed!");
        }
    } else {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "IPCACHE: no defined dump filename!");
    }

    return res;
}

bool TIPCacheIPv6::ListDump(const TString& Filename) {
    bool res = true;


    if ((Filename.size() > 0)) {
        FILE* handle = fopen(Filename.c_str(), "wb");
        if (handle != NULL) {
            TReadGuard g(m_Mutex);
            TIPInfoListIPv6 iplist;
            TIPInfoListIPv6It itl;
            TString st = "";
            TKIPv6 ip = TKIPv6();
            TIPInfoItemIPv6 value;

            for (const auto& [_, value]: data) {
                iplist.push_back(value);
            }

            iplist.sort();

            itl = iplist.begin();
            while (itl != iplist.end()) {
                st = (*itl).GetDataS() + "\n";
                fprintf(handle, "%s", st.c_str());

                ++itl;
            }

            fclose(handle);
        }
    }

    return res;
}

ui32 TIPCacheIPv6::Size() {
    ui32 res = 0;

    TReadGuard g(m_Mutex);
    res = data.size();

    return res;
}

//**********************************************************************************************************************************************
