#pragma once

#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include "tlogsgroup_cf.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>

//***********************************************************************************************************************************************
//                                                 TIPCache
//***********************************************************************************************************************************************

struct TIPInfoItem {
    ui32 m_ip;
    time_t m_firsttime;
    TString m_geos;
    TString m_hosts;

    TIPInfoItem() {
        Clear();
    }

    TIPInfoItem(ui32 ipA, const TString& geos, const TString& hosts) {
        Clear();
        m_ip = ipA;
        m_firsttime = time(NULL);
        m_geos = geos;
        m_hosts = hosts;
    }

    TIPInfoItem(const char* BUFF, int SizeBUFF) {
        Clear();
        if (SizeBUFF >= (int)(sizeof(m_firsttime) + sizeof(ui16) + sizeof(ui16))) {
            ui16 field_size = 0;
            int pos = 0;

            memcpy(&m_ip, BUFF + pos, sizeof(m_ip));
            pos = pos + sizeof(m_ip);

            memcpy(&m_firsttime, BUFF + pos, sizeof(m_firsttime));
            pos = pos + sizeof(m_firsttime);

            if ((int)(pos + sizeof(field_size)) <= SizeBUFF) {
                memcpy(&field_size, BUFF + pos, sizeof(field_size));
                pos = pos + sizeof(field_size);
                if ((field_size > 0) && ((pos + field_size) <= SizeBUFF)) {
                    m_geos = TString(BUFF + pos, field_size);
                    pos = pos + m_geos.length();
                }
            }

            if ((int)(pos + sizeof(field_size)) <= SizeBUFF) {
                memcpy(&field_size, BUFF + pos, sizeof(field_size));
                pos = pos + sizeof(field_size);
                if ((field_size > 0) && ((pos + field_size) <= SizeBUFF)) {
                    m_hosts = TString(BUFF + pos, field_size);
                    pos = pos + m_hosts.length();
                }
            }
        }
    }

    void Clear() {
        m_ip = 0;
        m_firsttime = 0;
        m_geos = "";
        m_hosts = "";
    }

    size_t size() const {
        size_t res = 0;

        res = res + sizeof(m_ip);
        res = res + sizeof(m_firsttime);
        res = res + sizeof(ui16);
        res = res + m_geos.length();
        res = res + sizeof(ui16);
        res = res + m_hosts.length();

        return res;
    }

    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;
        ui16 field_size = 0;

        if (BuffSize >= (int)size()) {
            memcpy(BUFF + res, &m_ip, sizeof(m_ip));
            res = res + sizeof(m_ip);

            memcpy(BUFF + res, &m_firsttime, sizeof(m_firsttime));
            res = res + sizeof(m_firsttime);

            field_size = m_geos.length();
            memcpy(BUFF + res, &field_size, sizeof(field_size));
            res = res + sizeof(field_size);
            memcpy(BUFF + res, m_geos.c_str(), m_geos.length());
            res = res + m_geos.length();

            field_size = m_hosts.length();
            memcpy(BUFF + res, &field_size, sizeof(field_size));
            res = res + sizeof(field_size);
            memcpy(BUFF + res, m_hosts.c_str(), m_hosts.length());
            res = res + m_hosts.length();
        }

        return res;
    }

    bool operator<(const TIPInfoItem& value) const {
        return m_ip < value.m_ip;
    }

    TString GetDataS() {
        TString res = "";

        res = IntToIp(m_ip) + ": t='" + TimeToStr(m_firsttime) + "' g='" + m_geos + "' h='" + m_hosts + "'";

        return res;
    }
};

typedef THashMap<ui32, TIPInfoItem> TIPInfoHash;
typedef TIPInfoHash::iterator TIPInfoHashIt;

typedef std::list<TIPInfoItem> TIPInfoList;
typedef TIPInfoList::iterator TIPInfoListIt;


//***********************************************************************************************************************************************
//                                                 TIPCacheIPv6
//***********************************************************************************************************************************************

struct TIPInfoItemIPv6 {
    TKIPv6 m_ip;
    time_t m_firsttime;
    TString m_geos;
    TString m_hosts;

    TIPInfoItemIPv6() {
        Clear();
    }

    TIPInfoItemIPv6(TKIPv6 ipA, const TString& geos, const TString& hosts) {
        Clear();
        m_ip = ipA;
        m_firsttime = time(NULL);
        m_geos = geos;
        m_hosts = hosts;
    }

    TIPInfoItemIPv6(const char* BUFF, int SizeBUFF) {
        Clear();
        if (SizeBUFF >= (int)(sizeof(m_firsttime) + sizeof(ui16) + sizeof(ui16))) {
            ui16 field_size = 0;
            int pos = 0;

            memcpy(&m_ip, BUFF + pos, sizeof(m_ip));
            pos = pos + sizeof(m_ip);

            memcpy(&m_firsttime, BUFF + pos, sizeof(m_firsttime));
            pos = pos + sizeof(m_firsttime);

            if ((int)(pos + sizeof(field_size)) <= SizeBUFF) {
                memcpy(&field_size, BUFF + pos, sizeof(field_size));
                pos = pos + sizeof(field_size);
                if ((field_size > 0) && ((pos + field_size) <= SizeBUFF)) {
                    m_geos = TString(BUFF + pos, field_size);
                    pos = pos + m_geos.length();
                }
            }

            if ((int)(pos + sizeof(field_size)) <= SizeBUFF) {
                memcpy(&field_size, BUFF + pos, sizeof(field_size));
                pos = pos + sizeof(field_size);
                if ((field_size > 0) && ((pos + field_size) <= SizeBUFF)) {
                    m_hosts = TString(BUFF + pos, field_size);
                    pos = pos + m_hosts.length();
                }
            }
        }
    }

    void Clear() {
        m_ip = TKIPv6();
        m_firsttime = 0;
        m_geos = "";
        m_hosts = "";
    }

    size_t size() const {
        size_t res = 0;

        res = res + sizeof(m_ip);
        res = res + sizeof(m_firsttime);
        res = res + sizeof(ui16);
        res = res + m_geos.length();
        res = res + sizeof(ui16);
        res = res + m_hosts.length();

        return res;
    }

    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;
        ui16 field_size = 0;

        if (BuffSize >= (int)size()) {
            memcpy(BUFF + res, &m_ip, sizeof(m_ip));
            res = res + sizeof(m_ip);

            memcpy(BUFF + res, &m_firsttime, sizeof(m_firsttime));
            res = res + sizeof(m_firsttime);

            field_size = m_geos.length();
            memcpy(BUFF + res, &field_size, sizeof(field_size));
            res = res + sizeof(field_size);
            memcpy(BUFF + res, m_geos.c_str(), m_geos.length());
            res = res + m_geos.length();

            field_size = m_hosts.length();
            memcpy(BUFF + res, &field_size, sizeof(field_size));
            res = res + sizeof(field_size);
            memcpy(BUFF + res, m_hosts.c_str(), m_hosts.length());
            res = res + m_hosts.length();
        }

        return res;
    }

    bool operator<(const TIPInfoItemIPv6& value) const {
        return m_ip < value.m_ip;
    }

    TString GetDataS() {
        TString res = "";

        res = m_ip.toStroka() + ": t='" + TimeToStr(m_firsttime) + "' g='" + m_geos + "' h='" + m_hosts + "'";

        return res;
    }
};

typedef THashMap<TKIPv6, TIPInfoItemIPv6> TIPInfoHashIPv6;

typedef std::list<TIPInfoItemIPv6> TIPInfoListIPv6;
typedef TIPInfoListIPv6::iterator TIPInfoListIPv6It;

class TIPCacheIPv6 {
private:
    static const int LIVE_TIME = 86400;
    static const ui32 MAXREADDUMPBUFFERU = 1000000;

    TIPInfoHashIPv6 data;
    TRWMutex m_Mutex;
    TLogsGroupCF* LogsGroup{};
    TString m_dump_filename;

    bool ReadDumpA(const TString& Filename);
    bool WriteDumpA(TString& Filename, ui32& reccount);

public:
    TIPCacheIPv6();
    ~TIPCacheIPv6();

    void Init(TLogsGroupCF* LogsGroupA, TString& dump_filenameA);
    bool GetInfo(TKIPv6 ip, TIPInfoItemIPv6& ipinf);
    void AddInfo(TKIPv6 ip, const TIPInfoItemIPv6& ipinf);
    void Midnight();
    bool ReadDump();
    bool WriteDump();
    ui32 Size();

    bool ListDump(const TString& Filename);
};

//************************************************************************************************************************************
