#include "tlogsgroup_cf.h"

//****************************************************************************************************************************************
//                                              TLogsGroup
//****************************************************************************************************************************************

TLogsGroupCF::TLogsGroupCF() {
    iniobj = NULL;
    m_debug_mode = false;
    m_ServerLog = NULL;
    m_InputLog = NULL;
    m_LongRequestLog = NULL;
    m_DebugInfoLog = NULL;
    m_StorageLog = NULL;

    m_longrequest_treshold = 195;

    m_LogTrace = NULL;
    m_DeliveryLog = NULL;
    m_Top20Log = NULL;
    m_FilterLog = NULL;
    m_FnStatisticsLog = NULL;
    m_StatSOLog = NULL;
    m_SendAnswerLog = NULL;
    m_SendAnswerFullLog = NULL;
    m_ComplateLog = NULL;
    m_ControlLog = NULL;
    m_ProxyLog = NULL;
    m_CPFStatLog = NULL;
    m_MonLog = NULL;
    m_CriticalEventLog = NULL;
}

TLogsGroupCF::~TLogsGroupCF() {
    DeleteLog(m_ServerLog);
    DeleteLog(m_InputLog);
    DeleteLog(m_LongRequestLog);
    DeleteLog(m_DebugInfoLog);
    DeleteLog(m_StorageLog);
    DeleteLog(m_MonLog);
    DeleteLog(m_CPFStatLog);
    DeleteLog(m_ProxyLog);
    DeleteLog(m_ComplateLog);
    DeleteLog(m_SendAnswerFullLog);
    DeleteLog(m_SendAnswerLog);
    DeleteLog(m_FnStatisticsLog);
    DeleteLog(m_FilterLog);
    DeleteLog(m_LogTrace);
    DeleteLog(m_CriticalEventLog);

    if (m_ControlLog != NULL) {
        delete m_ControlLog;
        m_ControlLog = NULL;
    }

    if (m_StatSOLog != NULL) {
        delete m_StatSOLog;
        m_StatSOLog = NULL;
    }

    if (m_Top20Log != NULL) {
        delete m_Top20Log;
        m_Top20Log = NULL;
    }

    if (m_DeliveryLog != NULL) {
        delete m_DeliveryLog;
        m_DeliveryLog = NULL;
    }
}

bool TLogsGroupCF::Init(TKConfig* iniobjA) {
    bool res = true;

    iniobj = iniobjA;
    if (iniobj != NULL) {
        m_debug_mode = iniobj->ReadBool("logs", "debug_mode", false);
        //enable_fflush = iniobj->ReadBool("logs", "fflush", false);
        m_longrequest_treshold = iniobj->ReadInteger("logs", "longrequest_treshold", 195);
        m_longrequest_mode = iniobj->ReadInteger("logs", "longrequest_mode", 0);

        m_InputLog = CreateLog(iniobj->ReadStroka("logs", "inputlog", ""), false);
        m_LongRequestLog = CreateLog(iniobj->ReadStroka("logs", "longrequest", ""), false);
        m_DebugInfoLog = CreateLog(iniobj->ReadStroka("logs", "debuginfo", ""), false);
        m_StorageLog = CreateLog(iniobj->ReadStroka("logs", "storage_name", ""), false);
        m_ServerLog = CreateLog(iniobj->ReadStroka("logs", "serverlog", ""), false);
        m_LogTrace = CreateLog(iniobj->ReadStroka("logs", "tracelog", ""), false);
        m_FnStatisticsLog = CreateLog(iniobj->ReadStroka("filter", "fnstatisticslog", ""), false);
        m_FilterLog = CreateLog(iniobj->ReadStroka("filter", "filterlog", ""), false);
        m_SendAnswerLog = CreateLog(iniobj->ReadStroka("logs", "sendanswerlog", ""), false);
        m_SendAnswerFullLog = CreateLog(iniobj->ReadStroka("logs", "sendanswerfulllog", ""), false);
        m_ComplateLog = CreateLog(iniobj->ReadStroka("logs", "complaintlog", ""), false);
        m_ProxyLog = CreateLog(iniobj->ReadStroka("logs", "proxylog", ""), false);
        m_CPFStatLog = CreateLog(iniobj->ReadStroka("filter", "cpfstat", ""), false);
        m_MonLog = CreateLog(iniobj->ReadStroka("logs", "mon", ""), false);
        m_CriticalEventLog = CreateLog(iniobj->ReadStroka("logs", "criticallog", ""), false);

        m_DeliveryLog = new TGroupLogClass(iniobj, deliverykey, false);
        if (m_DeliveryLog != NULL)
            ((TGroupLogClass*)m_DeliveryLog)->EnableWrite();

        m_Top20Log = new TGroupLogClass(iniobj, top20key, false);
        if (m_Top20Log != NULL)
            ((TGroupLogClass*)m_Top20Log)->EnableWrite();

        m_StatSOLog = new TGroupLogClass(iniobj, statsokey, false);
        if (m_StatSOLog != NULL)
            ((TGroupLogClass*)m_StatSOLog)->EnableWrite();

        m_ControlLog = new TGroupLogClass(iniobj, controlkey, false);
        if (m_ControlLog != NULL)
            ((TGroupLogClass*)m_ControlLog)->EnableWrite();
    }

    return res;
}

bool TLogsGroupCF::TruncLog() {
    bool res = true;

    if (m_ServerLog != NULL)
        if (!m_ServerLog->TruncLog())
            res = false;

    if (m_InputLog != NULL)
        if (!m_InputLog->TruncLog())
            res = false;

    if (m_LongRequestLog != NULL)
        if (!m_LongRequestLog->TruncLog())
            res = false;

    if (m_DebugInfoLog != NULL)
        if (!m_DebugInfoLog->TruncLog())
            res = false;

    if (m_StorageLog != NULL)
        if (!m_StorageLog->TruncLog())
            res = false;

    if (m_LogTrace != NULL)
        if (!m_LogTrace->TruncLog())
            res = false;

    if (m_DeliveryLog != NULL)
        if (!m_DeliveryLog->TruncLog())
            res = false;

    if (m_Top20Log != NULL)
        if (!m_Top20Log->TruncLog())
            res = false;

    if (m_FnStatisticsLog != NULL)
        if (!m_FnStatisticsLog->TruncLog())
            res = false;

    if (m_FilterLog != NULL)
        if (!m_FilterLog->TruncLog())
            res = false;

    if (m_StatSOLog != NULL)
        if (!m_StatSOLog->TruncLog())
            res = false;

    if (m_SendAnswerLog != NULL)
        if (!m_SendAnswerLog->TruncLog())
            res = false;

    if (m_SendAnswerFullLog != NULL)
        if (!m_SendAnswerFullLog->TruncLog())
            res = false;

    if (m_ComplateLog != NULL)
        if (!m_ComplateLog->TruncLog())
            res = false;

    if (m_ControlLog != NULL)
        if (!m_ControlLog->TruncLog())
            res = false;

    if (m_ProxyLog != NULL)
        if (!m_ProxyLog->TruncLog())
            res = false;

    if (m_CPFStatLog != NULL)
        if (!m_CPFStatLog->TruncLog())
            res = false;

    if (m_MonLog != NULL)
        if (!m_MonLog->TruncLog())
            res = false;

    if (m_CriticalEventLog != NULL)
        if (!m_CriticalEventLog->TruncLog())
            res = false;

    return res;
}

void TLogsGroupCF::DisableFFlush(bool dsb) {
    if (m_InputLog != NULL)
        m_InputLog->SetDisableFFlush(dsb);

    if (m_LongRequestLog != NULL)
        m_LongRequestLog->SetDisableFFlush(dsb);

    if (m_DebugInfoLog != NULL)
        m_DebugInfoLog->SetDisableFFlush(dsb);

    if (m_StorageLog != NULL)
        m_StorageLog->SetDisableFFlush(dsb);

    if (m_ServerLog != NULL)
        m_ServerLog->SetDisableFFlush(dsb);

    if (m_LogTrace != NULL)
        m_LogTrace->SetDisableFFlush(dsb);

    if (m_DeliveryLog != NULL)
        m_DeliveryLog->SetDisableFFlush(dsb);

    if (m_Top20Log != NULL)
        m_Top20Log->SetDisableFFlush(dsb);

    if (m_FnStatisticsLog != NULL)
        m_FnStatisticsLog->SetDisableFFlush(dsb);

    if (m_FilterLog != NULL)
        m_FilterLog->SetDisableFFlush(dsb);

    if (m_StatSOLog != NULL)
        m_StatSOLog->SetDisableFFlush(dsb);

    if (m_SendAnswerLog != NULL)
        m_SendAnswerLog->SetDisableFFlush(dsb);

    if (m_SendAnswerFullLog != NULL)
        m_SendAnswerFullLog->SetDisableFFlush(dsb);

    if (m_ComplateLog != NULL)
        m_ComplateLog->SetDisableFFlush(dsb);

    if (m_ControlLog != NULL)
        m_ControlLog->SetDisableFFlush(dsb);

    if (m_ProxyLog != NULL)
        m_ProxyLog->SetDisableFFlush(dsb);

    if (m_CPFStatLog != NULL)
        m_CPFStatLog->SetDisableFFlush(dsb);

    if (m_MonLog != NULL)
        m_MonLog->SetDisableFFlush(dsb);

    if (m_CriticalEventLog != NULL)
        m_CriticalEventLog->SetDisableFFlush(dsb);
}

//******************************************************************************************************************************************
