#pragma once

#include "util/generic/string.h"
#include <mail/so/spamstop/tools/so-common/tkinifile.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>

#define deliverykey "delivery_log"
#define top20key "top20_log"
#define statsokey "statso_log"
#define controlkey "control_log"

//****************************************************************************************************************************************
//                                              TLogsGroupCF
//****************************************************************************************************************************************

class TLogsGroupCF : public TLogsGroupBase {
private:
    TKConfig* iniobj;
    TLogClass* m_InputLog;
    TLogClass* m_LongRequestLog;
    TLogClass* m_DebugInfoLog;
    TLogClass* m_StorageLog;

    TLogClass* m_ServerLog;
    TLogClass* m_LogTrace;
    TGroupLogClass* m_DeliveryLog;
    TGroupLogClass* m_Top20Log;
    TLogClass* m_FilterLog;
    TLogClass* m_FnStatisticsLog;
    TGroupLogClass* m_StatSOLog;
    TLogClass* m_SendAnswerLog;
    TLogClass* m_SendAnswerFullLog;
    TGroupLogClass* m_ControlLog;
    TLogClass* m_ComplateLog;
    TLogClass* m_ProxyLog;
    TLogClass* m_CPFStatLog; //central pool filter statistik log
    TLogClass* m_MonLog;
    TLogClass* m_CriticalEventLog;

public:
    TLogsGroupCF();
    ~TLogsGroupCF();

    bool Init(TKConfig* iniobjA);

    TLogClass* GetInputLog() {
        return m_InputLog;
    }
    TLogClass* GetLongRequestLog() {
        return m_LongRequestLog;
    }
    TLogClass* GetDebugInfoLog() {
        return m_DebugInfoLog;
    }
    TLogClass* GetStorageLog() {
        return m_StorageLog;
    }

    TLogClass* GetServerLog() {
        return m_ServerLog;
    }
    TLogClass* GetLogTrace2() {
        return m_LogTrace;
    }
    TGroupLogClass* GetDeliveryLog() {
        return m_DeliveryLog;
    }
    TGroupLogClass* GetTop20Log() {
        return m_Top20Log;
    }
    TLogClass* GetFilterLog() {
        return m_FilterLog;
    }
    TLogClass* GetFnStatisticsLog() {
        return m_FnStatisticsLog;
    }
    TGroupLogClass* GetStatSOLog() {
        return m_StatSOLog;
    }
    TLogClass* GetSendAnswerLog() {
        return m_SendAnswerLog;
    }
    TLogClass* GetSendAnswerFullLog() {
        return m_SendAnswerFullLog;
    }
    TGroupLogClass* GetControlLog() {
        return m_ControlLog;
    }
    TLogClass* GetComplateLog() {
        return m_ComplateLog;
    }
    TLogClass* GetProxyLog() {
        return m_ProxyLog;
    }
    TLogClass* GetCPFStatLog() {
        return m_CPFStatLog;
    }
    TLogClass* GetMonLog() {
        return m_MonLog;
    }
    TLogClass* GetCriticalEventLog() {
        return m_CriticalEventLog;
    }

    bool TruncLog();
    void DisableFFlush(bool dsb);
};
//******************************************************************************************************************************************
