#include "tlongbasa_types.h"

namespace long_stor {
    TString TStorageDataTypeToTString(TStorageDataType type) {
        TString res = "";

        switch (type) {
            case SDT_IPADDRESS:
                res = "IPADDRESS";
                break;
            case SDT_INAME:
                res = "INAME";
                break;
            case SDT_FNAME:
                res = "FNAME";
                break;
            case SDT_IFNAME:
                res = "IFNAME";
                break;
            case SDT_PHONE:
                res = "PHONE";
                break;
            default:
                res = "UNKNOWN";
        };

        return res;
    }

    TKIPv6 TStringToTKIPv6FST(TStorageDataType type, const TString& text) {
        TKIPv6 res = TKIPv6();
        ui64 shingle = 0;

        if (!text.empty()) {
            shingle = ShingleFromStroka(text);
            if (shingle != 0)
                res = TKIPv6(type, shingle);
        }

        return res;
    }

} // namespace long_stor
