#pragma once

#include <mail/so/spamstop/tools/so-clients/ktime.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <util/generic/string.h>
#include <util/system/types.h>
#include <mail/so/spamstop/tools/so-common/tbasestoragetypes.h>

namespace long_stor {
    enum TStorageDataType { SDT_IPADDRESS,
                            SDT_INAME,
                            SDT_FNAME,
                            SDT_IFNAME,
                            SDT_PHONE,
                            SDT_END };

    TString TStorageDataTypeToTString(TStorageDataType type);
    TKIPv6 TStringToTKIPv6FST(TStorageDataType type, const TString& text);

    struct TLongDataRqstInfo {
        bool use[SDT_END];
        bool empty[SDT_END];
        bool is_cache[SDT_END];

        TLongDataRqstInfo() {
            Clear();
        }

        void Clear() {
            memset(use, 0, sizeof(use));
            memset(empty, 0, sizeof(empty));
            memset(is_cache, 0, sizeof(is_cache));
        }
    };

    struct TStorageDataItem {
        TStorageDataType m_stordata_type;
        char m_data_sources[151];
        kday_t m_lastday;
        ui32 m_ham;
        ui32 m_spam85;
        ui32 m_spam100;
        bool is_collision;

        TStorageDataItem() {
            Clear();
        }

        TStorageDataItem(TStorageDataType type, const TString& source, kday_t last_day, i32 ham, i32 spam85, i32 spam100) {
            Clear();

            m_stordata_type = type;
            if (source.length() > 0) {
                if (source.length() > (sizeof(m_data_sources) - 1))
                    memcpy(m_data_sources, source.c_str(), sizeof(m_data_sources) - 1);
                else
                    memcpy(m_data_sources, source.c_str(), source.length());

                m_data_sources[sizeof(m_data_sources) - 1] = 0x00;
            }
            m_lastday = last_day;
            m_ham = static_cast<ui32>(ham);
            m_spam85 = static_cast<ui32>(spam85);
            m_spam100 = static_cast<ui32>(spam100);
        }

        void Clear() {
            m_stordata_type = SDT_END;
            memset(m_data_sources, 0, sizeof(m_data_sources));
            m_lastday = kday_t((unsigned long)0);
            m_ham = 0;
            m_spam85 = 0;
            m_spam100 = 0;
            is_collision = false;
        }

        bool IsCollision() {
            return is_collision;
        }

        bool Empty() {
            bool res = false;

            if (m_stordata_type == SDT_END)
                res = true;
            if ((m_ham == 0) && (m_spam85 == 0) && (m_spam100 == 0))
                res = true;
            if (static_cast<ui32>(m_lastday) == 0)
                res = true;

            return res;
        }

        TString GetSource() {
            TString res = "";

            m_data_sources[sizeof(m_data_sources) - 1] = 0x00;
            res = TString(m_data_sources);
            CGIUnescape(res);

            return res;
        }
    };

    typedef THashMap<ui64, TStorageDataItem> TStorageDataItemHash;
    typedef TStorageDataItemHash::iterator TStorageDataItemHashIt;

    struct TStorageDataItemExt {
        ui64 m_rec_shingle;
        TStorageDataType m_rec_stordata_type;
        TKIPv6 m_rec_data;
        TString m_rec_source;
        TStorageDataItem m_stordata;
        stor_bt::TNoSqlItem nosqldata;
        bool m_err;
        ui32 m_tick;
        bool m_in_cache;

        TStorageDataItemExt() {
            Clear();
        }

        TStorageDataItemExt(TKIPv6 data, TStorageDataType type, const TString& source) {
            Clear();

            m_rec_data = data;
            m_rec_stordata_type = type;

            if (source.length() > 50)
                m_rec_source = source.substr(0, 50);
            else
                m_rec_source = source;
            CGIEscape(m_rec_source);

            if (!data.Undefined()) {
                TString tstr = "";

                switch (m_rec_stordata_type) {
                    case SDT_IPADDRESS:
                        tstr = "ipaddr_" + m_rec_data.IPv6AddressStr();
                        break;
                    case SDT_INAME:
                        tstr = "iname_" + m_rec_data.IPv6AddressStr();
                        break;
                    case SDT_FNAME:
                        tstr = "fname_" + m_rec_data.IPv6AddressStr();
                        break;
                    case SDT_IFNAME:
                        tstr = "ifname_" + m_rec_data.IPv6AddressStr();
                        break;
                    case SDT_PHONE:
                        tstr = "phone_" + m_rec_data.IPv6AddressStr();
                        break;
                };

                if (!tstr.empty()) {
                    char sshingle[32];

                    memset(sshingle, 0, sizeof(sshingle));
                    calc_strcrc64(tstr.c_str(), tstr.size(), sshingle);
                    sscanf(sshingle, "%llx", &m_rec_shingle);
                }
            }
        }

        void Clear() {
            m_rec_shingle = 0;
            m_rec_stordata_type = SDT_END;
            m_rec_data = TKIPv6();
            m_rec_source = "";
            m_stordata.Clear();
            nosqldata.clear();
            m_err = false;
            m_tick = 0;
            m_in_cache = false;
        }
    };

    struct TStorageData {
        TStorageDataItemExt m_data[SDT_END];

        TStorageData() {
            Clear();
        }

        void Init(const TStorageDataItemExt& ipaddr, const TStorageDataItemExt& iname, const TStorageDataItemExt& fname, const TStorageDataItemExt& ifname, const TStorageDataItemExt& phone) {
            Clear();

            m_data[SDT_IPADDRESS] = ipaddr;
            m_data[SDT_INAME] = iname;
            m_data[SDT_FNAME] = fname;
            m_data[SDT_IFNAME] = ifname;
            m_data[SDT_PHONE] = phone;
        }

        void Clear() {
            for (size_t i = 0; i < SDT_END; i++)
                m_data[i].Clear();
        }
    };

} // namespace long_stor
