#include <library/cpp/iterator/enumerate.h>
#include <util/string/join.h>
#include <mail/so/spamstop/tools/so-common/safe_recode.h>
#include "tmakerequest.h"
//#include "../so-clients/functional_clients/UserReputClient.h"

#ifdef INTERFACE
#undef INTERFACE
#endif

//*******************************************************************************************************************************************
//                                                             TMakeRequest
//*******************************************************************************************************************************************

TString TSQLTypeKToTString(TSQLTypeK value) {
    TString res = "";

    switch (value) {
        case ST_UNKNOWN:
            res = "UNKNOWN";
            break;
        case ST_SQL:
            res = "SQL";
            break;
        case ST_NOSQL:
            res = "NOSQL";
            break;
    };

    return res;
}

TString TShardTypeToTString(TShardType value) {
    TString res = "";

    switch (value) {
        case SHT_UNKNOWN:
            res = "UNKNOWN";
            break;
        case SHT_SKEEP:
            res = "SKEEP";
            break;
        case SHT_NUMBER:
            res = "NUMBER";
            break;
    };

    return res;
}

TMakeRequest::TMakeRequest(TServiceObjectBase& srvcobjA, void* serverA)
    : TMakeRequestBase(srvcobjA, serverA) {
    //������� ������� ������� �� ������� '?', ���� � ��� � ��������� ���� ������, �� ������� ������� �� ���� action �������, ���� �� ���� action ���, �� �������� ������� ��������� console
    AllowList.push_back("loginrcpt");
    AllowList.push_back("check");
    AllowList.push_back("info");
    AllowList.push_back("showweight");
    AllowList.push_back("favicon.ico");
    AllowList.push_back("corrlgipstat");
    AllowList.push_back("allrulesreset");
    AllowList.push_back("phoneauth");
    AllowList.push_back("getforfrodo");
    AllowList.push_back("getforfrod2");
    AllowList.push_back("storreaddump");
    AllowList.push_back("storwritedump");
    AllowList.push_back("storprintlist");
    AllowList.push_back("status");
}

TMakeRequest::~TMakeRequest() {
}

void TMakeRequest::Midnight(const TString& id, TReqParams* /*m_ReqParams*/) {
    TString text = "";

    if ((srvcobj.GetGeneralObject() != NULL)) {
        srvcobj.GetGeneralObject()->Midnight();

        text = text + "Midnight command accepted<br>";
        text = text + "<A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";
        SendToClient(SO_LOG_MESSAGE, 200, text, id);
    }
}

void TMakeRequest::Shutdown(const TString& id, TReqParams* /*m_ReqParams*/) {
    TString text = "";

    srvcobj.GetGeneralObject()->Shutdown();

    text = text + "<html><head>";
    text = text + "<meta http-equiv='refresh' content='3; url=" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>";
    text = text + "</head><body bgcolor=palegoldenrod>\n";
    text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
    text = text + "<tr><td valign='top'>Shutdown command accepted.</td></tr>";
    text = text + "</table></body></html>";

    SendToClient(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::ConsoleA(const TString& id, TReqParams* /*m_ReqParams*/, bool short_view) {
    char CurTime[CShingleTime::MAX_TIME_SIZE];
    CShingleTime::GetTimeStr(CurTime);
    const char* table_color = "'#ffffcc'";
    TString text = "";
    TString reloadlink = "";
    TString debugtxt = "";
    TTrafficCtrlStat inputstat;
    ui32 getstat_tick = 0;
    ui32 storsize_tick = 0;
    ui32 allstorstat_tick = 0;
    ui32 cachestat_tick = 0;

    getstat_tick = CShingleTime::GetMs();
    //if (GetGeneralObject() != NULL)
    //   stat = GetGeneralObject()->GetStatistic();
    getstat_tick = CShingleTime::GetMs() - getstat_tick;

    text = text + "<i><b>Server control:</b></i>&nbsp;&nbsp;";
    text = text + "<A href='" + GetHost() + GetModuleName("askshutdown") + GetActionOneParam("askshutdown") + "'>Shutdown</A> &nbsp; ";
    text = text + "<A href='" + GetHost() + GetModuleName("askmidnight") + GetActionOneParam("askmidnight") + "'>Midnight</A> &nbsp; ";
    text = text + "<A href='" + GetHost() + GetModuleName("trunclogs") + GetActionOneParam("trunclogs") + "'>Trunc_logs</A> &nbsp;";
    text = text + "<A href='" + GetHost() + GetModuleName("askreload") + GetActionOneParam("askreload") + "' target='_blank'>Reload (rules, black list, white list)</A> &nbsp; ";

    if (short_view)
        text = text + "<A href='" + GetHost() + GetModuleName("askpushtostor") + GetActionOneParam("askpushtostor") + "' target='_blank'>Push_data_to_storage</A> &nbsp;";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
    text = text + "<tr valign='top'><td valign='left' width='25%'>Version</td><td>" + m_servername + "</td></tr>";
    if ((GetServiceObject().GetNumberRequest() != NULL))
        text = text + "<tr valign='top'><td valign='left' width='25%'>Host name (code)</td><td>" + GetServiceObject().GetNumberRequest()->GetHostName() + " (" + GetServiceObject().GetNumberRequest()->GetHostCode() + ")</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='25%'>Port</td><td>" + srvcobj.Port() + "</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='25%'>Start time</td><td>" + m_StartTime + "</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='25%'>Current time</td><td>" + TString(CurTime) + "</td></tr>";
    //text = text + "<tr valign='top'><td valign='left' width='25%'>Pool type</td><td>" + pooltypelink + "</td></tr>";
    if (GetLogsGroup()->GetDebugMode())
        debugtxt = "yes (<A href='" + GetHost() + GetModuleName("dsbdbgmode") + GetActionOneParam("dsbdbgmode") + "'>disable</A>)";
    else
        debugtxt = "no (<A href='" + GetHost() + GetModuleName("enbdbgmode") + GetActionOneParam("enbdbgmode") + "'>enable</A>)";
    text = text + "<tr valign='top'><td align='left' width='25%'>Debug mode</td><td>" + debugtxt + " &nbsp </td></tr>";
    text = text + "</table>";

    TString view_uid_storage_form = "<br><form action='" + GetHost() + GetModuleName("viewuidstor") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; uid= <input type='text' size='20' name='uid' value=''> &nbsp; " + GetActionFormParam("viewuidstor") + "<input type='submit' size='10' value='view storinfo'></form>";

    text = text + "<br><i><b>Storage:</b></i>:&nbsp;&nbsp;";
    text += "<A href='" + GetHost() + GetModuleName("storreaddump") + GetActionOneParam("storreaddump") + "'>Read dump</A> &nbsp; &nbsp; ";
    text += "<A href='" + GetHost() + GetModuleName("storwritedump") + GetActionOneParam("storwritedump") + "'>Write dump</A> &nbsp; &nbsp; ";
    text += "<A href='" + GetHost() + GetModuleName("storprintlist") + GetActionOneParam("storprintlist") + "'>Print list</A> &nbsp; &nbsp; ";
    text += "<A href='" + GetHost() + GetModuleName("rqstlimit") + GetActionOneParam("rqstlimit") + "' target='_blank'>View requests limit</A> &nbsp; &nbsp; ";
    text += "<A href='" + GetHost() + GetModuleName("getstorstat") + GetActionOneParam("getstorstat") + "' target='_blank'>Storage statistik</A> &nbsp; &nbsp; ";
    text += "<A href='" + GetHost() + GetModuleName("getcachestat") + GetActionOneParam("getcachestat") + "' target='_blank'>Cache statistik</A> &nbsp; &nbsp; ";
    text += "<A href='" + GetHost() + GetModuleName("tracestat") + GetActionOneParam("tracestat") + "' target='_blank'>Traccert statistik</A> &nbsp; &nbsp; ";
    text += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
    TString storage_status = "";
    if (GetGeneralObject()->StorageInitStatus(storage_status))
        text = text + "<tr valign='top'><td align='left' width='25%'>Storage: basa name (type)</td><td width='75%'>" + GetGeneralObject()->GetStorageIdent() + ": " + storage_status + " &nbsp </td></tr>";
    else
        text = text + "<tr valign='top'><td align='left' width='25%'>Storage: basa name (type)</td><td width='75%' bgcolor='red'>" + GetGeneralObject()->GetStorageIdent() + ": " + storage_status + " &nbsp </td></tr>";
    if (!short_view) {
        i64 storsizei = 0;

        storsize_tick = CShingleTime::GetMs();
        storsizei = GetGeneralObject()->GetStorageSize();
        storsize_tick = CShingleTime::GetMs() - storsize_tick;

        text = text + "<tr valign='top'><td align='left' width='25%'>Storage size</td><td width='75%'>" + UI64ToStroka(static_cast<ui64>(storsizei)) + " &nbsp </td></tr>";
    }
    text = text + "</table>";

    if (!short_view) {
        text = text + "<br><i><b>Servers:</b></i>&nbsp;&nbsp;";
        if (GetGeneralObject() != NULL)
            text += GetGeneralObject()->GetServersStatistikText(allstorstat_tick);
    }

    if (!short_view) {
        text = text + "<br><i><b>Services statistik:</b></i>&nbsp;&nbsp;";
        if (GetGeneralObject() != NULL)
            text += GetGeneralObject()->GetServicesStatistik();
    }

    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
        GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "TRACCERT: console=%u-%u-%u-%u", getstat_tick, storsize_tick, allstorstat_tick, cachestat_tick);

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::Console(const TString& id, TReqParams* m_ReqParams) {
    ui32 full_tick = CShingleTime::GetMs();
    bool skeep = false;

    if (GetGeneralObject()->GetLimitObj()->AddThread(TMakeRequestLimit::INTERFACE)) {
        skeep = false;

        ConsoleA(id, m_ReqParams, false);

        GetGeneralObject()->GetLimitObj()->ReturnThread(TMakeRequestLimit::INTERFACE);

    } else {
        skeep = true;

        SendToClientWithShap(SO_LOG_MESSAGE, 200, "Limit is exceeded the connection!", id);
    }

    full_tick = CShingleTime::GetMs() - full_tick;
    GetGeneralObject()->GetLimitObj()->AddTick(TMakeRequestLimit::INTERFACE, full_tick, skeep);
}

void TMakeRequest::ExtConsole(const TString& id, TReqParams* m_ReqParams) {
    ConsoleA(id, m_ReqParams, true);
}

bool TMakeRequest::ActionWOParse(const TString& /*Ident*/, TRequestDopData& /*data*/, const TString& /*InRequest*/, const TString& /*NumbRequest*/, const TString& /*request_source*/, int /*thread_index*/) {
    bool res = false;

    /*if (Ident == "ident")
   {
      //����� ������ ������ � ���
      if (InputLog != NULL)
         InputLog->WriteMessageAndData("<begin %s>%s<end>\n", NumbRequest.c_str(), request_source.c_str());

      //������������ ������ InRequest
      //...

      //���������� �����, ����� �� ������������ ������
      res = true;
   }*/

    return res;
}

bool TMakeRequest::ActionParse(const TString& Ident, TRequestDopData& /*data*/, TReqParams* m_ReqParams, const TString& NumbRequest, const TString& requrl, int thread_index) {
    bool res = false;

    if (Ident == "check-json") {
        try {
            if ((*m_ReqParams)["data"].empty())
                ythrow yexception() << "empty body";
            const auto js = NJson::ReadJsonFastTree(SafeRecode((*m_ReqParams)["data"].front()));

            if (m_ReqParams->contains("service"))
                (*m_ReqParams)["so_service"] = (*m_ReqParams)["service"];
            if (m_ReqParams->contains("form_id"))
                (*m_ReqParams)["so_form_name"] = (*m_ReqParams)["form_id"];

            for (const auto& [from, to] : {
                     std::make_tuple("form_id", "form_id"),
                     std::make_tuple("client_ip", "so_ip"),
                     std::make_tuple("client_uid", "client_uid"),
                     std::make_tuple("client_email", "client_email"),
                     std::make_tuple("capture_type", "capture_type"),
                     std::make_tuple("form_type", "form_type"),
                     std::make_tuple("form_realpath", "so_realpath"),
                     std::make_tuple("form_author", "so_login"),
                     std::make_tuple("subject_template", "subject_template"),
                     std::make_tuple("subject", "so_subject"),
                     std::make_tuple("from_template", "from_template"),
                     std::make_tuple("from", "from"),
                     std::make_tuple("body_template", "body_template"),
                     std::make_tuple("body", "so_comment"),
                     std::make_tuple("form_recipients", "so_rcpt"),
                     std::make_tuple("so_q1text", "so_q1text"),
                 }) {
                if (auto p = MapFindPtr(js.GetMapSafe(), from); p && !p->IsNull()) {
                    if (p->IsArray() && !p->GetArray().empty())
                        (*m_ReqParams)[to] = TReqValues{p->GetArray().front().GetStringRobust()};
                    else
                        (*m_ReqParams)[to] = TReqValues{p->GetStringRobust()};
                }
            }

            if (auto p = MapFindPtr(js.GetMapSafe(), "form_fields"); p && p->IsMap()) {
                for (const auto field : {
                        "guid",
                        "is_robot",
                        "chat_type",
                        "chat_creation_timestamp",
                        "message_timestamp",
                        "yandex_uid"
                    }) {
                    if (auto obj = MapFindPtr(p->GetMapSafe(), field); obj && obj->IsMap()) {
                        if (auto value = MapFindPtr(obj->GetMapSafe(), "value"); value && !value->IsNull()) {
                            (*m_ReqParams)[TString::Join("form_field_value_", field)] = TReqValues{value->GetStringRobust()};
                        }
                    }
                }
            }

            (*m_ReqParams)["so_login_as_uid"] = TReqValues{"1"};

            CheckCheckForm(thread_index, m_ReqParams, js, NumbRequest, requrl, work_delays);
            res = true;
        } catch (...) {
            Cerr << MakeRangeJoiner(",", (*m_ReqParams)["id"]) << ' ' << CurrentExceptionMessageWithBt() << Endl;
        }

    } else if (Ident == "check") {
        CheckCheckForm(thread_index, m_ReqParams, NJson::TJsonValue{}, NumbRequest, requrl, work_delays);
        res = true;

    } else if (Ident == "allrulesreset") {
        DoRulesReload("-");
        res = true;

    } else if (Ident == "favicon.ico") {
        SendToClientRAW(HTTP_200_OK(NumbRequest));
        res = true;

    } else if (Ident == "rslvipfromcache") {
        RslvIPFromCache("-", m_ReqParams);
        res = true;

    } else if (Ident == "getforfrodo") //debug
    {
        TestGetForFrodo(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "getforfrod2") //debug
    {
        TestGetForFrodo2(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "status") {
        Status(NumbRequest, m_ReqParams);
        res = true;
    }

    if ((!res)) //� ���������� �������
    {
        if (Ident == "reloadprop") {
            //ReloadProperties("");
            res = true;

        } else if (Ident == "askreload") {
            AskRulesReload("-");
            res = true;

        } else if (Ident == "doreload") {
            DoRulesReload("-");
            res = true;
        }
    }

    if ((!res)) //� ������� �������� ������������
    {
        if (Ident == "rqstlimit") {
            ViewRequestLimit();
            res = true;

        } else if (Ident == "getstorstat") {
            ViewStorStat();
            res = true;

        } else if (Ident == "getcachestat") {
            ViewCacheStat();
            res = true;

        } else if (Ident == "getudnssrvcdt") {
            GetUDNSServices("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewresolvstat") {
            ViewResolvStat();
            res = true;

        } else if (Ident == "trunclogs") {
            TruncLogs("-");
            res = true;

        } else if (Ident == "storreaddump") {
            StorReadDump();
            res = true;

        } else if (Ident == "storwritedump") {
            StorWriteDump();
            res = true;

        } else if (Ident == "storprintlist") {
            StorPrintlist();
            res = true;

        } else if (Ident == "tracestat") {
            TraccertStat("-");
            res = true;
        }
    }

    return res;
}

void TMakeRequest::AskRulesReload(const TString& id) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Reload rules & lists?')) {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("doreload") + GetActionOneParam("doreload") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";
    SendToClientRAW(text);
}

void TMakeRequest::DoRulesReload(const TString& /*id*/) {
    if (GetGeneralObject() != NULL) {
        TResetResponceCF rr;

        rr = GetGeneralObject()->Reset();
        if (rr.flag_ok) {
            SendToClientWithShap(SO_LOG_MESSAGE, 200, rr.filterres, "-");
        } else {
            SendToClient(SO_LOG_ERROR, 501, "Reload rules & lists - FAILED.", "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error!", "-");
    }
}

void TMakeRequest::ViewRequestLimit() {
    if (GetGeneralObject() != NULL) {
        TString text = "";

        if (GetGeneralObject() != NULL) {
            text = GetGeneralObject()->GetLimitObj()->GetWebStatistik();
            text += GetGeneralObject()->GetUpdateQueueWebStatistik();

            //text += "<br><i><b>Statistik for long data cache (read from storage):</b></i>&nbsp;&nbsp;";
            //text += GetGeneralObject()->GetLongStorCacheStatS();
        }

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

void TMakeRequest::ViewStorStat() {
    if (GetGeneralObject() != NULL) {
        TString text = "";
        TString prop1 = "";
        TString prop2 = "";

        prop1 = GetGeneralObject()->GetDriverProperties();
        prop2 = GetGeneralObject()->GetPutQueueProperties();

        text += "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
        text += "<tr>";
        text += "<td width='25%' valign='top'><i><b>Driver properties:</b></i>&nbsp;&nbsp;<br><br>" + prop1 + "</td>";
        text += "<td width='25%' valign='top'><i><b>Put queue properties:</b></i>&nbsp;&nbsp;<br><br>" + prop2 + "</td>";
        text += "<td width='25%' valign='top'>&nbsp;</td>";
        text += "<td width='25%' valign='top'>&nbsp;</td>";
        text += "</tr>";
        text += "</table><hr><br>";

        text += GetGeneralObject()->GetStorageWebStatistik();
        text += GetGeneralObject()->GetStorageTraccertStatistik();
        if (text.empty())
            text = "<br>Empty";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

void TMakeRequest::ViewCacheStat() {
    if (GetGeneralObject() != NULL) {
        TString text = "";

        text += GetGeneralObject()->GetReadCacheStatistik();
        text += GetGeneralObject()->GetPutQueueStatistik();

        if (text.empty())
            text = "<br>Empty";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

TString GetOnlyLocalID(const TString& id) {
    TString res = id;
    const char* p = NULL;
    int count = 0;

    p = strchr(id.c_str(), '[');
    if (p != NULL) {
        count = p - id.c_str() - 2;
        if (count > 0)
            res = id.substr(2, count);
    }

    return res;
}

void PrepareJson1(NJsonWriter::TBuf& js, bool spam, TMaybe<bool> dirtyword, TMaybe<bool> banrule) {
    js.WriteKey("spam").WriteBool(spam);
    if(dirtyword.Defined())
        js.WriteKey("dirty").WriteBool(*dirtyword);
    if(banrule.Defined())
        js.WriteKey("ban").WriteString(BoolToStroka4(*banrule));
}

void PrepareJson2(NJsonWriter::TBuf& js, bool spam, TMaybe<bool> dirtyword, TMaybe<bool> banrule) {
    js.WriteKey("spam").WriteInt(spam);
    if(dirtyword.Defined())
        js.WriteKey("dirty").WriteInt(*dirtyword);
    if(banrule.Defined())
        js.WriteKey("ban").WriteInt(*banrule);
}

void PrepareJson3(NJsonWriter::TBuf& js, bool spam, TMaybe<bool> dirtyword, TMaybe<bool> banrule) {
    js.WriteKey("spam").WriteBool(spam);
    if(dirtyword.Defined())
        js.WriteKey("dirty").WriteBool(*dirtyword);
    if(banrule.Defined())
        js.WriteKey("ban").WriteBool(*banrule);
}

using JsonPrepare = void(*)(NJsonWriter::TBuf& js, bool spam, TMaybe<bool> dirtyword, TMaybe<bool> banrule);

TString MakeJsonAnswer(bool spam, TMaybe<bool> dirtyword, TMaybe<bool> banrule, const TString& id, const TMaybe<TReceipt>& receipt, JsonPrepare prepare) {

    NJsonWriter::TBuf js;

    js.BeginObject();
    js.WriteKey("check");
    {
        js.BeginObject();

        prepare(js, spam, dirtyword, banrule);
        if(id)
            js.WriteKey("id").WriteString(id);
        if(receipt) {
            if (const auto data = receipt->CompressAndBase64())
                js.WriteKey("receipt").WriteString(data);
        }

        js.EndObject();
    }

    js.EndObject();

    return js.Str();
}


TString MakeXMLAnswer(bool spam, TMaybe<bool> dirtyword, TMaybe<bool> banrule, const TString& id, const TMaybe<TReceipt>& receipt, const TStringBuf clr) {
    TStringStream s;

    s << "<spam";
    if(receipt) {
        if (const auto data = receipt->CompressAndBase64())
            s << " receipt=\"" << data << "\"";
    }
    s << '>' << int(spam) << "</spam>" << clr;

    if (dirtyword)
        s << "<dirty>" << int(*dirtyword) << "</dirty>" << clr;
    if (banrule)
        s << "<ban>" << int(*banrule) << "</ban>" << clr;
    if(id)
        s << "<id>" << id << "</id>" << clr;

    return std::move(s.Str());
}

void TMakeRequest::CheckCheckForm(int /*thread_index*/, TReqParams* m_ReqParams, const NJson::TJsonValue& js, const TString& NumbRequest, const TString& source_request, TMakeRqstDelays* /*work_delays*/) {
    bool Spam = false;
    bool Skeep = false;
    TString service = "";
    TString formname = "";
    int is_xml = 0;
    bool is_json = false;
    bool is_json2 = false;
    bool is_json3 = false;
    bool dirtyword = false;
    bool banrule = false;
    bool retdirtypr = false;
    bool retbantag = false;
    TCheckformResponceType format;
    ui32 ttt = 0;
    ui32 ttt_full = 0;
    int http_code = 0;
    ui32 worktime = CShingleTime::GetMs();
    TString res = "";
    TString res_log = "";
    TAntiDDOSCriterionInfo antiddos;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL)) {
        if (GetGeneralObject()->GetCheckTC() != NULL)
            GetGeneralObject()->GetCheckTC()->Skeep();

        chkfrm::TDelayClass DelayClass;
        ttt_full = CShingleTime::GetMs();
        ttt = ttt_full;

        TMaybe<TReceipt> receipt;
        int r = GetGeneralObject()->CheckCF(m_ReqParams, js, Spam, NumbRequest, DelayClass, service, formname, Skeep, dirtyword, banrule, format, antiddos, receipt);


        if (r != 0) {
            PushSignal(TStringBuilder{} << service << "_5xx");
            http_code = 400;
            SendToClient(SO_LOG_ERROR, 400, ToString(r), NumbRequest);
        } else {
            PushSignal(TStringBuilder{} << service << '_' << (Spam ? TStringBuf("spam") : TStringBuf("ham")));
            ttt = CShingleTime::GetMs() - ttt;

            if ((GetConfigObject() != NULL) && (GetGeneralObject()->GetGroupFilter() != NULL)) {
                if (GetGeneralObject()->GetGroupFilter()->IsUnknownService(service)) {
                    is_xml = GetConfigObject()->ReadInteger("***UNKNOWN", "content-type-xml", 0);
                    is_json = GetConfigObject()->ReadInteger("***UNKNOWN", "content-type-json", false);
                    is_json2 = GetConfigObject()->ReadInteger("***UNKNOWN", "content-type-json2", false);
                    is_json3 = GetConfigObject()->ReadInteger("***UNKNOWN", "content-type-json3", false);
                    retdirtypr = GetConfigObject()->ReadBool("***UNKNOWN", "return_dirtyword_pr", false);
                    retbantag = GetConfigObject()->ReadBool("***UNKNOWN", "return_ban_tag", false);
                } else {
                    is_xml = GetConfigObject()->ReadInteger("***" + service, "content-type-xml", 0);
                    is_json = GetConfigObject()->ReadInteger("***" + service, "content-type-json", false);
                    is_json2 = GetConfigObject()->ReadInteger("***" + service, "content-type-json2", false);
                    is_json3 = GetConfigObject()->ReadInteger("***" + service, "content-type-json3", false);
                    retdirtypr = GetConfigObject()->ReadBool("***" + service, "return_dirtyword_pr", false);
                    retbantag = GetConfigObject()->ReadBool("***" + service, "return_ban_tag", false);
                }
            }

            switch (format) //������������ ����� �� ������ �� ������� (format=)
            {
                case RTEXT:
                    is_xml = 0;
                    is_json = false;
                    is_json2 = false;
                    is_json3 = false;
                    break;
                case RXML1:
                    is_xml = 1;
                    is_json = false;
                    is_json2 = false;
                    is_json3 = false;
                    break;
                case RXML2:
                    is_xml = 2;
                    is_json = false;
                    is_json2 = false;
                    is_json3 = false;
                    break;
                case RJSON:
                    is_xml = 0;
                    is_json = true;
                    is_json2 = false;
                    is_json3 = false;
                    break;
                case RJSON2:
                    is_xml = 0;
                    is_json = false;
                    is_json2 = true;
                    is_json3 = false;
                    break;
                case RJSON3:
                    is_xml = 0;
                    is_json = false;
                    is_json2 = false;
                    is_json3 = true;
                    break;
                case RUNKNOWN:
                    //��������� ��� ��-��������� �� �������
                    break;
            };

            res = "";
            res_log = "";

            const TMaybe<bool> dw = retdirtypr ? MakeMaybe(dirtyword) : Nothing();
            const TMaybe<bool> rb = retbantag ? MakeMaybe(banrule) : Nothing();

            switch (GetGeneralObject()->GetServiceType()) {
                default:
                    break;
                case SO_CHECKFORM:
                    if (is_json) {
                        res_log = res = MakeJsonAnswer(Spam, dw, rb, GetOnlyLocalID(NumbRequest), receipt, PrepareJson1);

                        http_code = 200;
                        SendToClientRAWJSON(SO_LOG_MESSAGE, 200, res, NumbRequest);

                    } else if (is_json2) {
                        res_log = res = MakeJsonAnswer(Spam, dw, rb, GetOnlyLocalID(NumbRequest), receipt, PrepareJson2);

                        http_code = 200;
                        SendToClientRAWJSON(SO_LOG_MESSAGE, 200, res, NumbRequest);

                    } else if (is_json3) {
                        res_log = res = MakeJsonAnswer(Spam, dw, rb, GetOnlyLocalID(NumbRequest), receipt, PrepareJson3);

                        http_code = 200;
                        SendToClientRAWJSON(SO_LOG_MESSAGE, 200, res, NumbRequest);

                    } else if (is_xml == 1) {
                        res_log = res = MakeXMLAnswer(Spam, dw, rb, TString{}, receipt, "");
                        if (Spam) {
                            res += "\n";
                        }
                        http_code = 200;
                        SendToClientRAWXML(SO_LOG_MESSAGE, 200, res, NumbRequest);

                    } else if (is_xml == 2) {
                        res = "<check>\n" + MakeXMLAnswer(Spam, dw, rb, GetOnlyLocalID(NumbRequest), receipt, "\n") + "</check>\n";
                        if (!Spam) {
                            res.pop_back();
                        }
                        res_log = "<check>" + MakeXMLAnswer(Spam, dw, rb, GetOnlyLocalID(NumbRequest), receipt, "") + "</check>";

                        http_code = 200;
                        SendToClientRAWXML(SO_LOG_MESSAGE, 200, res, NumbRequest);
                    } else {
                        res_log = res = MakeXMLAnswer(Spam, dw, rb, TString{}, receipt, "");
                        if (Spam) {
                            res = res + "\n"; //������ silk@, ����� ��������� � ���� ������� ������ (�������� '\n')
                        }

                        http_code = 200;
                        SendToClientRAWPlain(SO_LOG_MESSAGE, 200, res, NumbRequest);
                    }
                    break;
                case SO_CLEANWEB:
                    if (is_json) {
                        res_log = res = MakeJsonAnswer(Spam, dw, rb, GetOnlyLocalID(NumbRequest), receipt, PrepareJson3);

                        http_code = 200;
                        SendToClientRAWJSON(SO_LOG_MESSAGE, 200, res, NumbRequest);

                    } else {
                        res = res_log =  "<check>" + MakeXMLAnswer(Spam, dw, rb, GetOnlyLocalID(NumbRequest), receipt, "") + "</check>";
                        http_code = 200;
                        SendToClientRAWXML(SO_LOG_MESSAGE, 200, res, NumbRequest);
                    }
                    break;
            };

            ttt_full = CShingleTime::GetMs() - ttt_full;
            DelayClass.SetDelayFull(ttt_full);

            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetSendAnswerLog() != NULL)) {
                if (antiddos.m_action)
                    res = res_log + " ( " + IntToStroka(DelayClass.GetFullDelay()) + " : " + antiddos.GetReport() + ")";
                else
                    res = res_log + " (" + DelayClass.GetReport2() + ")";
                GetLogsGroup()->GetSendAnswerLog()->WriteMessageAndData("%s\t%s", NumbRequest.c_str(), res.c_str());
            }
        }

        worktime = CShingleTime::GetMs() - worktime;
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetSendAnswerFullLog() != NULL)) {
            TString responce_s = res_log;
            GetLogsGroup()->GetSendAnswerFullLog()->WriteMessageAndData("%s % 5u % 3d SRVC='%s' SRC='%s' RSPNC='%s'", NumbRequest.c_str(), worktime, http_code, service.c_str(), source_request.c_str(), responce_s.c_str());
        }

        if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetDelaysStorage() != NULL))
            GetGeneralObject()->GetDelaysStorage()->Add(service, formname, worktime, Spam, banrule, dirtyword, http_code);
    }
}

void TMakeRequest::RslvIPFromCache(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString ips = "";
    TKIPv6 ip = TKIPv6();

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetFilter() != NULL)) {
        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ips = Trim(par_it->second[0]);
            if (!ips.empty())
                ip = TKIPv6(ips.c_str());
        }

        if (!ip.Undefined()) {
            text += GetGeneralObject()->GetFilter()->GetRslvIPFromCache(ip);

            SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request", "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::GetUDNSServices(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    const char* table_color = "'#ffffcc'";
    TString text = "";
    TString ips = "";
    TKIPv6 ip = TKIPv6();
    TSummDataUdnsList stat_list;
    TSummDataUdnsListIt it;

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetFilter() != NULL)) {
        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ips = Trim(par_it->second[0]);
            if (!ips.empty())
                ip = TKIPv6(ips.c_str());
        }

        if (!ip.Undefined()) {
            GetGeneralObject()->GetFilter()->GetUdnsServicesIPData("", ip, stat_list);

            text = text + "<i><b>UDNS result for ip='" + ip.toStroka() + "':</b></i>&nbsp;&nbsp;";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";

            text = text + "<tr align='center'>";
            text = text + "<td width='5%'><b>SERVICE</b></td>";
            text = text + "<td width='5%'><b>HOST:PORT</b></td>";
            text = text + "<td width='5%'><b>TIMEOUT</b></td>";
            text = text + "<td width='10%'><b>ZONE</b></td>";
            text = text + "<td width='5%'><b>TICK</b></td>";
            text = text + "<td width='70%'><b>RESULT</b></td>";
            text = text + "</tr>";

            it = stat_list.begin();
            while (it != stat_list.end()) {
                text = text + "<tr align='right'>";
                text = text + "<td align='left'>" + (*it).m_data.m_name + "</td>";
                if ((*it).m_prop.m_enable)
                    text = text + "<td>" + (*it).m_prop.m_host + ":" + IntToStroka((*it).m_prop.m_port) + "</td>";
                else
                    text = text + "<td>disabled (" + (*it).m_prop.m_host + ":" + IntToStroka((*it).m_prop.m_port) + ")</td>";
                text = text + "<td>" + IntToStroka((*it).m_prop.m_timeout) + "</td>";
                text = text + "<td>" + (*it).m_prop.m_zone + "</td>";
                text = text + "<td>" + IntToStroka((*it).m_data.m_tick) + "</td>";
                if ((*it).m_data.m_ok)
                    text = text + "<td>" + (*it).m_data.ToResultS() + "</td>";
                else
                    text = text + "<td>FAILED</td>";
                text = text + "</tr>";

                ++it;
            }
            text = text + "</table>";

            SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request", "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::TraccertStat(const TString& /*id*/) {
    if (GetGeneralObject() != NULL) {
        TString text = "";

        text += "<i><b>Traccert statistik for 'check':</b></i> &nbsp; ";
        text += "<A href='" + GetHost() + GetModuleName("viewresolvstat") + GetActionOneParam("viewresolvstat") + "' target=_blank>viewresolvstat</A> &nbsp; ";
        text += "<br><br>";

        text += GetGeneralObject()->GetTraccertStatWeb();

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text.c_str(), "-");

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::ViewResolvStat() {
    TString text = "";

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetFilter() != NULL)) {
        TString ipfromcache_form = "<b>Get IP info from cache: </b><form action='" + GetHost() + GetModuleName("rslvipfromcache") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; <input type='text' size='30' name='ip' value=''> &nbsp; " + GetActionFormParam("rslvipfromcache") + "<input type='submit' size='10' value='query by ip'></form>";

        text = GetGeneralObject()->GetFilter()->ViewResolvWebStat(ipfromcache_form);

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::AskPushToStorage(const TString& /*id*/) {
    TString text = "";

    text = text + HTTP_200_OK("-");
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Push data from file to storage (the old data will be overwritten)?')) {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("dopushtostor") + GetActionOneParam("dopushtostor") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";
    SendToClientRAW(text);
}

void TMakeRequest::DoPushToStorage(const TString& /*id*/) {
    TString text = "";

    if (GetGeneralObject() != NULL) {
        /*if (GetGeneralObject()->PushToStorage())
         text += "Push data to storage - Busy";
      else
         text += "Push data to storage - OK";*/

        SendToClient(SO_LOG_MESSAGE, 200, text, "-");

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::TestGetForFrodo(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();

    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = par_it->second[0];
        CGIUnescape(ip_s);
        ip_s = Trim(ip_s);
        ip = TKIPv6(ip_s.c_str());

        if (!ip.Undefined()) {
            ui32 today_ham = 0;
            ui32 today_spam = 0;
            ui32 today_malic = 0;
            ui32 today_flags = 0;
            ui32 yesterday_ham = 0;
            ui32 yesterday_spam = 0;
            ui32 yesterday_malic = 0;
            ui32 yesterday_flags = 0;
            ui32 history_reject = 0;
            ui32 history_noreject = 0;
            ui32 history_ham = 0;
            ui32 history_spam = 0;
            char buff[2048];
            TString hostgeo = "";
            TString rdns = "";
            TString geo = "";

            today_ham = 1;
            today_spam = 0;
            today_malic = 0;
            today_flags = 0;

            yesterday_ham = 1;
            yesterday_spam = 0;
            yesterday_malic = 0;
            yesterday_flags = 0;

            history_reject = 0;
            history_noreject = 1;
            history_ham = 1;
            history_spam = 0;

            snprintf(buff, sizeof(buff) - 1, "ip=%s&empty=0&data=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u&host=%s&geo=%s", ip.toStroka().c_str(), today_ham, today_spam, today_malic, today_flags, yesterday_ham, yesterday_spam, yesterday_malic, yesterday_flags, history_reject, history_noreject, history_ham, history_spam, rdns.c_str(), geo.c_str());
            text = TString(buff);

            SendToClientRAW(HTTP_200_OK(id) + text);

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request (bad ip parameters).", id);
        }
    } else {
        SendToClient(SO_LOG_ERROR, 400, "Bad request (no ip parameters).", id);
    }
}

void TMakeRequest::TestGetForFrodo2(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();

    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = par_it->second[0];
        CGIUnescape(ip_s);
        ip_s = Trim(ip_s);
        ip = TKIPv6(ip_s.c_str());

        if (!ip.Undefined()) {
            ui32 today_ham = 0;
            ui32 today_spam = 0;
            ui32 today_malic = 0;
            ui32 today_flags = 0;
            ui32 yesterday_ham = 0;
            ui32 yesterday_spam = 0;
            ui32 yesterday_malic = 0;
            ui32 yesterday_flags = 0;
            ui32 history_reject = 0;
            ui32 history_noreject = 0;
            ui32 history_ham = 0;
            ui32 history_spam = 0;
            char buff[2048];
            TString hostgeo = "";
            bool ban = false;
            ui16 ban_hours = 0;
            ui8 ban_pr = 0;
            bool ban7 = false;
            ui16 ban7_hours = 0;
            ui8 ban7_pr = 0;
            TString ban_stat = "";
            TString ban7_stat = "";
            TString rdns = "";
            TString geo = "";

            //���������� ����
            //GetStatIPObject()->IsBanIpExt(ip, ban, ban_hours, ban_pr, ban7, ban7_hours, ban7_pr);
            ban_stat = BoolToStroka(ban) + "-" + IntToStroka(ban_hours) + "-" + IntToStroka(ban_pr);
            ban7_stat = BoolToStroka(ban7) + "-" + IntToStroka(ban7_hours) + "-" + IntToStroka(ban7_pr);

            //���������� �� ������
            today_ham = 1;
            today_spam = 0;
            today_malic = 0;
            today_flags = 0;

            yesterday_ham = 1;
            yesterday_spam = 0;
            yesterday_malic = 0;
            yesterday_flags = 0;

            history_reject = 0;
            history_noreject = 1;
            history_ham = 1;
            history_spam = 0;

            snprintf(buff, sizeof(buff) - 1, "ip=%s&empty=0&data=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u&host=%s&geo=%s&ban=%s&ban7=%s", ip.toStroka().c_str(), today_ham, today_spam, today_malic, today_flags, yesterday_ham, yesterday_spam, yesterday_malic, yesterday_flags, history_reject, history_noreject, history_ham, history_spam, rdns.c_str(), geo.c_str(), ban_stat.c_str(), ban7_stat.c_str());
            text = TString(buff);

            SendToClientRAW(HTTP_200_OK(id) + text);

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request (bad ip parameters).", id);
        }

    } else {
        SendToClient(SO_LOG_ERROR, 400, "Bad request (no ip parameters).", id);
    }
}

TString TMakeRequest::HTTP_200_OK_PlainExt(float rating, ui8 hash_one, ui64 hash_two) {
    TString text = "";

    text = text + "Status: 200 OK\r\n";
    text = text + "Server: " + m_servername + "\r\n";
    text = text + "Content-type: text/plain\r\n";
    text = text + "Rate: " + FloatToStr0(rating) + "\r\n";
    text = text + "HashOne: " + IntToStroka(hash_one) + "\r\n";
    text = text + "HashTwo: " + ShingleToStroka2(hash_two) + "\r\n";
    text = text + "\r\n";

    return text;
}

void TMakeRequest::StorReadDump() {
    if (GetGeneralObject() != NULL) {
        bool res = false;
        ui32 collection_count = 0;
        ui32 record_count = 0;
        TString text = "";
        ui32 tick = 0;

        tick = CShingleTime::GetMs();
        res = GetGeneralObject()->ReadDump(collection_count, record_count);
        tick = CShingleTime::GetMs() - tick;
        if (res) {
            text = "read dump - OK (" + IntToStroka(tick) + "ms, collection_count = " + IntToStroka(collection_count) + ", all_record_count = " + IntToStroka(record_count) + ")";
            SendToClient(SO_LOG_MESSAGE, 200, text, "-");

        } else {
            text = "read dump - FAILED (" + IntToStroka(tick) + "ms)";
            SendToClient(SO_LOG_ERROR, 400, text, "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::StorWriteDump() {
    if (GetGeneralObject() != NULL) {
        bool res = false;
        ui32 collection_count = 0;
        ui32 record_count = 0;
        TString text = "";
        ui32 tick = 0;

        tick = CShingleTime::GetMs();
        res = GetGeneralObject()->WriteDump(collection_count, record_count);
        tick = CShingleTime::GetMs() - tick;
        if (res) {
            text = "write dump - OK (" + IntToStroka(tick) + "ms, collection_count = " + IntToStroka(collection_count) + ", all_record_count = " + IntToStroka(record_count) + ")";
            SendToClient(SO_LOG_MESSAGE, 200, text, "-");

        } else {
            text = "write dump - FAILED (" + IntToStroka(tick) + "ms)";
            SendToClient(SO_LOG_ERROR, 400, text, "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::StorPrintlist() {
    if (GetGeneralObject() != NULL) {
        bool res = false;
        ui32 collection_count = 0;
        ui32 record_count = 0;
        TString text = "";
        ui32 tick = 0;

        tick = CShingleTime::GetMs();
        res = GetGeneralObject()->ListDump(collection_count, record_count);
        tick = CShingleTime::GetMs() - tick;
        if (res) {
            text = "list dump - OK (" + IntToStroka(tick) + "ms, collection_count = " + IntToStroka(collection_count) + ", all_record_count = " + IntToStroka(record_count) + ")";
            SendToClient(SO_LOG_MESSAGE, 200, text, "-");

        } else {
            text = "list dump - FAILED (" + IntToStroka(tick) + "ms)";
            SendToClient(SO_LOG_ERROR, 400, text, "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::Status(const TString& /*id*/, TReqParams* /*m_ReqParams*/) {
    if (GetGeneralObject() != NULL) {
        TString text = "";
        bool err = false;
        ui32 last_update_bd_diff = 0;
        ui32 current_time = time(NULL);
        ui32 start_diff = 0;
        const ui32 STARTDIFF = 5 * 60;
        const ui32 BADDIFF = 5 * 60;

        if (current_time > m_StartTimeTick)
            start_diff = current_time - m_StartTimeTick;
        if (current_time > GetGeneralObject()->GetLastUpdateStatistikToBD())
            last_update_bd_diff = current_time - GetGeneralObject()->GetLastUpdateStatistikToBD();
        if (start_diff >= STARTDIFF) {
            if (last_update_bd_diff >= BADDIFF) {
                text += "BD: error updating statistics (" + IntToStroka(last_update_bd_diff) + " sec);";
                err = true;

            } else {
                err = false;
            }
        }

        if (err) {
            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetCriticalEventLog() != NULL)) {
                GetLogsGroup()->GetCriticalEventLog()->WriteMessageAndDataStatus(KERROR, "%s", text.c_str());
                GetLogsGroup()->GetCriticalEventLog()->FFlush();
            }

            SendToClient(SO_LOG_ERROR, 500, text.c_str(), "-");

        } else {
            SendToClient(SO_LOG_MESSAGE, 200, "OK", "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

//*******************************************************************************************************************************************
