#pragma once

#include "util/generic/hash.h"
#include <mail/so/spamstop/tools/fcgiserver_base/tserviceobjectbase.h>
#include <mail/so/spamstop/tools/fcgiserver_base/tmakerequestbase.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/thashipv6.h>
#include <mail/so/spamstop/tools/so-common/tnetipv6.h>
#include "tserviceobject.h"
#include "tlogsgroup_cf.h"
#include "tgeneralobject.h"
#include "trqstlimit.h"
#include "tconsolestat.h"
#include "antiddosstor.h"
#include "tcheckform_types.h"
#include "traccert.h"

//*******************************************************************************************************************************************
//                                                             TMakeRequest
//*******************************************************************************************************************************************

class TMakeRequest : public TMakeRequestBase {
private:
    static const int MAX_BAN_IP_COUNT = 1000; //����� ��������
    //static const ui32 LONG_REQUEST_DEFAULT   = 200;      //���� ������, �� � ������� ������ RT
    enum TCorrectLongstatType { CLT_IP,
                                CLT_FIELD,
                                CLT_SHINGLE };

private:
    TServiceObject& GetServiceObject() {
        return dynamic_cast<TServiceObject&>(srvcobj);
    }
    TLogsGroupCF* GetLogsGroup() {
        return (TLogsGroupCF*)srvcobj.GetLogsGroup();
    }
    TKConfig* GetConfigObject() {
        return srvcobj.GetConfigObject();
    }
    TGeneralObject* GetGeneralObject() {
        return (TGeneralObject*)srvcobj.GetGeneralObject();
    }

    void Midnight(const TString& id, TReqParams* m_ReqParams) override;
    void Shutdown(const TString& id, TReqParams* m_ReqParams) override;
    void Console(const TString& id, TReqParams* m_ReqParams) override;
    void ExtConsole(const TString& id, TReqParams* m_ReqParams) override;

    bool ActionWOParse(const TString& Ident, TRequestDopData& data, const TString& InRequest, const TString& NumbRequest, const TString& request_source, int thread_index) override;
    bool ActionParse(const TString& Ident, TRequestDopData& data, TReqParams* m_ReqParams, const TString& NumbRequest, const TString& requrl, int thread_index) override;

    void ConsoleA(const TString& id, TReqParams* m_ReqParams, bool short_view);

    void AskRulesReload(const TString& id);
    void DoRulesReload(const TString& id);

    void ViewRequestLimit();
    void ViewStorStat();
    void ViewCacheStat();

    void RslvIPFromCache(const TString& id, TReqParams* m_ReqParams);
    void GetUDNSServices(const TString& id, TReqParams* m_ReqParams);

    void TraccertStat(const TString& id);

    void ViewResolvStat();
    void CheckCheckForm(int thread_index, TReqParams* m_ReqParams, const NJson::TJsonValue& js, const TString& NumbRequest, const TString& source_request, TMakeRqstDelays* work_delays);

    void AskPushToStorage(const TString& id);
    void DoPushToStorage(const TString& id); //push data from file to storage

    void StorReadDump();
    void StorWriteDump();
    void StorPrintlist();

    void TestGetForFrodo(const TString& id, TReqParams* m_ReqParams);
    void TestGetForFrodo2(const TString& id, TReqParams* m_ReqParams);

    void Status(const TString& id, TReqParams* m_ReqParams);

    TString HTTP_200_OK_PlainExt(float rating, ui8 hash_one, ui64 hash_two);

public:
    TMakeRequest(TServiceObjectBase& srvcobjA, void* serverA);
    ~TMakeRequest() override;
};

//*******************************************************************************************************************************************
