#include "top20list.h"

//****************************************************************************************************************************************
//                                                     TTop20ListItem
//****************************************************************************************************************************************

TTop20ListItem::TTop20ListItem() {
    m_name = "";
    allrqst = 0;
}

TTop20ListItem::TTop20ListItem(const TString& name, const TString& value) {
    m_name = name;
    allrqst = 0;
    AddValue(value);
}

TTop20ListItem::~TTop20ListItem() {
}

void TTop20ListItem::AddValue(const TString& value) {
    TTop20DataHashIt it;
    ui64 shingle = 0;

    if (!value.empty()) {
        shingle = ShingleFromStroka(value);
        if (shingle > 0) {
            allrqst = IncMax64(allrqst, 1);
            it = storage.find(shingle);
            if (it != storage.end()) {
                (*it).second.Increment();

            } else {
                storage[shingle] = TTop20Data(value);
            }
        }
    }
}

TString TTop20ListItem::GetTop20() {
    TString res = "";
    TTop20DataHashIt it;
    TTop20DataSet topset;
    TTop20DataSetIt sit;
    int count = 0;
    float prcnt = 0;

    it = storage.begin();
    while (it != storage.end()) {
        topset.insert((*it).second);

        ++it;
    }

    sit = topset.begin();
    while (sit != topset.end()) {
        count++;
        if (count > 20)
            break;

        if (allrqst > 0)
            prcnt = (float)(*sit).GetCount() * (float)100 / (float)allrqst;
        else
            prcnt = 0;
        res = res + FloatToStr(prcnt) + "% (" + IntToStroka4((*sit).GetCount()) + ") '" + (*sit).GetData() + "'\n";

        ++sit;
    }

    return res;
}

TString TTop20ListItem::GetTop20Text() {
    TString res = "";
    TTop20DataHashIt it;
    TTop20DataSet topset;
    TTop20DataSetIt sit;
    int count = 0;
    float prcnt = 0;
    TString text_prev = "";
    TString text_next = "";

    it = storage.begin();
    while (it != storage.end()) {
        text_prev = text_prev + ShingleToStroka((*it).first) + ":'" + (*it).second.GetData() + "'(" + IntToStroka((*it).second.GetCount()) + ")\n";
        topset.insert((*it).second);
        //f_ok = topset.insert((*it).second).second;

        ++it;
    }

    text_next = text_next + "ALLSIZESET=" + IntToStroka(topset.size()) + "\n";
    sit = topset.begin();
    while (sit != topset.end()) {
        text_next = text_next + "'" + (*sit).GetData() + "'(" + IntToStroka((*sit).GetCount()) + ")\n";

        ++sit;
    }

    sit = topset.begin();
    while (sit != topset.end()) {
        count++;
        if (count > 20)
            break;

        if (allrqst > 0)
            prcnt = (float)(*sit).GetCount() * (float)100 / (float)allrqst;
        else
            prcnt = 0;
        res = res + FloatToStr(prcnt) + "% (" + IntToStroka4((*sit).GetCount()) + ") '" + (*sit).GetData() + "'\n";

        ++sit;
    }

    res = text_prev + "*******\n" + text_next + "*******\n" + res;

    return res;
}

//****************************************************************************************************************************************
//                                                       TTop20List
//****************************************************************************************************************************************

TTop20List::TTop20List() {
    m_service = "";
    storage = new TTop20ListItemHash();
    m_log = NULL;
    m_lastwritestat = time(NULL);
}

TTop20List::~TTop20List() {
    if (storage != NULL) {
        delete storage;
        storage = NULL;
    }
}

void TTop20List::Lock() {
    m_Mutex.Acquire();
}

void TTop20List::UnLock() {
    m_Mutex.Release();
}

void TTop20List::Init(TLogClass* log, const TString& service) {
    m_service = service;
    m_log = log;
    m_lastwritestat = time(NULL);
}

void TTop20List::AddValue(const TString& field_name, const TString& value) {
    ui64 shingle = 0;
    TTop20ListItemHashIt it;

    if ((m_log != NULL) && (!field_name.empty())) {
        shingle = ShingleFromStroka(field_name);
        if (shingle != 0) {
            Lock();

            if (storage == NULL)
                storage = new TTop20ListItemHash();

            if (storage != NULL) {
                it = storage->find(shingle);
                if (it != storage->end()) {
                    (*it).second.AddValue(value);

                } else {
                    //(*storage)[shingle] = TTop20ListItem(field_name, value);
                    //it = storage->insert(TTop20ListItemHash::value_type(shingle, TTop20ListItem(field_name, value))).first;
                    storage->insert(TTop20ListItemHash::value_type(shingle, TTop20ListItem(field_name, value)));
                }
            }

            UnLock();
        }
    }
}

void TTop20List::WriteTopToLog(TTop20ListItemHash* stor) {
    TTop20ListItemHashIt it;
    TString text = "";

    if (m_log != NULL) {
        if ((stor != NULL) && (stor->size() > 0)) {
            it = stor->begin();
            while (it != stor->end()) {
                text = text + "FIELD='" + (*it).second.GetName() + "', all=" + UI64ToStroka((*it).second.GetAllRqst()) + ":\n" + (*it).second.GetTop20() + "\n";

                ++it;
            }

        } else {
            text = text + "NO DATA\n";
        }

        m_log->WriteMessageAndDataStatus(KMESSAGE, "TOP20 by fields for '%s'\n%s", m_service.c_str(), text.c_str());
    }
}

void TTop20List::CalcStatByTime() {
    if (m_log != NULL) {
        tm tlast, tcurr;
        time_t currtime = time(NULL);

        tlast = *localtime(&m_lastwritestat);
        tcurr = *localtime(&currtime);

        if ((tlast.tm_year != tcurr.tm_year) || (tlast.tm_mon != tcurr.tm_mon) || (tlast.tm_mday != tcurr.tm_mday) || (tlast.tm_hour != tcurr.tm_hour) || (tlast.tm_min != tcurr.tm_min)) {
            TTop20ListItemHash* oldstorage = NULL;

            Lock();

            m_lastwritestat = currtime;
            if (storage != NULL) {
                oldstorage = storage;
                storage = new TTop20ListItemHash();
            }

            UnLock();

            if (oldstorage != NULL) {
                WriteTopToLog(oldstorage);

                delete oldstorage;
                oldstorage = NULL;
            }
        }
    }
}

void TTop20List::CalcStatWOTime() {
    if (m_log != NULL) {
        TTop20ListItemHash* oldstorage = NULL;

        Lock();

        m_lastwritestat = time(NULL);
        if (storage != NULL) {
            oldstorage = storage;
            storage = new TTop20ListItemHash();
        }

        UnLock();

        if (oldstorage != NULL) {
            WriteTopToLog(oldstorage);

            delete oldstorage;
            oldstorage = NULL;
        }
    }
}

void TTop20List::EventTick() {
    CalcStatByTime();
}

//****************************************************************************************************************************************
