#pragma once

#include "util/generic/string.h"
#include <set>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>

//****************************************************************************************************************************************
//                                                     TTop20ListItem
//****************************************************************************************************************************************

class TTop20Data {
private:
    TString m_data;
    ui32 m_count;

public:
    TTop20Data() {
        m_data = "";
        m_count = 0;
    }

    TTop20Data(const TString& data_s) {
        const int max_symb_count = 128;

        if (data_s.length() > max_symb_count)
            m_data = data_s.substr(0, max_symb_count);
        else
            m_data = data_s;
        m_count = 1;
    }

    ~TTop20Data() {
    }

    ui32 GetCount() const {
        return m_count;
    }

    TString GetData() const {
        return m_data;
    }

    void Increment() {
        m_count = IncMax32(m_count, 1);
    }

    TString PrintToLog() {
        return (IntToStroka(m_count) + "'" + m_data + "'");
    }

    bool operator<(const TTop20Data& value) const {
        bool res = false;

        res = (value.m_count < m_count);

        return res;
        //return ( (value.m_count < m_count) && (value.m_data < m_data) );
    }
};

typedef THashMap<ui64, TTop20Data> TTop20DataHash;
typedef TTop20DataHash::iterator TTop20DataHashIt;

typedef std::multiset<TTop20Data> TTop20DataSet;
typedef TTop20DataSet::iterator TTop20DataSetIt;

//****************************************************************************************************************************************
//                                                     TTop20ListItem
//****************************************************************************************************************************************

class TTop20ListItem {
private:
    TString m_name;
    TTop20DataHash storage;
    ui64 allrqst;

public:
    TTop20ListItem();
    TTop20ListItem(const TString& name, const TString& value);
    ~TTop20ListItem();

    void AddValue(const TString& value);
    TString GetTop20();
    TString GetTop20Text();
    TString GetName() {
        return m_name;
    }
    ui64 GetAllRqst() {
        return allrqst;
    }
};

typedef THashMap<ui64, TTop20ListItem> TTop20ListItemHash;
typedef TTop20ListItemHash::iterator TTop20ListItemHashIt;

//****************************************************************************************************************************************
//                                                       TTop20List
//****************************************************************************************************************************************

class TTop20List {
private:
    TString m_service;
    TTop20ListItemHash* storage;
    TLogClass* m_log;
    TMutex m_Mutex;
    time_t m_lastwritestat;

    void Lock();
    void UnLock();
    void WriteTopToLog(TTop20ListItemHash* stor);

public:
    TTop20List();
    ~TTop20List();

    void Init(TLogClass* log, const TString& service);
    void AddValue(const TString& field_name, const TString& value);
    void CalcStatByTime();
    void CalcStatWOTime();
    void EventTick();
};

//****************************************************************************************************************************************
