#pragma once

#include "util/generic/string.h"
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/urlparser.h>
#include <mail/so/spamstop/tools/so-common/tspamstatclient.h>
#include <mail/so/spamstop/tools/so-common/tphoneparser.h>
#include <list>
#include <mail/so/spamstop/tools/so-common/local_cache_template.h>
#include "tstorebase_data.h"

//****************************************************************************************************************
//                                        TObrabParams
//****************************************************************************************************************

using TBBInfo = TAtomicSharedPtr<NBlackbox2::TResponse>;
using TBBCache = NCache::TCacheBase<ui64, TBBInfo>;

struct TObrabParams {
    TObrabParams() = default;
    TString so_service = UNKNOWNSERVICE;
    TString so_service_from_fitem = UNKNOWNSERVICE;
    int max_mess_count_from_login{};
    bool msearch_step2{};
    int msearch_found{};
    int msearch_offset = -1;
    bool no_write_storage{};
    TKIPv6 ip;
    TString phone;
    bool is_black_ip{};
    bool is_white_ip{};
    TString form_name;
    TString rcpt;
    size_t rcpt_count{};
    TZoneDetector::TStrokaHash hlist_rcpt;
    TZoneDetector::TStrokaHash mlist_rcpt;
    TZoneDetector::TStrokaHash hlist;
    TZoneDetector::TStrokaHash mlist;
    TZoneDetector::TKUrlHash urlhash_t;
    bool urlmail_parse_max{};
    ui32 max_host_count_in_field{};
    ui32 max_email_count_in_field{};
    common::TPhoneParser::TPhoneList plist;
    ui32 max_phone_count_in_field{};
    stordata::TStorDataByHMP stordata_hmp;
    TString id_postcard;
    ui64 so_idpostcard_shingle{};
    TString login, so_login;
    TInstant soCustomUserRegdate;

    NThreading::TFuture<std::tuple<TBBInfo, TMaybe<TString>, TMaybe<TUrlStatisticVector>>> curlFuture;
    TString formId;
    bool is_black_login{};
    bool is_white_login{};
    std::list<TString> login_virt1;
    TString xmpp_server_name;
    ui64 xmpp_server_name_shingle{};
    TString so_subject;
    ui32 so_subject_length{};
    ui32 so_subject_words{};
    ui64 so_subject_shingle{};
    bool soname_cmp_sosubject{};
    TString so_nick;
    ui32 so_nick_length{};
    ui32 so_nick_words{};
    ui64 so_nick_shingle{};
    TString so_comment;
    ui32 so_comment_length{};
    ui32 so_comment_words{};
    ui64 so_comment_shingle{};
    ui32 so_reg_age{};
    i32 so_reg_age_days{};
    TString so_reg_age_str;
    ui32 so_contlen{};
    bool est_contlen{};
    ui32 login_age{};
    i32 login_age_days = -1;
    TString login_age_str = "-";
    TString geos;
    TString geos_as;
    TString geos_tor;
    TString geotime;
    ui64 geo_shingle{};
    ui64 geocountry_shingle{};
    TString hosts;
    bool spamstat_today_ban{};
    bool spamstat_yesterday_ban{};
    ui64 ip_suid_total_hash{};
    ui64 ip_text_total_hash{};
    ui64 ip_suid_text_total_hash{};
    ui64 ip_found_hash{};
    ui64 suid_found_hash{};
    ui64 text_found_hash{};
    ui64 geos_found_hash{};
    ui64 ip_suid_found_hash{};
    ui64 ip_text_found_hash{};
    TSPSTDataRes spst_answer;
    stordata::TServiceStoreResult srvc_res;
    stordata::TCommonStoreResult common_res;
    NThreading::TFuture<TLongIPData> longipdataFuture;
    NThreading::TFuture<TLongIPData> longphonedataFuture;
    TSrvcStatMin srvc_data;
    ui64 so_login_chatid_shingle{};
    ui64 so_uniq_chats_by_login_shingle{};
};

//****************************************************************************************************************
//                                        TServiceFullStat
//****************************************************************************************************************

struct TServiceFullStat {
    TString m_so_service;
    TObrabParams m_data;
    bool m_collision_error{};

    TServiceFullStat() = default;

    TServiceFullStat(TString srvc_name) noexcept
        : m_so_service(std::move(srvc_name)) {
    }
};

typedef std::list<TServiceFullStat> TServiceFullStatList;
typedef TServiceFullStatList::iterator TServiceFullStatListIt;

//****************************************************************************************************************
