#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>

namespace chkfrm {
    //***********************************************************************************************************************
    //                                               TRuleInfo
    //***********************************************************************************************************************

    struct TRuleInfo {
        ui32 fulltime;
        ui32 count;

        TRuleInfo() {
            fulltime = 0;
            count = 0;
        }

        TRuleInfo(ui32 countA, ui32 fulltimeA) {
            fulltime = fulltimeA;
            count = countA;
        }

        void AppendTime(ui32 addtimeA) {
            fulltime = IncMax32(fulltime, addtimeA);
            count = IncMax32(count, 1);
        }
    };

    typedef THashMap<TString, TRuleInfo> TRuleInfoHash;
    typedef TRuleInfoHash::iterator TRuleInfoHashIt;

    //****************************************************************************************
    //                              TDelayClass
    //****************************************************************************************
    class TDelayClass {
    public:
        //static const ui32 ELCOUNT = 20;
        //ui32              Elements[ELCOUNT];
        ui32 start{};
        bool is_black_login{};
        bool is_white_login{};
        bool is_max_mess_from_login{};
        TString login;
        TString service;
        TRuleInfoHash ruleshash;

        ui32 check_delay{}; //����� ���������� �-�� check

        ui32 geo_delay{}; //����� ��������� ������ �� ���
        bool geo_delay_pr{};
        bool geo_delay_ok{};
        bool geo_delay_ru{};

        ui32 rblrule_delay{}; //����� ��������� ������ �� udns �������� �� ����������
        bool rblrule_delay_pr{};
        std::list<TString> rblrule_list;

        ui32 spamstat_delay{}; //����� ������� ������ �� ���������
        bool spamstat_delay_pr{};
        bool spamstat_delay_exist{};
        bool spamstat_today_ban{};
        bool spamstat_yesterday_ban{};
        bool spamstat_exist_host{};
        bool spamstat_exist_geo{};

        ui32 resolv_delay{}; //����� ����������
        bool resolv_delay_pr{};
        bool resolv_delay_ok{};

        bool antiddos_action{};
        bool antiddos_ip{};
        bool antiddos_xmpp_srv{};
        bool antiddos_login{};
        bool antiddos_subj{};
        bool antiddos_nick{};
        bool antiddos_comment{};

        bool updmsearchfound{};
        ui32 updmsearchfound_tick{};

        bool updlongipstat{};
        ui32 updlongipstat_tick{};
        bool get_longip_stat{};
        ui32 get_longip_stat_tick{};

        bool updlongphonestat{};
        ui32 updlongphonestat_tick{};
        bool get_longphone_stat{};
        ui32 get_longphone_stat_tick{};

        ui32 parse_host_email_phone_tick{};
        bool parse_host_email_phone{};

        ui32 get_from_storage_tick{};
        bool get_from_storage{};
        ui32 upd_to_storage_tick{};
        bool upd_to_storage{};

        bool get_filter_ok{};
        ui32 get_filter_ok_tick{};
        bool get_filter_failed{};
        ui32 get_filter_failed_tick{};
        ui32 filterwork_delay{}; //����� ������ rengine
        bool filterwork{};

        ui32 mongohosts{};  //���-�� ����������� ������ � ����
        ui32 mongoemails{}; //���-�� ����������� ������� � ����
        ui32 mongophones{}; //���-�� ����������� ��������� � ����
        ui32 hosts{};       //����� ���-�� ������
        ui32 emails{};      //����� ���-�� �������
        ui32 phones{};

        ui32 full_delay{};   //������ ����� (��������� ������, check � �����)
        ui32 filter_index{}; //������ ������������� ������� (>0)
        ui32 loop_count{};   //���-�� ������� �������� ������

        ui32 ipstat_collision_count{};
        ui32 phonestat_collision_count{};
        ui32 service_stat_collision_count{};
        ui32 shingles_collision_count{};

        bool writedlvlog{};
        ui32 writedlvlog_delay{};

    public:
        TDelayClass() = default;

        void SetBlackLogin() {
            is_black_login = true;
        }
        void SetWhiteLogin() {
            is_white_login = true;
        }
        void SetMaxMessFromLogin(TString& loginA) {
            is_max_mess_from_login = true;
            login = loginA;
        }

        TString GetReport2() {
            TString res = "";
            TRuleInfoHashIt it;
            bool first_record = true;

            if (is_black_login) {
                res = res + IntToStroka4D(full_delay) + " : black_login " + service;
            } else if (is_white_login) {
                res = res + IntToStroka4D(full_delay) + " : white_login " + service;
            } else if (is_max_mess_from_login) {
                res = res + IntToStroka4D(full_delay) + " : max_mess_from_login '" + login + "' " + service;
            } else {
                res += IntToStroka4D(full_delay) + " : " + service + " - ";
                res += "FIDX=" + IntToStroka2(filter_index) + ", ";
                if (loop_count > 1)
                    res += "LOOPCNT=" + IntToStroka(loop_count) + ", ";
                res += "CHK=" + IntToStroka4D(check_delay) + ", ";

                if (geo_delay_pr)
                    res += "GEO=" + IntToStroka(geo_delay) + ", ";
                if (geo_delay_ok)
                    res += "GEO_OK, ";

                if (spamstat_delay_pr) {
                    res += "SPST=" + IntToStroka(spamstat_delay) + ", ";
                    if (spamstat_delay_exist)
                        res += "SPST_EXIST, ";
                    /*if (spamstat_today_ban)
                        traccert_stat.AddTick("SPST (today_ban) <b>[CNT]</b>", 0);
                    if (spamstat_yesterday_ban)
                        traccert_stat.AddTick("SPST (yesterday_ban) <b>[CNT]</b>", 0);
                    if (spamstat_exist_host)
                        traccert_stat.AddTick("SPST (exist_host) <b>[CNT]</b>", 0);
                    if (spamstat_exist_geo)
                        traccert_stat.AddTick("SPST (exist_geo) <b>[CNT]</b>", 0);*/
                }

                if (resolv_delay_pr)
                    res += "RSLV=" + IntToStroka(resolv_delay) + ", ";
                if (resolv_delay_ok)
                    res += "RSLV_OK, ";

                if (is_black_login)
                    res += "BLK_LOGIN, ";
                if (is_white_login)
                    res += "WHT_LOGIN, ";
                if (is_max_mess_from_login)
                    res += "MAX_MESS_FROM_LOGIN, ";

                if (antiddos_action)
                    res += "ADDOS_ACT, ";
                if (antiddos_ip)
                    res += "ADDOS_IP, ";
                if (antiddos_xmpp_srv)
                    res += "ADDOS_XMPPSRV, ";
                if (antiddos_login)
                    res += "ADDOS_LGN, ";
                if (antiddos_subj)
                    res += "ADDOS_SUBJ, ";
                if (antiddos_nick)
                    res += "ADDOS_NICK, ";
                if (antiddos_comment)
                    res += "ADDOS_CMNT, ";

                if (updmsearchfound)
                    res += "UPD_MSRH_FND=" + IntToStroka(updmsearchfound_tick) + ", ";

                if (get_longip_stat)
                    res += "GETLONGIP=" + IntToStroka(get_longip_stat_tick) + ", ";
                if (updlongipstat)
                    res += "UPDLONGIP=" + IntToStroka(updlongipstat_tick) + ", ";

                if (get_longphone_stat)
                    res += "GETLONGPHONE=" + IntToStroka(get_longphone_stat_tick) + ", ";
                if (updlongphonestat)
                    res += "UPDLONGPHONE=" + IntToStroka(updlongphonestat_tick) + ", ";

                if (parse_host_email_phone)
                    res += "PARSE_HST_EML_PHN=" + IntToStroka(parse_host_email_phone_tick) + ", ";

                if (get_from_storage)
                    res += "GETSTOR=" + IntToStroka(get_from_storage_tick) + ", ";

                if (upd_to_storage)
                    res += "UPDSTOR=" + IntToStroka(upd_to_storage_tick) + ", ";

                if (get_filter_ok)
                    res += "FLTRGET_OK=" + IntToStroka(get_filter_ok_tick) + ", ";

                if (get_filter_failed)
                    res += "FLTRGET_FAIL=" + IntToStroka(get_filter_failed_tick) + ", ";

                if (filterwork)
                    res += "FLTRWRK=" + IntToStroka(filterwork_delay) + ", ";

                if (ipstat_collision_count > 0)
                    res += "IP_CLSN=" + IntToStroka(ipstat_collision_count) + ", ";
                if (phonestat_collision_count > 0)
                    res += "PHONE_CLSN=" + IntToStroka(phonestat_collision_count) + ", ";

                if (service_stat_collision_count > 0)
                    res += "SRVC_CLSN=" + IntToStroka(service_stat_collision_count) + ", ";

                if (shingles_collision_count > 0)
                    res += "SHIN_CLSN=" + IntToStroka(shingles_collision_count) + ", ";

                if (ruleshash.size() > 0) {
                    first_record = true;
                    it = ruleshash.begin();
                    while (it != ruleshash.end()) {
                        if ((*it).second.fulltime >= 50) {
                            if (first_record) {
                                first_record = false;
                                res = res + "RULES[count,time]:{";
                                res = res + (*it).first + "[" + IntToStroka((*it).second.count) + "," + IntToStroka((*it).second.fulltime) + "]";
                            } else
                                res = res + ", " + (*it).first + "[" + IntToStroka((*it).second.count) + "," + IntToStroka((*it).second.fulltime) + "]";
                        }

                        ++it;
                    }
                    if (!first_record)
                        res = res + "}";
                }
            }

            return res;
        }

        void SetDelayWriteDeliveryLog(ui32 delay) {
            writedlvlog = true;
            writedlvlog_delay = delay;
        }

        void SetService(const TString& serviceA) {
            service = serviceA;
        }

        void SetDelayGEO(ui32 delay, bool ok) {
            geo_delay = delay;
            geo_delay_pr = true;
            geo_delay_ok = ok;
        }

        void SetDelaySpamstat(ui32 delay, bool exist_data, bool today_ban, bool yesterday_ban, bool exist_host, bool exist_geo) {
            spamstat_delay = delay;
            spamstat_delay_pr = true;
            spamstat_delay_exist = exist_data;

            spamstat_today_ban = today_ban;
            spamstat_yesterday_ban = yesterday_ban;
            spamstat_exist_host = exist_host;
            spamstat_exist_geo = exist_geo;
        }

        void SetDelayResolv(ui32 delay, bool ok) {
            resolv_delay = delay;
            resolv_delay_pr = true;
            resolv_delay_ok = ok;
        }

        ui32 GetFullDelay() {
            return full_delay;
        }

        void AddHostChecked() {
            hosts++;
        }

        void AddMongoHostChecked() {
            mongohosts++;
        }

        void AddEmailChecked() {
            emails++;
        }

        void AddMongoEmailChecked() {
            mongoemails++;
        }

        void AddPhoneChecked() {
            phones++;
        }

        void AddMongoPhoneChecked() {
            mongophones++;
        }

        void SetDelayFull(ui32 delay) {
            full_delay = delay;
        }

        void SetFilterIndex(ui32 index) {
            filter_index = index;
        }

        void SetLoopCount(ui32 count) {
            loop_count = count;
        }

        TRuleInfoHash* GetRuleHash() {
            return &ruleshash;
        }
    };

} // namespace chkfrm
