#include <mail/so/spamstop/sp/spk3.h>
#include "trenginepool_cf.h"

//*****************************************************************************************************************************************
//                                                    TCalcRulesCSStat
//*****************************************************************************************************************************************

/*TCalcRulesCSStat::TCalcRulesCSStat()
{

}

TCalcRulesCSStat::~TCalcRulesCSStat()
{


}

void TCalcRulesCSStat::AddFilterCall(const TString &rules_cs)
{
   THashMap<TString, ui32>::iterator it;

   m_Mutex.Acquire();

   it = m_data.find(rules_cs);
   if (it != m_data.end())
      (*it).second++;
   else
      m_data[rules_cs] = 1;

   m_Mutex.Release();
}

TString TCalcRulesCSStat::GetUniqRulesCount()
{
   TString res              = "";
   int    uniq_part_count  = 0;
   int    all_call_count   = 0;
   THashMap<TString, ui32>::iterator it;

   m_Mutex.Acquire();

   uniq_part_count = m_data.size();
   it = m_data.begin();
   while (it != m_data.end())
   {
      all_call_count = all_call_count + (*it).second;
      ++it;
   }
   m_data.clear();

   m_Mutex.Release();

   res = IntToStroka(uniq_part_count) + "/" + IntToStroka(all_call_count);

   return res;
}*/

//****************************************************************************************
//                                     TKAtomic
//****************************************************************************************

/*TKAtomic::TKAtomic()
{
#ifdef KATOMIC_MUTEX

   m_value = 0;

#else

   m_value = 0;

#endif
}

TKAtomic::~TKAtomic()
{
#ifdef KATOMIC_MUTEX

#else

#endif
}

i64 TKAtomic::Value()
{
   i64 res = 0;

#ifdef KATOMIC_MUTEX

   res = m_value;

#else

   intptr_t a = 0;
   intptr_t b = 0;

   b = AtomicAdd(m_value, a);
   res = b;

#endif

   return res;
}

i64 TKAtomic::Add(i64 value)
{
   i64 res = 0;

#ifdef KATOMIC_MUTEX

   m_Mutex.Acquire();
   m_value = IncMax64_i(m_value, value);
   res     = m_value;
   m_Mutex.Release();

#else

   intptr_t a = value;
   intptr_t b = 0;

   b = AtomicAdd(m_value, a);
   res = b;

#endif

   return res;
}

i64 TKAtomic::Swap(i64 value)
{
   i64 res = 0;

#ifdef KATOMIC_MUTEX

   m_Mutex.Acquire();
   m_value = value;
   res     = m_value;
   m_Mutex.Release();

#else

   intptr_t a = value;
   intptr_t b = 0;

   b = AtomicSwap(&m_value, a);
   res = b;

#endif

   return res;
}

i64 TKAtomic::Increment()
{
   i64 res = 0;

#ifdef KATOMIC_MUTEX

   m_Mutex.Acquire();
   m_value = IncMax64_i(m_value, 1);
   res     = m_value;
   m_Mutex.Release();

#else

   intptr_t b = 0;

   b = AtomicIncrement(m_value);
   res = b;

#endif

   return res;
}

i64 TKAtomic::Decrement()
{
   i64 res = 0;

#ifdef KATOMIC_MUTEX

   m_Mutex.Acquire();
   m_value = IncMax64_i(m_value, -1);
   res     = m_value;
   m_Mutex.Release();

#else

   intptr_t b = 0;

   b = AtomicDecrement(m_value);
   res = b;

#endif

   return res;
}*/

//********************************************************************************************************************************
//                                                       TDiffCounter
//********************************************************************************************************************************

/*TDiffCounter::TDiffCounter()
{
   last_value = 0;
}

TDiffCounter::~TDiffCounter()
{

}

void TDiffCounter::Increment()
{
   curr_value.Increment();
}

ui32 TDiffCounter::GetDiff()
{
   ui32 res             = 0;
   i64  current_value   = 0;

   current_value = curr_value.Value();
   if (current_value > 0)
   {
      if (current_value < last_value)
      {
         m_Mutex.Acquire();

         last_value = 0;

         m_Mutex.Release();
      }
      if (current_value > last_value)
      {
         m_Mutex.Acquire();

         res = current_value - last_value;
         last_value = current_value;

         m_Mutex.Release();
      }
   }

   return res;
}*/

//************************************************************************************
//                             TRengineElementCF
//************************************************************************************

TRengineElementCF::TRengineElementCF(ui32 object_index) : m_pSpTop(false) {
    ServerLog = nullptr;
    FilterLog = nullptr;
    FnStatisticsLog = nullptr;
    m_srvc_ident = "";
    m_index = 0;
    m_lastcalctime = time(NULL);
    m_cps = 0;
    m_count = 0;
    m_loadrules_time = 0;

    if (object_index > 0)
        m_index = object_index;

    RULEBUFFSIZE = RULEBUFFSIZE_DEFAULT;
    RULEBUFF = new char[RULEBUFFSIZE];
}

TRengineElementCF::~TRengineElementCF() {
    if (RULEBUFF != NULL) {
        delete[] RULEBUFF;
        RULEBUFF = NULL;
    }

    m_hSp.Reset();
}

void TRengineElementCF::Lock() {
    m_Mutex.Acquire();
}

void TRengineElementCF::UnLock() {
    m_Mutex.Release();
}

bool TRengineElementCF::Init(TBaseLogClass* serverLog,
                             TBaseLogClass* filterLog,
                             TBaseLogClass* fnStatisticsLog,
                             TLogsGroupCF* logsGroupCf,
                             TString& RulesA,
                             float ScoreA,
                             const TString& srvc_ident,
                             TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder) {
    bool res = false;

    ServerLog = serverLog;
    FilterLog = filterLog;
    FnStatisticsLog = fnStatisticsLog;
    m_srvc_ident = srvc_ident;

    Lock();

    m_pSpTop.dnRules = {RulesA};
    m_pSpTop.score = ScoreA;

    if (pRulesHolder) {
        if (pRulesHolder->IsOK()) {

            SpLoggers.GetSpLoggerPtr(SO_RULES_LOGGER)->SetSPKLog(FilterLog);
            SpLoggers.GetSpLoggerPtr(SO_RULES_LOGGER)->SetOpen(true);

            SpLoggers.DeliveryLog = logsGroupCf->GetDeliveryLog()->GetLogger(srvc_ident);

            pDaemonLogger = SpLoggers.GetSpLoggerPtr(SO_DAEMON_LOGGER);
            if (!(m_hSp = SpOpenA(nullptr, std::move(pRulesHolder), &m_pSpTop, SpLoggers))) {
                PrintServerLog(KERROR, "MESS:       Can't open filter");
            } else {
                res = true;
            }
        } else {
            PrintServerLog(KERROR, "MESS:       RulesHolder FAILED.");
        }
    } else {
        PrintServerLog(KERROR, "MESS:       RulesHolder is NULL.");
    }

    m_loadrules_time = time(NULL);

    UnLock();

    return res;
}

TString TRengineElementCF::Reset(
        bool& ok,
        ui32& t1,
        ui32& t2,
        ui32& t3,
        const bool getreturn,
        TLogsGroupCF* logsGroupCf,
        TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder) {
    TString res = "";
    ui32 tt = 0;

    ok = false;

    Lock();

    tt = CShingleTime::GetMs();
    t1 = CShingleTime::GetMs() - tt;

    if (getreturn && FilterLog)
        ((TLogClass*)FilterLog)->SetDiffPoint();

    if (pRulesHolder) {
        if (pRulesHolder->IsOK()) {
            SpLoggers.GetSpLoggerPtr(SO_RULES_LOGGER)->SetSPKLog(FilterLog);
            SpLoggers.GetSpLoggerPtr(SO_RULES_LOGGER)->SetOpen(true);

            SpLoggers.DeliveryLog = logsGroupCf->GetDeliveryLog()->GetLogger(m_srvc_ident);

            tt = CShingleTime::GetMs();
            if (!(m_hSp = SpOpenA(nullptr, pRulesHolder, &m_pSpTop, SpLoggers))) {
                t2 = CShingleTime::GetMs() - tt;
                PrintServerLog(KERROR, "MESS:       Can't reset filter");
                ok = false;
            } else {
                t2 = CShingleTime::GetMs() - tt;
                PrintServerLog(KMESSAGE, "MESS:       Filter reset - OK");
                tt = CShingleTime::GetMs();
                if (getreturn && FilterLog)
                    res = ((TLogClass*)FilterLog)->GetDiff2();
                t3 = CShingleTime::GetMs() - tt;
                ok = true;
            }
        } else {
            PrintServerLog(KERROR, "MESS:       RulesHolder FAILED");
        }
    } else {
        PrintServerLog(KERROR, "MESS:       RulesHolder is NULL");
    }

    m_loadrules_time = time(NULL);

    UnLock();

    return res;
}

TString TRengineElementCF::Reset2(
        bool& ok,
        const TString& dnrulesA,
        float scoreA,
        TLogsGroupCF* logsGroupCf,
        TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder) {
    TString res = "";

    ok = false;

    Lock();

    if (FilterLog)
        ((TLogClass*)FilterLog)->SetDiffPoint();

    m_pSpTop.dnRules = {dnrulesA};
    m_pSpTop.score = scoreA;
    if (pRulesHolder->IsOK()) {
        SpLoggers.GetSpLoggerPtr(SO_RULES_LOGGER)->SetSPKLog(FilterLog);
        SpLoggers.GetSpLoggerPtr(SO_RULES_LOGGER)->SetOpen(true);

        SpLoggers.DeliveryLog = logsGroupCf->GetDeliveryLog()->GetLogger(m_srvc_ident);

        if (!(m_hSp = SpOpenA(nullptr, std::move(pRulesHolder), &m_pSpTop, SpLoggers))) {
            PrintServerLog(KERROR, "MESS:       Can't reset filter");
            ok = false;
        } else {
            PrintServerLog(KMESSAGE, "MESS:       Filter reset - OK");

            if (FilterLog)
                res = ((TLogClass*)FilterLog)->GetDiff();
            ok = true;
        }
    } else {
        PrintServerLog(KERROR, "MESS:       RulesHolder FAILED");
    }

    m_loadrules_time = time(NULL);

    UnLock();

    return res;
}

ui32 TRengineElementCF::PrintServerLog(TLogStatus status, const char* msg, ...) {
    ui32 tt = 0;

    tt = CShingleTime::GetMs();
    if (ServerLog) {
        va_list args;
        char buf[2048];

        memset(buf, 0, sizeof(buf));
        va_start(args, msg);
        vsnprintf(buf, sizeof(buf) - 1, msg, args);
        va_end(args);

        ServerLog->WriteMessageAndDataStatus(status, "%s", buf);
    }
    tt = CShingleTime::GetMs() - tt;

    return tt;
}

void TRengineElementCF::InitAction() {
    Lock();
    CalcCPS();
}

void TRengineElementCF::CalcCPS() {
    if (m_count < 0xFFFFFFFF)
        m_count++;

    OnlyCalcCPS();
}

void TRengineElementCF::OnlyCalcCPS() {
    time_t currenttime = time(NULL);

    if ((currenttime - m_lastcalctime) > 30) {
        m_cps = (float)m_count / (float)(currenttime - m_lastcalctime);
        m_count = 0;
        m_lastcalctime = currenttime;
    }
}

float TRengineElementCF::GetCPS() {
    OnlyCalcCPS();

    return m_cps;
}

//************************************************************************************
//                               TRenginePoolCF
//************************************************************************************

TRenginePoolCF::TRenginePoolCF() {
    m_Ident = "";
    elementcount = 0;
    elementcount_item_max = 0;
    m_half_elementcount = 0;
    m_quarter_elementcount = 0;
    m_threefourth_elementcount = 0;
    m_last_calc_usedrengine = time(NULL);
    m_max_usedrengine = 0;
    for (int i = 0; i < MAX_INDEX_COUNT; i++)
        index_counter[i] = 0;
    m_exit = false;
#ifdef KSEMA
    m_Sema = NULL;
#endif
    m_rules_path = "";
}

TRenginePoolCF::~TRenginePoolCF() {
    SetExit();

    Lock();

    TRengineElementCFListIt it = m_AllElementList.begin();
    while (it != m_AllElementList.end()) {
        if ((*it) != NULL) {
            delete (*it);
            (*it) = NULL;
        }

        ++it;
    }
    UnLock();

#ifdef KSEMA
    if (m_Sema != NULL) {
        delete m_Sema;
        m_Sema = NULL;
    }
#endif
}

void TRenginePoolCF::Lock() {
    m_Mutex.Acquire();
}

void TRenginePoolCF::UnLock() {
    m_Mutex.Release();
}

bool TRenginePoolCF::Init(
        TBaseLogClass* serverLog,
        TBaseLogClass* filterLog,
        TBaseLogClass* fnStatisticsLog,
        TLogsGroupCF* logsGroupCf,
        const TString& IdentA,
        int elementcountA,
        TString& RulesA,
        float ScoreA,
        bool local_rengine) {
    bool res = true;
    TRengineElementCF* elem = NULL;
    TRengineElementCFListIt it;
    ui32 tt = 0;
    TString full_ident = "";

    LogsGroupCf = logsGroupCf;
    ServerLog = serverLog;
    FilterLog = filterLog;
    FnStatisticsLog = fnStatisticsLog;
    
    m_Ident = IdentA;
    if (local_rengine)
        full_ident = "local." + m_Ident;
    else
        full_ident = "global." + m_Ident;
    elementcount = elementcountA;
    //elementcount_item_max = elementcount / 2;
    elementcount_item_max = elementcount; //������ ������ ������� ��� �������, �.�. � ��� ����� 1 ������
    if (elementcount_item_max < 1)
        elementcount_item_max = 1;

#ifdef KSEMA
    if (m_Sema == NULL)
        m_Sema = new TUnnamedSemaphore(elementcount);
#endif

    m_half_elementcount = elementcount / 2;
    m_quarter_elementcount = elementcount / 4;
    m_threefourth_elementcount = 3 * elementcount / 4;

    m_MutexExit.Acquire();
    m_exit = false;
    m_MutexExit.Release();

    Lock();

    {
        tt = CShingleTime::GetMs();

        m_rules_path = RulesA;
        spLoggersMain.GetSpLoggerPtr(SO_RULES_LOGGER)->SetSPKLog(FilterLog);

        pRulesHolder = MakeTrueAtomicShared<TRulesHolder>(true, TVector<TFsPath>{m_rules_path}, spLoggersMain, NRegexp::TSettings{});

        tt = CShingleTime::GetMs() - tt;
        if (ServerLog)
            ServerLog->WriteMessageAndDataStatus(KMESSAGE, "Init rules to %u msec", tt);
    }

    for (int i = 0; i < MAX_INDEX_COUNT; i++)
        index_counter[i] = 0;

    for (int i = 0; i < elementcount; i++) {
        elem = new TRengineElementCF(i + 1);
        m_AllElementList.push_back(elem);
        m_AccessibleList.push_back(elem);
    }

    it = m_AllElementList.begin();
    while (it != m_AllElementList.end()) {
        if ((*it) != NULL) {
            tt = CShingleTime::GetMs();

            if (!(*it)->Init(ServerLog, FilterLog, FnStatisticsLog, logsGroupCf, m_rules_path, ScoreA, full_ident, pRulesHolder)) {
                res = false;

                tt = CShingleTime::GetMs() - tt;
                if (ServerLog)
                    ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%u Init filter (%s) - FAILED.", tt, m_Ident.c_str());
            } else {
                tt = CShingleTime::GetMs() - tt;
                if (ServerLog)
                    ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%u Init filter (%s) - OK.", tt, m_Ident.c_str());
            }
        }

        ++it;
    }

    UnLock();

    return res;
}

TResetResponceCF TRenginePoolCF::Reset(bool& ok, const bool getreturn) {
    TResetResponceCF res;
    TRengineElementCFListIt it;
    bool first_elm = true;
    bool ok_elm = false;
    int ok_count = 0;
    int failed_count = 0;
    TString s = "";
    ui32 tt = 0;
    ui32 t1 = 0, t2 = 0, t3 = 0;
    bool getreturn_t = getreturn;

    Lock();

    spLoggersMain.GetSpLoggerPtr(SO_RULES_LOGGER)->SetSPKLog(FilterLog);
    pRulesHolder = MakeTrueAtomicShared<TRulesHolder>(true, TVector<TFsPath>{m_rules_path}, spLoggersMain, NRegexp::TSettings{});

    it = m_AllElementList.begin();
    while (it != m_AllElementList.end()) {
        if ((*it) != NULL) {
            tt = CShingleTime::GetMs();
            s = (*it)->Reset(ok_elm, t1, t2, t3, getreturn_t, LogsGroupCf, pRulesHolder);
            tt = CShingleTime::GetMs() - tt;

            if (first_elm) {
                res.filterres = s;
                getreturn_t = false;
                first_elm = false;
            }
            if (ok_elm) {
                ok_count++;
                if (ServerLog)
                    ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%u Reset filter (%s, %u, %u, %u) - OK.", tt, m_Ident.c_str(), t1, t2, t3);
            } else {
                failed_count++;
                if (ServerLog)
                    ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%u Reset filter (%s, %u, %u, %u) - FAILED.", tt, m_Ident.c_str(), t1, t2, t3);
            }
        }

        ++it;
    }

    UnLock();

    res.filterres = "<b>Reload filters: succesfull=" + IntToStroka(ok_count) + " failed=" + IntToStroka(failed_count) + "<b>\n" + res.filterres;
    res.text = "Reload filters: succesfull=" + IntToStroka(ok_count) + " failed=" + IntToStroka(failed_count);

    if ((ok_count > 0) && (failed_count == 0))
        ok = true;
    else
        ok = false;

    res.flag_ok = ok;

    return res;
}

TResetResponceCF TRenginePoolCF::Reset2(bool& ok, const TString& dnrulesA, float scoreA) {
    TResetResponceCF res;
    TRengineElementCFListIt it;
    bool first_elm = true;
    bool ok_elm = false;
    int ok_count = 0;
    int failed_count = 0;
    TString s = "";

    Lock();

    spLoggersMain.GetSpLoggerPtr(SO_RULES_LOGGER)->SetSPKLog(FilterLog);
    pRulesHolder = MakeTrueAtomicShared<TRulesHolder>(true, TVector<TFsPath>{m_rules_path}, spLoggersMain, NRegexp::TSettings{});

    it = m_AllElementList.begin();
    while (it != m_AllElementList.end()) {
        if ((*it) != NULL) {
            s = (*it)->Reset2(ok_elm, dnrulesA, scoreA, LogsGroupCf, pRulesHolder);
            if (first_elm) {
                res.filterres = s;
                first_elm = false;
            }
            if (ok_elm)
                ok_count++;
            else
                failed_count++;
        }

        ++it;
    }

    UnLock();

    res.filterres = "<b>Reload filters: succesfull=" + IntToStroka(ok_count) + " failed=" + IntToStroka(failed_count) + "<b>\n" + res.filterres;
    res.text = "Reload filters: succesfull=" + IntToStroka(ok_count) + " failed=" + IntToStroka(failed_count);

    if ((ok_count > 0) && (failed_count == 0))
        ok = true;
    else
        ok = false;

    res.flag_ok = ok;

    return res;
}

void TRenginePoolCF::ReturnFilter(TRengineElementCF* elem, ui32 index, const TString& srvcname, bool spam) {
    Lock();

    m_AccessibleList.push_back(elem);
    if ((index >= 0) && (index < MAX_INDEX_COUNT)) {
        if (index_counter[index] > 0)
            index_counter[index]--;
    }

    AddServiceToCalc(srvcname, spam);

    UnLock();

#ifdef KSEMA
    if (m_Sema != NULL)
        m_Sema->Release();
#endif
}

TRengineElementCF* TRenginePoolCF::GetFilter(ui32 index, ui32& loop_count) {
    TRengineElementCF* res = NULL;
    TRengineElementCFListIt it;
    int remain_size = 0;

    if ((index >= 0) && (index <= MAX_INDEX_COUNT)) {
        while (true) {
            if (loop_count < 0xFFFFFFFF)
                loop_count++;

            if (m_exit)
                break;

#ifdef KSEMA
            if (m_Sema != NULL)
                m_Sema->Acquire();
#endif

            if (m_exit)
                break;

            Lock();

            //if (index_counter[index] < elementcount_item_max)
            //{
            it = m_AccessibleList.begin();
            if (it != m_AccessibleList.end()) {
                res = (*it);
                m_AccessibleList.erase(it);
                index_counter[index]++;

                remain_size = m_AccessibleList.size();
                if ((elementcount - remain_size) > m_max_usedrengine)
                    m_max_usedrengine = elementcount - remain_size;

                UnLock();
                break;
            }
            //}

            UnLock();

#ifdef KSEMA
            if (m_Sema != NULL)
                m_Sema->Release();
#endif
        }
    }

    if (res != NULL) {
        /*if (remain_size < m_quarter_elementcount)
      {
         if ( (LogsGroup != NULL) && (LogsGroup->TraceIpLog() != NULL) )
            LogsGroup->TraceIpLog()->WriteMessageAndData("Remain quarter element count.");
      } else if (remain_size < m_half_elementcount)
      {
         if ( (LogsGroup != NULL) && (LogsGroup->TraceIpLog() != NULL) )
            LogsGroup->TraceIpLog()->WriteMessageAndData("Remain half element count.");
      } else if (remain_size < m_threefourth_elementcount)
      {
         if ( (LogsGroup != NULL) && (LogsGroup->TraceIpLog() != NULL) )
            LogsGroup->TraceIpLog()->WriteMessageAndData("Remain three fourth element count.");
      }*/
    }

    return res;
}

void TRenginePoolCF::SetExit() {
    m_MutexExit.Acquire();

    m_exit = true;

    m_MutexExit.Release();

#ifdef KSEMA
    if ((m_Sema != NULL) && (elementcount > 0)) {
        for (int i = 0; i < elementcount; i++)
            m_Sema->Release();
    }
#endif
}

ui32 TRenginePoolCF::GetAccessibleFilterCount() {
    ui32 res = 0;

    Lock();

    res = m_AccessibleList.size();

    UnLock();

    return res;
}

int TRenginePoolCF::CalcUsedRengine() {
    time_t currenttime = time(NULL);
    int res = 0;

    if (currenttime > m_last_calc_usedrengine) {
        Lock();

        res = m_max_usedrengine;
        m_last_calc_usedrengine = currenttime;
        m_max_usedrengine = 0;

        UnLock();
    }

    return res;
}

int TRenginePoolCF::GetUsedRengine() {
    return m_max_usedrengine;
}

TString TRenginePoolCF::GetCPSList() {
    TString res = "";
    TRengineElementCFListIt it;
    bool first = true;

    it = m_AllElementList.begin();
    while (it != m_AllElementList.end()) {
        if ((*it) != NULL) {
            if (first) {
                res = res + FloatToStr((*it)->GetCPS());
                first = false;
            } else
                res = res + " - " + FloatToStr((*it)->GetCPS());
        }

        ++it;
    }

    return res;
}

int TRenginePoolCF::GetNumberSection(ui32 ip) {
    int res = 0;

    res = ip % MAX_INDEX_COUNT;
    if ((res < 0) || (res >= MAX_INDEX_COUNT))
        res = 0;

    return res;
}

void TRenginePoolCF::Close() {
}

void TRenginePoolCF::AddServiceToCalc(const TString& srvcname, bool spam) {
    m_SrvcCalcMutex.Acquire();

    TServiceCalcHashIt it;

    it = m_srvc_calc_hash.find(srvcname);
    if (it != m_srvc_calc_hash.end()) {
        (*it).second.m_all = IncMax32((*it).second.m_all, 1);
        if (spam)
            (*it).second.m_spam = IncMax32((*it).second.m_spam, 1);
    } else {
        if (spam)
            m_srvc_calc_hash[srvcname] = TServiceCalcRecord(srvcname, 1, 1);
        else
            m_srvc_calc_hash[srvcname] = TServiceCalcRecord(srvcname, 1, 0);
    }

    m_SrvcCalcMutex.Release();
}

TString TRenginePoolCF::GetServiceCalcData() {
    TString res = "";
    TServiceCalcHashIt it;
    TServiceCalcList sclist;
    TServiceCalcListIt lit;

    m_SrvcCalcMutex.Acquire();

    it = m_srvc_calc_hash.begin();
    while (it != m_srvc_calc_hash.end()) {
        sclist.push_back((*it).second);

        ++it;
    }
    m_srvc_calc_hash.clear();

    m_SrvcCalcMutex.Release();

    sclist.sort();
    lit = sclist.begin();
    while (lit != sclist.end()) {
        res = res + (*lit).m_srvc + ": " + IntToStroka((*lit).m_all) + " / " + IntToStroka((*lit).m_spam) + ", ";

        ++lit;
    }

    return res;
}

//************************************************************************************
