#pragma once

#include "util/system/mutex.h"
#include "util/system/sem.h"
#include <list>
#include "tlogsgroup_cf.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/unnamedsem.h>
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/spamstop/sp/spk3.h>
#include <mail/so/spamstop/sp/sptop.h>
#include <mail/so/spamstop/sp/spamstop.h>

struct TResetResponceCF {
    TString text;
    TString filterres;
    bool flag_ok;

    TResetResponceCF() {
        text = "";
        filterres = "";
        flag_ok = "";
    }
};

#define KSEMA

//*****************************************************************************************************************************************
//                                                    TCalcRulesCSStat
//*****************************************************************************************************************************************

/*class TCalcRulesCSStat
{
private:
         THashMap<TString, ui32> m_data;
         TMutex              m_Mutex;
public:
         TCalcRulesCSStat();
         ~TCalcRulesCSStat();

         void     AddFilterCall(const TString &rules_cs);
   TString  GetUniqRulesCount();
};*/

//****************************************************************************************
//                                     TKAtomic
//****************************************************************************************

//#define KATOMIC_MUTEX

/*class TKAtomic
{
private:
#ifdef KATOMIC_MUTEX
         TMutex  m_Mutex;
         i64     m_value;
#else
         TAtomic m_value;
#endif
public:
         TKAtomic();
         ~TKAtomic();

         i64  Value();
         i64  Add(i64 value);
         i64  Swap(i64 value);
         i64  Increment();
         i64  Decrement();
};*/

//********************************************************************************************************************************
//                                                       TDiffCounter
//********************************************************************************************************************************

/*class TDiffCounter
{
private:
         TKAtomic curr_value;
         i64      last_value;
         TMutex   m_Mutex;
public:
         TDiffCounter();
         ~TDiffCounter();

         void Increment();
         ui32 GetDiff();
};*/

//************************************************************************************
//                             TRengineElementCF
//************************************************************************************

class TRengineElementCF {
private:
    static const int RULEBUFFSIZE_DEFAULT = 65000;

    TSoConfig m_pSpTop;
    TSpLoggers SpLoggers;

    THolder<TRengine> m_hSp; //rengine object
    TMutex m_Mutex;
    TBaseLogClass* ServerLog;
    TBaseLogClass* FilterLog;
    TBaseLogClass* FnStatisticsLog;
    ui32 m_index;
    TString m_srvc_ident;

    ui32 m_count;
    time_t m_lastcalctime;
    float m_cps;
    time_t m_loadrules_time;

    void CalcCPS();
    void OnlyCalcCPS();

public:
    TRengineElementCF(ui32 object_index);
    ~TRengineElementCF();

    char* RULEBUFF;
    int RULEBUFFSIZE;

    bool Init(TBaseLogClass* serverLog,
              TBaseLogClass* filterLog,
              TBaseLogClass* fnStatisticsLog,
              TLogsGroupCF* logsGroupCf,
              TString& RulesA,
              float ScoreA,
              const TString& srvc_ident,
              TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder);
    ui32 PrintServerLog(TLogStatus status, const char* msg, ...);
    TString Reset(bool& ok, ui32& t1, ui32& t2, ui32& t3, const bool getreturn,
                  TLogsGroupCF* logsGroupCf, TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder);
    TString Reset2(bool& ok, const TString& dnrulesA, float scoreA,
                   TLogsGroupCF* logsGroupCf, TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder);
    TRengine& GetFilterHandle() {
        return *m_hSp;
    }
    ui32 ObjectIndex() {
        return m_index;
    }
    TString GetRulesCS() {
        return "";
    }
    time_t GetLoadRulesTime() {
        return m_loadrules_time;
    }
    TString GetLoadRulesElapsed() {
        TString res = "???";

        if (m_loadrules_time != 0) {
            time_t currtime = time(NULL);
            ui32 diff = 0;

            if (currtime >= m_loadrules_time) {
                diff = currtime - m_loadrules_time;
                res = IntToHourMinSec2(diff);
            }
        }

        return res;
    }

    void Lock();
    void UnLock();
    void InitAction();
    float GetCPS();
    TString RengineTypeInfo() {
        return m_srvc_ident;
    }
};

//************************************************************************************
//                               TRenginePoolCF
//************************************************************************************

typedef std::list<TRengineElementCF*> TRengineElementCFList;
typedef TRengineElementCFList::iterator TRengineElementCFListIt;

struct TServiceCalcRecord {
    TString m_srvc;
    ui32 m_all;
    ui32 m_spam;

    TServiceCalcRecord() {
        m_srvc = "";
        m_all = 0;
        m_spam = 0;
    }

    TServiceCalcRecord(const TString& srvc, ui32 all, ui32 spam) {
        m_srvc = srvc;
        m_all = all;
        m_spam = spam;
    }

    bool operator<(const TServiceCalcRecord& scr) const {
        return m_srvc < scr.m_srvc;
    }
};

typedef THashMap<TString, TServiceCalcRecord> TServiceCalcHash;
typedef TServiceCalcHash::iterator TServiceCalcHashIt;

typedef std::list<TServiceCalcRecord> TServiceCalcList;
typedef TServiceCalcList::iterator TServiceCalcListIt;

class TRenginePoolCF {
private:
    static const int MAX_INDEX_COUNT = 8;

    TString m_rules_path;
    TSpLoggers spLoggersMain;
    TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder; //rules object
    TString m_Ident;
    TLogsGroupCF* LogsGroupCf;
    TBaseLogClass* ServerLog;
    TBaseLogClass* FilterLog;
    TBaseLogClass* FnStatisticsLog;
    TRengineElementCFList m_AllElementList;
    TRengineElementCFList m_AccessibleList;
    TMutex m_Mutex;
    TMutex m_MutexExit;
    TMutex m_MutexCalcUsedRengine;
    int elementcount;
    int elementcount_item_max;
    int index_counter[MAX_INDEX_COUNT];
    bool m_exit;
    int m_half_elementcount;
    int m_quarter_elementcount;
    int m_threefourth_elementcount;
    time_t m_last_calc_usedrengine;
    int m_max_usedrengine;
    TServiceCalcHash m_srvc_calc_hash;
    TMutex m_SrvcCalcMutex;
#ifdef KSEMA
    TUnnamedSemaphore* m_Sema;
#endif
    TCalcRulesCSStat rules_mon_stat;
    TDiffCounter m_badgetfilteritem_counter;
    TDiffCounter m_skeepfilter_counter;

    void Lock();
    void UnLock();
    void AddServiceToCalc(const TString& srvcname, bool spam);

public:
    TRenginePoolCF();
    ~TRenginePoolCF();

    bool Init(
            TBaseLogClass* ServerLogA,
            TBaseLogClass* FilterLogA,
            TBaseLogClass* FnStatisticsLogA,
            TLogsGroupCF* logsGroupCf,
            const TString& IdentA,
            int elementcountA,
            TString& RulesA,
            float ScoreA,
            bool local_rengine);
    TResetResponceCF Reset(bool& ok, const bool getreturn);
    TResetResponceCF Reset2(bool& ok, const TString& dnrulesA, float scoreA);
    void ReturnFilter(TRengineElementCF* elem, ui32 index, const TString& srvcname, bool spam);
    TRengineElementCF* GetFilter(ui32 index, ui32& loop_count);
    void SetExit();
    ui32 GetAccessibleFilterCount();
    int CalcUsedRengine();
    int GetUsedRengine();
    TString GetCPSList();
    int GetNumberSection(ui32 ip);
    void Close();
    TString GetServiceCalcData();
    TCalcRulesCSStat* GetRulesMonStat() {
        return &rules_mon_stat;
    }
    void AddSkeepFilter() {
        m_skeepfilter_counter.Increment();
    }
    ui32 GetSkeepFilter() {
        return m_skeepfilter_counter.GetDiff();
    }
    void AddBadGetFilterItem() {
        m_badgetfilteritem_counter.Increment();
    }
    ui32 GetBadGetFilterItem() {
        return m_badgetfilteritem_counter.GetDiff();
    }
};

//************************************************************************************
