#include <mail/so/spamstop/tools/so-common/shtime.h>
#include "trulestat.h"

//******************************************************************************
//                            TRuleStat
//******************************************************************************

TRuleStatRecord::TRuleStatRecord() {
    data = new TRSRList();
}

TRuleStatRecord::TRuleStatRecord(char* BUFF, ui32 BuffSize) {
    ui32 count = 0;
    time_t t = 0;

    data = new TRSRList();
    if ((BUFF != NULL) && (BuffSize >= sizeof(time_t))) {
        while (count < BuffSize) {
            memcpy(&t, BUFF + count, sizeof(time_t));
            count += sizeof(time_t);
            data->push_back(t);
        }
    }
}

TRuleStatRecord::TRuleStatRecord(time_t sec) {
    data = new TRSRList();
    data->push_back(sec);
}

TRuleStatRecord::TRuleStatRecord(const TRuleStatRecord& value) {
    TRSRListCIt cit;

    data = new TRSRList();
    cit = value.data->begin();
    while (cit != value.data->end()) {
        data->push_back((*cit));
        ++cit;
    }
}

TRuleStatRecord::~TRuleStatRecord() {
    if (data != NULL) {
        data->clear();
        delete data;
        data = NULL;
    }
}

TRuleStatRecord& TRuleStatRecord::operator=(const TRuleStatRecord& value) {
    TRSRListCIt cit;

    if (this->data != NULL) {
        cit = value.data->begin();
        while (cit != value.data->end()) {
            this->data->push_back((*cit));
            ++cit;
        }
    }
    return *this;
}

size_t TRuleStatRecord::size() const {
    size_t res = 0;
    TRSRListIt it;

    if (data != NULL) {
        it = data->begin();
        while (it != data->end()) {
            res += sizeof(*it);
            ++it;
        }
    }
    return res;
}

size_t TRuleStatRecord::GetBuffer(char* BUFF, int BuffSize) const {
    size_t res = 0;
    TRSRListIt it;
    ui32 count = 0;

    if (data != NULL) {
        it = data->begin();
        while (it != data->end()) {
            res += sizeof(*it);
            if ((int)(count + sizeof(*it)) <= BuffSize) {
                memcpy(BUFF + count, &(*it), sizeof(*it));
                count += sizeof(*it);
            }
            ++it;
        }
    }
    return res;
}

void TRuleStatRecord::listdump(FILE* handle) const {
    TRSRListIt it;

    if ((data != NULL) && (handle != NULL)) {
        it = data->begin();
        while (it != data->end()) {
            fprintf(handle, "%lu, ", *it);
            ++it;
        }
    }
}

ui32 TRuleStatRecord::GetCountFrom(time_t sec) {
    ui32 res = 0;
    TRSRListIt it;

    if (data != NULL) {
        it = lower_bound(data->begin(), data->end(), sec);

        while (it != data->end()) {
            res++;
            ++it;
        }
    }

    return res;
}

void TRuleStatRecord::TruncData(time_t sec) {
    TRSRList* datanew = NULL;
    TRSRListIt it;

    datanew = new TRSRList();
    it = lower_bound(data->begin(), data->end(), sec);
    while (it != data->end()) {
        datanew->push_back(*it);
        ++it;
    }
    data->clear();
    delete data;
    data = NULL;

    data = datanew;
}

void TRuleStatRecord::Add(time_t sec) {
    if (data != NULL) {
        data->push_back(sec);
        data->sort();
    }
}

//TRuleStat

TRuleStat::TRuleStat() {
    m_rulestatlist = NULL;
}

TRuleStat::~TRuleStat() {
    rulehash.clear();
}

void TRuleStat::Lock() {
    m_Mutex.Acquire();
}

void TRuleStat::UnLock() {
    m_Mutex.Release();
}

void TRuleStat::SetRuleStatList(TKIniFile* rulestatlist) {
    Lock();

    m_rulestatlist = rulestatlist;

    UnLock();
}

void TRuleStat::TruncData(time_t sec, bool del, ui64& RequestCount) {
    Lock();

    if (del && ((RequestCount % 50) == 0)) {
        TRSRhashIt it;

        it = rulehash.begin();
        while (it != rulehash.end()) {
            (*it).second.TruncData(sec);
            ++it;
        }
    }

    UnLock();
}

void TRuleStat::AddRuleStat(time_t sec, const char* BUFF) {
    Lock();

    const char *p = NULL, *pbegin = NULL;
    const char* trimtext = NULL;
    char rulename[128];
    int count = 0;
    TString rulenames = "";
    int trimtextsize = 0;
    TRSRhashIt it;
    TString prefix = "TSR_";

    p = BUFF;
    pbegin = p;
    while (true) {
        p = strstr(pbegin, ",");
        if (p != NULL) {
            count = p - pbegin;
            memset(rulename, 0, sizeof(rulename));
            if (count <= (int)(sizeof(rulename) - 1)) {
                memcpy(rulename, pbegin, count);
                SpTrim(rulename, &trimtext, &trimtextsize);
                rulenames = TString(trimtext, trimtextsize);

                if (m_rulestatlist != NULL) {
                    if (m_rulestatlist->KeyExists("rules", rulenames))
                    //if ( (rulenames.size() > prefix.size()) && (memcmp(rulenames.c_str(), prefix.c_str(), prefix.size()) == 0) ) //�������� �� �������� "TSR_"
                    {
                        it = rulehash.find(rulenames);
                        if (it != rulehash.end()) {
                            (*it).second.Add(sec);
                        } else {
                            rulehash[rulenames] = TRuleStatRecord(sec);
                        }
                    }
                }
            }
            pbegin = p + 1;
        } else
            break;
    }

    UnLock();
}

void TRuleStat::GetRuleStat(time_t sec, TRuleStatResList& res) {
    res.clear();

    TRSRhashIt it;
    TRuleStatRes rsr;

    Lock();

    it = rulehash.begin();
    while (it != rulehash.end()) {
        rsr.rulename = (*it).first;
        rsr.count = (*it).second.GetCountFrom(sec);
        if (m_rulestatlist->KeyExists("rules", rsr.rulename)) {
            res.push_back(rsr);
            ++it;

        } else {
            rulehash.erase(it++);
        }
    }

    UnLock();
}

void TRuleStat::Clear() {
    Lock();

    rulehash.clear();

    UnLock();
}

void TRuleStat::WriteDumpSizes(TString Filename) {
    Lock();

    if (Filename.size() > 0) {
        TRSRhashIt it;
        size_t t1 = 0, t2 = 0;

        FILE* yfhandle = fopen(Filename.c_str(), "wb");
        if (yfhandle != NULL) {
            it = rulehash.begin();
            while (it != rulehash.end()) {
                t1 = it->first.size();
                t2 = it->second.size();
                fprintf(yfhandle, "%zu - %zu\n", t1, t2);
                ++it;
            }
            fclose(yfhandle);
        }
    }

    UnLock();
}

bool TRuleStat::WriteDump(TString Filename, ui32& reccount, ui32& lockwaittime, ui32& writetime) {
    bool res = true;
    ui32 tick = 0;

    lockwaittime = 0;
    writetime = 0;

    tick = CShingleTime::GetMs();
    Lock();
    lockwaittime = CShingleTime::GetMs() - tick;

    tick = CShingleTime::GetMs();
    reccount = 0;
    if (Filename.size() > 0) {
        TRSRhashIt it;
        size_t t1 = 0, t2 = 0;
        size_t count1 = 0, count2 = 0, count3 = 0;
        char* BUFF = NULL;
        size_t BuffSize = 0;
        ui32 crc32 = 0;
        TString ident = "KBI";
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;

        FILE* yfhandle = fopen(Filename.c_str(), "wb");
        if (yfhandle != NULL) {
            it = rulehash.begin();
            while (it != rulehash.end()) {
                t1 = it->first.size();
                t2 = it->second.size();
                keysize = t1;
                valsize = t2;
                bodysize = t1 + t2;
                prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);

                BuffSize = prefix_size + t1 + t2;
                if (BuffSize > 0) {
                    BUFF = new char[BuffSize];
                    try {
                        count1 = it->first.GetBuffer(BUFF + prefix_size, BuffSize - prefix_size);
                        if (count1 == t1) {
                            count2 = it->second.GetBuffer(BUFF + prefix_size + count1, BuffSize - prefix_size - count1);
                            if (count2 == t2) {
                                memcpy(BUFF, ident.c_str(), ident.size());
                                memcpy(BUFF + ident.size(), &bodysize, sizeof(bodysize));
                                crc32 = 0;
                                for (int i = prefix_size; i < (int)BuffSize; i++)
                                    crc32 += BUFF[i];
                                memcpy(BUFF + ident.size() + sizeof(bodysize), &crc32, sizeof(crc32));
                                memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32), &keysize, sizeof(keysize));
                                memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), &valsize, sizeof(valsize));

                                count3 = fwrite(BUFF, 1, BuffSize, yfhandle);
                                if (count3 != BuffSize) {
                                    res = false;
                                    break;
                                } else {
                                    reccount++;
                                }
                            }
                        }

                        delete[] BUFF;
                        BUFF = NULL;
                    } catch (...) {
                        delete[] BUFF;
                        BUFF = NULL;
                    }
                }
                ++it;
            }
            fclose(yfhandle);
        }
    }
    writetime = CShingleTime::GetMs() - tick;

    UnLock();

    return res;
}

bool TRuleStat::ReadDump2(TString Filename) {
    bool res = true;

    Lock();

    if (Filename.size() > 0) {
        size_t count1 = 0, count4 = 0;
        char* BUFF;
        size_t BuffSize = 0;
        ui32 crc32 = 0, crc32_a = 0;
        TString ident = "KBI";
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;
        char ShapBuff[1600];
        char* SPEEDBUFF = NULL;
        ui32 SPEEDBUFFSize = MAXREADDUMPBUFFER;
        ui32 inSPEEDBUFF = 0;
        ui32 SPEEDBUFFpos = 0;

        FILE* yfhandle = fopen(Filename.c_str(), "rb");
        if (yfhandle != NULL) {
            SPEEDBUFF = new char[SPEEDBUFFSize];
            SPEEDBUFFpos = 0;
            while (!feof(yfhandle)) {
                if ((SPEEDBUFFSize - inSPEEDBUFF) > 0) {
                    count4 = fread(SPEEDBUFF + inSPEEDBUFF, 1, SPEEDBUFFSize - inSPEEDBUFF, yfhandle);
                    inSPEEDBUFF += count4;
                }
                if (inSPEEDBUFF > 0) {
                    prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);
                    while ((inSPEEDBUFF - SPEEDBUFFpos) > 0) {
                        if ((inSPEEDBUFF - SPEEDBUFFpos) < prefix_size)
                            break;
                        memcpy(ShapBuff, SPEEDBUFF + SPEEDBUFFpos, prefix_size);
                        if (memcmp(ShapBuff, ident.c_str(), ident.size()) == 0) {
                            memcpy(&bodysize, ShapBuff + ident.size(), sizeof(bodysize));
                            memcpy(&crc32, ShapBuff + ident.size() + sizeof(bodysize), sizeof(crc32));
                            memcpy(&keysize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32), sizeof(keysize));
                            memcpy(&valsize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), sizeof(valsize));
                            if ((bodysize > 0) && (bodysize < 100000000) && (bodysize == (keysize + valsize))) //������ �� ����
                            {
                                if ((inSPEEDBUFF - SPEEDBUFFpos) < (prefix_size + bodysize))
                                    break;
                                BuffSize = bodysize;
                                BUFF = new char[BuffSize];
                                try {
                                    memcpy(BUFF, SPEEDBUFF + SPEEDBUFFpos + prefix_size, bodysize);
                                    SPEEDBUFFpos += prefix_size + bodysize;

                                    crc32_a = 0;
                                    for (int i = 0; i < (int)BuffSize; i++)
                                        crc32_a += BUFF[i];
                                    if (crc32 == crc32_a) {
                                        rulehash[KTString(BUFF, keysize)] = TRuleStatRecord(BUFF + keysize, valsize);

                                    } else
                                        res = false;

                                    delete[] BUFF;
                                    BUFF = NULL;
                                } catch (...) {
                                    delete[] BUFF;
                                    BUFF = NULL;
                                }
                                if (res == false)
                                    goto MEND;
                            } else {
                                res = false;
                                goto MEND;
                            }
                        }
                    }
                }
                count1 = inSPEEDBUFF - SPEEDBUFFpos;
                if (count1 > 0) {
                    char* tbuff = new char[count1];
                    try {
                        memcpy(tbuff, SPEEDBUFF + SPEEDBUFFpos, count1);
                        memcpy(SPEEDBUFF, tbuff, count1);
                        inSPEEDBUFF = count1;
                        SPEEDBUFFpos = 0;

                        delete[] tbuff;
                        tbuff = NULL;
                    } catch (...) {
                        delete[] tbuff;
                        tbuff = NULL;
                    }
                } else {
                    inSPEEDBUFF = 0;
                    SPEEDBUFFpos = 0;
                }
            }
        MEND:
            fclose(yfhandle);
            if (SPEEDBUFF != NULL) {
                delete[] SPEEDBUFF;
                SPEEDBUFF = NULL;
                inSPEEDBUFF = 0;
            }
        }
    }

    UnLock();

    return res;
}

bool TRuleStat::ListDump(TString Filename) {
    bool res = true;

    Lock();

    if (Filename.size() > 0) {
        TRSRhashIt it;
        TString ident = "KBI";

        FILE* yfhandle = fopen(Filename.c_str(), "wb");
        if (yfhandle != NULL) {
            it = rulehash.begin();
            while (it != rulehash.end()) {
                fprintf(yfhandle, "[beginrecord]\n");
                fprintf(yfhandle, "[key]\n");
                it->first.listdump(yfhandle);
                fprintf(yfhandle, "[value]\n");
                it->second.listdump(yfhandle);
                fprintf(yfhandle, "[endrecord]\n\n");

                ++it;
            }
            fclose(yfhandle);
        }
    }

    UnLock();

    return res;
}

ui32 TRuleStat::GetSize() {
    return rulehash.size();
}

//*******************************************************************************************************************
