#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkinifile.h>
#include "util/generic/hash_set.h"
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "ktypes.h"

//******************************************************************************
//                            TRuleStat
//******************************************************************************

typedef std::list<time_t> TRSRList;
typedef TRSRList::iterator TRSRListIt;
typedef TRSRList::const_iterator TRSRListCIt;

class TRuleStatRecord {
private:
    TRSRList* data;

public:
    TRuleStatRecord();
    TRuleStatRecord(time_t sec);
    TRuleStatRecord(char* BUFF, ui32 BuffSize);
    TRuleStatRecord(const TRuleStatRecord& value);
    ~TRuleStatRecord();

    TRuleStatRecord& operator=(const TRuleStatRecord& value);

    size_t size() const;
    void Add(time_t sec);
    size_t GetBuffer(char* BUFF, int BuffSize) const;
    void listdump(FILE* handle) const;
    ui32 GetCountFrom(time_t sec);
    void TruncData(time_t sec);
};

struct TRuleStatRes {
    TString rulename;
    ui32 count;
};

typedef THashMap<KTString, TRuleStatRecord> TRSRhash;
typedef TRSRhash::iterator TRSRhashIt;
typedef std::list<TRuleStatRes> TRuleStatResList;
typedef TRuleStatResList::iterator TRuleStatResListIt;

class TRuleStat {
private:
    TRSRhash rulehash;
    TMutex m_Mutex;
    TKIniFile* m_rulestatlist;

    void Lock();
    void UnLock();

public:
    TRuleStat();
    ~TRuleStat();

    void SetRuleStatList(TKIniFile* rulestatlist);
    void TruncData(time_t sec, bool del, ui64& RequestCount);
    void AddRuleStat(time_t sec, const char* BUFF);
    void GetRuleStat(time_t sec, TRuleStatResList& res);
    void Clear();

    void WriteDumpSizes(TString Filename);
    bool WriteDump(TString Filename, ui32& reccount, ui32& lockwaittime, ui32& writetime);
    bool ReadDump2(TString Filename);
    bool ListDump(TString Filename);
    ui32 GetSize();
};

//*****************************************************************************************************************
