#include <mail/so/spamstop/tools/so-common/shtime.h>
#include "tsignatureclass.h"

TSignatureClass::TSignatureClass() {
    m_ident = "MSEARCHSIGN";
    m_log = NULL;
    m_filename = "";
    m_hash = NULL;
}

TSignatureClass::~TSignatureClass() {
    if (m_hash != NULL) {
        delete m_hash;
        m_hash = NULL;
    }
}

void TSignatureClass::Init(const TString& filename, TBaseLogClass* logA) {
    m_log = logA;
    m_filename = filename;
}

void TSignatureClass::LockLoad() {
    m_MutexLoad.Acquire();
}

void TSignatureClass::UnLockLoad() {
    m_MutexLoad.Release();
}

void TSignatureClass::Lock() {
    m_Mutex.Acquire();
}

void TSignatureClass::UnLock() {
    m_Mutex.Release();
}

bool TSignatureClass::ExistsFile() {
    bool res = false;
    FILE* handle = NULL;

    if (!m_filename.empty()) {
        handle = fopen(m_filename.c_str(), "rb");
        if (handle != NULL) {
            res = true;
            fclose(handle);
        }
    }

    return res;
}

bool TSignatureClass::FileStateWasChangedK(const char* fn, TFileStateSC* poldbufstat) {
    struct stat bufstat;

    if (fn == 0 || *fn == 0) {
        return false;
    }

    if (stat(fn, &bufstat)) {
        return false;
    }

    if (poldbufstat->mtime == bufstat.st_mtime &&
        poldbufstat->size == bufstat.st_size)
        return false;

    poldbufstat->mtime = bufstat.st_mtime;
    poldbufstat->size = bufstat.st_size;

    return true;
}

TString TSignatureClass::GetResultPrint(THashStatSC& stat, ui32 timedelay) {
    TString res = "";
    ui32 all = 0;

    all = IncMax32(all, stat.no_trace_count);
    all = IncMax32(all, stat.trace_count);
    all = IncMax32(all, stat.bad_count);
    all = IncMax32(all, stat.dublicat_count);
    res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (good=" + IntToStroka(stat.trace_count) + ", dublicat=" + IntToStroka(stat.dublicat_count) + ", lost\\t=" + IntToStroka(stat.bad_count) + ")";

    return res;
}

void TSignatureClass::Reload() {
    if (!m_filename.empty()) {
        if (ExistsFile()) {
            if (!FileStateWasChangedK(m_filename.c_str(), &m_statfile)) {
                if (m_log != NULL)
                    m_log->WriteMessageAndDataStatus(KMESSAGE, "%s:    no changed.", m_ident.c_str());
                return;
            }

            FILE* handle = NULL;
            char tbuff[1024];
            int len = 0;
            TString restxt = "";
            THashStatSC stat;
            ui64 shingle = 0;
            TString stt = "";
            TSignatureHashIt it;
            TSignatureHash* m_hash_temp = NULL;
            TSignatureHash* m_hash_old = NULL;
            const char* p = NULL;
            int count = 0;

            handle = fopen(m_filename.c_str(), "rb");
            if (handle != NULL) {
                LockLoad();

                ui32 timepoint = CShingleTime::GetMs();

                m_hash_temp = new TSignatureHash();
                if (m_hash_temp != NULL) {
                    while (fgets(tbuff, sizeof(tbuff), handle)) {
                        len = strlen(tbuff);
                        if (len > 0) {
                            p = strchr(tbuff, '\t');
                            if (p != NULL) {
                                count = p - tbuff;
                                if (count > 0)
                                    stt = TString(tbuff, count);

                            } else {
                                stat.bad_count = IncMax32(stat.bad_count, 1);
                                stt = TString(tbuff, len);
                                //printf("lost \\t: '%s'\n\n", tbuff);
                            }

                            stt = Trim(stt);
                            if (!stt.empty()) {
                                to_lower_k(stt);
                                shingle = ShingleFromStroka(stt);
                                if (shingle > 0) {
                                    it = m_hash_temp->find(shingle);
                                    if (it != m_hash_temp->end()) {
                                        stat.dublicat_count = IncMax32(stat.dublicat_count, 1);

                                    } else {
                                        (*m_hash_temp)[shingle] = stt;
                                        stat.trace_count = IncMax32(stat.trace_count, 1);
                                    }
                                }
                            }
                        }
                    }
                }

                UnLockLoad();

                fclose(handle);

                Lock();

                m_hash_old = m_hash;
                m_hash = m_hash_temp;

                UnLock();

                timepoint = CShingleTime::GetMs() - timepoint;
                restxt = GetResultPrint(stat, timepoint);
                if (m_log != NULL)
                    m_log->WriteMessageAndDataStatus(KMESSAGE, "%s", restxt.c_str());

                if (m_hash_old != NULL) {
                    delete m_hash_old;
                    m_hash_old = NULL;
                }

            } else {
                if (m_log != NULL)
                    m_log->WriteMessageAndDataStatus(KMESSAGE, "%s:   error open file to read: '%s'.", m_ident.c_str(), m_filename.c_str());
            }
        } else {
            if (m_log != NULL)
                m_log->WriteMessageAndDataStatus(KMESSAGE, "%s:   file not found: '%s'.", m_ident.c_str(), m_filename.c_str());
        }
    } else {
        if (m_log != NULL)
            m_log->WriteMessageAndDataStatus(KMESSAGE, "%s:   no defined filename.", m_ident.c_str());
    }
}

bool TSignatureClass::FindTextS(const TString& s) {
    bool res = false;
    ui64 shingle = 0;
    TSignatureHashIt it;
    TString st = TString{Trim(s)};

    if (!st.empty()) {
        to_lower_k(st);
        shingle = ShingleFromStroka(st);

        if (shingle > 0) {
            Lock();

            if (m_hash != NULL) {
                it = m_hash->find(shingle);
                if (it != m_hash->end())
                    res = true;
            }

            UnLock();
        }
    }

    return res;
}
