#pragma once

#include <util/system/defaults.h>
#include <util/system/compat.h>
#include <util/system/mutex.h>
#include <util/generic/hash.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>

typedef THashMap<ui64, TString> TSignatureHash;
typedef TSignatureHash::iterator TSignatureHashIt;

class TSignatureClass {
private:
    struct TFileStateSC {
        time_t mtime;
        long size;

        TFileStateSC() {
            mtime = 0;
            size = 0;
        }
    };

    struct THashStatSC {
        ui32 trace_count;
        ui32 no_trace_count;
        ui32 bad_count;
        ui32 dublicat_count;

        THashStatSC() {
            Clear();
        }

        void Clear() {
            trace_count = 0;
            no_trace_count = 0;
            bad_count = 0;
            dublicat_count = 0;
        }
    };

private:
    TString m_ident;
    TSignatureHash* m_hash;
    TBaseLogClass* m_log;
    TString m_filename;
    TFileStateSC m_statfile;
    TMutex m_MutexLoad;
    TMutex m_Mutex;

    void LockLoad();
    void UnLockLoad();
    void Lock();
    void UnLock();
    bool ExistsFile();
    bool FileStateWasChangedK(const char* fn, TFileStateSC* poldbufstat);
    TString GetResultPrint(THashStatSC& stat, ui32 timedelay);

public:
    TSignatureClass();
    ~TSignatureClass();

    void Init(const TString& filename, TBaseLogClass* logA);
    void Reload();

    bool FindTextS(const TString& s);
};
