#include <mail/so/spamstop/tools/so-common/shtime.h>
#include "tstoragenosql.h"

//****************************************************************************************************************************************
//                                                       TStorageNoSql
//****************************************************************************************************************************************

TStorageNoSql::TStorageNoSql() {
    m_index = -1;
    m_server_hostname = "";
    m_server_code = "";
    m_server_start_time = "";
    m_server_version = "";
    LogsGroup = NULL;
    configobj = NULL;
    m_storage_name = "";
    m_basa_type_name = "";
    m_otherdata = "";
    m_storage_connect = false;
    m_storage_status = "";
    m_use_putqueue = true;
    m_liverqst_lastupdate = 0;
    m_use_longipcache = false;
    m_use_datacache = false;
}

TStorageNoSql::~TStorageNoSql() {
    if (m_putqueue != NULL) {
        delete m_putqueue;
        m_putqueue = NULL;
    }
}

TString TStorageNoSql::GetDatabaseName() {
    TString res = "";

    switch (m_servicetype) {
        case SO_CHECKFORM:
            res = TString(DATABASE_NAME_CHECKFORM);
            break;
        case SO_CLEANWEB:
            res = TString(DATABASE_NAME_CLEANWEB);
            break;
        case SO_MSEARCH:
            res = TString(DATABASE_NAME_MSEARCH);
            break;
    };

    return res;
}

bool TStorageNoSql::InitBeforeFork_base(int index, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupCF* LogsGroupA, TKConfig* configobjA, TServiceType servicetypeA) {
    bool res = true;
    ui32 traffic_min_treshold = 10000000;
    ui32 traffic_max_treshold = 20000000;
    bool no_control_traffic = false;

    m_index = index;

    m_servicetype = servicetypeA;

    m_server_hostname = server_hostname;
    m_server_code = server_code;
    m_server_start_time = server_start_time;
    m_server_version = server_version;
    LogsGroup = LogsGroupA;
    configobj = configobjA;
    if (configobj != NULL) {
        traffic_min_treshold = configobj->ReadInteger("storage_" + IntToStroka(index), "traffic_min_treshold", 10000000);
        traffic_max_treshold = configobj->ReadInteger("storage_" + IntToStroka(index), "traffic_max_treshold", 20000000);
        no_control_traffic = configobj->ReadBool("storage_" + IntToStroka(index), "no_control_traffic", false);

        m_use_putqueue = configobj->ReadBool("update_queue", "enable", true);
        m_use_longipcache = configobj->ReadBool("longipcache", "enable", true);
        m_use_datacache = configobj->ReadBool("datacache", "enable", true);
    }
    TRControl.Init(traffic_min_treshold, traffic_max_treshold, !no_control_traffic);

    //cache long basa
    m_longip_cache.Init(m_use_longipcache, LogsGroupA->GetServerLog(), configobjA, "longipcache");
    m_data_today_cache.Init(m_use_datacache, LogsGroupA->GetServerLog(), configobjA, "datacache");
    m_data_yesterday_cache.Init(m_use_datacache, LogsGroupA->GetServerLog(), configobjA, "datacache");

    m_traccert_driver.Init();

    return res;
}

void TStorageNoSql::InitAfterFork_base() {
    //update queue
    m_putqueue = new updqueue::TUpdateQueueMain();
    if (m_putqueue != NULL)
        m_putqueue->Init(this, configobj);
}

void TStorageNoSql::StoragesClose() {
}

void TStorageNoSql::Midnight() {
    m_traccert_driver.Midnight();

    webstat.Midnight();
    webstat.DeleteEmpty();

    m_longip_cache.Midnight();
    m_data_today_cache.Midnight();
    m_data_yesterday_cache.Midnight();

    TGuard<TMutex> g(m_LiveRqstMutex);
    m_liverqst_yesterday_stat_master = m_liverqst_today_stat_master;
    m_liverqst_today_stat_master.Clear();
    m_liverqst_yesterday_stat_replica = m_liverqst_today_stat_replica;
    m_liverqst_today_stat_replica.Clear();

    if (!CreateNewCollections()) {
        Sleep(TDuration::Seconds(1));
        CreateNewCollections(); //try 2
    }

    if (m_putqueue != NULL)
        m_putqueue->Midnight();

    ClearOldCollections();
}

void TStorageNoSql::EventTick() {
    m_longip_cache.EventTick();
    m_data_today_cache.EventTick();
    m_data_yesterday_cache.EventTick();
    LiveRqstUpdate();
}

void TStorageNoSql::Shutdown() {
}

TString TStorageNoSql::GetCollectionName(stor_bt::TShingleStorageType sstype, const TString& collname) {
    TString res = "";

    switch (sstype) {
        case stor_bt::SST_STAT:
            res = TString(STAT_COLLECTION);
            break;
        case stor_bt::SST_USRCOLL_ASTEXT:
            res = collname;
            break;
        default:
            res = "";
    };

    return res;
};

void TStorageNoSql::IncrementStat(stor_bt::TShingleStorageType stortype, const TString& collname, bool res) {
    Y_UNUSED(stortype, collname, res);
};

void TStorageNoSql::AddStorageStat(stor_bt::TShingleStorageType stortype, const TString& collname, stor_bt::TStorageActionType acttype, int count, NStorageStats::TSRSErrType good, ui32 tick) {
    NStorageStats::TStorageRequestStat::TStorageActionType acttype_cnv = NStorageStats::TStorageRequestStat::SAT_UPDATE;

    switch (acttype) {
        case stor_bt::SAT_UPDATE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_UPDATE;
            break;
        case stor_bt::SAT_FINDONE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_FINDONE;
            break;
        case stor_bt::SAT_ERASE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_ERASE;
            break;
        case stor_bt::SAT_SIZE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_SIZE;
            break;
        case stor_bt::SAT_MULTYACTION:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_MULTYACTION;
            break;
        case stor_bt::SAT_FIND:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_FIND;
            break;
        case stor_bt::SAT_CLEAR:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_CLEAR;
            break;
        case stor_bt::SAT_FINDANDMODIFY:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_FINDANDMODIFY;
            break;
        case stor_bt::SAT_DROPTABLE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_DROPTABLE;
            break;
        case stor_bt::SAT_CREATETABLE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_CREATETABLE;
            break;
    };

    webstat.AddCount(GetDatabaseName(), GetCollectionName(stortype, collname), acttype_cnv, count, good, tick);
    monstat.AddCount(GetDatabaseName(), GetCollectionName(stortype, collname), acttype_cnv, count, good, tick);
}

TStorageInfoFull TStorageNoSql::GetStorageFullInfo() {
    TStorageInfoFull res;

    res.basatypename = GetBasaTypeName();
    res.storageident = GetStorageIdent();

    return res;
}

i64 UI64ToI64(ui64 value) {
    i64 res = 0;

    memcpy(&res, &value, sizeof(value));

    return res;
}

bool TStorageNoSql::WriteConsoleDataToStorage(ui64 shingle, nosql::HashMap& sets) {
    bool res = false;
    nosql::HashMap incrs;
    bool err = false;

    if (m_storage_connect)
        res = StorageUpdate(shingle, stor_bt::SST_STAT, "", incrs, sets, err);

    return res;
}

bool TStorageNoSql::ReadConsoleDataFromStorage(TConsoleStatDataList& srv_list) {
    bool res = false;
    bool err = false;
    TVector<nosql::HashMap> hashes;
    TVector<nosql::HashMap>::const_iterator it;
    TConsoleStatData cs_data;

    res = StorageFind(stor_bt::SST_STAT, "", hashes, err);
    if (res) {
        it = hashes.begin();
        while (it != hashes.end()) {
            if ((*it).size() > 0) {
                cs_data.Clear();
                if (cs_data.ParseRequestFromStorage(*it))
                    srv_list.push_back(cs_data);
            }

            ++it;
        }
    }

    return res;
}

bool TStorageNoSql::StorageInitStatus(TString& status) {
    status = m_storage_status;

    return m_storage_connect;
}

i64 TStorageNoSql::GetStorageSize() {
    i64 res = 0;
    bool err = false;

    //res = StorageSize(0, stor_bt::SST_LONGSTAT, err);
    if (err)
        res = 0;

    return res;
}

TString TStorageNoSql::GetPutQueueMonStatistik() {
    TString res = "";

    if ((m_use_putqueue) && (m_putqueue != NULL))
        res = m_putqueue->GetMonStatistik();

    return res;
}

qustat::TDriverRqstPoolStatFour TStorageNoSql::GetConsoleStat() {
    qustat::TDriverRqstPoolStatFour res;

    if ((m_use_putqueue) && (m_putqueue != NULL))
        res = m_putqueue->GetConsoleStat();

    return res;
}

TString TStorageNoSql::GetPutQueueProperties() {
    TString res = "";

    if (m_putqueue != NULL)
        res = m_putqueue->GetProperties();
    else
        res = "Put queue disabled!";

    return res;
}

TString TStorageNoSql::GetUpdateQueueWebStatistik() {
    TString res = "";

    if ((m_use_putqueue) && (m_putqueue != NULL))
        res = m_putqueue->PrintWebStatistik();

    return res;
}

void TStorageNoSql::LiveRqstUpdate() {
    TGuard<TMutex> g(m_LiveRqstMutex);

    time_t currtime = time(NULL);
    qustat::TDriverRqstPoolStat data_from_drv_master;
    qustat::TDriverRqstPoolStat data_from_drv_replica;

    data_from_drv_master = ReturnLiveRqstStatMaster();
    data_from_drv_replica = ReturnLiveRqstStatReplica();

    if ((currtime > m_liverqst_lastupdate) && ((currtime - m_liverqst_lastupdate) >= 15)) {
        m_liverqst_current_stat_master.Clear();
        m_liverqst_current_stat_replica.Clear();
        m_liverqst_lastupdate = currtime;
    }

    m_liverqst_current_stat_master += data_from_drv_master;
    m_liverqst_today_stat_master += data_from_drv_master;

    m_liverqst_current_stat_replica += data_from_drv_replica;
    m_liverqst_today_stat_replica += data_from_drv_replica;
}

void TStorageNoSql::GetLiveRqstDataMaster(qustat::TDriverRqstPoolStat& liverqst_current_stat, qustat::TDriverRqstPoolStat& liverqst_today_stat, qustat::TDriverRqstPoolStat& liverqst_yesterday_stat) {
    liverqst_current_stat = m_liverqst_current_stat_master;
    liverqst_today_stat = m_liverqst_today_stat_master;
    liverqst_yesterday_stat = m_liverqst_yesterday_stat_master;
}

void TStorageNoSql::GetLiveRqstDataReplica(qustat::TDriverRqstPoolStat& liverqst_current_stat, qustat::TDriverRqstPoolStat& liverqst_today_stat, qustat::TDriverRqstPoolStat& liverqst_yesterday_stat) {
    liverqst_current_stat = m_liverqst_current_stat_replica;
    liverqst_today_stat = m_liverqst_today_stat_replica;
    liverqst_yesterday_stat = m_liverqst_yesterday_stat_replica;
}

TString TStorageNoSql::GetLiveRqstData(bool is_master) {
    TString res = "";
    qustat::TDriverRqstPoolStat liverqst_current_stat;
    qustat::TDriverRqstPoolStat liverqst_today_stat;
    qustat::TDriverRqstPoolStat liverqst_yesterday_stat;

    if (is_master)
        GetLiveRqstDataMaster(liverqst_current_stat, liverqst_today_stat, liverqst_yesterday_stat);
    else
        GetLiveRqstDataReplica(liverqst_current_stat, liverqst_today_stat, liverqst_yesterday_stat);

    if (is_master)
        res += "<br><i><b>Request live time statistik (master):</b></i>&nbsp;&nbsp;";
    else
        res += "<br><i><b>Request live time statistik (replica):</b></i>&nbsp;&nbsp;";
    res += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor='#ffffcc'>";

    res += "<tr align='center' bgcolor='DarkKhaki'>";
    res += "<td width='30%'>&nbsp;</td>";
    res += "<td width='9%'><b>0..10</b></td>";
    res += "<td width='9%'><b>10..20</b></td>";
    res += "<td width='9%'><b>20..50</b></td>";
    res += "<td width='9%'><b>50..100</b></td>";
    res += "<td width='9%'><b>100..150</b></td>";
    res += "<td width='9%'><b>150..190</b></td>";
    res += "<td width='8%'><b>190..500</b></td>";
    res += "<td width='8%'><b>more 500</b></td>";
    res += "</tr>";

    res += "<tr align='right'>";
    res += "<td>current request live</td>";
    res += "<td>" + liverqst_current_stat.GetCount_0_10_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_10_20_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_20_50_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_50_100_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_100_150_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_150_190_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_190_500_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_MORE500_s() + "</td>";
    res += "</tr>";

    res += "<tr align='right'>";
    res += "<td>today request live</td>";
    res += "<td>" + liverqst_today_stat.GetCount_0_10_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_10_20_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_20_50_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_50_100_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_100_150_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_150_190_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_190_500_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_MORE500_s() + "</td>";
    res += "</tr>";

    res += "<tr align='right'>";
    res += "<td>yesterday request live</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_0_10_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_10_20_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_20_50_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_50_100_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_100_150_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_150_190_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_190_500_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_MORE500_s() + "</td>";
    res += "</tr>";

    res += "</table>";

    return res;
}

void TStorageNoSql::UpdateQueueAll(stordata::TUpdateCacheStruct& value) {
    if (value.m_is_longip) {
        stordata::TShingleData data = stordata::TShingleData();

        auto it = value.m_srvc_shingles_list.begin();
        if (it != value.m_srvc_shingles_list.end())
            data = *it;

        UpdateLongIPStatDirect(data, value.m_cnt_type);

    } else {
        UpdateDataToStorageDirect(value.m_srvc_shingles_list, value.m_Spam, value.m_rcpt_count);
    }
}

void TStorageNoSql::GetDataFromStorage(const TString& NumbRequest, stordata::TShingleDataList& srvc_shingles_list, ui32& service_stat_collision_count, ui32& shingles_collision_count) {
    service_stat_collision_count = 0;
    shingles_collision_count = 0;

    if (srvc_shingles_list.size() > 0) {
        stor_bt::TStorageActionList sactlist;
        bool err = false;
        time_t current_time = time(NULL);
        time_t yesterday_time = current_time - 86400;
        TString today_collection = "";
        TString yesterday_collection = "";
        TString error_s = "";

        today_collection = GetShingleDataCollectionName(current_time);
        yesterday_collection = GetShingleDataCollectionName(yesterday_time);

        stordata::TShingleDataList::iterator it;

        //clear all
        it = srvc_shingles_list.begin();
        while (it != srvc_shingles_list.end()) {
            it->Clear();

            ++it;
        }

        //request to today storage
        err = false;
        sactlist.clear();
        it = srvc_shingles_list.begin();
        while (it != srvc_shingles_list.end()) {
            it->m_err = false;
            it->m_tick = 0;
            it->m_nosqldata = stor_bt::TNoSqlItem(it->m_shingle, 0);
            it->m_nosqldata.sets[FIELD_SOSERVICE] = it->m_so_service;
            it->m_nosqldata.sets[FIELD_TYPE] = it->m_type;
            sactlist.push_back(stor_bt::TStorageActionItem(stor_bt::SAT_FINDONE, today_collection, &it->m_nosqldata, &it->m_err, &it->m_tick));

            ++it;
        }

        StorageMultiAction(sactlist, err);

        if (!err) {
            it = srvc_shingles_list.begin();
            while (it != srvc_shingles_list.end()) {
                if (!it->m_nosqldata.Empty()) {
                    stordata::TShingleDataItemSerialization::Deserialize(it->m_nosqldata.hash, it->m_data_today);
                    if (it->m_is_stat) //statistik by so_service
                    {
                        if (!it->MoveStatTodayData(error_s)) {
                            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s %s", NumbRequest.c_str(), error_s.c_str());

                            if (it->m_collision_error)
                                service_stat_collision_count = IncMax32(service_stat_collision_count, 1);
                        }

                    } else {
                        if (!it->MoveTodayData(error_s)) {
                            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s %s", NumbRequest.c_str(), error_s.c_str());

                            if (it->m_collision_error)
                                shingles_collision_count = IncMax32(shingles_collision_count, 1);
                        } else {
                            //add to local cache
                            m_data_today_cache.Add(it->m_shingle, it->m_data_today);
                        }
                    }
                }

                ++it;
            }
        } else {
            bool exists = false;
            stordata::TShingleDataItem value = stordata::TShingleDataItem();

            it = srvc_shingles_list.begin();
            while (it != srvc_shingles_list.end()) {
                if (!it->m_is_stat) {
                    exists = false;
                    value = stordata::TShingleDataItem();

                    value = m_data_today_cache.Get(it->m_shingle, exists);
                    if (exists)
                        it->m_data_today = value;
                }

                ++it;
            }
        }

        //request to yesterday storage
        err = false;
        sactlist.clear();
        it = srvc_shingles_list.begin();
        while (it != srvc_shingles_list.end()) {
            it->m_err = false;
            it->m_tick = 0;
            it->m_nosqldata = stor_bt::TNoSqlItem(it->m_shingle, 0);
            it->m_nosqldata.sets[FIELD_SOSERVICE] = it->m_so_service;
            it->m_nosqldata.sets[FIELD_TYPE] = it->m_type;
            sactlist.push_back(stor_bt::TStorageActionItem(stor_bt::SAT_FINDONE, yesterday_collection, &it->m_nosqldata, &it->m_err, &it->m_tick));

            ++it;
        }

        StorageMultiAction(sactlist, err);

        if (!err) {
            it = srvc_shingles_list.begin();
            while (it != srvc_shingles_list.end()) {
                if (!it->m_nosqldata.Empty()) {
                    stordata::TShingleDataItemSerialization::Deserialize(it->m_nosqldata.hash, it->m_data_yesterday);
                    if (it->m_is_stat) //statistik by so_service
                    {
                        if (!it->MoveStatYesterdayData(error_s)) {
                            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s %s", NumbRequest.c_str(), error_s.c_str());

                            if (it->m_collision_error)
                                service_stat_collision_count = IncMax32(service_stat_collision_count, 1);
                        }

                    } else {
                        if (!it->MoveYesterdayData(error_s)) {
                            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s %s", NumbRequest.c_str(), error_s.c_str());

                            if (it->m_collision_error)
                                shingles_collision_count = IncMax32(shingles_collision_count, 1);
                        } else {
                            //add to local cache
                            m_data_yesterday_cache.Add(it->m_shingle, it->m_data_yesterday);
                        }
                    }
                }

                ++it;
            }
        } else {
            bool exists = false;
            stordata::TShingleDataItem value = stordata::TShingleDataItem();

            it = srvc_shingles_list.begin();
            while (it != srvc_shingles_list.end()) {
                if (!it->m_is_stat) {
                    exists = false;
                    value = stordata::TShingleDataItem();

                    value = m_data_yesterday_cache.Get(it->m_shingle, exists);
                    if (exists)
                        it->m_data_yesterday = value;
                }

                ++it;
            }
        }
    }
}

void TStorageNoSql::UpdateDataToStorage(const TString& NumbRequest, stordata::TShingleDataList& srvc_shingles_list, stordata::RESTYPE Spam, int rcpt_count) {
    if (m_use_putqueue) {
        if (m_putqueue != NULL)
            m_putqueue->AddRecord(stordata::TUpdateCacheStruct(NumbRequest, srvc_shingles_list, Spam, rcpt_count));

    } else
        UpdateDataToStorageDirect(srvc_shingles_list, Spam, rcpt_count);
}

void TStorageNoSql::UpdateDataToStorageDirect(stordata::TShingleDataList& srvc_shingles_list, stordata::RESTYPE Spam, int rcpt_count) {
    if (srvc_shingles_list.size() > 0) {
        stor_bt::TStorageActionList sactlist1;
        bool err = false;
        time_t current_time = time(NULL);
        TString today_collection = "";
        TString error_s = "";
        //stordata::TShingleData      data_v = stordata::TShingleData();
        stor_bt::TStorageActionItem sav = stor_bt::TStorageActionItem();

        today_collection = GetShingleDataCollectionName(current_time);

        //request to today sorage
        err = false;

        stordata::TShingleDataList::iterator it = srvc_shingles_list.begin();
        while (it != srvc_shingles_list.end()) {
            //data_v = *it;

            it->m_err = false;
            it->m_tick = 0;
            it->m_nosqldata = stor_bt::TNoSqlItem(it->m_shingle, 0);

            if (it->m_is_stat) {
                it->m_nosqldata.sets[FIELD_SOSERVICE] = it->m_so_service;

                if (it->m_type == stordata::SERVICE_STAT_RQST) {
                    it->m_nosqldata.incrs[FIELD_TYPE] = 1;
                    switch (Spam) {
                        case stordata::RT_SPAM:
                            it->m_nosqldata.incrs[FIELD_SPAM] = 1;
                            break;
                        case stordata::RT_HAM:
                            it->m_nosqldata.incrs[FIELD_HAM] = 1;
                            break;
                        case stordata::RT_ERROR:
                            break;
                    };

                } else if (it->m_type == stordata::SERVICE_STAT_RCPT) {
                    it->m_nosqldata.incrs[FIELD_TYPE] = rcpt_count;
                    switch (Spam) {
                        case stordata::RT_SPAM:
                            it->m_nosqldata.incrs[FIELD_SPAM] = rcpt_count;
                            break;
                        case stordata::RT_HAM:
                            it->m_nosqldata.incrs[FIELD_HAM] = rcpt_count;
                            break;
                        case stordata::RT_ERROR:
                            break;
                    };
                }

            } else {
                it->m_nosqldata.sets[FIELD_SOSERVICE] = it->m_so_service;
                it->m_nosqldata.sets[FIELD_TYPE] = it->m_type;

                if (Spam == stordata::RT_SPAM)
                    it->m_nosqldata.incrs[FIELD_SPAM] = rcpt_count;
                else
                    it->m_nosqldata.incrs[FIELD_HAM] = rcpt_count;
            }

            sav = stor_bt::TStorageActionItem(stor_bt::SAT_UPDATE, today_collection, &it->m_nosqldata, &it->m_err, &it->m_tick);
            printf("USD: %s\n", sav.toLog().c_str());
            sactlist1.push_back(sav);

            ++it;
        }

        stor_bt::TStorageActionList::iterator sit = sactlist1.begin();
        while (sit != sactlist1.end()) {
            if ((*sit).m_nosqldata != NULL) {
                printf("USD2: %s\n", sit->toLog().c_str());
            }

            ++sit;
        }

        StorageMultiAction(sactlist1, err);
    }
}

TString TStorageNoSql::GetShingleDataCollectionName(time_t colltime) {
    tm tmt = *localtime(&colltime);

    return "coll_" + IntToStroka(1900 + tmt.tm_year) + "_" + IntToStroka2(1 + tmt.tm_mon) + "_" + IntToStroka2(tmt.tm_mday);
}

TString TStorageNoSql::GetShingleDataIndexName(time_t colltime) {
    tm tmt = *localtime(&colltime);

    return "idx_" + IntToStroka(1900 + tmt.tm_year) + IntToStroka2(1 + tmt.tm_mon) + IntToStroka2(tmt.tm_mday);
}

bool TStorageNoSql::CreateNewCollections() {
    bool res = false;
    time_t current_time = time(NULL);
    TString today_collection = "";
    TString err_s = "";
    ui32 tick = 0;

    tick = CShingleTime::GetMs();

    today_collection = GetShingleDataCollectionName(current_time);

    if (CreateCollection(today_collection, err_s)) {
        res = true;
        tick = CShingleTime::GetMs() - tick;
        if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
            LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KMESSAGE, "Create collection '%s' to %u msec - OK.", today_collection.c_str(), tick);

    } else {
        res = false;
        tick = CShingleTime::GetMs() - tick;
        if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
            LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "Create collection '%s' to %u msec - FAILED (%s).", today_collection.c_str(), tick, err_s.c_str());
    }

    return res;
}

void TStorageNoSql::ClearOldCollections() {
    time_t current_time = time(NULL);
    time_t coll_time = 0;
    TString collection_name = "";
    TString err_s = "";
    ui32 tick = 0;

    for (size_t i = 2; i < 7; i++) {
        coll_time = current_time - 86400 * i;
        collection_name = GetShingleDataCollectionName(coll_time);

        tick = CShingleTime::GetMs();
        if (DeleteCollection(collection_name, err_s)) {
            tick = CShingleTime::GetMs() - tick;
            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KMESSAGE, "Delete collection '%s' to %u msec - OK.", collection_name.c_str(), tick);

        } else {
            tick = CShingleTime::GetMs() - tick;
            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "Delete collection '%s' to %u msec - FAILED (%s).", collection_name.c_str(), tick, err_s.c_str());
        }
    }
}

TLongIPData TStorageNoSql::GetLongIPStat(const TString& NumbRequest, stordata::TShingleData& data, bool& collision_error) {
    TLongIPData res = TLongIPData();
    stor_bt::TStorageActionList sactlist;
    bool err = false;
    TString error_s = "";
    TString collection_name = data.m_so_service + TString(LONGIP_COLLECTION_ID);

    //request to today sorage
    collision_error = false;
    err = false;
    sactlist.clear();

    data.m_err = false;
    data.m_tick = 0;
    data.m_nosqldata = stor_bt::TNoSqlItem(data.m_shingle, 0);
    data.m_nosqldata.sets[FIELD_LIP_SOSERVICE] = data.m_so_service;

    sactlist.push_back(stor_bt::TStorageActionItem(stor_bt::SAT_FINDONE, collection_name, &data.m_nosqldata, &data.m_err, &data.m_tick));

    StorageMultiAction(sactlist, err);

    if (!data.m_err) {
        if (!data.m_nosqldata.Empty()) {
            stordata::TLongIPDataItemSerialization::Deserialize(data.m_nosqldata.hash, data.m_longipdata);
            if (data.m_longipdata.m_so_service == data.m_so_service) {
                res = data.m_longipdata.ConverToTLongIPData();

                m_longip_cache.Add(data.m_shingle, data.m_longipdata); //put in local cache
            } else {
                //collision
                collision_error = true;
                error_s = "Collision LONGIP (local_so_service='" + data.m_so_service + "', ext:" + data.m_longipdata.toList(data.m_shingle) + ")";
                if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                    LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s %s", NumbRequest.c_str(), error_s.c_str());
            }
        }

    } else {
        stordata::TLongIPDataItem value = stordata::TLongIPDataItem();
        bool exists = false;

        value = m_longip_cache.Get(data.m_shingle, exists);
        if (exists) {
            data.m_longipdata = value;
            res = data.m_longipdata.ConverToTLongIPData();
        }
    }

    return res;
}

void TStorageNoSql::UpdateLongIPStat(const TString& NumbRequest, stordata::TShingleData& data, stordata::TLongIPCnt cnt_type) {
    if (m_use_putqueue) {
        if (m_putqueue != NULL)
            m_putqueue->AddRecord(stordata::TUpdateCacheStruct(NumbRequest, data, cnt_type));

    } else
        UpdateLongIPStatDirect(data, cnt_type);
}

void TStorageNoSql::UpdateLongIPStatDirect(stordata::TShingleData& v_data, stordata::TLongIPCnt cnt_type) {
    stordata::TLongIPDataItem res;
    stor_bt::TStorageActionList sactlist;
    bool err = false;
    TString error_s = "";
    TString collection_name = v_data.m_so_service + TString(LONGIP_COLLECTION_ID);

    //request to today sorage
    err = false;
    sactlist.clear();

    v_data.m_err = false;
    v_data.m_tick = 0;
    v_data.m_nosqldata = stor_bt::TNoSqlItem(v_data.m_shingle, 0);

    v_data.m_nosqldata.sets[FIELD_LIP_SOSERVICE] = v_data.m_so_service;
    v_data.m_nosqldata.sets[FIELD_LIP_LASTTIME] = static_cast<ui32>(kday_t(time(NULL)));

    switch (cnt_type) {
        case stordata::LPHONE_HAM:
        case stordata::LIP_HAM:
            v_data.m_nosqldata.incrs[FIELD_LIP_HAM] = 1;
            break;
        case stordata::LPHONE_SPAM:
        case stordata::LIP_SPAM:
            v_data.m_nosqldata.incrs[FIELD_LIP_SPAM] = 1;
            break;
        case stordata::LIP_FOUND:
            v_data.m_nosqldata.incrs[FIELD_LIP_FOUND] = 1;
            break;
    };

    sactlist.push_back(stor_bt::TStorageActionItem(stor_bt::SAT_UPDATE, collection_name, &v_data.m_nosqldata, &v_data.m_err, &v_data.m_tick));

    StorageMultiAction(sactlist, err);
}

//****************************************************************************************************************************************
