#pragma once

#include "util/generic/hash.h"
#include "util/generic/vector.h"
#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/string/util.h"
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-clients/ktime.h>
#include <mail/so/spamstop/tools/so-clients/kshingle.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/so-common/tstoragerequeststat.h>
#include <mail/so/spamstop/tools/so-common/ttraccert_stat.h>
#include <mail/so/spamstop/tools/so-common/tbasestoragetypes.h>
#include <list>
#include <mail/so/spamstop/tools/so-clients/functional_clients/UserReputClient.h>
#include "tconsolestat.h"
#include <mail/so/spamstop/tools/fcgiserver_base/sotypes.h>
#include "tstoragecachebase.h"
#include "kqueuestat.h"
#include "ttraccert_stat.h"
#include "tstoragepooltypes.h"
#include "tlogsgroup_cf.h"
#include "tstorebase.h"
#include "tupdatequeue.h"

#define DATABASE_NAME_CHECKFORM "CHECKFORM2"
#define DATABASE_NAME_CLEANWEB "CLEANWEB2"
#define DATABASE_NAME_MSEARCH "MSEARCH2"
#define LONGIP_COLLECTION "LONGIP"
#define STAT_COLLECTION "GENSTAT"

//****************************************************************************************************************************************
//                                                       TStorageNoSql
//****************************************************************************************************************************************

class TStorageNoSql : public TStoreBase {
public:
    enum ERRTYPE { ER_GOOD,
                   ER_ERROR,
                   ER_POOLTIMEOUT,
                   ER_SENDTIMEOUT,
                   ER_RCVTIMEOUT,
                   ER_UNKNOWN };

public:
    int m_index;
    TServiceType m_servicetype;
    TString m_storage_name;
    TString m_basa_type_name;
    TLogsGroupCF* LogsGroup;
    TKConfig* configobj;
    TTrafficControl TRControl;
    bool m_storage_connect;
    TString m_storage_status;

    TString m_server_hostname;
    TString m_server_code;
    TString m_server_start_time;
    TString m_server_version;
    TString m_otherdata;

    st_cache::TStorageCacheBase<stordata::TLongIPDataItem> m_longip_cache;
    st_cache::TStorageCacheBase<stordata::TShingleDataItem> m_data_today_cache;
    st_cache::TStorageCacheBase<stordata::TShingleDataItem> m_data_yesterday_cache;
    bool m_use_longipcache;
    bool m_use_datacache;

    updqueue::TUpdateQueueMain* m_putqueue;
    bool m_use_putqueue;

    NStorageStats::TStorageRequestStatMain webstat;
    NStorageStats::TStorageRequestStatMain monstat;

    trcstat::TTraccertStat m_traccert_driver;

    ui32 m_liverqst_lastupdate;
    qustat::TDriverRqstPoolStat m_liverqst_current_stat_master;
    qustat::TDriverRqstPoolStat m_liverqst_today_stat_master;
    qustat::TDriverRqstPoolStat m_liverqst_yesterday_stat_master;
    qustat::TDriverRqstPoolStat m_liverqst_current_stat_replica;
    qustat::TDriverRqstPoolStat m_liverqst_today_stat_replica;
    qustat::TDriverRqstPoolStat m_liverqst_yesterday_stat_replica;
    TMutex m_LiveRqstMutex;
    void LiveRqstUpdate();

    TString GetCollectionName(stor_bt::TShingleStorageType sstype, const TString& collname);
    void IncrementStat(stor_bt::TShingleStorageType stortype, const TString& collname, bool res);
    void AddStorageStat(stor_bt::TShingleStorageType stortype, const TString& collname, stor_bt::TStorageActionType acttype, int count, NStorageStats::TSRSErrType good, ui32 tick);

    //������� ������ � �����
    virtual bool StorageUpdate(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err) = 0;
    virtual bool StorageFindOne(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, nosql::HashMap& hash, bool& err) = 0;
    virtual bool StorageFind(stor_bt::TShingleStorageType sstype, const TString& ext_collname, TVector<nosql::HashMap>& hashes, bool& err) = 0;
    virtual bool StorageErase(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err) = 0;
    virtual i64 StorageSize(int type, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err) = 0;
    virtual bool StorageTableDrop(int type, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err) = 0;
    virtual void StorageMultiAction(stor_bt::TStorageActionList& actlist, bool& err) = 0;

    virtual TString ReturnDriverProp() = 0;
    virtual qustat::TDriverRqstPoolStat ReturnLiveRqstStatMaster() = 0;
    virtual qustat::TDriverRqstPoolStat ReturnLiveRqstStatReplica() = 0;

public:
    TStorageNoSql();
    virtual ~TStorageNoSql();

    TString GetDatabaseName();
    int GetIndex() {
        return m_index;
    }
    bool InitBeforeFork_base(int index, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupCF* LogsGroupA, TKConfig* configobjA, TServiceType servicetypeA);
    void InitAfterFork_base();
    void StoragesClose();
    void Clear(){};
    void Midnight();
    void EventTick();
    void Shutdown();
    TString GetBasaTypeName() {
        return m_basa_type_name;
    }
    TString GetOnlyStorageName() {
        return m_storage_name;
    }
    TString GetStorageIdent() {
        return GetOnlyStorageName() + " (" + GetBasaTypeName() + ")";
    }
    TStorageInfoFull GetStorageFullInfo();

    NStorageStats::TStorageStatVector GetWebStatistik() {
        return webstat.GetWebStat();
    }
    NStorageStats::TStorageStatVector GetMonStatistik() {
        return monstat.GetMonStat();
    }
    TString GetTraccertStat() {
        return m_traccert_driver.GetWebData();
    }

    bool WriteConsoleDataToStorage(ui64 shingle, nosql::HashMap& sets);
    bool ReadConsoleDataFromStorage(TConsoleStatDataList& srv_list);

    bool StorageInitStatus(TString& status);
    i64 GetStorageSize();

    TString GetLongIPCacheStatS() {
        return m_longip_cache.GetCacheStatistic();
    }
    TString GetDataTodayCacheStatS() {
        return m_data_today_cache.GetCacheStatistic();
    }
    TString GetDataYesterdayCacheStatS() {
        return m_data_yesterday_cache.GetCacheStatistic();
    }

    TString GetPutQueueMonStatistik();
    qustat::TDriverRqstPoolStatFour GetConsoleStat();
    TString GetPutQueueProperties();
    TString GetUpdateQueueWebStatistik();

    void GetLiveRqstDataMaster(qustat::TDriverRqstPoolStat& liverqst_current_stat, qustat::TDriverRqstPoolStat& liverqst_today_stat, qustat::TDriverRqstPoolStat& liverqst_yesterday_stat);
    void GetLiveRqstDataReplica(qustat::TDriverRqstPoolStat& liverqst_current_stat, qustat::TDriverRqstPoolStat& liverqst_today_stat, qustat::TDriverRqstPoolStat& liverqst_yesterday_stat);
    TString GetLiveRqstData(bool is_master);

    TString GetShingleDataCollectionName(time_t colltime);
    TString GetShingleDataIndexName(time_t colltime);
    bool CreateNewCollections();
    void ClearOldCollections();

    void UpdateQueueAll(stordata::TUpdateCacheStruct& value);

    void GetDataFromStorage(const TString& NumbRequest, stordata::TShingleDataList& srvc_shingles_list, ui32& service_stat_collision_count, ui32& shingles_collision_count);
    void UpdateDataToStorageDirect(stordata::TShingleDataList& srvc_shingles_list, stordata::RESTYPE Spam, int rcpt_count);
    void UpdateDataToStorage(const TString& NumbRequest, stordata::TShingleDataList& srvc_shingles_list, stordata::RESTYPE Spam, int rcpt_count);

    TLongIPData GetLongIPStat(const TString& NumbRequest, stordata::TShingleData& data, bool& collision_error);
    void UpdateLongIPStatDirect(stordata::TShingleData& v_data, stordata::TLongIPCnt cnt_type);
    void UpdateLongIPStat(const TString& NumbRequest, stordata::TShingleData& data, stordata::TLongIPCnt cnt_type);
};

//****************************************************************************************************************************************
