#include "tstorebase.h"

//******************************************************************************
//                                TStoreBase
//******************************************************************************

TStoreBase::TStoreBase() {
    Ident = "";
}

TStoreBase::~TStoreBase() {
}

bool TStoreBase::GetAntiDDOSActionIP(const TString& so_service, TKIPv6 ip, ui32& value, int& remain_sec) {
    bool res = false;
    ui64 shingle = 0;

    remain_sec = -1;
    value = 0;
    if (!ip.Undefined()) {
        shingle = ShingleFromStroka(ip.toStroka());
        if (shingle != 0)
            res = storage.Get(so_service, TAntiDDOSStorage::ST_IP, shingle, value, remain_sec);
    }

    return res;
}

bool TStoreBase::GetAntiDDOSActionLogin(const TString& so_service, const TString& login, ui32& value, int& remain_sec) {
    bool res = false;
    ui64 shingle = 0;

    remain_sec = -1;
    value = 0;
    if (!login.empty()) {
        shingle = ShingleFromStroka(login);
        if (shingle != 0)
            res = storage.Get(so_service, TAntiDDOSStorage::ST_LOGIN, shingle, value, remain_sec);
    }

    return res;
}

bool TStoreBase::GetAntiDDOSActionNick(const TString& so_service, ui64 nick_shingle, ui32& value, int& remain_sec) {
    bool res = false;
    ui64 shingle = 0;

    remain_sec = -1;
    value = 0;
    shingle = nick_shingle;
    if (shingle != 0)
        res = storage.Get(so_service, TAntiDDOSStorage::ST_NICK, shingle, value, remain_sec);

    return res;
}

bool TStoreBase::GetAntiDDOSActionComment(const TString& so_service, ui64 comment_shingle, ui32& value, int& remain_sec) {
    bool res = false;
    ui64 shingle = 0;

    remain_sec = -1;
    value = 0;
    shingle = comment_shingle;
    if (shingle != 0)
        res = storage.Get(so_service, TAntiDDOSStorage::ST_COMMENT, shingle, value, remain_sec);

    return res;
}

bool TStoreBase::GetAntiDDOSActionXMPPServerName(const TString& so_service, ui64 xmpp_srvname_shingle, ui32& value, int& remain_sec) {
    bool res = false;
    ui64 shingle = 0;

    remain_sec = -1;
    value = 0;
    shingle = xmpp_srvname_shingle;
    if (shingle != 0)
        res = storage.Get(so_service, TAntiDDOSStorage::ST_XMPPSERVERNAME, shingle, value, remain_sec);

    return res;
}

bool TStoreBase::GetAntiDDOSActionSubject(const TString& so_service, ui64 subject_shingle, ui32& value, int& remain_sec) {
    bool res = false;
    ui64 shingle = 0;

    remain_sec = -1;
    value = 0;
    shingle = subject_shingle;
    if (shingle != 0)
        res = storage.Get(so_service, TAntiDDOSStorage::ST_SUBJECT, shingle, value, remain_sec);

    return res;
}

void TStoreBase::AddAntiDDOSActionIP(const TString& so_service, TKIPv6 ip, TCountersStatEx value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    if (!ip.Undefined()) {
        valuedata = IncMax32(value.today_ham, value.today_spam);
        shingle = ShingleFromStroka(ip.toStroka());
        if (shingle != 0)
            storage.Add(so_service, TAntiDDOSStorage::ST_IP, shingle, valuedata);
    }
}

void TStoreBase::AddAntiDDOSActionLogin(const TString& so_service, const TString& login, TCountersStat value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    if (!login.empty()) {
        valuedata = value.All;
        shingle = ShingleFromStroka(login);
        if (shingle != 0)
            storage.Add(so_service, TAntiDDOSStorage::ST_LOGIN, shingle, valuedata);
    }
}

void TStoreBase::AddAntiDDOSActionLogin(const TString& so_service, const TString& login, TCountersStatEx value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    if (!login.empty()) {
        valuedata = IncMax32(value.today_ham, value.today_spam);
        shingle = ShingleFromStroka(login);
        if (shingle != 0)
            storage.Add(so_service, TAntiDDOSStorage::ST_LOGIN, shingle, valuedata);
    }
}

void TStoreBase::AddAntiDDOSActionNick(const TString& so_service, ui64 nick_shingle, TCountersStatEx value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    valuedata = IncMax32(value.today_ham, value.today_spam);
    shingle = nick_shingle;
    if (shingle != 0)
        storage.Add(so_service, TAntiDDOSStorage::ST_NICK, shingle, valuedata);
}

void TStoreBase::AddAntiDDOSActionXMPPServerName(const TString& so_service, ui64 xmpp_srvname_shingle, TCountersStat value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    valuedata = value.All;
    shingle = xmpp_srvname_shingle;
    if (shingle != 0)
        storage.Add(so_service, TAntiDDOSStorage::ST_XMPPSERVERNAME, shingle, valuedata);
}

void TStoreBase::AddAntiDDOSActionXMPPServerName(const TString& so_service, ui64 xmpp_srvname_shingle, TCountersStatEx value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    valuedata = IncMax32(value.today_ham, value.today_spam);
    shingle = xmpp_srvname_shingle;
    if (shingle != 0)
        storage.Add(so_service, TAntiDDOSStorage::ST_XMPPSERVERNAME, shingle, valuedata);
}

void TStoreBase::AdddAntiDDOSActionComment(const TString& so_service, ui64 comment_shingle, TCountersStatEx value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    valuedata = IncMax32(value.today_ham, value.today_spam);
    shingle = comment_shingle;
    if (shingle != 0)
        storage.Add(so_service, TAntiDDOSStorage::ST_COMMENT, shingle, valuedata);
}

void TStoreBase::AdddAntiDDOSActionSubject(const TString& so_service, ui64 subject_shingle, TCountersStat value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    valuedata = value.All;
    shingle = subject_shingle;
    if (shingle != 0)
        storage.Add(so_service, TAntiDDOSStorage::ST_SUBJECT, shingle, valuedata);
}

void TStoreBase::AdddAntiDDOSActionSubject(const TString& so_service, ui64 subject_shingle, TCountersStatEx value) {
    ui64 shingle = 0;
    ui32 valuedata = 0;

    valuedata = IncMax32(value.today_ham, value.today_spam);
    shingle = subject_shingle;
    if (shingle != 0)
        storage.Add(so_service, TAntiDDOSStorage::ST_SUBJECT, shingle, valuedata);
}

//******************************************************************************
