#pragma once

#include "util/generic/string.h"
#include "util/generic/hash.h"
#include <library/cpp/deprecated/atomic/atomic.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include "tlogsgroup_cf.h"
#include "antiddosstor.h"
#include "traccert.h"
#include "kclasses.h"
#include "tstorebase_data.h"
#include "tcheckform_types.h"

//******************************************************************************
//                                TShinglesList
//******************************************************************************

typedef std::list<ui64> TShinglesList;
typedef TShinglesList::iterator TShinglesListIt;

//******************************************************************************
//                                TStoreStat
//******************************************************************************

struct TStoreStat {
    time_t last_info_time;
    TAtomic ip_all;
    TAtomic ip_today;
    TAtomic login_all;
    TAtomic login_today;
    TAtomic host_all;
    TAtomic host_today;
    TAtomic nick_all;
    TAtomic nick_today;
    TAtomic comment_all;
    TAtomic comment_today;
    TAtomic email_all;
    TAtomic email_today;
    TAtomic phone_all;
    TAtomic phone_today;
    TAtomic geo_all;
    TAtomic geo_today;

    TStoreStat() {
        clear();
    }

    void clear() {
        last_info_time = 0;
        ip_all = 0;
        ip_today = 0;
        login_all = 0;
        login_today = 0;
        host_all = 0;
        host_today = 0;
        nick_all = 0;
        nick_today = 0;
        comment_all = 0;
        comment_today = 0;
        email_all = 0;
        email_today = 0;
        phone_all = 0;
        phone_today = 0;
        geo_all = 0;
        geo_today = 0;
    }
};

//******************************************************************************
//                                TStoreBase
//******************************************************************************

class TStoreBase {
protected:
    TString Ident;
    TAntiDDOSStorage storage;

public:
    TStoreBase();
    virtual ~TStoreBase();

    virtual bool InitBeforeFork(TServiceType servicetypeA, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupCF* LogsGroupA, TKConfig* configobjA) = 0;
    virtual bool InitBeforeForkNum(int index, TServiceType servicetypeA, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupCF* LogsGroupA, TKConfig* configobjA) = 0;
    virtual void InitAfterFork() = 0;

    virtual void Clear() = 0;
    virtual void Midnight() = 0;
    virtual void EventTick() = 0;
    virtual TString GetIdent() {
        return Ident;
    }

    virtual void GetDataFromStorage(const TString& NumbRequest, stordata::TShingleDataList& srvc_shingles_list, ui32& service_stat_collision_count, ui32& shingles_collision_count) = 0;
    virtual void UpdateDataToStorage(const TString& NumbRequest, stordata::TShingleDataList& srvc_shingles_list, stordata::RESTYPE Spam, int rcpt_count) = 0;
    virtual bool CreateCollection(const TString& collection_name, TString& err_s) = 0;
    virtual bool DeleteCollection(const TString& collection_name, TString& err_s) = 0;
    virtual TLongIPData GetLongIPStat(const TString& NumbRequest, stordata::TShingleData& data, bool& collision_error) = 0;
    virtual void UpdateLongIPStat(const TString& NumbRequest, stordata::TShingleData& data, stordata::TLongIPCnt cnt_type) = 0;

    //������ � �������
    virtual bool WriteDump(const TString& path, ui32& collection_count, ui32& record_count) = 0;
    virtual bool ReadDump(const TString& path, ui32& collection_count, ui32& record_count) = 0;
    virtual bool ListDump(const TString& path, ui32& collection_count, ui32& record_count) = 0;

    //anti ddos
    bool GetAntiDDOSActionIP(const TString& so_service, TKIPv6 ip, ui32& value, int& remain_sec);                             //"~ip"
    bool GetAntiDDOSActionLogin(const TString& so_service, const TString& login, ui32& value, int& remain_sec);               //"~login"
    bool GetAntiDDOSActionXMPPServerName(const TString& so_service, ui64 xmpp_srvname_shingle, ui32& value, int& remain_sec); //"~xmpp_srvname"
    bool GetAntiDDOSActionNick(const TString& so_service, ui64 nick_shingle, ui32& value, int& remain_sec);                   //"~nick"
    bool GetAntiDDOSActionComment(const TString& so_service, ui64 comment_shingle, ui32& value, int& remain_sec);             //"~comment"
    bool GetAntiDDOSActionSubject(const TString& so_service, ui64 subject_shingle, ui32& value, int& remain_sec);             //"~subject"

    void AddAntiDDOSActionIP(const TString& so_service, TKIPv6 ip, TCountersStatEx value);
    void AddAntiDDOSActionLogin(const TString& so_service, const TString& login, TCountersStat value);
    void AddAntiDDOSActionLogin(const TString& so_service, const TString& login, TCountersStatEx value);
    void AddAntiDDOSActionNick(const TString& so_service, ui64 nick_shingle, TCountersStatEx value);
    void AddAntiDDOSActionXMPPServerName(const TString& so_service, ui64 xmpp_srvname_shingle, TCountersStat value);
    void AddAntiDDOSActionXMPPServerName(const TString& so_service, ui64 xmpp_srvname_shingle, TCountersStatEx value);
    void AdddAntiDDOSActionComment(const TString& so_service, ui64 comment_shingle, TCountersStatEx value);
    void AdddAntiDDOSActionSubject(const TString& so_service, ui64 subject_shingle, TCountersStat value);
    void AdddAntiDDOSActionSubject(const TString& so_service, ui64 subject_shingle, TCountersStatEx value);
};

//******************************************************************************
