#include "tstorebase_data.h"

namespace stordata {
    TString DATATYPEToStroka(DATATYPE type) {
        TString res = "";

        switch (type) {
            case IPSTAT:
                res = "IPSTAT";
                break;
            case LOGINSTAT:
                res = "LOGINSTAT";
                break;
            case HOSTSTAT:
                res = "HOSTSTAT";
                break;
            case EMAILSTAT:
                res = "EMAILSTAT";
                break;
            case PHONESTAT:
                res = "PHONESTAT";
                break;
            case NICKSTAT:
                res = "NICKSTAT";
                break;
            case COMMENTSTAT:
                res = "COMMENTSTAT";
                break;
            case GEO:
                res = "GEO";
                break;
            case GEOCOUNTRY:
                res = "GEOCOUNTRY";
                break;
            case SUIDTOTAL:
                res = "SUIDTOTAL";
                break;
            case TEXTTOTAL:
                res = "TEXTTOTAL";
                break;
            case IPSUIDTEXTTOTAL:
                res = "IPSUIDTEXTTOTAL";
                break;
            case IPFOUND:
                res = "IPFOUND";
                break;
            case LOGINFOUND:
                res = "LOGINFOUND";
                break;
            case TEXTFOUND:
                res = "TEXTFOUND";
                break;
            case GEOSFOUND:
                res = "GEOSFOUND";
                break;
            case IPSUIDFOUND:
                res = "IPSUIDFOUND";
                break;
            case IPTEXTFOUND:
                res = "IPTEXTFOUND";
                break;
            default:
                res = "UNKNOWN";
        };

        return res;
    }

    ui64 CreateShingle(ui64 shingle, DATATYPE type) {
        ui64 res = 0;
        TString res_txt = "";

        res_txt += ShingleToStroka(shingle) + "_" + DATATYPEToStroka(type);

        return res;
    }

    //*************************************************************************************************************
    //                                    TShingleDataItemSerialization
    //*************************************************************************************************************

    void TShingleDataItemSerialization::Deserialize(nosql::HashMap& hash, TShingleDataItem& data) {
        i32 type = 0;
        i32 ham = 0;
        i32 spam = 0;
        TString soservice = "";

        AssignValue(type, hash[FIELD_TYPE].Long());
        soservice = hash[FIELD_SOSERVICE].String();
        AssignValue(ham, hash[FIELD_HAM].Long());
        AssignValue(spam, hash[FIELD_SPAM].Long());

        data.Clear();
        data.m_type = static_cast<ui32>(type);
        data.m_so_service = soservice;
        data.m_ham = static_cast<ui32>(ham);
        data.m_spam = static_cast<ui32>(spam);
    }

    void TShingleDataItemSerialization::Deserialize2(nosql::HashMap& incrs, nosql::HashMap& sets, TShingleDataItem& data) {
        i32 type = 0;
        i32 ham = 0;
        i32 spam = 0;
        TString soservice = "";

        soservice = sets[FIELD_SOSERVICE].String();

        const char* p = strstr(soservice.c_str(), TString(BASE_STAT_SHINGLE_DOPSTR).c_str());

        if ((p != NULL) && (p == soservice.c_str())) //so_service stat
            AssignValue(type, incrs[FIELD_TYPE].Long());
        else
            AssignValue(type, sets[FIELD_TYPE].Long());

        AssignValue(ham, incrs[FIELD_HAM].Long());
        AssignValue(spam, incrs[FIELD_SPAM].Long());

        data.Clear();
        data.m_type = static_cast<ui32>(type);
        data.m_so_service = soservice;
        data.m_ham = static_cast<ui32>(ham);
        data.m_spam = static_cast<ui32>(spam);
    }

    void TShingleDataItemSerialization::Serialize(const TShingleDataItem& data, nosql::HashMap& sets) {
        SetElementWOCheck(sets, FIELD_TYPE, static_cast<i32>(data.m_type));
        SetElementWOCheck(sets, FIELD_SOSERVICE, TString(data.m_so_service));
        SetElementWOCheck(sets, FIELD_HAM, static_cast<i32>(data.m_ham));
        SetElementWOCheck(sets, FIELD_SPAM, static_cast<i32>(data.m_spam));
    }

    //*************************************************************************************************************
    //                                    TLongIPDataItemSerialization
    //*************************************************************************************************************

    void TLongIPDataItemSerialization::Deserialize(nosql::HashMap& hash, TLongIPDataItem& data) {
        TString soservice = "";
        i32 last_update = 0;
        i32 ham = 0;
        i32 spam = 0;
        i32 found = 0;

        soservice = hash[FIELD_LIP_SOSERVICE].String();
        AssignValue(last_update, hash[FIELD_LIP_LASTTIME].Long());
        AssignValue(ham, hash[FIELD_LIP_HAM].Long());
        AssignValue(spam, hash[FIELD_LIP_SPAM].Long());
        AssignValue(found, hash[FIELD_LIP_FOUND].Long());

        data.Clear();
        data.m_so_service = soservice;
        data.m_lasttime = static_cast<ui32>(last_update);
        data.m_ham = static_cast<ui32>(ham);
        data.m_spam = static_cast<ui32>(spam);
        data.m_found = static_cast<ui32>(found);
    }

    void TLongIPDataItemSerialization::Deserialize2(nosql::HashMap& incrs, nosql::HashMap& sets, TLongIPDataItem& data) {
        TString soservice = "";
        i32 last_update = 0;
        i32 ham = 0;
        i32 spam = 0;
        i32 found = 0;

        soservice = sets[FIELD_LIP_SOSERVICE].String();
        AssignValue(last_update, sets[FIELD_LIP_LASTTIME].Long());
        AssignValue(ham, incrs[FIELD_LIP_HAM].Long());
        AssignValue(spam, incrs[FIELD_LIP_SPAM].Long());
        AssignValue(found, incrs[FIELD_LIP_FOUND].Long());

        data.Clear();
        data.m_so_service = soservice;
        data.m_lasttime = static_cast<ui32>(last_update);
        data.m_ham = static_cast<ui32>(ham);
        data.m_spam = static_cast<ui32>(spam);
        data.m_found = static_cast<ui32>(found);
    }

    void TLongIPDataItemSerialization::Serialize(const TLongIPDataItem& data, nosql::HashMap& sets) {
        SetElementWOCheck(sets, FIELD_LIP_SOSERVICE, TString(data.m_so_service));
        SetElementWOCheck(sets, FIELD_LIP_LASTTIME, static_cast<i32>(data.m_lasttime));
        SetElementWOCheck(sets, FIELD_LIP_HAM, static_cast<i32>(data.m_ham));
        SetElementWOCheck(sets, FIELD_LIP_SPAM, static_cast<i32>(data.m_spam));
        SetElementWOCheck(sets, FIELD_LIP_FOUND, static_cast<i32>(data.m_found));
    }

} // namespace stordata
