#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <vector>
#include "ktypes.h"

namespace trcstat_chfrm {
    //*******************************************************************************************************************************************
    //                                        TTraccertResultStat
    //*******************************************************************************************************************************************

    struct TTrResStat {
        ui32 m_ham;
        ui32 m_spam;
        ui32 m_malic;
        ui32 m_empty;

        TTrResStat() {
            Clear();
        }

        void Clear() {
            m_ham = 0;
            m_spam = 0;
            m_malic = 0;
            m_empty = 0;
        }

        ui32 All() {
            ui32 res = 0;

            res = IncMax32(res, m_ham);
            res = IncMax32(res, m_spam);
            res = IncMax32(res, m_malic);
            res = IncMax32(res, m_empty);

            return res;
        }
    };

    struct TTrResStatTY {
        TTrResStat m_today;
        TTrResStat m_yesterday;

        TTrResStatTY() {
            m_today.Clear();
            m_yesterday.Clear();
        }

        void Midnight() {
            m_yesterday = m_today;
            m_today.Clear();
        }
    };

    class TTraccertResultStat {
    private:
        TTrResStatTY m_res_wo_ml;
        TTrResStatTY m_res_with_ml;
        TTrResStatTY m_res_final;

        TTrResStatTY m_res_hamtospambyml;
        TTrResStatTY m_res_malictospambyml;
        TTrResStatTY m_res_spamtohambyml;
        TTrResStatTY m_res_malictohambyml;

        TTrResStatTY m_res_hamtospam_final;
        TTrResStatTY m_res_hamtomalic_final;
        TTrResStatTY m_res_spamtoham_final;
        TTrResStatTY m_res_spamtomalic_final;
        TTrResStatTY m_res_malictoham_final;
        TTrResStatTY m_res_malictospam_final;

        TMutex m_Mutex;

    public:
        TTraccertResultStat();
        ~TTraccertResultStat();

        void Midnight();

        void AddStatusWoML(ui32 spam_weight);
        void AddStatusWithML(ui32 spam_weight);
        void AddStatusFinal(ui32 spam_weight);

        void AddStatusHamToSpamByML(ui32 spam_weight);
        void AddStatusMalicToSpamByML(ui32 spam_weight);
        void AddStatusSpamToHamByML(ui32 spam_weight);
        void AddStatusMalicToHamByML(ui32 spam_weight);

        void AddStatusHamToSpamFinal(ui32 spam_weight);
        void AddStatusHamToMalicFinal(ui32 spam_weight);
        void AddStatusSpamToHamFinal(ui32 spam_weight);
        void AddStatusSpamToMalicFinal(ui32 spam_weight);
        void AddStatusMalicToHamFinal(ui32 spam_weight);
        void AddStatusMalicToSpamFinal(ui32 spam_weight);

        TString GetWebStat();
    };

    //*******************************************************************************************************************************************

} // namespace trcstat_chfrm
