#include <mail/so/spamstop/tools/so-common/shtime.h>
#include "tupdatequeue.h"
#include "tstoragenosql.h"

namespace updqueue {
    //**************************************************************************************************************************
    //                                           TUpdateQueueMain
    //**************************************************************************************************************************

    TUpdateQueue::TUpdateQueue() {
        stornosqlobj = NULL;
        m_thread_count = 0;
        m_size_fast = 0;
    }

    TUpdateQueue::~TUpdateQueue() {
    }

    bool TUpdateQueue::Init(void* stornosqlobjA, ui32 thread_count, ui32 size_fast) {
        bool res = true;

        stornosqlobj = stornosqlobjA;
        m_thread_count = thread_count;
        m_size_fast = size_fast;

        return res;
    }

    void TUpdateQueue::Midnight() {
        m_Mutex.Acquire();

        fast_yesterday_stat = fast_today_stat;
        fast_today_stat.Clear();

        m_Mutex.Release();
    }

    bool TUpdateQueue::AddRecord(const stordata::TUpdateCacheStruct& value) {
        bool res = false;

        m_Mutex.Acquire();

        fast_current_stat.IncrementInputAll();
        fast_today_stat.IncrementInputAll();

        if (fast_list.size() < m_size_fast) {
            fast_list.push_back(value);

        } else {
            fast_current_stat.IncrementInputLost();
            fast_today_stat.IncrementInputLost();
        }

        m_Mutex.Release();

        return res;
    }

    void TUpdateQueue::ActionFunction(bool& needstop) {
        bool notfount = true;
        stordata::TUpdateCacheStruct rec;

        needstop = false;

        m_Mutex.Acquire();

        auto it = fast_list.begin();
        if (it != fast_list.end()) {
            notfount = false;
            rec = *it;
            fast_list.erase(it);
        }

        m_Mutex.Release();

        if (!notfount) {
            m_Mutex.Acquire();

            fast_current_stat.IncrementOutputAll();
            fast_today_stat.IncrementOutputAll();

            m_Mutex.Release();

            if (stornosqlobj != NULL) {
                bool res_err = false;
                TUpdateQueueRqstErr qer;

                qer.m_tick = CShingleTime::GetMs();
                ((TStorageNoSql*)stornosqlobj)->UpdateQueueAll(rec);
                qer.m_tick = CShingleTime::GetMs() - qer.m_tick;

                m_Mutex.Acquire();

                if (!res_err) {
                    fast_current_stat.IncrementRequestOK();
                    fast_today_stat.IncrementRequestOK();

                } else {
                    fast_current_stat.IncrementRequestErr();
                    fast_today_stat.IncrementRequestErr();
                }
                fast_current_stat.AddTime(qer.m_tick);
                fast_today_stat.AddTime(qer.m_tick);

                m_Mutex.Release();
            }

        } else {
            usleep(10000);
        }
    }

    TString TUpdateQueue::PrintWebStatistik() {
        TString res = "";
        qustat::TDriverRqstPoolStat stat;
        qustat::TDriverRqstPoolStat current_stat;
        qustat::TDriverRqstPoolStat today_stat;
        qustat::TDriverRqstPoolStat yesterday_stat;
        TString main_label = "";
        TString label = "";
        TString rowcolor = "";
        TString itemlabel = "";

        res += "<br><i><b>Statistik for update queue:</b></i>&nbsp;&nbsp;";
        res += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor='" + TString(color_table_default) + "'>";

        res += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'>";
        res += "<td width='20%' colspan='2'>&nbsp</td>";
        res += "<td width='20%' colspan='2'><b>OK</b></td>";
        res += "<td width='10%'><b>ERROR</b></td>";
        res += "<td width='20%' colspan='2'><b>INPUT ALL</b></td>";
        res += "<td width='10%'><b>INPUT LOST</b></td>";
        res += "<td width='10%'><b>COUNT</b></td>";
        res += "<td width='10%'><b>OUTPUT ALL</b></td>";
        res += "</tr>";

        for (size_t i = 0; i < 3; i++) {
            current_stat = fast_current_stat;
            today_stat = fast_today_stat;
            yesterday_stat = fast_yesterday_stat;
            itemlabel = "PUTQUEUE";

            switch (i) {
                case 0:
                    label = "CURRENT";
                    stat = current_stat;
                    rowcolor = TString(color_table_default);
                    break;
                case 1:
                    label = "TODAY";
                    stat = today_stat;
                    rowcolor = TString(color_table_today);
                    break;
                case 2:
                    label = "YESTERDAY";
                    stat = yesterday_stat;
                    rowcolor = TString(color_table_yesterday);
                    break;
            };

            res += "<tr align='center' bgcolor='" + rowcolor + "'>";
            res += "<td width='10%'>" + label + "</td>";
            res += "<td>" + itemlabel + "</td>";
            res += "<td colspan='2'>" + stat.GetRequestOK_s() + "</td>";
            res += "<td>" + stat.GetRequestErr_s() + "</td>";
            res += "<td colspan='2'>" + stat.GetInputAll_s() + "</td>";
            res += "<td>" + stat.GetInputLost_s() + "</td>";
            res += "<td>" + stat.GetCount_s() + "</td>";
            res += "<td>" + stat.GetOutputAll_s() + "</td>";
            res += "</tr>";
        }

        res += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'>";
        res += "<td width='20%' colspan='2'>&nbsp</td>";
        res += "<td width='10%'><b>0..10</b></td>";
        res += "<td width='10%'><b>10..20</b></td>";
        res += "<td width='10%'><b>20..50</b></td>";
        res += "<td width='10%'><b>50..100</b></td>";
        res += "<td width='10%'><b>100..150</b></td>";
        res += "<td width='10%'><b>150..190</b></td>";
        res += "<td width='10%'><b>190..500</b></td>";
        res += "<td width='10%'><b>more 500</b></td>";
        res += "</tr>";

        for (size_t i = 0; i < 3; i++) {
            current_stat = fast_current_stat;
            today_stat = fast_today_stat;
            yesterday_stat = fast_yesterday_stat;
            itemlabel = "PUTQUEUE";

            switch (i) {
                case 0:
                    label = "CURRENT";
                    stat = current_stat;
                    rowcolor = TString(color_table_default);
                    break;
                case 1:
                    label = "TODAY";
                    stat = today_stat;
                    rowcolor = TString(color_table_today);
                    break;
                case 2:
                    label = "YESTERDAY";
                    stat = yesterday_stat;
                    rowcolor = TString(color_table_yesterday);
                    break;
            };

            res += "<tr align='center' bgcolor='" + rowcolor + "'>";
            res += "<td width='10%'>" + label + "</td>";
            res += "<td>" + itemlabel + "</td>";
            res += "<td>" + stat.GetCount_0_10_s() + "</td>";
            res += "<td>" + stat.GetCount_10_20_s() + "</td>";
            res += "<td>" + stat.GetCount_20_50_s() + "</td>";
            res += "<td>" + stat.GetCount_50_100_s() + "</td>";
            res += "<td>" + stat.GetCount_100_150_s() + "</td>";
            res += "<td>" + stat.GetCount_150_190_s() + "</td>";
            res += "<td>" + stat.GetCount_190_500_s() + "</td>";
            res += "<td>" + stat.GetCount_MORE500_s() + "</td>";
            res += "</tr>";
        }

        res += "</table>";
        res += "<br>";

        return res;
    }

    TString TUpdateQueue::GetMonStatistik() {
        TString res = "";

        qustat::TDriverRqstPoolStat fast_stat;

        m_Mutex.Acquire();

        fast_stat = fast_current_stat;
        fast_current_stat.Clear();

        m_Mutex.Release();

        res += "<PUTQ: " + fast_stat.GetMonStat() + ">";

        return res;
    }

    qustat::TDriverRqstPoolStatFour TUpdateQueue::GetConsoleStat() {
        qustat::TDriverRqstPoolStatFour res;

        res.m_today_fastput = fast_today_stat;
        res.m_yesterday_fastput = fast_yesterday_stat;

        return res;
    }

    TString TUpdateQueue::GetProperties() {
        TString res = "";

        res += "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
        res += "<tr align='left'><td width='50%'>Enable</td><td>yes</td></tr>";
        res += "<tr align='left'><td>Thread count</td><td>" + IntToStroka(m_thread_count) + "</td></tr>";
        res += "<tr align='left'><td>Queue size  </td><td>" + IntToStroka(m_size_fast) + "</td></tr>";
        res += "</table>";

        return res;
    }

    //***************************************************************************************************************************
    //                                                 TUpdateQueueMain
    //***************************************************************************************************************************

    void UPQThreadProc(void* par) {
        TUpdateQueueMain* ss = (TUpdateQueueMain*)par;

        if (ss != NULL) {
            while (!ss->QueueThreadShouldStop()) {
                ss->ActionFunction();
            }

            ss->DecrementNumberThread();
        }
    }

    TUpdateQueueMain::TUpdateQueueMain() {
        dr_obj = new TUpdateQueue();

        for (size_t i = 0; i < MAX_THREAD_WORK; i++)
            m_QueueThread[i] = NULL;
        use_threadcount = 0;
        run_scan_thread = false;
        m_StopQueueThread = false;
        m_thread_count = 1;
    }

    TUpdateQueueMain::~TUpdateQueueMain() {
        if (run_scan_thread) {
            StopQueueThread();
            while (!QueueThreadStopped())
                usleep(5000);

            for (size_t i = 0; i < MAX_THREAD_WORK; i++) {
                if (m_QueueThread[i] != NULL) {
                    delete m_QueueThread[i];
                    m_QueueThread[i] = NULL;
                }
            }
        }

        if (dr_obj != NULL) {
            delete dr_obj;
            dr_obj = NULL;
        }
    }

    bool TUpdateQueueMain::InitBase(ui32 thread_count) {
        bool res = true;

        m_thread_count = thread_count;
        if (m_thread_count < 1)
            m_thread_count = 1;
        if (m_thread_count >= MAX_THREAD_WORK)
            m_thread_count = MAX_THREAD_WORK;

        StartQueueThread();

        return res;
    }

    bool TUpdateQueueMain::Init(void* stornosqlobjA, TKConfig* configobjA) {
        bool res = false;
        ui32 thread_count = DEFAULT_THREAD_WORK;
        ui32 size_fast = DEFAULT_QUEUE_SIZE;

        if (dr_obj != NULL) {
            if (configobjA != NULL) {
                thread_count = configobjA->ReadInteger("update_queue", "thread_count", DEFAULT_THREAD_WORK);
                size_fast = configobjA->ReadInteger("update_queue", "size", DEFAULT_QUEUE_SIZE);
            }

            if (size_fast == 0)
                size_fast = 10000;
            if (size_fast > 5000000)
                size_fast = 5000000;

            if (dr_obj->Init(stornosqlobjA, thread_count, size_fast))
                res = InitBase(thread_count);
        }

        return res;
    }

    void TUpdateQueueMain::Midnight() {
        if (dr_obj != NULL)
            dr_obj->Midnight();
    }

    void TUpdateQueueMain::StartQueueThread() {
        m_QueueMutex.Acquire();

        m_StopQueueThread = false;

        for (size_t i = 0; i < m_thread_count; i++) {
            m_QueueThread[i] = new TThread((TThread::TThreadProc)&UPQThreadProc, this);
            m_QueueThread[i]->Start();
        }
        run_scan_thread = true;

        m_QueueMutex.Release();
    }

    int TUpdateQueueMain::IncrementNumberThread() {
        int res = 0;

        m_QueueMutex.Acquire();

        use_threadcount++;
        res = use_threadcount;

        m_QueueMutex.Release();

        return res;
    }

    void TUpdateQueueMain::DecrementNumberThread() {
        m_QueueMutex.Acquire();

        if (use_threadcount > 0)
            use_threadcount--;

        m_QueueMutex.Release();
    }

    void TUpdateQueueMain::StopQueueThread() {
        m_QueueMutex.Acquire();
        m_StopQueueThread = true;
        m_QueueMutex.Release();
    }

    bool TUpdateQueueMain::QueueThreadStopped() {
        bool res = false;

        if (use_threadcount == 0)
            res = true;

        return res;
    }

    void TUpdateQueueMain::ActionFunction() {
        bool needstop = false;

        if (dr_obj != NULL)
            dr_obj->ActionFunction(needstop);
        if (needstop)
            StopQueueThread();
    }

    bool TUpdateQueueMain::AddRecord(const stordata::TUpdateCacheStruct& value) {
        bool res = false;

        if (dr_obj != NULL)
            res = dr_obj->AddRecord(value);

        return res;
    }

    TString TUpdateQueueMain::PrintWebStatistik() {
        TString res = "";

        if (dr_obj != NULL)
            res = dr_obj->PrintWebStatistik();

        return res;
    }

    TString TUpdateQueueMain::GetMonStatistik() {
        TString res = "";

        if (dr_obj != NULL)
            res = dr_obj->GetMonStatistik();

        return res;
    }

    qustat::TDriverRqstPoolStatFour TUpdateQueueMain::GetConsoleStat() {
        qustat::TDriverRqstPoolStatFour res;

        if (dr_obj != NULL)
            res = dr_obj->GetConsoleStat();

        return res;
    }

    TString TUpdateQueueMain::GetProperties() {
        TString res = "";

        if (dr_obj != NULL)
            res = dr_obj->GetProperties();

        return res;
    }

    //***************************************************************************************************************************

} // namespace updqueue
