#pragma once

#include <sys/stat.h>
#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/system/thread.h"
#include "util/thread/factory.h"
#include <library/cpp/cgiparam/cgiparam.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include "kqueuestat.h"
#include <list>
#include "tstorebase_data.h"

namespace updqueue {

    //**************************************************************************************************************************
    //                                           TUpdateQueueRqstErr
    //**************************************************************************************************************************

    struct TUpdateQueueRqstErr {
        ui32 m_tick;

        TUpdateQueueRqstErr() {
            Clear();
        }

        void Clear() {
            m_tick = 0;
        }
    };

    //**************************************************************************************************************************
    //                                           TUpdateQueueMain
    //**************************************************************************************************************************

    class TUpdateQueue {
    private:
        void* stornosqlobj;
        ui32 m_thread_count;
        ui32 m_size_fast;
        TMutex m_Mutex;

        std::list<stordata::TUpdateCacheStruct> fast_list;
        qustat::TDriverRqstPoolStat fast_current_stat;
        qustat::TDriverRqstPoolStat fast_today_stat;
        qustat::TDriverRqstPoolStat fast_yesterday_stat;

    public:
        TUpdateQueue();
        ~TUpdateQueue();

        bool Init(void* stornosqlobjA, ui32 thread_count, ui32 size_fast);
        void Midnight();

        void ActionFunction(bool& needstop);
        bool AddRecord(const stordata::TUpdateCacheStruct& value);

        TString PrintWebStatistik();
        TString GetMonStatistik();

        qustat::TDriverRqstPoolStatFour GetConsoleStat();

        TString GetProperties();
    };

    //***************************************************************************************************************************
    //                                                 TUpdateQueueMain
    //***************************************************************************************************************************

    class TUpdateQueueMain {
    public:
        static const ui32 MAX_THREAD_WORK = 64;
        static const ui32 DEFAULT_THREAD_WORK = 32;
        static const ui32 DEFAULT_QUEUE_SIZE = 10000;

    private:
        TUpdateQueue* dr_obj;

        TThread* m_QueueThread[MAX_THREAD_WORK];
        TMutex m_QueueMutex;
        bool m_StopQueueThread;
        bool run_scan_thread;
        ui32 m_thread_count;

        int use_threadcount;
        void StartQueueThread();
        bool QueueThreadStopped();

    public:
        ui32 GetThreadCount() {
            return m_thread_count;
        }
        void StopQueueThread();
        int IncrementNumberThread();
        void DecrementNumberThread();
        bool QueueThreadShouldStop() {
            return m_StopQueueThread;
        }
        void ActionFunction();
        bool InitBase(ui32 thread_count);

    public:
        TUpdateQueueMain();
        ~TUpdateQueueMain();

        bool Init(void* stornosqlobjA, TKConfig* configobjA);
        void Midnight();

        bool AddRecord(const stordata::TUpdateCacheStruct& value);

        TString PrintWebStatistik();
        TString GetMonStatistik();
        qustat::TDriverRqstPoolStatFour GetConsoleStat();

        TString GetProperties();
    };

} // namespace updqueue

//***************************************************************************************************************************
