#pragma once

// Common

#include <library/cpp/charset/recyr.hh>

#include <util/system/tempfile.h>
#include <util/system/maxlen.h>
#include <util/generic/utility.h>
#include <util/system/defaults.h>
#include <util/system/compat.h>
#include <util/generic/string.h>
#include <util/generic/hash.h>

#include <stdlib.h>
#include <iostream>
#include <list>

#ifdef WIN32
#include <io.h>
#include <sys/stat.h>
#else
#include <unistd.h>
#include <dirent.h>
#endif

#include <sys/types.h>
#include <fcntl.h>

typedef enum { SO_LOG_MESSAGE,
               SO_LOG_WARNING,
               SO_LOG_ERROR } TLogLevel;
typedef TVector<TString> TReqValues;
typedef THashMap<TString, TReqValues> TReqParams;
typedef std::list<TString> TRulesList;

struct TReqItem {
    ui64 shingle;
    ui16 type;

    TReqItem() {
        clear();
    }
    TReqItem(ui64 shingleA, ui16 typeA) {
        shingle = shingleA;
        type = typeA;
    }
    void clear() {
        Zero(*this);
    }
};

typedef std::list<TReqItem> TReqItemList;
typedef TReqItemList::iterator TReqItemListIt;

struct TReqItemExt {
    ui64 shingle;
    ui16 type;
    ui16 dop1;
    ui16 dop2;
    ui16 dop3;

    TReqItemExt() {
        clear();
    }
    TReqItemExt(ui64 shingleA, ui16 typeA, ui16 dop1A, ui16 dop2A, ui16 dop3A) {
        shingle = shingleA;
        type = typeA;
        dop1 = dop1A;
        dop2 = dop2A;
        dop3 = dop3A;
    }
    void clear() {
        Zero(*this);
    }
};

typedef std::list<TReqItemExt> TReqItemListExt;
typedef TReqItemListExt::iterator TReqItemListExtIt;

struct TMakeRqstDelays {
    ui32 m_fulltick;
    ui32 m_gstdin;      //tick read data from socket
    ui32 m_fillheaders; //tick set environment FCGI and other headers
    ui32 m_reply;
    ui32 m_parse_getpost;          //tick parsing requests GET, POST by params
    ui32 m_write_rqst_to_inputlog; //tick write in inputlog
    TString m_remote_ip;
    TString m_request_id;
    TString m_out_messid;
    TString m_dop_traccert;

    TMakeRqstDelays() {
        Clear();
    }

    void Clear() {
        m_fulltick = 0;
        m_gstdin = 0;
        m_fillheaders = 0;
        m_reply = 0;
        m_parse_getpost = 0;
        m_write_rqst_to_inputlog = 0;
        m_remote_ip = "";
        m_request_id = "";
        m_out_messid = "";
        m_dop_traccert = "";
    }

    TString GetServiceTicks() {
        char buff[64];

        buff[0] = 0x00;
        buff[sizeof(buff) - 1] = 0x00;
        snprintf(buff, sizeof(buff) - 1, "%u-%u-%u-%u-%u", m_gstdin, m_fillheaders, m_reply, m_parse_getpost, m_write_rqst_to_inputlog);

        return TString(buff);
    }
};
