#pragma once

#include <contrib/libs/fcgi/fcgio.h>
#include <contrib/libs/fcgi/fcgi_config.h>

#include <library/cpp/deprecated/atomic/atomic.h>

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <util/generic/vector.h>

#include <mail/so/spamstop/tools/so-common/shconn.h>

#include <vector>

#include "tmakerequestbase.h"
#include "tserviceobjectbase.h"


#ifndef _win_
#include <pthread.h>
#include <poll.h>

#define POLL_RD_FLAGS (POLLIN | POLLPRI)
#define POLL_WR_FLAGS (POLLOUT)
#define MS(timeout) (((timeout)->tv_sec * 1000) + (timeout)->tv_usec)

#define FD_RD_VAR(rds) struct pollfd rds

#define FD_IS_RD_EXC(sd, rds) \
    (((rds).revents & (POLLER | POLLHUP | POLLNVAL)) != 0)

#include <sys/types.h>
#include <sys/syscall.h>
#include <fcntl.h>
#include <unistd.h>
#include <util/system/thread.h>
#include <mail/so/spamstop/tools/so-common/shtime.h>

#endif

//**********************************************************************************
//                               TKBridge
//**********************************************************************************

class TKBridge {
private:
    // Constants
    typedef enum { DAY,
                   HOUR,
                   MINUTE } MIDNIGHT_TIME;

private:
    TAtomic m_StreamCount;
    TAtomic m_ExitStream;
    TServiceObjectBase* m_srvcobj = nullptr;
    void* m_server = nullptr;
    int m_pid;

    // Midnight
    char m_MidnightTimeStr[CShingleTime::MAX_TIME_SIZE]{};
    i16 m_MidnightTime[3];
    bool SetMidnightTime();

    // Sheduler
    ui16 m_SleepTime;
    TThread* m_Sheduler = nullptr;
    TAtomic m_StopSheduler;
    bool ShedulerStopped();
    void StopSheduler();
    TAtomic m_stop;

    // ShedulerHeavy
    TThread* m_ShedulerHeavy = nullptr;
    TAtomic m_StopShedulerHeavy;
    bool ShedulerHeavyStopped();
    void StopShedulerHeavy();
    bool m_stop_heavy;
    TAtomic m_midnight_heavy;

public:
    TKBridge();
    ~TKBridge();

    bool Init(ui32 queuesize, TServiceObjectBase* srvcobjA, void* server);
    ui32 IncrementStreamCount();
    void DecrementStreamCount();
    ui32 GetStreamCount();
    void SetStartStream();
    void SetExitStream();
    bool GetExitStream();
    TServiceObjectBase* GetSrvcObj() {
        return m_srvcobj;
    }
    void* GetFastServerLink() {
        return m_server;
    }

    bool IsStop() {
        return m_stop;
    }
    bool ShedulerShouldStop() {
        return m_StopSheduler;
    }
    void ShedulerStopped(bool Stopped);

    bool IsStopHeavy() {
        return m_stop_heavy;
    }
    bool ShedulerHeavyShouldStop() {
        return m_StopShedulerHeavy;
    }
    void ShedulerHeavyStopped(bool Stopped);

    void Sleep();
    void Close();
    void Shutdown();
    bool WritePid();
    void WriteToLog(const TLogStatus LogLevel, const char* msg, ...);

    void CheckMidnight();
    void EventTick();
    void EventTickHeavy();
    void CheckMidnightHeavy();
    void StartSheduler();
    void StartShedulerHeavy();
    void WriteThreadIDToLog();
    void WriteThreadIDHeavyToLog();
};

//**********************************************************************************
//                              TKThread
//**********************************************************************************

class TKThread {
private:
    TThread* m_thread = nullptr;
    TKBridge* m_bridge = nullptr;
    int m_thread_number;
    ui64 m_ThreadHandle;

public:
    TKThread(TKBridge* bridge, int thread_number);
    ~TKThread();

    void Start();
    void SetThreadHandle(); //not thread safe!!!
    int ThreadNumber() {
        return m_thread_number;
    }
    TKBridge* Bridge() {
        return m_bridge;
    }
    ui64 ThreadHandle() {
        return m_ThreadHandle;
    }
};

//**********************************************************************************
//                              TStreamPool
//**********************************************************************************

typedef std::vector<TKThread*> TStreamPoolC;
typedef TStreamPoolC::iterator TStreamPoolCIt;

class TStreamPool {
private:
    int count;
    TKBridge* bridge = nullptr;
    TStreamPoolC Pool;

public:
    TStreamPool();
    ~TStreamPool();

    void Init(int countA, TKBridge* bridgeA);
    void Close();
    void Wait();
    void SendSIGUSR1();
    ui32 ThreadAMount();
};

//**********************************************************************************
//                               TFCGIServerBase
//**********************************************************************************

long gstdin(FCGX_Request* request, TVector<char>& content);
void FillHeaderHash(FCGX_Request* request, TWStrokaHash& header_hash);

class TFCGIServerBase {
public:
    static const int LISTEN_QUEUE_BACK_LOG_DEFAULT = 128;
    static const unsigned long STDIN_MAX = 5000000;

private:
    TString m_port;
    int m_listenQueueBacklog = 0;
    ui32 m_streamcount = 0;
    ui32 m_queuesize = 0;
    int m_listen_socket = -1;
    TServiceObjectBase& ServiceObject;
    TKBridge bridge;
    TStreamPool* pool = nullptr;
#ifndef _win_
    pthread_t main_thread_id = 0;
#endif

    void WriteToLog(const TLogStatus LogLevel, const char* msg, ...);

public:
    TFCGIServerBase(TServiceObjectBase& ServiceObjectA) : ServiceObject(ServiceObjectA) {};
    virtual ~TFCGIServerBase();

    bool InitBeforeFork();
    bool InitAfterFork();
    void StartFCGIServerThreads();
    void Wait();
    bool GetRequest(int& err, TKBridge* bridge, int potok_number, FCGX_Request& request);
    void Close();
    bool WritePid();
    void SendSIGUSR1();
    void Shutdown();
    TServiceObjectBase& GetServiceObject() {
        return ServiceObject;
    }
    virtual TMakeRequestBase* CreateMakeRequest() = 0;
    virtual void DeleteMakeRequest(TMakeRequestBase** mrp) = 0;
    void WriteThreadIDToLog(int thread_index);
    void InitRequest(FCGX_Request& request) const;
};

//***********************************************************************************
