#pragma once

#include "tmakerequestbase.h"

#include <util/generic/string.h>
#include <util/generic/yexception.h>
#include <util/generic/deque.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/thread/pool.h>

#include <library/cpp/logger/log.h>

struct FCGX_Request;
namespace NFCGI {
    class Error: public yexception {
    public:
        Error(int code)
            : code(code)
        {
        }

    private:
        int code;
    };

    struct TSettings {
        size_t listenThreads = 16;
        size_t processThreads = 64;
        size_t backLog = 128;
        size_t processQueueSize = 16;

        TSettings() { }

        TSettings(size_t listenThreads, size_t processThreads, size_t backLog, size_t processQueueSize)
            : listenThreads(listenThreads)
            , processThreads(processThreads)
            , backLog(backLog)
            , processQueueSize(processQueueSize)
        {
        }
    };

    /**
 * FCGI server version with separated producers and consumers of packets
 */
    class TServer : IThreadFactory::IThreadAble {
    public:
        virtual void Handle(FCGX_Request& request) noexcept = 0;
        void Listen(const TString& url);
        void Stop();
        void SetLogger(TAutoPtr<TLogBackend> back);

        TServer(const TSettings& settings);
        virtual ~TServer();

    private:
        bool Accept(FCGX_Request& request);
        virtual void DoExecute();

    protected:
        TLog logger;

    private:
        const TSettings settings;
        TAtomic stop;
        TDeque<TAutoPtr<IThreadFactory::IThread>> threads;
        int socket;
        TSimpleThreadPool processQueue;
    };

} //namespace NFCGI
