#pragma once

#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>
#include "sotypes.h"

class TGeneralServiceObject {
private:
    TString m_hostname;
    TString m_code;
    TString m_start_time;

public:
    TString m_server_version;

public:
    TGeneralServiceObject();
    virtual ~TGeneralServiceObject();

    virtual bool InitBeforeFork(const TString& server_id, TLogsGroupBase* LogsGroupA, TKConfig* configA) = 0; //������������� ����� ����������� fork()
    virtual bool InitAfterFork() = 0;                                                                         //������������� ����� ���������� fork()

    virtual bool Midnight() = 0;  //�������
    virtual bool Shutdown() = 0;  //�������� ������� �� ���������� �������
    virtual void EventTick() = 0; //������ 5 ��� ����������� ��� �������

    //!!!ADD NEW FUNCTIONS!!!
    void EventTickHeavy(){}; //������ 5 ��� ����������� ��� ������� (��� ������� ��������)
    bool MidnightHeavy() {
        return false;
    } //������� ��� "��������" ���������� ������ (���������������� � �������� ��������� �������)

    virtual bool Close() = 0; //����������� ���������� (������� ����������� ����� ��������� shutdown)

    void SetHostNameAndCode(const TString& hostname, const TString& code, const TString& server_start_time, const TString& server_version);
    TString GetServerHostName() {
        return m_hostname;
    }
    TString GetServerCode() {
        return m_code;
    }
    TString GetServerStartTime() {
        return m_start_time;
    }
    TString GetServerVersion() {
            return m_server_version;
    }

    virtual void AddINTick(const TMakeRqstDelays &) {}
};
