#include <util/generic/string.h>
#include <mail/so/spamstop/tools/so-common/sobase64.h>
#include <library/cpp/string_utils/base64/base64.h>
#include <library/cpp/http/server/response.h>
#include <library/cpp/unistat/unistat.h>
#include <util/string/builder.h>
#include <util/string/ascii.h>

#include "tmakerequestbase.h"
#include "tfcgiserverbase.h"

class TFCGXStream : public IOutputStream {
public:
    void DoWrite(const void* buf, size_t len) override {
        FCGX_PutStr(static_cast<const char*>(buf), len, stream);
    }

    explicit TFCGXStream(FCGX_Stream* stream)
        : stream(stream) {
    }

private:
    FCGX_Stream* stream;
};

TMakeRequestBase::TMakeRequestBase(TServiceObjectBase& srvcobjA, void* serverA)
    : srvcobj(srvcobjA) {
    server = serverA;

    work_delays = NULL;
    m_BeginProcTime = 0;
    ServerLog = NULL;
    InputLog = NULL;
    NumberRequest = NULL;
    LogsGroup = NULL;
    m_remote_ip = "";
    m_cookie = "";
    m_remote_server_id = "";
    m_servername = "";
    m_StartTime = "";
    m_StartTimeTick = 0;
    m_dob_command = "";
    all_headers = "";
    m_last_request = "";
    m_rqstsrc = "";

    if ((srvcobj.GetLogsGroup() != NULL)) {
        ServerLog = srvcobj.GetLogsGroup()->GetServerLog();
        InputLog = srvcobj.GetLogsGroup()->GetInputLog();
    }
    LogsGroup = srvcobj.GetLogsGroup();
    NumberRequest = srvcobj.GetNumberRequest();
    if (NumberRequest != NULL)
        m_server_ident = NumberRequest->GetSummCode();

    if (srvcobj.GetConfigObject() != NULL) {
        m_dob_command = srvcobj.GetConfigObject()->ReadStroka("server", "dob_command", "");
    }

    m_servername = srvcobj.GetServerName();
    m_StartTime = srvcobj.GetStartTime();
    m_StartTimeTick = srvcobj.GetStartTimeTick();
    AllowList.push_back("ping");
    AllowList.push_back("unistat");
}

TString TMakeRequestBase::GetCommand(char* Command, TString& request_str) {
    TString res = "";
    const char* brequestall = NULL;
    const char* brequest = NULL;
    const char* p = NULL;
    const char* p1 = NULL;
    const char* p2 = NULL;
    ui32 commandsize = 0;

    brequestall = request_str.c_str();
    if (brequestall != NULL) {
        brequest = strstr(brequestall, "/");
        if (brequest != NULL) {
            brequest += 1;

            if (brequest != NULL) {
                p1 = strstr(brequest, "HTTP/");
                p2 = strstr(brequest, "?");
                if ((p1 != NULL) && (p2 == NULL))
                    p = p1;
                else if ((p1 == NULL) && (p2 != NULL))
                    p = p2;
                else if ((p1 != NULL) && (p2 != NULL))
                    p = p1 > p2 ? p2 : p1;
                if (p != NULL) {
                    commandsize = p - brequest;
                    if (commandsize > MAXCOMMANDSIZE)
                        commandsize = MAXCOMMANDSIZE;
                    if (commandsize > 0) {
                        memcpy(Command, brequest, commandsize);
                        Command[commandsize] = 0;
                        res = TString(Command);
                    }
                }
            }
        }
    }

    return res;
}

TString TMakeRequestBase::GetCommand2(char* Command, TString& request_str) {
    TString res = "";
    const char* brequestall = NULL;
    const char* brequest = NULL;
    //   const char   *p           = NULL;
    const char* p1 = NULL;
    const char* p2 = NULL;
    ui32 commandsize = 0;
    ui32 commandsize2 = 0;
    //TString       identaction  = "action=";
    TString identaction = TString(INTERFACEACTION) + "=";
    const char* p3 = NULL;
    const char* p4 = NULL;
    const char* p5 = NULL;

    brequestall = request_str.c_str();
    if (brequestall != NULL) {
        brequest = strstr(brequestall, "/");
        if (brequest != NULL) {
            brequest += 1;

            if (brequest != NULL) {
                p1 = strstr(brequest, "HTTP/");
                p5 = p1;
                p2 = strstr(brequest, "?");
                if ((p1 != NULL) && (p2 != NULL)) {
                    commandsize = p1 - p2;
                    if (commandsize > MAXCOMMANDSIZE) {
                        commandsize = MAXCOMMANDSIZE;
                        p1 = p2 + commandsize;
                    }
                    if (commandsize <= MAXCOMMANDSIZE) {
                        p3 = strstr(p2, identaction.c_str());
                        if (p3 != NULL) {
                            p4 = strchr(p3, '&');
                            if (p4 == NULL)
                                p4 = p5;
                            commandsize2 = p4 - p3 - identaction.length();
                            if (commandsize2 > 0)
                                res = Trim(TString(p3 + identaction.length(), commandsize2));
                        }
                    }
                }
            }
        }
    }

    if (!res.empty()) {
        size_t symbcount = res.length();
        if (symbcount >= MAXCOMMANDSIZE)
            symbcount = MAXCOMMANDSIZE - 1;

        strncpy(Command, res.c_str(), symbcount);
        Command[symbcount] = 0x00;
    }

    return res;
}

TString TMakeRequestBase::GetValueCheck(TReqParams::iterator& it) {
    TString res = "";

    if (it->second[0].length() > 100)
        res = it->second[0].substr(0, 100);
    else
        res = it->second[0];

    return res;
}

TString TMakeRequestBase::TransformRequest(const TString& request) {
    TString res = request;
    const char* p1 = NULL;
    const char* p2 = NULL;
    const char* p3 = NULL;
    const char* p4 = NULL;
    TString action = "";
    int count = 0;
    //TString      action_ident1  = "?action=";
    //TString      action_ident2  = "&action=";
    TString action_ident1 = "?" + TString(INTERFACEACTION) + "=";
    TString action_ident2 = "&a" + TString(INTERFACEACTION) + "=";
    const char* p_action1 = NULL;
    const char* p_action2 = NULL;
    TString prefix = "";

    p1 = strchr(request.c_str(), '?');
    if (p1 != NULL) {
        p3 = strchr(p1 + 1, '&');
        p4 = strchr(p1 + 1, '=');
        p2 = strchr(p1 + 1, '?');
        if ((p2 != NULL) && (p3 != NULL) && (p2 > p3)) //'?' must be the first character '&'
            p2 = NULL;
        if ((p2 != NULL) && (p4 != NULL) && (p2 > p4)) //'?' must be the first character '='
            p2 = NULL;
        if (p2 != NULL) {
            count = p2 - p1 - 1;
            if (count > 0) {
                action = TString(p1 + 1, count);
                //res = "/?action=" + action + "&" + TString(p2 + 1);
                res = "/?" + TString(INTERFACEACTION) + "=" + action + "&" + TString(p2 + 1);
            }
        } else {
            p_action1 = strstr(request.c_str(), action_ident1.c_str());
            p_action2 = strstr(request.c_str(), action_ident2.c_str());
            if ((p1 > request.c_str()) && (p_action1 == NULL) && (p_action2 == NULL)) {
                prefix = TString(request.c_str(), p1 - request.c_str());
                if ((prefix.size() > 1) && ((prefix[0] == '/') || (prefix[0] == '\\')))
                    prefix = TString(prefix.c_str() + 1);
                if ((prefix == "check") || (prefix == "console") || (prefix == "info") || (prefix == "ping"))
                    //res = "/?action=" + prefix + "&" + TString(p1 + 1);
                    res = "/?" + TString(INTERFACEACTION) + "=" + prefix + "&" + TString(p1 + 1);
            }
        }
    }

    return res;
}

TString DelDigitFromRqst(const TString& request) {
    TString res = request;
    char symb = 0;

    if (request.length() > 1) {
        symb = request[request.length() - 1];
        if ((symb >= '0') && (symb <= '9'))
            res = request.substr(0, request.length() - 1);
    }

    return res;
}

ui64 TMakeRequestBase::CalcSumm(const char* buff) {
    ui64 res = 0;
    int len = 0;
    unsigned char uc = 0;

    len = strlen(buff);
    if (len > 0) {
        for (int i = 0; i < len; i++) {
            memcpy(&uc, buff + i, sizeof(uc));
            res = IncMax64(res, uc);
        }
    }

    return res;
}

TString TMakeRequestBase::ModNumbrequest(const TReqParams& paramlist, const TString& Numbrequest) {
    TString res = "";
    TReqParams::const_iterator it;
    bool is_proxy = false;
    ui64 all_summ = 0;
    TString server_id = "";
    TString local_id = "";

    it = paramlist.begin();
    while (it != paramlist.end()) {
        if (!it->second.empty()) {
            if ((*it).first == "proxyvalue") {
                if ((*it).second[0] == "1")
                    is_proxy = true;

            } else {
                all_summ = IncMax64(all_summ, CalcSumm((*it).first.c_str()));
                all_summ = IncMax64(all_summ, CalcSumm((*it).second[0].c_str()));
            }
        }

        ++it;
    }

    server_id = TString(Numbrequest.c_str() + 2, 4);
    local_id = TString(Numbrequest.c_str() + 7);
    if (!is_proxy)
        res = "##*-" + server_id + "-" + ShingleToStroka8(all_summ) + "-" + local_id;
    else
        res = "##P-" + server_id + "-" + ShingleToStroka8(all_summ) + "-" + local_id;

    return res;
}

TString TMakeRequestBase::HTTP_200_OK_UNISTAT() const {
    TStringStream s;
    {
        THttpResponse(HTTP_OK).SetContent(TUnistat::Instance().CreateJsonDump(0, false), "application/json").OutTo(s);
    }
    return std::move(s.Str());
}

void TMakeRequestBase::CheckContentType(const TString& contenttypeA, const TString& content_length, TRequestDopData& ardataA) {
    if (strstr(contenttypeA.c_str(), "application/x-lzop") != NULL) {
        ardataA.content_type = TADT_APPLXLZOP;

    } else if (strstr(contenttypeA.c_str(), "text/plain") != NULL) {
        ardataA.content_type = TADT_TEXTPLAIN;

    } else {
        ardataA.content_type = TADT_UNKNOWN;
    }
    if (!content_length.empty())
        ardataA.content_length = atoi(content_length.c_str());
}

void TMakeRequestBase::SetBuffers(char* BUFF, int BUFFSize, TRequestDopData& ardataA) {
    ardataA.BUFF = BUFF;
    ardataA.BUFFSize = BUFFSize;
}

bool TMakeRequestBase::Reply(void* outA, TWStrokaHash* headers, char* dataA, ui32 datasizeA, int thread_index, TMakeRqstDelays* work_delaysA) {
    bool res = false;
    bool notfound_admin = false, notfounf_auser = false, notfound_user = false, notfound_other = false;
    int ok = false;
    TString firststr = "";

    //   bool           allow           = false;
    TString ip_s = "";
    TString requestmethod_s = "";
    TWStrokaHashIt it;
    TString reqmethod = "";
    TString servprotokol = "";
    TString requrl = "";

    TString s = "";
    TString autorizs = "";
    TString cnttype = "";
    TString cntlength = "";
    TString request_source = "";
    TString request = "";
    TString ltcommand = "";
    TString ltcommand2 = "";
    TString ltcommand_change = "";
    bool allowcommand = false;
    TString server_ident = "";
    TString out_request_ident = "-";
    TString out_messid = "-";
    TRequestDopData ardata;

    work_delays = work_delaysA;

    if (NumberRequest != NULL)
        NumbRequest = NumberRequest->GetNumberS(false);

    ardata.Clear();

    m_remote_ip = "???";
    m_rqstsrc = "";
    out = outA;
    if ((out != NULL) && (headers != NULL)) {
        m_Request = m_RequestA;
        memset(m_RequestA, 0, sizeof(m_RequestA));
        m_BeginProcTime = CShingleTime::GetMs();

        it = headers->find("REMOTE_ADDR");
        if (it != headers->end()) {
            m_remote_ip = (*it).second;
            if (work_delays != NULL)
                work_delays->m_remote_ip = m_remote_ip;
        }

        it = headers->find("REQUEST_METHOD");
        if (it != headers->end())
            reqmethod = (*it).second;

        it = headers->find("SERVER_PROTOCOL");
        if (it != headers->end())
            servprotokol = (*it).second;

        it = headers->find("REQUEST_URI");
        if (it != headers->end())
            requrl = (*it).second;

        it = headers->find("Authorization");
        if (it != headers->end())
            autorizs = (*it).second;

        it = headers->find("CONTENT_TYPE");
        if (it != headers->end())
            cnttype = (*it).second;

        it = headers->find("CONTENT_LENGTH");
        if (it != headers->end())
            cntlength = (*it).second;

        it = headers->find("HTTP_COOKIE");
        if (it != headers->end())
            m_cookie = (*it).second;

        it = headers->find("ServerID");
        if (it != headers->end())
            m_remote_server_id = (*it).second;

        it = headers->find("HTTP_X_SO_RQSTIDENT");
        if (it != headers->end()) {
            out_request_ident = (*it).second;
            if (work_delays != NULL)
                work_delays->m_request_id = out_request_ident;
        }

        it = headers->find("HTTP_X_SO_MESSID");
        if (it != headers->end()) {
            out_messid = (*it).second;
            if (!out_messid.empty()) {
                CGIUnescape(out_messid);
                if (work_delays != NULL)
                    work_delays->m_out_messid = out_messid;
            }
        }

        NumbRequest = NumbRequest + "[" + out_request_ident + "]";

        all_headers = "";
        /*it = headers->begin();
      while (it != headers->end())
      {
         all_headers = all_headers + "'" + (*it).first + "'='" + (*it).second + "'\n";

         ++it;
      }*/

        request_source = reqmethod + " " + requrl + " " + servprotokol;
        request = reqmethod + " " + TransformRequest(requrl) + " " + servprotokol;
        m_last_request = request_source;

        if ((!reqmethod.empty()) && (!requrl.empty()) && (!servprotokol.empty())) {
            ltcommand = GetCommand(m_Request, request); //must be the first character'?'
            if (ltcommand.empty())
                ltcommand = GetCommand2(m_Request, request); //from field 'action' GET request
            //ltcommand2 = GetCommand2(request);            //from field 'action' GET reaquest
            ltcommand_change = Trim(ltcommand);
            //ltcommand_change = DelDigitFromRqst(ltcommand_change); //delete the digits at the end of the query if it is there (turned off because caas api has digits in ident)

            //if ( (reqmethod == "POST") && (TString(m_Request) == "store") ) //debug
            //   reqmethod = "PUT";

            CheckContentType(cnttype, cntlength, ardata);
            SetBuffers(dataA, datasizeA, ardata);

            if (ActionWOParse(ltcommand_change, ardata, requrl, NumbRequest, request_source, thread_index)) {
            } else if (true) {
                TString tst = "";

                allowcommand = false;
                for (const auto& tst : AllowList) {
                    if (ltcommand_change == tst) {
                        allowcommand = true;
                        break;
                    }
                }

                if (!reqmethod.empty()) {
                    TReqParams paramlist;
                    if (reqmethod == "GET") {
                        ardata.reqmethod = RM_GET;
                        ok = GETRequest(paramlist, m_Request, NumbRequest, request, m_remote_ip, request_source);
                        if (requrl.length() >= MAXSIZEBODYDATA)
                            m_rqstsrc = TStringBuf(requrl.c_str(), MAXSIZEBODYDATA);
                        else
                            m_rqstsrc = requrl;

                    } else if (reqmethod == "POST") {
                        ardata.reqmethod = RM_POST;
                        ok = GETRequest(paramlist, m_Request, NumbRequest, request, m_remote_ip, request_source);
                        ok = POSTRequest(paramlist, m_Request, NumbRequest, cnttype, cntlength, dataA, datasizeA, m_remote_ip, request_source);
                        if (strlen(dataA) >= MAXSIZEBODYDATA)
                            m_rqstsrc = TString(m_Request) + "?" + TStringBuf(dataA, MAXSIZEBODYDATA);
                        else
                            m_rqstsrc = TString(m_Request) + "?" + TString(dataA);

                    } else if (reqmethod == "PUT") {
                        ardata.reqmethod = RM_PUT;
                        ok = PUTRequest(paramlist, ardata, m_Request, NumbRequest, cnttype, cntlength, dataA, datasizeA, m_remote_ip, request_source, requrl);

                    } else //UNKNOWN REQUEST
                    {
                        ardata.reqmethod = RM_UNKNOWN;
                        ok = 100;
                    }

                    if (ok == 0) {
                        NumbRequest = ModNumbrequest(paramlist, NumbRequest);
                        if (!allowcommand) {
                            auto pit = paramlist.find(INTERFACEACTION);
                            if (pit != paramlist.end()) {
                                s = Trim((*pit).second[0]);
                                s = DelDigitFromRqst(s);
                                if (!s.empty()) {
                                    strncpy(m_Request, s.c_str(), MAXCOMMANDSIZE - 1);
                                    ltcommand_change = s;
                                }
                                paramlist.erase(pit);
                            } else {
                                strncpy(m_Request, "console", MAXCOMMANDSIZE - 1);
                            }
                        }

                        NumbRequest = NumbRequest + GetUID(&paramlist);

                        if ((strlen(m_Request) >= 4) && (strncmp(m_Request, "ping", 4) == 0)) {
                            Ping("-", &paramlist);

                        } else if ((strlen(m_Request) >= 4) && (strncmp(m_Request, "info", 4) == 0)) {
                            Info("-", &paramlist);
                        } else if (AsciiEqualsIgnoreCase(m_Request, "unistat")) {
                            Unistat();
                        } else if ((strlen(m_Request) >= 11) && (strncmp(m_Request, "favicon.ico", 11) == 0)) {
                            SendToClientRAW(HTTP_200_OK(NumbRequest));
                            //} else if (ActionParse(TString(m_Request), paramlist, NumbRequest, KGUEST, requrl))
                        } else if (ActionParse(ltcommand_change, ardata, &paramlist, NumbRequest, requrl, thread_index)) {
                        } else {
                            //Authorization
                            ParamUnescape(paramlist);

                            //administrator
                            if ((strlen(m_Request) >= 10) && (strncmp(m_Request, "doshutdown", 10) == 0))
                                ShutdownA("-", &paramlist);
                            else if ((strlen(m_Request) >= 11) && (strncmp(m_Request, "askshutdown", 11) == 0))
                                AskShutdown();
                            else if ((strlen(m_Request) >= 9) && (strncmp(m_Request, "enbfflush", 9) == 0))
                                DisableFFlush(false, "-");
                            else if ((strlen(m_Request) >= 9) && (strncmp(m_Request, "dsbfflush", 9) == 0))
                                DisableFFlush(true, "-");
                            else if ((strlen(m_Request) >= 10) && (strncmp(m_Request, "enbdbgmode", 10) == 0))
                                DebugMode(true, "-");
                            else if ((strlen(m_Request) >= 10) && (strncmp(m_Request, "dsbdbgmode", 10) == 0))
                                DebugMode(false, "-");

                            //administrator and advanced user
                            if ((strlen(m_Request) >= 8) && (strncmp(m_Request, "askmidnight", 8) == 0))
                                AskMidnight();
                            else if ((strlen(m_Request) >= 10) && (strncmp(m_Request, "domidnight", 10) == 0))
                                Midnight("-", &paramlist);
                            else if ((strlen(m_Request) >= 10) && (strncmp(m_Request, "rotatelogs", 10) == 0))
                                TruncLogs(m_Request);

                            //administrator, advanced user and user
                            if ((strlen(m_Request) >= 7) && (strncmp(m_Request, "console", 7) == 0))
                                Console("-", &paramlist);
                            else if ((strlen(m_Request) >= 8) && (strncmp(m_Request, "econsole", 8) == 0))
                                ExtConsole("-", &paramlist);
                            else
                                notfound_user = true;

                            if (strlen(m_Request) == 0)
                                Console("-", &paramlist);

                            //other (to child)
                            if (ActionParse(TString(m_Request), ardata, &paramlist, NumbRequest, requrl, thread_index)) {
                            } else
                                notfound_other = true;
                        }

                    } else {
                        TString errtext = "";

                        if (ok == 3) {
                            errtext = "too much data";
                            SendToClient(SO_LOG_ERROR, 400, errtext, NumbRequest);
                        } else {
                            TString err_rqst = "<ERR=" + IntToStroka(ok) + ", m_Request='" + TString(m_Request) + "', cnttype='" + cnttype + "', cntlength='" + cntlength + "', datasizeA=" + IntToStroka(datasizeA) + ", m_remote_ip='" + m_remote_ip + "', request_source='" + request_source + "'>";

                            SendToClientRAW(HTTP_501_NOT_IMPLEMENTED());
                            WriteLogExt(SO_LOG_ERROR, 501, NumbRequest, err_rqst);
                        }
                    }
                }
            }
        }
    } else {
    }

    return res;
}

void TMakeRequestBase::Info() {
}

TReqParams TMakeRequestBase::CGIUnescapeDecodeParams(TReqParams& pReqParams) {
    ui32 size1 = 0, size2 = 0, size3 = 0;
    TReqParams::iterator par_it;
    char m_RequestPr[1096];
    char *ptarray = NULL, *p = NULL;
    bool extbuffer = false;
    TString sfirst = "", ssecond = "";
    TString st1 = "", st2 = "";

    TReqParams pReqParamsNew;
    par_it = pReqParams.begin();
    while (par_it != pReqParams.end()) {
        if (par_it->second.empty()) {
            ++par_it;
            continue;
        }

        size1 = par_it->first.size();
        size2 = par_it->second[0].size();
        size3 = size1 > size2 ? size1 : size2;

        if (size3 > (sizeof(m_RequestPr) - 1)) {
            ptarray = new char[size3 + 1];
            p = ptarray;
            extbuffer = true;
        } else {
            memset(m_RequestPr, 0, sizeof(m_RequestPr));
            p = m_RequestPr;
            extbuffer = false;
        }

        if (extbuffer)
            memset(ptarray, 0, size3 + 1);
        else
            memset(m_RequestPr, 0, sizeof(m_RequestPr));
        CGIUnescape(p, par_it->first.c_str());
        sfirst = TString(p);

        if (extbuffer)
            memset(ptarray, 0, size3 + 1);
        else
            memset(m_RequestPr, 0, sizeof(m_RequestPr));
        CGIUnescape(p, par_it->second[0].c_str());
        ssecond = TString(p);

        //add to hash
        pReqParamsNew[sfirst] = TReqValues();
        pReqParamsNew[sfirst].push_back(RemoveCR(DecodeFromHTML(ssecond)));

        if (ptarray != NULL) {
            delete[] ptarray;
            ptarray = NULL;
        }

        ++par_it;
    }

    return pReqParamsNew;
}

int TMakeRequestBase::GETRequest(TReqParams& paramlist, char* Command, TString& NumbRequest, TString& request_str,
                                 TString& remoteip, TString& request_source_str) {
    int err = 100;
    const char* brequestall_source = NULL;
    const char* brequestall = NULL;
    const char* brequest = NULL;
    const char* p = NULL;
    const char* p1 = NULL;
    const char* p2 = NULL;
    ui32 commandsize = 0;
    bool est_param = false;
    bool debug_mode = false;
    ui32 tick_parse_get = 0;
    ui32 tick_write_request_to_log = 0;

    tick_parse_get = CShingleTime::GetMs();

    paramlist.clear();

    brequestall_source = request_source_str.c_str();
    brequestall = request_str.c_str();
    if (brequestall != NULL) {
        tick_write_request_to_log = CShingleTime::GetMs();
        if ((LogsGroup != NULL) && (LogsGroup->GetDebugMode()))
            debug_mode = LogsGroup->GetDebugMode();
        if ((LogsGroup != NULL) && (LogsGroup->GetDebugMode()) && (InputLog != NULL))
            InputLog->WriteMessageAndData("<begin %s>%s<end>\n", NumbRequest.c_str(), brequestall_source);
        tick_write_request_to_log = CShingleTime::GetMs() - tick_write_request_to_log;

        brequest = strstr(brequestall, "/");
        if (brequest != NULL) {
            brequest += 1;

            if (brequest != NULL) {
                p1 = strstr(brequest, "?");
                if (p1 != NULL)
                    est_param = true;
                p2 = strstr(brequest, " HTTP/");
                if ((p1 != NULL) && (p2 == NULL))
                    p = p1;
                else if ((p1 == NULL) && (p2 != NULL))
                    p = p2;
                else if ((p1 != NULL) && (p2 != NULL))
                    p = p1 > p2 ? p2 : p1;
                if (p != NULL) {
                    commandsize = p - brequest;
                    if (commandsize > MAXCOMMANDSIZE)
                        commandsize = MAXCOMMANDSIZE;
                    if (commandsize > 0) {
                        memcpy(Command, brequest, commandsize);
                        Command[commandsize] = 0;
                    }
                }

                if (est_param && ((err == 0) || (err == 100))) {
                    //               ui32   bodysize       = 0;
                    //char   m_RequestT[REQ_BUFFER_SIZE_N];
                    //               char   *m_RequestBuff = NULL;
                    //               char   *longbuffer    = NULL;
                    //               char   *space         = NULL;

                    p1++;
                    err = ParseLinesParams(paramlist, p1, p2, err, NumbRequest, remoteip);

                } else
                    err = 0;
            }
        }
    }
    tick_parse_get = CShingleTime::GetMs() - tick_parse_get;

    if (tick_parse_get >= tick_write_request_to_log)
        tick_parse_get = tick_parse_get - tick_write_request_to_log;

    if (work_delays != NULL) {
        work_delays->m_parse_getpost = tick_parse_get;
        work_delays->m_write_rqst_to_inputlog = tick_write_request_to_log;
    }

    return err;
}

int TMakeRequestBase::POSTRequest(TReqParams& paramlist, Y_DECLARE_UNUSED char* Command, TString& NumbRequest, TString& scnttype,
                                  TString& scntlength, char* buff, int bufflen, TString& remoteipA, TString& urlA) {
    int err = 100;
    TString boundarys = "boundary=";
    TString boundary = "";
    ui8 cnttype = 0;
    ui32 cntlength = 0;
    const char* p1 = NULL;
    bool cnttypeb = false;
    bool cntlengthb = false;
    bool norcv = false;
    char* statb = NULL;
    ui32 statbsize = 0;
    TString errs = "";
    ui32 tick_parse_post = 0;
    ui32 tick_write_request_to_log = 0;

    tick_parse_post = CShingleTime::GetMs();
    if (!scnttype.empty()) {
        if (strstr(scnttype.c_str(), "application/x-www-form-urlencoded") != NULL) {
            cnttype = 1;

        } else if (strstr(scnttype.c_str(), "multipart/form-data") != NULL) {
            cnttype = 2;
            p1 = strstr(scnttype.c_str(), boundarys.c_str());
            if (p1 != NULL)
                boundary = TString(p1 + boundarys.length());

        } else if (strstr(scnttype.c_str(), "application/lzo") != NULL) {
            cnttype = 3;
        } else if (strstr(scnttype.c_str(), "application/json") != NULL) {
            cnttype = 4;
        }
        cnttypeb = true;
    }
    if (!scntlength.empty()) {
        cntlength = atoi(scntlength.c_str());
        cntlengthb = true;
    }
    if (cnttypeb && cntlengthb) {
        if (cntlength > 0) {
            if (cntlength <= MAXSIZEBODYDATA) {
                if (bufflen == cntlength) {
                    if (cnttype == 1) {
                        err = ParseLinesParams(paramlist, buff, buff + cntlength, err, NumbRequest, remoteipA);
                        statb = buff;
                        statbsize = cntlength;

                    } else if (cnttype == 2) {
                        ParsePOSTParams(paramlist, buff, cntlength, boundary);
                        statb = buff;
                        statbsize = cntlength;
                        err = 0;

                    } else if (cnttype == 3) {
                        err = ParseLZO(paramlist, buff, buff + cntlength, err, NumbRequest, remoteipA);
                        statb = buff;
                        statbsize = cntlength;
                        err = 0;

                    } else if (cnttype == 4) {
                        err = ParseJson(paramlist, buff, buff + cntlength, err, NumbRequest, remoteipA);
                        statb = buff;
                        statbsize = cntlength;
                        err = 0;

                    } else
                        err = 5;
                } else
                    err = 4;
            } else {
                if (cntlength > MAXSIZEBODYDATA_LIMIT)
                    norcv = true;
                err = 3;
            }
        } else
            err = 0;
    } else
        err = 1;

    switch (err) {
        case 3:
            errs = "3 (too much data)";
            break;
        case 4:
            errs = "4 (not enough data: " + IntToStroka(bufflen) + ")";
            break;
        case 5:
            errs = "5 (unknown POST)";
            break;
        default:
            errs = IntToStroka(err);
    };
    tick_parse_post = CShingleTime::GetMs() - tick_parse_post;

    tick_write_request_to_log = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->GetDebugMode()) && (InputLog != NULL) && (InputLog->GetWriteStatus())) {
        TString prefix = "";
        TString postfix = "";

        prefix = "<begin " + NumbRequest + ">" + errs + "\n" + urlA + "\n" + scnttype + "\n" + scntlength + "\n'";
        postfix = "'\n<end>\n";
        InputLog->WriteMessageAndDataBUFFExt(prefix.c_str(), postfix.c_str(), statb, statbsize);
    }
    tick_write_request_to_log = CShingleTime::GetMs() - tick_write_request_to_log;

    if (work_delays != NULL) {
        work_delays->m_parse_getpost = tick_parse_post;
        work_delays->m_write_rqst_to_inputlog = tick_write_request_to_log;
    }

    return err;
}

int TMakeRequestBase::PUTRequest(TReqParams& paramlist, TRequestDopData& data, char* Command,
                                 const TString& NumbRequest, const TString& scnttype, const TString& scntlength,
                                 char* buff, int bufflen, const TString& remoteipA, const TString& fullurlA,
                                 const TString& requesturl) {
    int err = 100;
    const char* p = NULL;
    TString errs = "";

    p = strchr(requesturl.c_str(), '?');
    if (p == NULL)
        p = requesturl.c_str();
    else
        p++;
    err = ParseLinesParams(paramlist, p, NULL, err, NumbRequest, remoteipA);

    if (bufflen > MAXSIZEBODYDATA)
        err = 3;

    errs = IntToStroka(err);
    if ((InputLog != NULL) && (InputLog->GetWriteStatus())) {
        TString prefix = "";
        TString postfix = "";
        TString logbuffdata;

        if (data.BUFF != NULL) {
            logbuffdata = Base64EncodeUrl(data.BUFF);
        };

        prefix = "<begin(base64) " + NumbRequest + ">" + errs + "\n" + fullurlA + "\n" + scnttype + "\n" + scntlength + "\n'";
        postfix = "'\n<end>\n";
        InputLog->WriteMessageAndDataBUFFExt(prefix.c_str(), postfix.c_str(), logbuffdata.c_str(), logbuffdata.size());
    }

    return err;
}

bool TMakeRequestBase::InitParamsNew(const TString& req, TReqParams& paramlist) {
    bool done = false;

    const char* it = req.cbegin();
    const char* end = req.cend();

    while (!done && it < end) {
        // Key
        const char* keyEnd = strchr(it, '=');
        if (!keyEnd)
            return false;

        const TStringBuf key(it, keyEnd);

        it = keyEnd + 1;

        // Value
        const char* valueEnd = strchr(it, '&');
        if (!valueEnd) {
            done = true;
            valueEnd = end;
        }

        const TStringBuf value(it, valueEnd);

        paramlist[key].emplace_back(std::move(value));

        it = valueEnd + 1;
    }
    return true;
}

void TMakeRequestBase::ParamUnescape(TReqParams& paramlist) {
    paramlist = CGIUnescapeDecodeParams(paramlist);
}

bool TMakeRequestBase::InitParams(ui16 Offset, const char* source, TReqParams** m_pReqParamsA) {
    bool res = false;
    const char* pequal = NULL;
    const char* pamp = NULL;
    const char* plaststart = NULL;
    const char* pstart = NULL;
    const char* pend = NULL;
    TString key = "";
    TString value = "";
    int count = 0;
    TReqParams::iterator it;

    pstart = source + Offset;
    pend = source + strlen(source);
    plaststart = pstart;
    pequal = strchr(pstart, '=');
    while (pequal != NULL) {
        key = "";
        value = "";

        pamp = strchr(pequal, '&');
        if (pamp == NULL)
            pamp = pend;

        count = pequal - plaststart;
        if (count > 0) {
            key = TString(plaststart, count);
            res = true;
        } else {
            res = false;
            break;
        }

        count = pamp - pequal - 1;
        if (count > 0)
            value = TString(pequal + 1, count);

        it = (*m_pReqParamsA)->find(key);
        if (it == (*m_pReqParamsA)->end()) {
            (**m_pReqParamsA)[key] = TReqValues();
            (**m_pReqParamsA)[key].push_back(value);
        } else
            it->second.push_back(value);

        plaststart = pamp + 1;
        pequal = strchr(pamp, '=');
    }

    return true;
}

int TMakeRequestBase::ParseLinesParams(TReqParams& paramlist, const char* p1, const char* p2, int errA,
                                       const TString& NumbRequest, const TString& remoteip) {
    int err = errA;
    ui32 bodysize = 0;
    //char        m_RequestT[REQ_BUFFER_SIZE_N];
    char* m_RequestBuff = NULL;
    char* longbuffer = NULL;
    char* space = NULL;

    if (p1 != NULL) {
        if (p2 != NULL)
            bodysize = p2 - p1;
        else
            bodysize = strlen(p1);

        if (bodysize > (sizeof(m_RequestT) - 1)) {
            if (bodysize <= MAXSIZEBODYDATA) {
                longbuffer = new char[bodysize + 1];
                memset(longbuffer, 0, bodysize + 1);
                m_RequestBuff = longbuffer;

            } else {
                if (ServerLog != NULL)
                    ServerLog->WriteMessageAndDataStatus(KERROR, "%s\t##%s\tbig size of input data (%u)!", remoteip.c_str(), NumbRequest.c_str(), bodysize);
                err = 3;
            }
        } else {
            m_RequestBuff = m_RequestT;
        }

        if ((err == 0) || (err == 100)) {
            memcpy(m_RequestBuff, p1, bodysize);
            m_RequestBuff[bodysize] = 0x00;

            if (InitParamsNew(m_RequestBuff, (paramlist))) {
                paramlist = CGIUnescapeDecodeParams(paramlist);
                err = 0;
            }

            if (longbuffer != NULL) {
                delete[] longbuffer;
                longbuffer = NULL;
            }
        }

    } else
        err = 0;

    return err;
}

int TMakeRequestBase::ParseLZO(TReqParams& paramlist, const char* p1, const char* p2, int errA,
                               const TString& NumbRequest, const TString& remoteip) {
    int err = errA;
    ui32 bodysize = 0;
    //char        m_RequestT[REQ_BUFFER_SIZE_N];
    char* m_RequestBuff = NULL;
    char* longbuffer = NULL;
    bool warning_size = false;
    TReqParams::iterator data_it;
    TReqParams::iterator errs_it;

    if (p1 != NULL) {
        if (p2 != NULL)
            bodysize = p2 - p1;
        else
            bodysize = strlen(p1);

        if (bodysize > (sizeof(m_RequestT) - 1)) {
            if (bodysize <= MAXSIZEBODYDATA) {
                longbuffer = new char[bodysize + 1];
                memset(longbuffer, 0, bodysize + 1);
                m_RequestBuff = longbuffer;

            } else {
                if (ServerLog != NULL)
                    ServerLog->WriteMessageAndDataStatus(KERROR, "%s\t##%s\tbig size of input data (%u)!", remoteip.c_str(), NumbRequest.c_str(), bodysize);
                err = 3;
            }
        } else {
            m_RequestBuff = m_RequestT;
        }

        if ((err == 0) || (err == 100)) {
            memcpy(m_RequestBuff, p1, bodysize);
            m_RequestBuff[bodysize] = 0x00;

            paramlist["data"] = TReqValues();
            paramlist["data"].push_back("");

            paramlist["errs"] = TReqValues();
            paramlist["errs"].push_back("");

            paramlist["warning_size"] = TReqValues();
            paramlist["res"] = TReqValues();

            data_it = paramlist.find("data");
            errs_it = paramlist.find("errs");
            if ((data_it != paramlist.end()) && (errs_it != paramlist.end())) {
                if (Unbase64AndUncompress(m_RequestBuff, bodysize, warning_size, data_it->second[0], errs_it->second[0])) {
                    paramlist["res"].push_back("1");
                    paramlist["warning_size"].push_back("0");

                } else {
                    paramlist["res"].push_back("0");
                    paramlist["warning_size"].push_back("1");
                }

                err = 0;
            }

            if (longbuffer != NULL) {
                delete[] longbuffer;
                longbuffer = NULL;
            }
        }

    } else
        err = 0;

    return err;
}

int TMakeRequestBase::ParseJson(TReqParams& paramlist, const char* p1, const char* p2, int errA,
                                const TString& NumbRequest, const TString& remoteip) {
    int err = errA;
    ui32 bodysize = 0;
    //char        m_RequestT[REQ_BUFFER_SIZE_N];
    char* m_RequestBuff = NULL;
    char* longbuffer = NULL;
    bool warning_size = false;
    TReqParams::iterator data_it;
    TReqParams::iterator errs_it;

    if (p1 != NULL) {
        if (p2 != NULL)
            bodysize = p2 - p1;
        else
            bodysize = strlen(p1);

        if (bodysize > (sizeof(m_RequestT) - 1)) {
            if (bodysize <= MAXSIZEBODYDATA) {
                longbuffer = new char[bodysize + 1];
                memset(longbuffer, 0, bodysize + 1);
                m_RequestBuff = longbuffer;

            } else {
                if (ServerLog != NULL)
                    ServerLog->WriteMessageAndDataStatus(KERROR, "%s\t##%s\tbig size of input data (%u)!", remoteip.c_str(), NumbRequest.c_str(), bodysize);
                err = 3;
            }
        } else {
            m_RequestBuff = m_RequestT;
        }

        if ((err == 0) || (err == 100)) {
            memcpy(m_RequestBuff, p1, bodysize);
            m_RequestBuff[bodysize] = 0x00;

            paramlist["data"] = TReqValues();
            paramlist["data"].push_back("");

            paramlist["errs"] = TReqValues();
            paramlist["errs"].push_back("");

            paramlist["warning_size"] = TReqValues();
            paramlist["res"] = TReqValues();

            data_it = paramlist.find("data");
            errs_it = paramlist.find("errs");
            if ((data_it != paramlist.end()) && (errs_it != paramlist.end())) {
                data_it->second[0].assign(m_RequestBuff, bodysize);
                err = 0;
            }

            if (longbuffer != NULL) {
                delete[] longbuffer;
                longbuffer = NULL;
            }
        }

    } else
        err = 0;

    return err;
}

ui32 GetStr_n(const char* source, ui32 source_size, char* destination, ui32 destination_size) {
    long pos = -1;
    ui32 res = 0;
    ui8 dob = 0;

    for (ui32 i = 0; i < source_size; i++) {
        if ((source[i] == 0x0D) && ((i + 1) < source_size) && (source[i + 1] == 0x0A)) {
            pos = i;
            dob = 1;
            break;
        }
        if (source[i] == 0x0A) {
            pos = i;
            dob = 0;
            break;
        }
    }
    res = pos + 1 + dob;
    if (res == 0)
        res = source_size;
    if (res > 0) {
        memset(destination, 0, destination_size);
        if (res <= (destination_size - 1)) {
            memcpy(destination, source, res);
        } else {
            memcpy(destination, source, destination_size - 1);
        }
    }
    return res;
}

bool ExludeContentType_n(TString cnttype) {
    bool res = false;

    if (strncmp(cnttype.c_str(), "image/", 6) == 0)
        res = true;
    else if (strncmp(cnttype.c_str(), "application/", 12) == 0)
        res = true;
    else if (strncmp(cnttype.c_str(), "chemical/", 9) == 0)
        res = true;
    else if (strncmp(cnttype.c_str(), "audio/", 6) == 0)
        res = true;
    else if (strncmp(cnttype.c_str(), "inode/", 6) == 0)
        res = true;
    else if (strncmp(cnttype.c_str(), "video/", 6) == 0)
        res = true;

    return res;
}

int TMakeRequestBase::ParsePOSTParams(TReqParams& paramlist, char* buff, ui32 buffsize, TString boundary) {
    int res = 0;
    TString boundary_sect = "";
    TString boundary_end = "";
    ui32 m_buff_pos = 0;
    char tbuff[65500];
    TString s = "";
    ui32 strlength = 0;
    bool is_bboundary = false;
    bool is_rn = false;
    bool is_name = false;
    TString rn = "\r\n";
    TString contentdispositions = "Content-Disposition:";
    TString contenttypes = "Content-Type:";
    TString contenttype = "";
    const char* p = NULL;
    const char* p1 = NULL;
    const char* p2 = NULL;
    TString names = "name=\"";
    TString name = "";
    ui32 namesize = 0;
    TString collectdata = "";

    paramlist.clear();
    if (!boundary.empty() && (buff != NULL) && (buffsize > 0)) {
        boundary_sect = "--" + boundary;
        boundary_end = "--" + boundary + "--";

        m_buff_pos = 0;
        while (m_buff_pos < buffsize) {
            strlength = GetStr_n(buff + m_buff_pos, buffsize - m_buff_pos, tbuff, sizeof(tbuff));
            if (strlength > 0) {
                m_buff_pos += strlength;
                s = TString(tbuff);
                if ((s.length() >= boundary_sect.length()) && (!memcmp(s.c_str(), boundary_sect.c_str(), boundary_sect.length()))) {
                    if (is_bboundary && is_name && is_rn) {
                        if (!ExludeContentType_n(contenttype)) {
                            if (paramlist.find(name) == paramlist.end()) {
                                TReqValues rv;

                                rv.push_back(collectdata);
                                paramlist[name] = rv;
                                res++;
                            }
                        }
                    }

                    is_bboundary = true;
                    is_rn = false;
                    is_name = false;
                    collectdata = "";
                    contenttype = "";
                } else if ((s.length() >= boundary_end.length()) && (!memcmp(s.c_str(), boundary_end.c_str(), boundary_end.length()))) {
                    if (is_bboundary && is_name && is_rn) {
                        if (!ExludeContentType_n(contenttype)) {
                            if (paramlist.find(name) == paramlist.end()) {
                                TReqValues rv;

                                rv.push_back(collectdata);
                                paramlist[name] = rv;
                                res++;
                            }
                        }
                    }

                    is_bboundary = true;
                    is_rn = false;
                    is_name = false;
                    collectdata = "";
                    contenttype = "";
                } else if (is_bboundary && (s.length() >= rn.length()) && (!memcmp(s.c_str(), rn.c_str(), rn.length()))) {
                    is_rn = true;
                } else if (is_bboundary && ((p = strstr(s.c_str(), contentdispositions.c_str())) != NULL)) {
                    p1 = strstr(p + contentdispositions.length(), names.c_str());
                    if (p1 != NULL) {
                        p2 = strstr(p1 + names.length(), "\"");
                        if (p2 != NULL) {
                            namesize = p2 - p1 - names.length();
                            if (namesize > 0) {
                                name = TString(p1 + names.length(), namesize);
                                is_name = true;
                            }
                        }
                    }
                } else if (is_bboundary && ((p = strstr(s.c_str(), contenttypes.c_str())) != NULL)) {
                    contenttype = Trim(TString(p + contenttypes.length()));
                } else if (is_bboundary && is_name && is_rn) {
                    if (!ExludeContentType_n(contenttype))
                        collectdata += s;
                }

            } else
                break;
        }
    }

    return res;
}

TString TMakeRequestBase::GetUID(TReqParams* m_ReqParams) {
    TReqParams::iterator pit;
    TString res = "[-]";

    pit = m_ReqParams->find("so_uid");
    if (pit != m_ReqParams->end()) {
        res = "[" + (*pit).second[0] + "]";
        m_ReqParams->erase(pit);
    }
    return res;
}

void TMakeRequestBase::Ping(const TString&, TReqParams*) {
    SendToClientRAW(HTTP_200_OK(NumbRequest));
}

void TMakeRequestBase::Info(const TString& id, TReqParams* m_ReqParams) {
    char CurTime[CShingleTime::MAX_TIME_SIZE];
    CShingleTime::GetTimeStr(CurTime);
    TString text = "";

    text = text + "<A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A></font>&nbsp;&nbsp;\n";
    text = text + "<A href='" + GetHost() + GetModuleName("ascconvpasswd") + GetActionOneParam("ascconvpasswd") + "'>Password convert</A></font>&nbsp;&nbsp;\n";
    // Server
    text = text + "<br><i><b>Server control:</b></i>&nbsp;&nbsp;\n";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
    text = text + "<tr valign='top'><td valign='left'>Version</td><td>\n" + m_servername + "</td></tr>\n";
    if ((srvcobj.GetNumberRequest() != NULL))
        text = text + "<tr valign='top'><td valign='left'>Host name (code)</td><td>" + srvcobj.GetNumberRequest()->GetHostName() + " (" + srvcobj.GetNumberRequest()->GetHostCode() + ")</td></tr>";
    text = text + "<tr valign='top'><td valign='left'>Start time</td><td>\n" + m_StartTime + "</td></tr>\n";
    text = text + "<tr valign='top'><td valign='left'>Current time</td><td>\n" + TString(CurTime) + "</td></tr>\n";
    text = text + "<tr valign='top'><td valign='left'>Connected from</td><td>" + m_remote_ip + " &nbsp; </td></tr>";
    text = text + "</table>\n";

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequestBase::Unistat() {
    SendToClientRAW(HTTP_200_OK_UNISTAT());
}

void TMakeRequestBase::PushSignal(const TString& name) {
    TUnistat::Instance().DrillFloatHole(name, "summ", NUnistat::TPriority{0})->PushSignal(1);
}

void TMakeRequestBase::AskShutdown() {
    TString text = "";

    text = text + HTTP_200_OK("-");
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Shutdown server ?')) {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("doshutdown") + GetActionOneParam("doshutdown") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";
    SendToClientRAW(text);
}

void TMakeRequestBase::ShutdownA(const TString& id, TReqParams* m_ReqParams) {
    if (server != NULL) {
        ((TFCGIServerBase*)server)->Shutdown();

        Shutdown(id, m_ReqParams);
    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", id);
    }
}

void TMakeRequestBase::AskMidnight() {
    TString text = "";

    text = text + HTTP_200_OK("-");
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Force midnight ?')) {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("domidnight") + GetActionOneParam("domidnight") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";
    SendToClientRAW(text);
}

void TMakeRequestBase::TruncLogs(const char* s) {
    ui32 BeginProcessTime = CShingleTime::GetMs();
    TString text = "";

    if (LogsGroup != NULL) {
        LogsGroup->TruncLog();

        text = text + "Logs truncate - OK.<br>";
        text = text + "<A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";
    }
    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");
}

void TMakeRequestBase::DisableFFlush(bool disable, const TString& id) {
    TString text = "";

    if (LogsGroup != NULL) {
        if (disable) {
            LogsGroup->DisableFFlush(true);
            text = "Disable fflush - OK.";
        } else {
            LogsGroup->DisableFFlush(false);
            text = "Enable fflush - OK.";
        }
    } else {
        if (disable)
            text = "Disable fflush - FAILED.";
        else
            text = "Enable fflush - FAILED.";
    }
    text = text + "<br><A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";

    SendToClient(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequestBase::DebugMode(bool enable, const TString& id) {
    TString text = "";

    if (LogsGroup != NULL) {
        if (enable) {
            LogsGroup->SetDebugMode(true);
            text = "Enable debug mode - OK.";
        } else {
            LogsGroup->SetDebugMode(false);
            text = "Disable debug mode - OK.";
        }
    } else {
        if (enable)
            text = "Enable debug mode - FAILED.";
        else
            text = "Disable debug mode - FAILED.";
    }
    text = text + "<br><A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";

    SendToClient(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequestBase::SendToClientRAW(const TString& text) {
    if (!text.empty()) {
        if (out != NULL) {
            FCGX_FPrintF(((FCGX_Request*)out)->out, "%s", text.c_str());
            FCGX_Finish_r(((FCGX_Request*)out));
        }
    }
}

void TMakeRequestBase::SendToClientPoorBase(const ui16 HttpCode, const TString& text, ui8 shap, const TString& id) {
    TString textex = "";

    if (out != NULL) {
        switch (HttpCode) {
            case 200:
                textex = HTTP_200_OK(id) + text;
                break;
            case 400:
                textex = HTTP_400_BAD_REQUEST(id) + text;
                break;
            case 403:
                textex = HTTP_403_FORBIDDEN(id) + text;
                break;
            case 404:
                textex = HTTP_404_NOT_FOUND(id) + text;
                break;
            case 500:
                textex = HTTP_500_INTERNAL_SERVER_ERROR() + text;
                break;
            case 501:
                textex = HTTP_501_NOT_IMPLEMENTED() + text;
                break;
        };
        if (out != NULL) {
            FCGX_FPrintF(((FCGX_Request*)out)->out, "%s", textex.c_str());
            FCGX_Finish_r(((FCGX_Request*)out));
        }
    }
}

void TMakeRequestBase::SendToClientBase(const ui16 HttpCode, const TString& text, ui8 shap, const TString& id) {
    SendToClientBase(HttpCode, text, shap, id, -1);
}

void TMakeRequestBase::SendToClientBase(const ui16 HttpCode, const TString& text, ui8 shap, const TString& id, i32 tick) {
    TString textex = "";
    TString srvr_ident = "";
    TString styles_txt = "";

    if ((srvcobj.GetNumberRequest() != NULL))
        srvr_ident = srvcobj.GetNumberRequest()->GetHostName() + " (" + srvcobj.GetNumberRequest()->GetHostCode() + ") &nbsp; ";
    if (!text.empty()) {
        switch (shap) {
            case 1:
                textex = textex + "<html><head><title>" + m_servername + "</title>" + styles_txt + "</head><body bgcolor=palegoldenrod>";
                textex = textex + "<table border='0' width='100%' cellspacing='0' cellpadding='4'>\n";
                textex = textex + "<tr><td><h1><i>" + m_servername;
                textex = textex + "</i></h1></td><td align='right' valign='top'>\n";
                textex = textex + srvr_ident;
                textex = textex + "<font size=2><A href='" + GetHost() + GetModuleName("econsole") + GetActionOneParam("econsole") + "'>ExtendedConsole</A></font>&nbsp;&nbsp;\n";
                textex = textex + "<font size=2><A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A></font>&nbsp;&nbsp;\n";
                textex = textex + "<font size=2><A href='" + GetHost() + GetModuleName("info") + GetActionOneParam("info") + "'>Info</A></font>&nbsp;&nbsp;\n";
                textex = textex + "</td></tr></table><hr>\n";
                break;
            case 2:
                textex = textex + "<html><head>" + styles_txt + "</head><body bgcolor=palegoldenrod>";
                textex = textex + "<div align='right'><font size=2>";
                textex = textex + srvr_ident;
                textex = textex + "<font size=2><A href='" + GetHost() + GetModuleName("econsole") + GetActionOneParam("econsole") + "'>ExtendedConsole</A></font>&nbsp;&nbsp;\n";
                textex = textex + "<font size=2><A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A></font>&nbsp;&nbsp;\n";
                textex = textex + "<font size=2><A href='" + GetHost() + GetModuleName("info") + GetActionOneParam("info") + "'>Info</A></font>&nbsp;&nbsp;\n";
                textex = textex + "</font></div>";
                break;
            default:
                textex = textex + "<html><body bgcolor=palegoldenrod>";
        }
        textex = textex + text;
        if (shap) {
            if (tick < 0)
                textex = textex + "<hr>&#169; 2017 &#171;Yandex&#187; / &#171;Spamooborona&#187;\n";
            else
                textex = textex + "<hr>&#169; 2017 &#171;Yandex&#187; / &#171;Spamooborona&#187; (" + IntToStroka(tick) + " msec)\n";
            textex = textex + "</body></html>\n";
        } else {
            textex = textex + "</body></html>";
        }
    }
    if (out != NULL) {
        switch (HttpCode) {
            case 200:
                if (tick < 0)
                    textex = HTTP_200_OK(id) + textex;
                else
                    textex = HTTP_200_OK(id, tick) + textex;
                break;
            case 400:
                if (tick < 0)
                    textex = HTTP_400_BAD_REQUEST(id) + textex;
                else
                    textex = HTTP_400_BAD_REQUEST(id, tick) + textex;
                break;
            case 403:
                textex = HTTP_403_FORBIDDEN(id) + textex;
                break;
            case 404:
                textex = HTTP_404_NOT_FOUND(id) + textex;
                break;
            case 500:
                textex = HTTP_500_INTERNAL_SERVER_ERROR() + textex;
                break;
            case 501:
                textex = HTTP_501_NOT_IMPLEMENTED() + textex;
                break;
        };
        if (out != NULL) {
            FCGX_FPrintF(((FCGX_Request*)out)->out, "%s", textex.c_str());
            FCGX_Finish_r(((FCGX_Request*)out));
        }
    }
}

void TMakeRequestBase::SendToClientPoor(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    SendToClientPoorBase(HttpCode, text, 0, id);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClient(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    SendToClientBase(HttpCode, text, 0, id);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClientFull(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    SendToClientBase(HttpCode, text, 0, id);
    WriteLogFull(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClientWithShap(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    SendToClientBase(HttpCode, text, 1, id);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClientWithLittleShap(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    SendToClientBase(HttpCode, text, 2, id);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClientWithLittleShap(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id, i32 tick) {
    SendToClientBase(HttpCode, text, 2, id, tick);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClientRAW(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    TString textt = "";

    textt = HTTP_200_OK(id) + text;
    SendToClientRAW(textt);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClientRAWXML(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    TString textt = "";

    textt = HTTP_200_OK_XML(id) + text;
    SendToClientRAW(textt);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClientRAWPlain(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    TString textt = "";

    textt = HTTP_200_OK_Plain(id) + text;
    SendToClientRAW(textt);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::SendToClientRAWJSON(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id) {
    TString textt = "";

    textt = HTTP_200_OK_JSON(id) + text;
    SendToClientRAW(textt);
    WriteLog(LogLevel, HttpCode, id);
}

void TMakeRequestBase::WriteLog(const TLogLevel LogLevel, const ui16 HttpCode, const TString& id) {
    ui32 proc_time = CShingleTime::GetMs() - m_BeginProcTime;
    TString rid = id;

    switch (LogLevel) {
        case SO_LOG_MESSAGE:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\t%s\t%u\t%u\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request);
            break;
        case SO_LOG_WARNING:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KWARNING, "%17s\t%s\t%u\t%u\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request);
            break;
        case SO_LOG_ERROR:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\t%s\t%u\t%u\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request);
            break;
        default:
            break;
    }
}

void TMakeRequestBase::WriteLogFull(const TLogLevel LogLevel, const ui16 HttpCode, const TString& id) {
    ui32 proc_time = CShingleTime::GetMs() - m_BeginProcTime;
    TString rid = id;

    switch (LogLevel) {
        case SO_LOG_MESSAGE:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\t%s\t%u\t%u\t%s(%s)", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request, m_rqstsrc.c_str());
            break;
        case SO_LOG_WARNING:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KWARNING, "%17s\t%s\t%u\t%u\t%s(%s)", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request, m_rqstsrc.c_str());
            break;
        case SO_LOG_ERROR:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\t%s\t%u\t%u\t%s(%s)", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request, m_rqstsrc.c_str());
            break;
        default:
            break;
    }
}

void TMakeRequestBase::WriteLogExt(const TLogLevel LogLevel, const ui16 HttpCode, const TString& id, const TString& dob) {
    ui32 proc_time = CShingleTime::GetMs() - m_BeginProcTime;
    TString rid = id;

    switch (LogLevel) {
        case SO_LOG_MESSAGE:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\t%s\t%u\t%u\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request, dob.c_str());
            break;
        case SO_LOG_WARNING:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KWARNING, "%17s\t%s\t%u\t%u\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request, dob.c_str());
            break;
        case SO_LOG_ERROR:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\t%s\t%u\t%u\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, m_Request, dob.c_str());
            break;
        default:
            break;
    }
}

void TMakeRequestBase::WriteLogMin(const TLogLevel LogLevel, const ui16 HttpCode, const char* sdob, const TString& id) {
    ui32 proc_time = CShingleTime::GetMs() - m_BeginProcTime;

    TString rid = id;
    const char* p = NULL;
    char buff[10];
    const char *pb = NULL, *pe = NULL;
    TString sb = "", se = "", sr = "";
    bool form = false;

    p = strstr(m_Request, "check?");
    if (p) {
        pb = strstr(m_Request, "&mail=");
        if (pb == NULL)
            pb = strstr(m_Request, "?mail=");
        if (pb != NULL) {
            pe = strstr(pb + 1, "&");
            if (pe != NULL)
                se = TString(pe);
            sb = TString(m_Request, pb - m_Request + 6);
            se = TString(pe);
            sr = sb + "*****" + se;
            p = sr.c_str();
            form = true;
        }
        if (!form) {
            memset(buff, 0, sizeof(buff));
            memcpy(buff, m_Request, 6);
            p = buff;
        }
    } else {
        p = m_Request;
    }

    switch (LogLevel) {
        case SO_LOG_MESSAGE:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\t%s\t%u\t%u\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, p, sdob);
            break;
        case SO_LOG_WARNING:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KWARNING, "%17s\t%s\t%u\t%u\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, p, sdob);
            break;
        case SO_LOG_ERROR:
            if (ServerLog != NULL)
                ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\t%s\t%u\t%u\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), proc_time, HttpCode, p, sdob);
            break;
        default:
            break;
    }
}

void TMakeRequestBase::WriteProcRequest(const ui32 ReqProcTime, const int HttpStatus, const char* Message, const char* Request, const TString& id) {
    TString rid = id;

    if (200 == HttpStatus) {
        if (ServerLog != NULL)
            ServerLog->WriteMessageAndDataStatus(KMESSAGE, "%17s\t%15s\t-\t%5u\t%3d\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), ReqProcTime, HttpStatus, Message, Request);
    } else if ((400 <= HttpStatus) && (HttpStatus < 500)) {
        if (ServerLog != NULL)
            ServerLog->WriteMessageAndDataStatus(KWARNING, "%17s\t%15s\t-\t%5u\t%3d\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), ReqProcTime, HttpStatus, Message, Request);
    } else {
        if (ServerLog != NULL)
            ServerLog->WriteMessageAndDataStatus(KERROR, "%17s\t%15s\t-\t%5u\t%3d\t%s\t%s", rid.c_str(), m_remote_ip.c_str(), ReqProcTime, HttpStatus, Message, Request);
    }
}

TString TMakeRequestBase::GetValue(TReqParams::iterator& it) {
    TString res = "";

    if (it->second[0].length() > 32000)
        res = it->second[0].substr(0, 32000);
    else
        res = it->second[0];

    return res;
}

TString TMakeRequestBase::GetHost() {
    return "";
}

TString TMakeRequestBase::GetModuleName(const TString& command) {
    TString res = "";

    res = srvcobj.ModuleName() + m_dob_command;

    return res;
}

TString TMakeRequestBase::GetActionOneParam(const TString& command) {
    //return "?action=" + command + m_dob_command + "&authlogin=" + userlogin;
    return "?" + TString(INTERFACEACTION) + "=" + command + m_dob_command;
}

TString TMakeRequestBase::GetActionMultiParam(const TString& command) {
    //return "action=" + command + m_dob_command + "&authlogin=" + userlogin + "&";
    return TString(INTERFACEACTION) + "=" + command + m_dob_command;
}

TString TMakeRequestBase::GetActionFormParam(const TString& command) {
    //return "<input type='hidden' size='10' name='action' value='" + command + m_dob_command + "'><input type='hidden' size='10' name='authlogin' value='" + userlogin + "'>";
    return "<input type='hidden' size='10' name='" + TString(INTERFACEACTION) + "' value='" + command + m_dob_command + "'><input type='hidden' size='10' name='authlogin' value=''>";
}
