#pragma once

#include <mail/so/spamstop/tools/so-common/sobase64.h>

#include <util/generic/vector.h>
#include <util/generic/list.h>
#include <util/string/util.h>
#include <library/cpp/string_utils/quote/quote.h>
#include <mail/so/spamstop/tools/so-clients/SperrorHolder.h>

#include "sotypes.h"
#include "tserviceobjectbase.h"

#define REQ_BUFFER_SIZE_N 65535
#define INTERFACEACTION "actiface"

typedef TVector<TString> THeaders;
typedef THeaders::iterator THeadersIt;

typedef THashMap<TString, TString> TWStrokaHash;
typedef TWStrokaHash::iterator TWStrokaHashIt;

enum TContentTypeK { TADT_UNKNOWN,
                     TADT_APPLXLZOP,
                     TADT_TEXTPLAIN };
enum TRequestMethodK { RM_UNKNOWN,
                       RM_GET,
                       RM_POST,
                       RM_PUT };

struct TRequestDopData {
    char* BUFF = nullptr;
    int BUFFSize;
    TRequestMethodK reqmethod;
    TContentTypeK content_type;
    int content_length;

    TRequestDopData() {
        Clear();
    }

    void Clear() {
        BUFF = NULL;
        BUFFSize = 0;
        content_type = TADT_UNKNOWN;
        content_length = 0;
        reqmethod = RM_UNKNOWN;
    }
};

//

class TMakeRequestBase {
public:
    static const ui32 MAXSIZEBODYDATA = 5000001;
    static const ui32 MAXSIZEBODYDATA_LIMIT = 6000000;
    static const ui32 MAXCOMMANDSIZE = 100;

    TServiceObjectBase& srvcobj;
    void* server = nullptr;
    TMakeRqstDelays* work_delays = nullptr;
    char m_RequestA[MAXCOMMANDSIZE];
    char m_RequestT[REQ_BUFFER_SIZE_N];
    char* m_Request = nullptr;
    ui32 m_BeginProcTime;

    TBaseLogClass* InputLog = nullptr;
    TBaseLogClass* ServerLog = nullptr;
    TNumberRequestClass* NumberRequest = nullptr;
    TLogsGroupBase* LogsGroup = nullptr;
    TString NumbRequest;
    TString m_remote_ip;
    TString m_rqstsrc;
    TString m_cookie;
    TString m_remote_server_id;
    void* out = nullptr;
    TString m_dob_command;
    TString m_servername;
    TString m_server_ident;
    TString m_StartTime;
    ui32 m_StartTimeTick;
    TList<TString> AllowList; //if the command is not listed, that replaced to 'console'
    TString all_headers;
    TString m_last_request;

    void CheckContentType(const TString& contenttypeA, const TString& content_length, TRequestDopData& ardataA);
    void SetBuffers(char* BUFF, int BUFFSize, TRequestDopData& ardataA);
    TReqParams CGIUnescapeDecodeParams(TReqParams& pReqParams);
    int GETRequest(TReqParams& paramlist, char* Command, TString& NumbRequest,
                   TString& request_str, TString& remoteip, TString& request_source_str);
    int POSTRequest(TReqParams& paramlist, char* Command, TString& NumbRequest, TString& scnttype,
                    TString& scntlength, char* buff, int bufflen, TString& remoteipA,
                    TString& urlA);
    int PUTRequest(TReqParams& paramlist, TRequestDopData& data, char* Command,
                   const TString& NumbRequest, const TString& scnttype, const TString& scntlength,
                   char* buff, int bufflen, const TString& remoteipA, const TString& fullurlA,
                   const TString& requesturl);
    bool InitParamsNew(const TString& req, TReqParams& paramlist);
    void ParamUnescape(TReqParams& paramlist); //urldecode parameters
    int ParseLinesParams(TReqParams& paramlist, const char* p1, const char* p2, int errA,
                         const TString& NumbRequest, const TString& remoteip);
    int ParseLZO(TReqParams& paramlist, const char* p1, const char* p2, int errA,
                 const TString& NumbRequest, const TString& remoteip);
    int ParseJson(TReqParams& paramlist, const char* p1, const char* p2, int errA,
                  const TString& NumbRequest, const TString& remoteip);
    int ParsePOSTParams(TReqParams& paramlist, char* buff, ui32 buffsize, TString boundary);
    TString GetCommand(char* Command, TString& request_str);
    TString GetCommand2(char* Command, TString& request_str);
    bool InitParams(ui16 Offset, const char* source, TReqParams** m_pReqParamsA);

    TString GetUID(TReqParams* m_ReqParams);
    void Ping(const TString& id, TReqParams* m_ReqParams);
    void Info(const TString& id, TReqParams* m_ReqParams);
    void Unistat();

    static void PushSignal(const TString& name);

    void AskShutdown();
    void ShutdownA(const TString& id, TReqParams* m_ReqParams);
    virtual void Shutdown(const TString& id, TReqParams* m_ReqParams) = 0;
    void AskMidnight();
    virtual void Midnight(const TString& id, TReqParams* m_ReqParams) = 0;
    void TruncLogs(const char* s);

    void DisableFFlush(bool disable, const TString& id);
    void DebugMode(bool enable, const TString& id);
    virtual void Console(const TString& id, TReqParams* m_ReqParams) = 0;
    virtual void ExtConsole(const TString& id, TReqParams* m_ReqParams) = 0;
    TString GetValue(TReqParams::iterator& it);

    TString GetHost();
    TString GetModuleName(const TString& command);
    TString GetActionOneParam(const TString& command);
    TString GetActionMultiParam(const TString& command);
    TString GetActionFormParam(const TString& command);

    void SendToClientRAW(const TString& text);
    void SendToClientPoorBase(const ui16 HttpCode, const TString& text, ui8 shap, const TString& id);
    void SendToClientBase(const ui16 HttpCode, const TString& text, ui8 shap, const TString& id);
    void SendToClientBase(const ui16 HttpCode, const TString& text, ui8 shap, const TString& id, i32 tick);
    void SendToClientPoor(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);
    void SendToClient(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);
    void SendToClientFull(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);
    void SendToClientWithShap(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);
    void SendToClientWithLittleShap(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);
    void SendToClientWithLittleShap(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id, i32 tick);
    void SendToClientRAW(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);
    void SendToClientRAWXML(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);
    void SendToClientRAWPlain(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);
    void SendToClientRAWJSON(const TLogLevel LogLevel, const ui16 HttpCode, const TString& text, const TString& id);

    void WriteLog(const TLogLevel LogLevel, const ui16 HttpCode, const TString& id);
    void WriteLogFull(const TLogLevel LogLevel, const ui16 HttpCode, const TString& id);
    void WriteLogExt(const TLogLevel LogLevel, const ui16 HttpCode, const TString& id, const TString& dob);
    void WriteLogMin(const TLogLevel LogLevel, const ui16 HttpCode, const char* sdob, const TString& id);
    void WriteProcRequest(const ui32 ReqProcTime, const int HttpStatus, const char* Message, const char* Request, const TString& id);

    TString GetValueCheck(TReqParams::iterator& it);
    TString TransformRequest(const TString& request);
    ui64 CalcSumm(const char* buff);
    TString ModNumbrequest(const TReqParams& paramlist, const TString& Numbrequest);

    TString GetServerIdent() {
        return m_server_ident;
    }
    TString GetRemoteServerIdent() {
        return m_remote_server_id;
    }
    TString GetAllHeaders() {
        return all_headers;
    }
    virtual bool ActionWOParse(const TString& Ident, TRequestDopData& data, const TString& InRequest, const TString& NumbRequest, const TString& request_source, int thread_index) = 0;
    virtual bool ActionParse(const TString& Ident, TRequestDopData& data, TReqParams* m_ReqParams,
                             const TString& NumbRequest, const TString& requrl,
                             int thread_index) = 0;

    TString HTTP_200_OK(const TString& request_id) {
        return "Status: 200 OK\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_200_OK_XML(const TString& request_id) {
        return "Status: 200 OK\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nContent-type: text/xml\r\n\r\n";
    }
    TString HTTP_200_OK_JSON(const TString& request_id) {
        return "Status: 200 OK\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nContent-type: application/json\r\n\r\n";
    }
    TString HTTP_200_OK_Plain(const TString& request_id) {
        return "Status: 200 OK\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nContent-type: text/plain\r\n\r\n";
    }
    TString HTTP_200_OK(const TString& request_id, ui32 delay) {
        return "Status: 200 OK\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nRequestTime: " + IntToStroka(delay) + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_200_OK_Plain(const TString& request_id, ui32 delay) {
        return "Status: 200 OK\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nRequestTime: " + IntToStroka(delay) + "\r\nContent-type: text/plain\r\n\r\n";
    }
    TString HTTP_200_OK_UNISTAT() const;
    TString HTTP_400_BAD_REQUEST(const TString& request_id) {
        return "Status: 400 Bad Request\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_400_BAD_REQUEST(const TString& request_id, ui32 delay) {
        return "Status: 400 Bad Request\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nRequestTime: " + IntToStroka(delay) + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_403_FORBIDDEN(const TString& request_id) {
        return "Status: 403 Forbidden\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_404_NOT_FOUND(const TString& request_id) {
        return "Status: 404 Not Found\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nRequestID: " + request_id + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_500_INTERNAL_SERVER_ERROR() {
        return "Status: 500 Internal Server Error\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_501_NOT_IMPLEMENTED() {
        return "Status: 501 Not Implemented\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_503_SERVICE_UNAVAILABLE() {
        return "Status: 503 Service Unavailable\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nContent-type: text/html\r\n\r\n";
    }
    TString HTTP_509_BANDWIDTH_LIMIT_EXCEEDED() {
        return "Status: 509 Bandwidth Limit Exceeded\r\nServer: " + m_servername + "\r\nServerID: " + GetServerIdent() + "\r\nContent-type: text/html\r\n\r\n";
    }

public:
    TMakeRequestBase(TServiceObjectBase& srvcobjA, void* serverA);
    virtual ~TMakeRequestBase() = default;

    bool Reply(void* outA, TWStrokaHash* headers, char* dataA, ui32 datasizeA, int thread_index, TMakeRqstDelays* work_delaysA);

    void Info();
};
