#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>
#include <util/string/ascii.h>
#include "tratesrvc.h"

TRateSrvc::TRateSrvc() {
    m_type_instance = TI_STANDART;
    LogsGroup = NULL;
    m_critical_serial_diap_min = 30;
    m_critical_summary_diap_min = 120;
    Clear();
}

TRateSrvc::~TRateSrvc() {
}

void TRateSrvc::Lock() {
    m_mutex.Acquire();
}

void TRateSrvc::UnLock() {
    m_mutex.Release();
}

void TRateSrvc::Init(TLogsGroupBase* LogsGroupA, int critical_serial_diap_minA, int critical_summary_diap_minA, const TString& type_instance) {
    auto type_instance_s = Trim(type_instance);

    if (AsciiEqualsIgnoreCase(type_instance_s, "minor_forever"))
        m_type_instance = TI_MINOR_FOREVER;
    else if (AsciiEqualsIgnoreCase(type_instance_s, "debug"))
        m_type_instance = TI_DEBUG;
    else if (AsciiEqualsIgnoreCase(type_instance_s, "readonly"))
        m_type_instance = TI_READONLY;
    else
        m_type_instance = TI_STANDART;

    LogsGroup = LogsGroupA;
    m_critical_serial_diap_min = critical_serial_diap_minA;
    m_critical_summary_diap_min = critical_summary_diap_minA;
}

void TRateSrvc::Clear() {
    memset(today_data, 0, sizeof(today_data));
    memset(yesterday_data, 0, sizeof(yesterday_data));
    current_year = 0;
    current_day = 0;
    calc_year = 0;
    calc_day = 0;
    calc_hour = 0;
    calc_min = 0;
    last_rating = 100;
}

void TRateSrvc::Reset() {
    Lock();

    Clear();

    UnLock();
}

float TRateSrvc::AddRequest1() {
    float res = 0;

    res = AddRequest(time(NULL));

    return res;
}

float TRateSrvc::GetLastRating()
{
   return last_rating;
}

float TRateSrvc::AddRequest(time_t tick) {
    float res = 0;
    tm tt;

    if (localtime_r(&tick, &tt) != NULL) {
        if ((current_year == 0) && (current_day == 0)) //�������������� ����� ������ ���������� ��� ������
        {
            Lock();

            current_year = tt.tm_year;
            current_day = tt.tm_yday;

            //�������������� true, ����� ����� ������ ���������� ��� ������ ������� ��� ������������
            //yesterday
            for (int i = 0; i < 24; i++) {
                for (int j = 0; j < 60; j++)
                    yesterday_data[i][j] = true;
            }

            //today
            for (int i = 0; i <= tt.tm_hour; i++) {
                if (i == tt.tm_hour) {
                    for (int j = 0; j < tt.tm_min; j++)
                        today_data[i][j] = true;
                } else {
                    for (int j = 0; j < 60; j++)
                        today_data[i][j] = true;
                }
            }

            UnLock();
        }
        if ((current_year == tt.tm_year) && (current_day == tt.tm_yday)) //���� �� ��������
        {
            if (!today_data[tt.tm_hour][tt.tm_min]) {
                Lock();
                today_data[tt.tm_hour][tt.tm_min] = true;
                UnLock();
            }

            if ((calc_year != tt.tm_year) || (calc_day != tt.tm_yday) || (calc_hour != tt.tm_hour) || (calc_min != tt.tm_min)) {
                res = CalcRatingTwoDay(tt);
                Lock();
                calc_year = tt.tm_year;
                calc_day = tt.tm_yday;
                calc_hour = tt.tm_hour;
                calc_min = tt.tm_min;
                last_rating = res;
                UnLock();
            } else
                res = last_rating;

        } else if ((current_year == tt.tm_year) && (tt.tm_yday > current_day) && ((tt.tm_yday - current_day) == 1)) //������ ��������� ����
        {
            Lock();

            for (int i = 0; i < 24; i++) {
                for (int j = 0; j < 60; j++) {
                    yesterday_data[i][j] = today_data[i][j];
                    today_data[i][j] = false;
                }
            }

            today_data[tt.tm_hour][tt.tm_min] = true;

            current_year = tt.tm_year;
            current_day = tt.tm_yday;

            UnLock();

            res = CalcRatingTwoDay(tt);

            Lock();
            last_rating = res;
            UnLock();

        } else if ((tt.tm_year > current_year) && ((tt.tm_year - current_year) == 1) && (tt.tm_yday < current_day)) //������ ��������� ���
        {
            Lock();

            for (int i = 0; i < 24; i++) {
                for (int j = 0; j < 60; j++) {
                    yesterday_data[i][j] = today_data[i][j];
                    today_data[i][j] = false;
                }
            }

            today_data[tt.tm_hour][tt.tm_min] = true;

            current_year = tt.tm_year;
            current_day = tt.tm_yday;

            UnLock();

            res = CalcRatingTwoDay(tt);

            Lock();
            last_rating = res;
            UnLock();

        } else {
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "Bad change time: new(y-d)=%d-%d, current(y-d)=%d-%d. Ignore.", tt.tm_year, tt.tm_yday, current_year, current_day);
        }
    }

    return res;
}

float TRateSrvc::CalcRatingTwoDay(tm& tt) {
    float res = 0;
    ui32 bad_count = 0;
    ui32 all_count = 0;
    ui32 bad_count_serial = 0;
    ui32 bad_count_max_seria = 0;

    bad_count = 0;
    bad_count_serial = 0;
    bad_count_max_seria = 0;

    //yesterday
    for (int i = 0; i < 24; i++) {
        for (int j = 0; j < 60; j++) {
            if (!yesterday_data[i][j]) {
                bad_count++;
                bad_count_serial++;
            } else {
                if (bad_count_serial > bad_count_max_seria)
                    bad_count_max_seria = bad_count_serial;
                bad_count_serial = 0;
            }
            all_count++;
        }
    }

    //today
    for (int i = 0; i <= tt.tm_hour; i++) {
        if (i == tt.tm_hour) {
            for (int j = 0; j < tt.tm_min; j++) {
                if (!today_data[i][j]) {
                    bad_count++;
                    bad_count_serial++;
                } else {
                    if (bad_count_serial > bad_count_max_seria)
                        bad_count_max_seria = bad_count_serial;
                    bad_count_serial = 0;
                }

                all_count++;
            }
        } else {
            for (int j = 0; j < 60; j++) {
                if (!today_data[i][j]) {
                    bad_count++;
                    bad_count_serial++;
                } else {
                    if (bad_count_serial > bad_count_max_seria)
                        bad_count_max_seria = bad_count_serial;
                    bad_count_serial = 0;
                }
                all_count++;
            }
        }
    }
    if (bad_count_serial > bad_count_max_seria)
        bad_count_max_seria = bad_count_serial;

    if (bad_count_max_seria >= m_critical_serial_diap_min)
        res = 0;
    else {
        int all_count_mod = 0;
        int bad_count_mod = 0;

        all_count_mod = (all_count > m_critical_summary_diap_min) ? m_critical_summary_diap_min : all_count;
        bad_count_mod = (bad_count > all_count_mod) ? all_count_mod : bad_count;

        res = (float)100 - ((float)100 * (float)bad_count_mod / (float)all_count_mod);
    }

    return res;
}

TString InstanceTypeToStroka(TRateSrvc::TTypeInstance instance_type) {
    TString res = "";

    switch (instance_type) {
        case TRateSrvc::TI_STANDART:
                                            res = "standart";
                                            break;
        case TRateSrvc::TI_MINOR_FOREVER:
                                            res = "minor_forever";
                                            break;
        case TRateSrvc::TI_DEBUG:
                                            res = "debug";
                                            break;
        case TRateSrvc::TI_READONLY:
                                            res = "readonly";
                                            break;
    };

    return res;
}
