#pragma once

#include "util/datetime/systime.h"
#include "util/generic/string.h"
#include "util/system/mutex.h"

class TRateSrvc {
public:
    enum TTypeInstance { TI_STANDART,
                         TI_MINOR_FOREVER,
                         TI_DEBUG,
                         TI_READONLY};

private:
    TTypeInstance m_type_instance;
    TLogsGroupBase* LogsGroup;
    bool today_data[24][60];
    bool yesterday_data[24][60];
    int current_year;
    int current_day;
    TMutex m_mutex;
    int calc_year;
    int calc_day;
    int calc_hour;
    int calc_min;
    float last_rating;
    int m_critical_serial_diap_min;  //����� ���������������� ����� ��� �������, ����� �� �������� ������� 0
    int m_critical_summary_diap_min; //��������� ����� ����� ��� ������� �� �����/�������, ����� �� �������� ������� 0

    float CalcRatingTwoDay(tm& tt);
    void Lock();
    void UnLock();
    void Clear();
    float AddRequest(time_t tick);

public:
    TRateSrvc();
    ~TRateSrvc();

    void Init(TLogsGroupBase* LogsGroupA, int critical_serial_diap_minA, int critical_summary_diap_minA, const TString& type_instance);
    void Reset();
    float AddRequest1();
    TTypeInstance GetTypeInstance() {
        return m_type_instance;
    }
    float GetLastRating();
};

TString InstanceTypeToStroka(TRateSrvc::TTypeInstance instance_type);
