#include <util/system/hostname.h>
#include <util/string/reverse.h>

#include <library/cpp/digest/old_crc/crc.h>
#include <mail/so/spamstop/tools/so-common/shtime.h>

#include "tserviceobjectbase.h"

//****************************************************************************************
//                                  TNumberRequestClass
//****************************************************************************************

TNumberRequestClass::TNumberRequestClass() {
    int startcode = 0;
    char buff[16];

    memset(buff, 0, sizeof(buff));
    startcode = time(NULL) % 0xFFFF;
    snprintf(buff, sizeof(buff) - 1, "%04x", startcode);
    timecode = TString(buff);

    last_sec = 0;
    number = 0;
    hostname = "";
    hostcode = "";
}

void TNumberRequestClass::Init() {
    last_sec = 0;
    number = 0;
    hostname = HostName();
    ui16 crcval = crc16(hostname.c_str(), hostname.size());

    char buf[10];
    sprintf(buf, "%04x", static_cast<int>(crcval));
    hostcode = buf;
}

TNumberRequestClass::~TNumberRequestClass() {
}

ui64 TNumberRequestClass::GetNumber() {
    ui64 res = 0;
    time_t t = time(NULL);

    m_Mutex.Acquire();

    if (t == last_sec) {
        number++;
        res = (ui64)last_sec * (ui64)100000 + (ui64)number;
    } else {
        res = (ui64)t * (ui64)100000;
        last_sec = t;
        number = 0;
    }

    m_Mutex.Release();

    return res;
}

TString TNumberRequestClass::GetNumberS(bool second) {
    TString res = "";

    if (second)
        res = "##" + hostcode + "-" + UI64ToStroka(GetNumber()) + "S";
    else
        res = "##" + hostcode + "-" + UI64ToStroka(GetNumber()) + "F";

    return res;
}

TString TNumberRequestClass::GetHostName() const {
    return hostname;
}

TString TNumberRequestClass::GetHostCode() const {
    return hostcode;
}

TString TNumberRequestClass::GetTimeCode() const {
    return timecode;
}

TString TNumberRequestClass::GetSummCode() const {
    TString res = "";

    res = timecode + "-" + hostcode;
    res = to_upper(res);

    return res;
}

//*****************************************************************************************
//                                     TServiceObjectBase
//*****************************************************************************************

TServiceObjectBase::TServiceObjectBase()
    : m_listen_streamcount()
{
    m_listenQueueBacklog = 0;
    m_streamcount = 0;
    m_queuesize = 0;
    m_daemonize = true;
    m_start_time_tick = 0;
    LogsGroup = NULL;
    m_generalobject = NULL;
    m_start_init = 0;
}

TServiceObjectBase::~TServiceObjectBase() {
}

void TServiceObjectBase::Close() {
    if (m_generalobject != NULL) {
        m_generalobject->Close();
        DeleteGeneralObject(&m_generalobject);
    }
    if (LogsGroup != NULL)
        DeleteLogsGroup(&LogsGroup);
}

bool TServiceObjectBase::InitBeforeFork(const char* ModulenameA, const char* config_filenameA, const char* ServerName) {
    bool res = false;
    TString s = "";
    const char* p = NULL;
    ui32 count = 0;
    char CurTime[CShingleTime::MAX_TIME_SIZE];
    TString server_alias = "";

    m_start_init = CShingleTime::GetMs();
    NumberRequest.Init();
    CShingleTime::GetTimeStr(CurTime);
    m_start_time = TString(CurTime);
    m_start_time_tick = static_cast<ui32>(time(NULL));
    //m_server_name = TString(ServerName);
    m_modulename = TString(ModulenameA);
    ReverseInPlace(m_modulename);
    p = strstr(m_modulename.c_str(), "/");
    if (p == NULL)
        p = strstr(m_modulename.c_str(), "\\");
    if (p != NULL) {
        count = p - m_modulename.c_str();
        if (count > 0)
            m_modulename = TString(m_modulename.c_str(), count);
    }
    ReverseInPlace(m_modulename);

    LogsGroup = CreateLogsGroup();
    m_generalobject = CreateGeneralObject();

    m_config_filename = TString(config_filenameA);

    res = IniFileObj.Load(m_config_filename);
    if (res) {
        server_alias = IniFileObj.ReadStroka("server", "alias", "");

        if (LogsGroup != NULL) {
            res = LogsGroup->Init(&IniFileObj);
            LogsGroup->SetServerID(GetNumberRequest()->GetSummCode());
            if ((res) && (LogsGroup->GetServerLog() != NULL)) {
                LogsGroup->GetServerLog()->WriteMessage("\n");
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "********** Start application %s (%s: %s) **********", ServerName, NumberRequest.GetHostName().c_str(), NumberRequest.GetSummCode().c_str());
            }
        }
    }

    if (server_alias.empty())
        m_server_name = TString(ServerName);
    else
        m_server_name = server_alias  + " (" + Trim(ServerName) + ")";

    if (m_generalobject != NULL)
        m_generalobject->SetHostNameAndCode(NumberRequest.GetHostName(), NumberRequest.GetHostCode(), GetStartTime(), GetServerName());

    if ((res) && (m_generalobject != NULL))
        res = m_generalobject->InitBeforeFork(NumberRequest.GetSummCode(), LogsGroup, &IniFileObj);
    else
        res = false;

    if (res) {
        m_streamcount = IniFileObj.ReadInteger("fcgi", "threads", 16);
        m_listen_streamcount = IniFileObj.ReadInteger("fcgi", "listen_threads", 16);
        m_queuesize = IniFileObj.ReadInteger("fcgi", "queue_size", 32);
        m_port = IniFileObj.ReadStroka("fcgi", "port", "");
        m_listenQueueBacklog = IniFileObj.ReadInteger("fcgi", "listenQueueBacklog", LISTEN_QUEUE_BACK_LOG_DEFAULT);
        m_daemonize = IniFileObj.ReadBool("server", "daemonize", true);
    }

    return res;
}

void TServiceObjectBase::InitSpTop(TSoConfig& /*sptop*/) { /*
   #ifdef MODSP
   sptop.SetdnRules(IniFileObj.ReadStroka("filter", "rules", ""));
   sptop.SetScore(IniFileObj.ReadFloat("filter", "score", 1.5));
   //en_repopt_no
   //en_repopt_compact
   //en_repopt_full
   //en_repopt_genetic
   //sptop.SetReportType(en_repopt_no);
   //sptop.SetfnFilterLog(IniFileObj.ReadStroka("filter", "filterlog", ""));
   //sptop.SetfnDeliveryLog(IniFileObj.ReadStroka("filter", "deliverylog", ""));
   #endif

*/
}

bool TServiceObjectBase::InitAfterFork() {
    bool res = false;
    ui32 compleate_init = 0;

    if (m_generalobject != NULL)
        res = m_generalobject->InitAfterFork();

    compleate_init = CShingleTime::GetMs() - m_start_init;
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL)) {
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "Application init - OK (%u msec)", compleate_init);
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "Application is started and ready to work!");
    }
    printf("Application init - OK (%u msec)\n", compleate_init);
    printf("Application is started and ready to work!\n");

    return res;
}

/*
TLogsGroupBase *TServiceObjectBase::CreateLogsGroup()
{
   TLogsGroupBase *res = NULL;

   res = new TLogsGroupBase();

   return res;
}

void TServiceObjectBase::DeleteLogsGroup(TLogsGroupBase **mrp)
{
   if ( (mrp != NULL) && ((*mrp) != NULL) )
   {
      delete (*mrp);
      (*mrp) = NULL;
   }
}

TGeneralServiceObject *TServiceObjectBase::CreateGeneralObject()
{
   TGeneralServiceObject *res = NULL;

   res = new TGeneralServiceObject();

   return res;
}

void TServiceObjectBase::DeleteGeneralObject(TGeneralServiceObject **mrp)
{
   if ( (mrp != NULL) && ((*mrp) != NULL) )
   {
      delete (*mrp);
      (*mrp) = NULL;
   }
}
*/

//****************************************************************************************
