#pragma once

#include <mail/so/spamstop/tools/so-common/tkinifile.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>

#include <util/system/mutex.h>

#include "tgeneralserviceobject.h"

//****************************************************************************************
//                                  TNumberRequestClass
//****************************************************************************************

class TNumberRequestClass {
private:
    time_t last_sec;
    ui32 number;
    TString hostname;
    TString hostcode;
    TString timecode;
    TMutex m_Mutex;

public:
    TNumberRequestClass();
    ~TNumberRequestClass();

    void Init();
    ui64 GetNumber();
    TString GetNumberS(bool second);
    TString GetHostName() const;
    TString GetHostCode() const;
    TString GetTimeCode() const;
    TString GetSummCode() const;
};

//*****************************************************************************************
//                                     TServiceObjectBase
//*****************************************************************************************

class TSoConfig;
class TServiceObjectBase {
public:
    static const int LISTEN_QUEUE_BACK_LOG_DEFAULT = 128;

private:
    TString m_modulename;
    TString m_config_filename;
    TKConfig IniFileObj;
    TLogsGroupBase* LogsGroup = nullptr;
    TNumberRequestClass NumberRequest;
    TString m_port;
    int m_listenQueueBacklog;
    ui32 m_streamcount;
    ui32 m_listen_streamcount;
    ui32 m_queuesize;
    bool m_daemonize;
    TString m_server_name;
    TString m_start_time;
    ui32 m_start_time_tick;
    TGeneralServiceObject* m_generalobject = nullptr; //object that contains all the bases and logic of the service
    ui32 m_start_init;

public:
    TServiceObjectBase();
    virtual ~TServiceObjectBase();

    virtual bool InitBeforeFork(const char* ModulenameA, const char* config_filenameA, const char* ServerName); //before fork
    virtual bool InitAfterFork();                                                                               //after fork
    virtual void InitSpTop(TSoConfig& sptop);
    void Close();

    TKConfig* GetConfigObject() {
        return &IniFileObj;
    }
    TLogsGroupBase* GetLogsGroup() {
        return LogsGroup;
    }
    TNumberRequestClass* GetNumberRequest() {
        return &NumberRequest;
    }
    TString ConfigFilename() {
        return m_config_filename;
    }
    TString ModuleName() {
        return m_modulename;
    }
    TGeneralServiceObject* GetGeneralObject() {
        return m_generalobject;
    }
    //first port
    TString Port() {
        return m_port;
    }
    int ListenQueueBackLog() {
        return m_listenQueueBacklog;
    }
    ui32 StreamCount() {
        return m_streamcount;
    }
    ui32 ListenStreamCount() {
        return m_listen_streamcount;
    }
    ui32 QueueSize() {
        return m_queuesize;
    }
    bool Daemonize() {
        return m_daemonize;
    }

    TString GetStartTime() {
        return m_start_time;
    }

    ui32 GetStartTimeTick() {
        return m_start_time_tick;
    }

    TString GetServerName() {
        return m_server_name;
    }

    virtual TLogsGroupBase* CreateLogsGroup() = 0;
    virtual void DeleteLogsGroup(TLogsGroupBase** mrp) = 0;
    virtual TGeneralServiceObject* CreateGeneralObject() = 0;
    virtual void DeleteGeneralObject(TGeneralServiceObject** mrp) = 0;
};

//***************************************************************************************
