#include "Python.h"
#include <util/system/types.h>
#include <util/digest/fnv.h>

static PyObject * hash32(PyObject *self, PyObject *args)
{
    const char* data;

    if (!PyArg_Parse(args, "s", &data))
        return NULL;
    size_t size = sizeof(data);
    ui64 result = FnvHash<ui32>(data, size);

    return Py_BuildValue("k", result);
}

static PyObject * hash64(PyObject *self, PyObject *args)
{
    const char* data;

    if (!PyArg_Parse(args, "s", &data))
        return NULL;
    size_t size = sizeof(data);
    ui64 result = FnvHash<ui64>(data, size);

    return Py_BuildValue("K", result);
}

static PyMethodDef FnvHashMethods[] = {
    {"hash32", hash32, METH_O, "Make 32-bit hash."},
    {"hash64", hash64, METH_O, "Make 64-bit hash."},
    {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC
init_fnvhash(void)
{
    PyObject *m;

    m = Py_InitModule("_fnvhash", FnvHashMethods);
    if (m == NULL)
        return;
}

