#pragma once

#define KPHAM 0
#define KPSPAM 85
#define KPMALIC 100
#define KPUNKNOWN 101

#define MAXREADDUMPBUFFER 5000000

#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>

inline ui64 Shingle(const TString& value) {
    ui64 res = 0;
    ui64 tres = 0;
    char sshingle[32];

    if (!value.empty()) {
        if (value.length() >= 4) {
            calc_strcrc64(value.c_str(), static_cast<int>(value.length()), sshingle);
            sscanf(sshingle, "%lx", &res);
        } else {
            for (size_t i = 0; i < value.length(); i++) {
                tres = value[i];
                tres = tres << (i * 8);
                res = res + tres;
            }
        }
    }

    return res;
}
//****************************************************************************************************************
//                                                TPackHint
//****************************************************************************************************************

class TPackHint {
private:
    ui64 part1{};
    ui64 part2{};

public:
    Y_SAVELOAD_DEFINE(part1, part2)
    TPackHint() {
        Clear();
    }
    TPackHint(ui64 part1A, ui64 part2A) {
        Clear();
        part1 = part1A;
        part2 = part2A;
    }

    void Clear() {
        part1 = 0;
        part2 = 0;
    }
    bool operator==(const TPackHint& value) const {
        return ((part1 == value.part1) && (part2 == value.part2));
    }
    [[nodiscard]] TString GetStr() const {
        return UnPack64Compat(part1) + "." + UnPack64Compat(part2);
    }
};

//******************************************************************************
//                               TCountValue
//******************************************************************************

class TCountValue {
private:
    ui32 m_Count{};

public:
    Y_SAVELOAD_DEFINE(m_Count)
    TCountValue() {
        Init();
    };
    explicit TCountValue(ui32 value) {
        m_Count = value;
    };
    void Init() {
        m_Count = 0;
    };
    void Update(const TCountValue& Stat) {
        m_Count += Stat.m_Count;
    };
    [[nodiscard]] ui32 GetCount() const {
        return m_Count;
    };
    [[nodiscard]] size_t size() const {
        return sizeof(m_Count);
    };
    TCountValue operator+(TCountValue& value) {
        m_Count += value.m_Count;
        return *this;
    }
};

//******************************************************************************
//                             TCountAndIPValue
//******************************************************************************

class TCountAndIPValue {
private:
    ui32 m_Count{};
    TKIPv6 m_ip;

public:
    Y_SAVELOAD_DEFINE(m_Count, m_ip)
    TCountAndIPValue() = default;
    TCountAndIPValue(ui32 value, TKIPv6 ip) {
        m_Count = value;
        m_ip = ip;
    }

    void Init() {
        m_Count = 0;
        m_ip = TKIPv6();
    }
    void Update(const TCountAndIPValue& Stat) {
        m_Count += Stat.m_Count;
        m_ip = Stat.m_ip;
    }
    [[nodiscard]] ui32 GetCount() const {
        return m_Count;
    }
    [[nodiscard]] TKIPv6 GetIP() const {
        return m_ip;
    }
    [[nodiscard]] size_t size() const {
        return (sizeof(m_Count) + sizeof(m_ip));
    }

    TCountAndIPValue operator+(TCountAndIPValue& value) {
        m_Count += value.m_Count;
        return *this;
    }
};

//*****************************************************************************************************************
//                                                 TExpStruct
//*****************************************************************************************************************

class TExpStruct {
public:
    TString flogin;
    ui32 fuid;
    ui8 fweight;
    ui8 fbackalg;
    bool fpdd;

public:
    TExpStruct(const TString& login, ui32 uid, ui8 weight, ui8 backalg, bool pdd) {
        flogin = login;
        fuid = uid;
        fweight = weight;
        fbackalg = backalg;
        fpdd = pdd;
    }

    [[nodiscard]] TString login() const {
        return flogin;
    }
    [[nodiscard]] ui32 uid() const {
        return fuid;
    }
    [[nodiscard]] ui8 weight() const {
        return fweight;
    }
    [[nodiscard]] ui8 backalg() const {
        return fbackalg;
    }
    [[nodiscard]] bool pdd() const {
        return fpdd;
    }
    [[nodiscard]] TString uids() const {
        TString res = "";
        char m[16];

        memset(m, 0, sizeof(m));
        snprintf(m, sizeof(m) - 1, "%u", fuid);
        res.assign(m);

        return res;
    }
    [[nodiscard]] TString weights() const {
        TString res = "";
        char m[16];

        memset(m, 0, sizeof(m));
        snprintf(m, sizeof(m) - 1, "%u", fweight);
        res.assign(m);

        return res;
    }
    [[nodiscard]] TString pdds() const {
        TString res = "";

        if (fpdd)
            res = " pdd=\"yes\" ";

        return res;
    }
};

typedef std::list<TExpStruct> TExpList;

//****************************************************************************************************************
