#pragma once

#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/so-common/eventhandler.h>
#include "tlogsgroup.h"

//*********************************************************************************************************************************
//                                                    LoggerHandler
//*********************************************************************************************************************************

class LoggerHandler : public nosql::EventHandler
{
    TLogsGroup* LogsGroup;

public:
    LoggerHandler()
    {
        LogsGroup = NULL;
    }

    void Init( TLogsGroup* LogsGroupA )
    {
        LogsGroup = LogsGroupA;
    }

    void Error( const TString& msg )
    {
        if( LogsGroup )
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus( KERROR, "Storage error: %s", msg.c_str() );
    }

    void Info( const TString& msg )
    {
        if( LogsGroup )
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus( KINFO, "Storage info: %s", msg.c_str() );
    }
};

namespace
{
    static LoggerHandler loghandler;
};


//**********************************************************************************************************************************************
