#include "tlogsgroup.h"
#include "tmakerequest.h"
#include "tgeneralobject.h"
#include "tserviceobject.h"
#include "tfcgiserver.h"

#define SERVER_NAME "Frodooborona 1.26 "

TServiceObject ServiceObject;
TFCGIServer fcgi_serv(ServiceObject);

/*HANDLE*/ void* hEventLog = nullptr;

int main(int argc, char* argv[]) {
    int ret_code = 0;

    printf("\n%s\n", SERVER_NAME);

    if (argc < 2) {
        printf("\nUsage: sonline <config_file>\n");
        exit(1);
    }

    if (ServiceObject.InitBeforeFork(argv[0], argv[1], SERVER_NAME)) {
        if (fcgi_serv.InitBeforeFork()) {
            fcgi_serv.InitAfterFork();
            fcgi_serv.WritePid();
            fcgi_serv.Wait();

            fcgi_serv.Close();
        } else {
            printf("Server not started - initialization error, see logs for details\n");
            ret_code = 1;
        }

    } else {
        printf("Server not started - initialization error, see logs for details\n");
        ret_code = 1;
    }

    ServiceObject.Close();

    return 0;
}
