from threading import Thread
from Queue import Queue, Full
from fcgiapp import FCGIAppIpV6
from logger import error, access


class FcgiSender(Thread):
    def __init__(self, host, max_queue_size, timeout=2.0):
        Thread.__init__(self)
        self.daemon = True

        (h, p) = host.rsplit(":", 1)
        self.host = host
        self.fcgi_host = h
        self.fcgi_port = int(p)

        self.timeout = timeout
        self.q = Queue(max_queue_size)
        self.start()

    def add(self, query):
        try:
            self.q.put(query, block=False)
        except Full:
            error("Failed sending to host %s. Queue is full. Query: [%s]" % (self.host, query["REQUEST_URI"]))

    def run(self):
        fcgi = FCGIAppIpV6(host=self.fcgi_host, port=self.fcgi_port)

        while True:
            env = self.q.get()

            query = env["REQUEST_URI"] if "REQUEST_URI" in env else ""

            try:
                status = fcgi(env)
            except Exception, e:
                error("Query [%s] to %s failed. Exception: %s" % (str(query), self.host, str(e)))
                continue

            code = status[0]

            if code.startswith("200"):
                access("Sent to %s %s [%s]" % (self.host, code, query))
            else:
                error("Query [%s] to %s failed. Code: %s" % (str(env), self.host, code))
