import logging
import logging.handlers

TRACE_ID = "trace"
ACCESS_ID = "access"
ACTION_ID = "action"
ERROR_ID = "error"


def configurelog(logid, filename):
    formatter = logging.Formatter("[%(asctime)s] %(message)s", datefmt="%Y.%m.%d %H:%M:%S")

    logger = logging.getLogger(logid)
    handler = logging.handlers.TimedRotatingFileHandler(filename, when='midnight', backupCount=15)
    handler.setFormatter(formatter)
    logger.handlers = []
    logger.addHandler(handler)
    logger.setLevel(logging.INFO)


def log(logid, s):
    logging.getLogger(logid).info(s)


def trace(s):
    log(TRACE_ID, s)


def access(s):
    log(ACCESS_ID, s)


def action(s):
    log(ACTION_ID, s)


def error(s):
    log(ERROR_ID, s)


def logs(logids, s):
    for id in logids:
        log(id, s)
