import subprocess
from logger import action, error


class NginxUpdater:
    def __init__(self, fastcgi_port, template, config, reload_cmd):
        self.nginx_balanced_host = "127.0.0.1:%d" % fastcgi_port
        self.template_data = open(template).read()
        self.config = config
        self.reload_cmd = reload_cmd

    def handle_weight(self, prefered, others):
        try:
            open(self.config, "wt").write(self.template_data.replace("UPSTREAM_HOST", prefered).replace("NGINX_BALANCED_HOST", self.nginx_balanced_host))
            action("Nginx config changed")
        except Exception as e:
            error("Error while update nginx config: " + str(e))
            return

        try:
            subprocess.check_call(self.reload_cmd, shell=True, stdout=open("/dev/null", "wt"), stderr=open("/dev/null", "wt"))
            action("Nginx reloaded")
        except subprocess.CalledProcessError, e:
            error("Error while restarting nginx. Code: %d" % e.returncode)
