from select import poll, POLLIN, POLLOUT, POLLERR


def select(rlist, wlist, xlist, timeout=-1):
    poller = poll()
    for fd in rlist:
        poller.register(fd, POLLIN)
    for fd in wlist:
        poller.register(fd, POLLOUT)
    for fd in xlist:
        poller.register(fd, POLLERR)

    r, w, x = [], [], []
    for (fd, event) in poller.poll(timeout):
        if event & POLLIN:
            r.append(fd)
        if event & POLLOUT:
            w.append(fd)
        if event & POLLERR:
            x.append(fd)

    return r, w, x
