#include "sofilter.h"
#include <mail/so/spamstop/sp/rengine.h>
#include <mail/so/spamstop/sp/spamstop.h>
#include <util/system/fs.h>
#include "tstoragenosql.h"
#include <library/cpp/json/json_writer.h>

CSoFilter::CSoFilter() {
    pStorNoSql = NULL;
    configobj = NULL;
    m_printfieldfilename = "";
    m_rulestatfilename = "";
    m_printfieldobj = NULL;
    m_rulestatlist = NULL;
    check_count = 0;
    BlackList = NULL;
    WhiteList = NULL;
    TrustedList = NULL;
    GruppedNetList = NULL;
    UnGruppedNetList = NULL;
    WhiteListSO = NULL;
    IntranetZoneSO = NULL;
    TrustedZoneSO = NULL;
    LocalZoneSO = NULL;
    NamesList = NULL;
    m_statdata = "";
    savr_ag = 0;
    savr_sg = 0;
    savr_eg = 0;
    savr_hg = 0;
    savr_calc = 0;
    LogsGroup = NULL;
    m_rblconf_enable = false;
    RBLHostObj = NULL;
    FilterPool = NULL;
    filter_prop.Clear();
    MLPoolClients = NULL;
    ytml_label = "mail-so-frodo-ml-log";
    m_async_resolv = false;
    mlyt_writecnt = 0;
}

// Init
//
bool CSoFilter::InitBeforeFork(TKConfig* configobjA, TLogsGroup* LogsGroupA) {
    bool res = true;

    TString usednss = "";

    TString EnableBackAlg = "";
    TString blacklistpath = "";
    TString whitelistpath = "";
    TString trustedlistpath = "";
    bool loadatstartup = false;
    TString gruppedlistpath = "";
    TString ungruppedlistpath = "";
    TString nameslistpath = "";
    TString todaybackup = "";
    TString statfilename = "";
    ui32 ipbasa_recmaxcount = 0;
    ui32 ipbasa_liveday = 0;
    TString ipbasa_dumpfilename = "";
    ui32 ipbasa_queuecapacity = 0;
    ui32 inamebasa_recmaxcount = 0;
    ui32 inamebasa_liveday = 0;
    TString inamebasa_dumpfilename = "";
    ui32 inamebasa_queuecapacity = 0;
    ui32 fnamebasa_recmaxcount = 0;
    ui32 fnamebasa_liveday = 0;
    TString fnamebasa_dumpfilename = "";
    ui32 fnamebasa_queuecapacity = 0;
    ui32 ifnamebasa_recmaxcount = 0;
    ui32 ifnamebasa_liveday = 0;
    TString ifnamebasa_dumpfilename = "";
    ui32 ifnamebasa_queuecapacity = 0;
    TMultiStringList rblconf_status_list;
    TMultiStringListIt rcslit;
    TString whitelistso_filename = "";
    TString intranetzoneso_filename = "";
    TString trustedzoneso_filename = "";
    TString localzoneso_filename = "";

    LogsGroup = LogsGroupA;
    configobj = configobjA;

    if (configobj != NULL) {
        EnableBackAlg = configobj->ReadStroka("filter", "enablebackalg", "");

        blacklistpath = configobj->ReadStroka("lists", "BlackListNet", "");
        whitelistpath = configobj->ReadStroka("lists", "WhiteListNet", "");
        trustedlistpath = configobj->ReadStroka("lists", "TrustedListNet", "");
        gruppedlistpath = configobj->ReadStroka("lists", "GruppedNetList", "");
        ungruppedlistpath = configobj->ReadStroka("lists", "UnGruppedNetList", "");
        nameslistpath = configobj->ReadStroka("lists", "NamesList", "");
        m_printfieldfilename = configobj->ReadStroka("lists", "PrintFieldList", "");
        m_rulestatfilename = configobj->ReadStroka("lists", "RulestatList", "");

        whitelistso_filename = configobj->ReadStroka("lists", "WhiteListSO", "");
        intranetzoneso_filename = configobj->ReadStroka("lists", "IntranetZoneSO", "");
        trustedzoneso_filename = configobj->ReadStroka("lists", "TrustedZoneSO", "");
        localzoneso_filename = configobj->ReadStroka("lists", "LocalZoneSO", "");

        ipbasa_recmaxcount = configobj->ReadInteger("ipbasa", "recmaxcount", 0);
        ipbasa_liveday = configobj->ReadInteger("ipbasa", "liveday", 0);
        ipbasa_dumpfilename = configobj->ReadStroka("ipbasa", "dumpfilename", "");
        ipbasa_queuecapacity = configobj->ReadInteger("ipbasa", "queuecapacity", 0);

        inamebasa_recmaxcount = configobj->ReadInteger("inamebasa", "recmaxcount", 0);
        inamebasa_liveday = configobj->ReadInteger("inamebasa", "liveday", 0);
        inamebasa_dumpfilename = configobj->ReadStroka("inamebasa", "dumpfilename", "");
        inamebasa_queuecapacity = configobj->ReadInteger("inamebasa", "queuecapacity", 0);

        fnamebasa_recmaxcount = configobj->ReadInteger("fnamebasa", "recmaxcount", 0);
        fnamebasa_liveday = configobj->ReadInteger("fnamebasa", "liveday", 0);
        fnamebasa_dumpfilename = configobj->ReadStroka("fnamebasa", "dumpfilename", "");
        fnamebasa_queuecapacity = configobj->ReadInteger("fnamebasa", "queuecapacity", 0);

        ifnamebasa_recmaxcount = configobj->ReadInteger("ifnamebasa", "recmaxcount", 0);
        ifnamebasa_liveday = configobj->ReadInteger("ifnamebasa", "liveday", 0);
        ifnamebasa_dumpfilename = configobj->ReadStroka("ifnamebasa", "dumpfilename", "");
        ifnamebasa_queuecapacity = configobj->ReadInteger("ifnamebasa", "queuecapacity", 0);

        loadatstartup = configobj->ReadBool("backup", "load_at_startup", false);
        todaybackup = configobj->ReadStroka("backup", "today", "");
        statfilename = configobj->ReadStroka("logs", "StatFilename", "");

        ytml_label = configobj->ReadStroka("mlpool", "ytlabel", "mail-so-frodo-ml-log");
    }

    if (!RBLHostObj)
        RBLHostObj = MakeHolder<TRBLHostClass>();
    m_rblconf_enable = configobj->ReadBool("rblconf", "enable", false);

    if(configobj->ReadBool("geoserver", "enable", false)) {
        TClientConfig config;
        config.Host = configobj->ReadStroka("geoserver", "host", "");
        config.Port = configobj->ReadInteger("geoserver", "port", 80);
        config.RequestTimeout = TDuration::MilliSeconds(configobj->ReadInteger("geoserver", "timeout", 150));

        rblClient = MakeHolder<NFuncClient::TRbl>(TRequestClient::TArgs(std::move(config)));
    }
    RBLHostObj->InitByConfig(configobj, LogsGroup->GetLogTrace());

    RBLHostObj->GetInitStatus(rblconf_status_list);
    rcslit = rblconf_status_list.begin();
    while (rcslit != rblconf_status_list.end()) {
        if (!(*rcslit).empty()) {
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", (*rcslit).c_str());
        }

        ++rcslit;
    }

    //machine learning clients
    {
        ml_prop.m_clcount = configobj->ReadInteger("mlpool", "clientcount", 1);
        ml_prop.m_host = configobj->ReadStroka("mlpool", "host", "");
        ml_prop.m_port = configobj->ReadInteger("mlpool", "port", 0);
        ml_prop.m_contimeout = configobj->ReadInteger("mlpool", "connecttimeout", 0);
        ml_prop.m_reqtimeout = configobj->ReadInteger("mlpool", "requesttimeout", 0);
        ml_prop.m_ca = configobj->ReadStroka("mlpool", "ca", TString{});
        if ((ml_prop.m_clcount > 0) && (!ml_prop.m_host.empty()) && (ml_prop.m_port > 0)) {
            MLPoolClients = MakeHolder<poolhttpcl::TPoolHttpClients>("MLPOOL");
            MLPoolClients->Init(ml_prop.m_clcount, ml_prop.m_host, ml_prop.m_port, ml_prop.m_contimeout, ml_prop.m_reqtimeout, LogsGroup->GetLogTrace(), ml_prop.m_onlyipv4, ml_prop.m_ca);
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "Initialization MLPOOL OK (cnt=%d, host='%s', port=%d, cto=%u, rto=%u, onlyipv4=%s).", ml_prop.m_clcount, ml_prop.m_host.c_str(), ml_prop.m_port, ml_prop.m_contimeout, ml_prop.m_reqtimeout, BoolToStroka2(ml_prop.m_onlyipv4).c_str());

        } else {
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "Initialization MLPOOL FAILED (cnt=%d, host='%s', port=%d, cto=%u, rto=%u, onlyipv4=%s).", ml_prop.m_clcount, ml_prop.m_host.c_str(), ml_prop.m_port, ml_prop.m_contimeout, ml_prop.m_reqtimeout, BoolToStroka2(ml_prop.m_onlyipv4).c_str());
        }
    }

    last_reg_time = 0;
    m_statdata = statfilename;

    //filters (rengine) and filter object init
    if (true) {
        filter_prop.dnrules = configobj->ReadStroka("filter", "dnRules", "");
        filter_prop.score = configobj->ReadFloat("filter", "score", 0);
        filter_prop.element_count = configobj->ReadInteger("filter", "filtercount", 1);
        filter_prop.max_server_queuesize = configobj->ReadInteger("fcgi", "threads", 0); //для компенсации задержек

        if ((!filter_prop.dnrules.empty()) && (filter_prop.score > 0) && (filter_prop.element_count > 0)) {
            FilterPool = MakeHolder<TRenginePool>();
            res = FilterPool->Init(LogsGroup, filter_prop.element_count, filter_prop.dnrules, filter_prop.score, NULL);

        } else {
            res = false;
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "Filters init FAILED : no data (rules='%s', score=%f, filtercount=%d).", filter_prop.dnrules.c_str(), filter_prop.score, filter_prop.element_count);
        }
    }
    //IPBASA.InitBeforeFork("ipbasa", configobj, LogsGroup, ipbasa_recmaxcount, ipbasa_liveday, ipbasa_dumpfilename, ipbasa_queuecapacity, false);
    //if (loadatstartup)
    //   IPBASA.ReadDump();

    //INAMEBASA.InitBeforeFork("inamebasa", configobj, LogsGroup, inamebasa_recmaxcount, inamebasa_liveday, inamebasa_dumpfilename, inamebasa_queuecapacity, false);
    //FNAMEBASA.InitBeforeFork("fnamebasa", configobj, LogsGroup, fnamebasa_recmaxcount, fnamebasa_liveday, fnamebasa_dumpfilename, fnamebasa_queuecapacity, false);
    //IFNAMEBASA.InitBeforeFork("ifnamebasa", configobj, LogsGroup, ifnamebasa_recmaxcount, ifnamebasa_liveday, ifnamebasa_dumpfilename, ifnamebasa_queuecapacity, false);

    m_Store.Init(LogsGroup, /*convert*/ false, configobj);

    if (!blacklistpath.empty()) {
        BlackList = MakeHolder<TNetIPv6>("       BLACKLIST");
        BlackList->Init(blacklistpath, LogsGroup->GetServerLog());
    }
    if (!trustedlistpath.empty()) {
        TrustedList = MakeHolder<TNetIPv6>("     TRUSTEDLIST");
        TrustedList->Init(trustedlistpath, LogsGroup->GetServerLog());
    }
    if (!whitelistpath.empty()) {
        WhiteList = MakeHolder<TNetIPv6>("       WHITELIST");
        WhiteList->Init(whitelistpath, LogsGroup->GetServerLog());
    }
    if (!gruppedlistpath.empty()) {
        GruppedNetList = MakeHolder<TNetIPv6>("  GRUPPEDNETLIST");
        GruppedNetList->Init(gruppedlistpath, LogsGroup->GetServerLog());
    }
    if (!ungruppedlistpath.empty()) {
        UnGruppedNetList = MakeHolder<TNetIPv6>("UNGRUPPEDNETLIST");
        UnGruppedNetList->Init(ungruppedlistpath, LogsGroup->GetServerLog());
    }
    if (!whitelistso_filename.empty()) {
        WhiteListSO = MakeHolder<TNetIPv6>("WHITETLISTSO");
        WhiteListSO->Init(whitelistso_filename, LogsGroup->GetServerLog());
    }
    if (!intranetzoneso_filename.empty()) {
        IntranetZoneSO = MakeHolder<TNetIPv6>("INTRANETZONESO");
        IntranetZoneSO->Init(intranetzoneso_filename, LogsGroup->GetServerLog());
    }
    if (!trustedzoneso_filename.empty()) {
        TrustedZoneSO = MakeHolder<TNetIPv6>("TRUSTEDZONESO");
        TrustedZoneSO->Init(trustedzoneso_filename, LogsGroup->GetServerLog());
    }
    if (!localzoneso_filename.empty()) {
        LocalZoneSO = MakeHolder<TNetIPv6>("LOCALZONESO");
        LocalZoneSO->Init(localzoneso_filename, LogsGroup->GetServerLog());
    }

    ReloadBlackList();
    ReloadWhiteList();
    ReloadTrustedList();
    ReloadGruppedNetList();
    ReloadUnGruppedNetList();
    ReloadLoginList();
    ReloadPrintFieldList();
    ReloadRulesStatList();

    ReloadWhiteListSO();
    ReloadIntranetZoneSO();
    ReloadTrustedZoneSO();
    ReloadLocalZoneSO();

    BackSpamAlg.Init(EnableBackAlg, LogsGroup);
    STATO.Init(m_statdata);

    return res;
}

bool CSoFilter::InitAfterFork(TAtomicSharedPtr<TStorageNoSql> pStorNoSqlA) {
    bool res = true;
    TLogClass* pddlog = NULL;
    TLogClass* bboxlog = NULL;

    pStorNoSql = std::move(pStorNoSqlA);

    if (LogsGroup != NULL)
        pddlog = LogsGroup->GetLogPDD();
    PDDObj.Init(configobj, pddlog);

    if (LogsGroup != NULL)
        bboxlog = LogsGroup->GetLogBBox();

    const auto tvmSelfId = static_cast<const NTvmAuth::TTvmId>(configobj->ReadInteger("filter", "self_tvm_id", 0));
    const TString tvmSelfSecret = configobj->ReadStroka("filter", "self_tvm_secret", nullptr);
    TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient;

    if(tvmSelfId && tvmSelfSecret) {
        NTvmAuth::NTvmApi::TClientSettings tvmBBClientSettings;
        tvmBBClientSettings.SetSelfTvmId(tvmSelfId); // tvm resource ID for sp-daemon, refer to ABC

        NTvmAuth::NTvmApi::TClientSettings::TDstMap dsts;
        if(const auto tvmBBId = static_cast<const NTvmAuth::TTvmId>(configobj->ReadInteger("filter", "bb_tvm_id", 0))) {
            dsts["blackbox"] = tvmBBId;
        }
        if(const auto tvmAfId = static_cast<const NTvmAuth::TTvmId>(configobj->ReadInteger("filter", "af_tvm_id", 0))) {
            dsts["af"] = tvmAfId;
        }
        tvmBBClientSettings.EnableServiceTicketsFetchOptions(tvmSelfSecret, std::move(dsts));

        tvmClient = MakeAtomicShared<NTvmAuth::TTvmClient>(tvmBBClientSettings, NTvmAuth::TDevNullLogger::IAmBrave());
    }

    const auto bbHost = configobj->ReadStroka("filter", "bb_host", "");
    if (bbHost) {
        TClientConfig config;
        config.Host = bbHost;
        config.TvmServiceName = "blackbox";
        bbClient = MakeHolder<NFuncClient::CBB>(TRequestClient::TArgs(config).SetTvm(tvmClient));
    }

    if(auto afHost = configobj->ReadStroka("filter", "af_host", "")) {
        TClientConfig config;
        config.Host = std::move(afHost);
        config.TvmServiceName = "af";
        if(auto timeout = configobj->ReadStroka("filter", "af_timeout", "")) {
            config.RequestTimeout = TDuration::Parse(timeout);
        }
        AfClient = MakeHolder<NFuncClient::TAfClient>(TRequestClient::TArgs(std::move(config)).SetTvm(tvmClient));
    }

    if (configobj != NULL) {
        bool resolv_enable = false;

        m_async_resolv = configobj->ReadBool("resolv", "async_mode", false);
        resolv_enable = configobj->ReadBool("resolv", "enable", false);

        if (m_async_resolv && resolv_enable) {
            AsyncResolvCache.Init(RBLHostObj.Get(), configobj, LogsGroup->GetLogTrace());
        }
    }

    return res;
}

bool BadAddress(TString ipaddress) {
    bool res = false;

    if (ipaddress == "127.0.0.1")
        return true;
    if (ipaddress == "unknown")
        return true;
    if (ipaddress == "255.255.255.255")
        return true;
    if ((ipaddress.size() >= 3) && (ipaddress.substr(0, 3) == "10."))
        return true;
    if ((ipaddress.size() >= 4) && (ipaddress.substr(0, 4) == "127."))
        return true;
    if ((ipaddress.size() >= 8) && (ipaddress.substr(0, 8) == "169.254."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.16."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.17."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.18."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.19."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.20."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.21."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.22."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.23."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.24."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.25."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.26."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.27."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.28."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.29."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.30."))
        return true;
    if ((ipaddress.size() >= 7) && (ipaddress.substr(0, 7) == "172.31."))
        return true;
    if ((ipaddress.size() >= 8) && (ipaddress.substr(0, 8) == "192.168."))
        return true;

    return res;
}

void CSoFilter::PrintTwoString(const TString& field_name, const TString& str1, const TString& str2) {
    TString res = "";
    unsigned char uc = 0;
    char sc = 0;
    TString str1_enc = "";
    TString str2_enc = "";

    if (!str1.empty()) {
        for (size_t i = 0; i < str1.length(); i++) {
            sc = str1[i];
            memcpy(&uc, &sc, sizeof(uc));
            str1_enc = str1_enc + "#" + IntToStroka(uc);
        }
    }

    if (!str2.empty()) {
        for (size_t i = 0; i < str2.length(); i++) {
            sc = str2[i];
            memcpy(&uc, &sc, sizeof(uc));
            str2_enc = str2_enc + "#" + IntToStroka(uc);
        }
    }

    res = "fieldname=" + field_name + ",'" + str1 + "'('" + str1_enc + "')='" + str2 + "'('" + str2_enc + "')";
    if ((LogsGroup != NULL) && (LogsGroup->GetDebugInfoLog() != NULL))
        LogsGroup->GetDebugInfoLog()->WriteMessageAndDataStatus(KMESSAGE, "FIELDENCPRINT: %s", res.c_str());
}

TReqParams* CSoFilter::DecodeParams(const TString& Numbrequest, TReqParams* pReqParams) {
    TReqParams* res = NULL;
    ui32 size1 = 0, size2 = 0, size3 = 0;
    TReqParams::iterator par_it;
    TString doccodes = "";
    TString st1 = "", st2 = "";
    ui8 codes_type = 0;
    TString sfirst = "", ssecond = "";
    TString sfirstnew = "", ssecondnew = "";
    TString ssecondtemp = "";
    TString stt1 = "", stt2 = "";

    if (pReqParams != NULL) {
        par_it = pReqParams->find("so_codes");
        if (par_it != pReqParams->end())
            doccodes = par_it->second[0];

        TReqParams* pReqParamsNew = new TReqParams();
        par_it = pReqParams->begin();
        while (par_it != pReqParams->end()) {
            stt1 = par_it->first;
            stt2 = par_it->second[0];
            size1 = par_it->first.size();
            size2 = par_it->second[0].size();
            size3 = size1 > size2 ? size1 : size2;
            TString ts = par_it->second[0];

            //text decoding
            if ((doccodes == "UTF8") || (doccodes == "utf8")) //utf8
                codes_type = 1;
            else if ((doccodes == "WIN1251") || (doccodes == "win1251")) //win
                codes_type = 2;
            else if ((doccodes == "CP1251") || (doccodes == "cp1251")) //win
                codes_type = 2;
            else
                codes_type = 2;

            switch (codes_type) {
                case 1: //utf8
                    sfirst = par_it->first;
                    CGIUnescape(sfirst);

                    ssecond = par_it->second[0];
                    CGIUnescape(ssecond);

                    try {
                        sfirstnew = Recode(CODES_UTF8, CODES_WIN, sfirst);
                    } catch (...) {
                        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s BROKEN_RECODE sfirst='%s'", Numbrequest.c_str(), sfirst.c_str());
                    }

                    try {
                        ssecondnew = Recode(CODES_UTF8, CODES_WIN, ssecond);
                    } catch (...) {
                        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s BROKEN_RECODE sfirst='%s', *ssecond='%s'", Numbrequest.c_str(), sfirst.c_str(), ssecond.c_str());
                    }

                    //PrintTwoString("<1>" + sfirstnew, ssecond, ssecondnew);

                    break;
                case 2: //win1251
                    sfirst = par_it->first;
                    CGIUnescape(sfirst);

                    ssecond = par_it->second[0];
                    CGIUnescape(ssecond);

                    sfirstnew = sfirst;
                    ssecondnew = ssecond;

                    //PrintTwoString("<2>" + sfirstnew, ssecond, ssecondnew);

                    break;
            };
            //add to hash
            (*pReqParamsNew)[sfirstnew] = TReqValues();
            (*pReqParamsNew)[sfirstnew].push_back(RemoveCR(DecodeFromHTML(ssecondnew)));

            ++par_it;
        }
        res = pReqParamsNew;
    }

    return res;
}

void CSoFilter::DeleteParams(TReqParams* pReqParamsNew) {
    if (pReqParamsNew != NULL) {
        pReqParamsNew->clear();
        delete pReqParamsNew;
        pReqParamsNew = NULL;
    }
}

ui32 IncMax32(ui32 value1, ui32 value2, ui32 value3) {
    ui32 res = 0;

    res = IncMax32(value1, value2);
    res = IncMax32(res, value3);

    return res;
}

bool CSoFilter::GetCorrLW(bool correct_login_enable, frodo_st::TCorrLoginWeigthClass& LoginWeightObj, const TString& login, ui8& corr_weigth) {
    bool res = false;
    ui64 login_shingle = 0;
    ui8 val = 0;

    if (correct_login_enable) {
        if (!login.empty()) {
            login_shingle = ShingleFromStroka(login);
            if (login_shingle != 0) {
                val = 0;
                if (LoginWeightObj.Get(login_shingle, val)) {
                    res = true;
                    corr_weigth = val;
                }
            }
        }
    }

    return res;
}

//
// Check fields
//
bool CSoFilter::Check(ui32 /*ReqId*/, TReqParams* pReqParams, TRulesList& /*RulesList*/, bool& Spam, TDelayClass& delays, TRequestInfo& ReqInfo, bool& allowuser, const TString& Numbrequest, bool is_upstream_request, frodo_st::TLongDataRqstInfo& longdatarqstinfo, TSpamonLogStruct& monlogdata, bool correct_login_enable, frodo_st::TCorrLoginWeigthClass& LoginWeightObj) {
    Spam = false;

    m_Mutex.Acquire();
    check_count++;
    m_Mutex.Release();

    ReqInfo.SpamList.clear();

    TLTExtList SpamListExt;
    TLTExtList::iterator SpamListExtIterator;
    bool flag_ok = true;
    TString s_regtime = "";
    TString geos = "";
    TString geos_t = "";
    TString geos_as = "";
    TString geos_tor = "";
    TString host = "";
    TString host_t = "";
    TString host2 = "";
    ui32 uid = 0;
    TKIPv6 blacknet = TKIPv6();
    TKIPv6 trustnet = TKIPv6();
    TKIPv6 whitenet = TKIPv6();
    TKIPv6 gruppednet = TKIPv6();
    TKIPv6 ungruppednet = TKIPv6();
    TString cmp_iname_s = "";
    TString cmp_fname_s = "";
    TString yandexuid_s = "";
    TString yandexuid_timestamp_s = "";
    TString step1time_s = "1000";
    TString step2time_s = "1000";
    TString captchareq_s = "";
    TString captchacount_s = "";
    TString lcheck_s = "1000";
    TReqParams* pReqParamsNew = NULL;
    TString lang = "";
    TString action = "";
    TOData odata;
    TReqParams::iterator par_it;
    CItemStat stat;
    bool fok = false;
    TString ip_s = "";
    ui32 ttt = 0;
    ui32 ttt1 = 0;
    TString stt = "";
    TString stt2 = "";
    ui32 ttt_dublicat_login = 0;

    ttt_dublicat_login = CShingleTime::GetMs();

    //login_src
    par_it = pReqParams->find("login");
    if (par_it != pReqParams->end()) {
        odata.login_src = Trim(par_it->second[0]);
        if (!odata.login_src.empty()) {
            const char* p = strchr(odata.login_src.c_str(), '@');
            if (p != NULL) {
                odata.login_src_domen = TString(p + 1);
                if (!odata.login_src_domen.empty())
                    odata.login_src_domen_puny = ForceHostNameToPunycode(UTF8ToWide(odata.login_src_domen));
            }
        }
    }

    pReqParamsNew = DecodeParams(Numbrequest, pReqParams);

    odata.messnumb = ReqInfo.messnumb;

    //lang
    par_it = pReqParamsNew->find("lang");
    if (par_it != pReqParamsNew->end())
        lang = par_it->second[0];
    else
        lang = "RU";
    lang.to_upper(0, lang.size());
    odata.langstr = "lang_" + lang;

    //action
    par_it = pReqParamsNew->find("action");
    if (par_it != pReqParamsNew->end()) {
        action = Trim(par_it->second[0]);
        odata.passpreqtype_source = action;
        if (action == "lightregister")
            odata.passpreqtype = TP_LIGHTREGISTER;
        else if (action == "regone")
            odata.passpreqtype = TP_REGONE;
        else if (action == "register")
            odata.passpreqtype = TP_REGISTER;
        else if (action == "admsocialreg")
            odata.passpreqtype = TP_ADMSOCIALREG;
        else if (action == "admimportreg")
            odata.passpreqtype = TP_ADMIMPORTREG;
        else if (action == "admreg")
            odata.passpreqtype = TP_ADMREG;

        else if (action == "changepass")
            odata.passpreqtype = TP_CHANGEPASS_BASE;
        else if (action == "change_password_force")
            odata.passpreqtype = TP_CHANGE_PASSWORD_FORCE;
        else if (action == "change_password_to_strong")
            odata.passpreqtype = TP_CHANGE_PASSWORD_STRONG;
        else if (action == "change_password_voluntarily")
            odata.passpreqtype = TP_CHANGE_PASSWORD_VOLUNTARILY;
        else if (action == "change_password")
            odata.passpreqtype = TP_CHANGE_PASSWORD;

        else if (action == "simplereg")
            odata.passpreqtype = TP_SIMPLEREG;
        else if (action == "postregistration")
            odata.passpreqtype = TP_POSTREGISTRATION;
        else if (action == "complete")
            odata.passpreqtype = TP_REQTYPE_COMPLETE;
        else if (action == "phonereg")
            odata.passpreqtype = TP_PHONEREG;
        else if (action == "alternative_phone")
            odata.passpreqtype = TP_ALTERNATIVEPHONE;
        else if (action == "alternative_hint")
            odata.passpreqtype = TP_ALTERNATIVEHINT;
        else if (action == "uncompleted_set_password")
            odata.passpreqtype = TP_UNCOMPLEATESETPASWD;
        else if (action == "complete_pdd")
            odata.passpreqtype = TP_COMPLEATE_PDD;
        else if (action == "directoryreg")
            odata.passpreqtype = TP_DIRECTORYREG;

        else if (action == "change_flushed_password")
            odata.passpreqtype = TP_CHANGE_FLUSHED_PASSWORD;
        else if (action == "kinopoiskreg")
            odata.passpreqtype = TP_KINOPOISK_REG;

        ReqInfo.passpreqtype = odata.passpreqtype;
        ReqInfo.passpreqtype_s = action;
    }
    delays.SetService(TPassportRequestTypeToTString(odata.passpreqtype, odata.passpreqtype_source));

    if (IsChangePass(odata.passpreqtype))
        delays.SetRequestType(true);
    else
        delays.SetRequestType(false);

    //so_uid (remote uid)
    par_it = pReqParamsNew->find("so_uid");
    if (par_it != pReqParamsNew->end()) {
        odata.remote_uid = "#" + TString{Trim(par_it->second[0])};
    }

    //time
    par_it = pReqParamsNew->find("time");
    if (par_it == pReqParamsNew->end()) {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s\tBad request, no 'time' parameter", ReqInfo.messnumb.c_str());
        DeleteParams(pReqParamsNew);
        return false;
    }
    s_regtime = par_it->second[0];
    odata.regtime = atol(s_regtime.c_str());
    if (odata.regtime > last_reg_time) {
        m_Mutex.Acquire();
        last_reg_time = odata.regtime;
        m_Mutex.Release();
    }
    STATO.AddAll(odata.regtime);
    ReqInfo.regrime = odata.regtime;

    //login
    par_it = pReqParamsNew->find("login");
    if (par_it == pReqParamsNew->end()) {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s\tBad request, no 'login' parameter", ReqInfo.messnumb.c_str());
        STATO.AddError(odata.regtime);
        DeleteParams(pReqParamsNew);
        return false;
    }
    odata.login = par_it->second[0];
    ReqInfo.mainlogin = odata.login;

    if (!IsChangePass(odata.passpreqtype))
        odata.login_corr_exists = GetCorrLW(correct_login_enable, LoginWeightObj, ReqInfo.mainlogin, odata.login_corr_weigth);

    delays.SetLogin(odata.login);

    odata.allowuser = AllowUser.ExistsLogin(odata.login);
    allowuser = odata.allowuser;

    //uid
    par_it = pReqParamsNew->find("uid");
    if (par_it != pReqParamsNew->end()) {
        odata.uid = Trim(par_it->second[0]);
        ReqInfo.uid = odata.uid;
    }

    //fuid
    par_it = pReqParamsNew->find("fuid");
    if (par_it != pReqParamsNew->end()) {
        odata.fuid = Trim(par_it->second[0]);
    }

    //iname
    par_it = pReqParamsNew->find("iname");
    if (par_it == pReqParamsNew->end()) {
        odata.iname = "";
        odata.iname_ipv6 = TKIPv6();

    } else {
        odata.iname.assign(par_it->second[0]);
        odata.iname_ipv6 = TStringToTKIPv6(odata.iname);
    }

    //fname
    par_it = pReqParamsNew->find("fname");
    if (par_it == pReqParamsNew->end()) {
        odata.fname = "";
        odata.fname_ipv6 = TKIPv6();

    } else {
        odata.fname.assign(par_it->second[0]);
        odata.fname_ipv6 = TStringToTKIPv6(odata.fname);
    }

    //iname + fname
    if ((!odata.iname.empty()) || (!odata.fname.empty()))
        odata.ifname_ipv6 = TStringToTKIPv6(odata.iname + "-" + odata.fname);

    if ((NamesList) && (NamesList->GetRecordCount() > 0)) {
        ttt = CShingleTime::GetMs();

        odata.in_inamelist = NamesList->Get(odata.iname, lang);
        odata.s_inamelist_cmp = NamesList->GetCompareTRSC(odata.iname, odata.in_inamelist_cmp);

        odata.in_fnamelist = NamesList->Get(odata.fname, lang);
        odata.s_fnamelist_cmp = NamesList->GetCompareTRSC(odata.fname, odata.in_fnamelist_cmp);

        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayNamesLst(ttt, odata.in_inamelist, odata.in_fnamelist);
    }

    if ((odata.iname != "") && (odata.fname != "") && (odata.iname == odata.fname))
        odata.cmp_ifname = true;

    //nickname
    par_it = pReqParamsNew->find("nickname");
    if (par_it == pReqParamsNew->end()) {
        odata.nickname = "";
    } else {
        odata.nickname = par_it->second[0];
    }

    //email
    par_it = pReqParamsNew->find("email");
    if (par_it == pReqParamsNew->end()) {
        odata.email = "";
    } else {
        odata.email = par_it->second[0];
    }

    //social_provider
    par_it = pReqParamsNew->find("social_provider");
    if (par_it != pReqParamsNew->end())
        odata.social_provider = par_it->second[0];

    //IP-address
    par_it = pReqParamsNew->find("ip_from");
    if (par_it == pReqParamsNew->end()) {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s\tBad request, no 'ip_from' parameter", ReqInfo.messnumb.c_str());
        STATO.AddError(odata.regtime);
        DeleteParams(pReqParamsNew);
        return false;
    }
    ip_s = par_it->second[0].c_str();
    if (BadAddress(ip_s)) {
        TReqParams::iterator par_it = pReqParamsNew->find("ip_prox");
        if (par_it == pReqParamsNew->end()) {
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s\tBad request, no 'ip_prox' parameter", ReqInfo.messnumb.c_str());
            STATO.AddError(odata.regtime);
            DeleteParams(pReqParamsNew);
            return false;
        }
        ip_s = par_it->second[0].c_str();
        if (ip_s == "")
            ip_s = "127.0.0.1";
    }
    odata.iplong = TKIPv6(ip_s.c_str());
    if (odata.iplong.Undefined()) {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s\tBad request, ip is undefined (%s)", ReqInfo.messnumb.c_str(), odata.iplong.toStroka().c_str());
        STATO.AddError(odata.regtime);
        DeleteParams(pReqParamsNew);
        return false;
    }
    odata.dublicat_login_count = m_Store.AddGetDublicatLogin(odata.login, odata.iplong).GetCount();
    delays.SetIPType(odata.iplong.IsIPv6());

    ttt = CShingleTime::GetMs(); //check by lists
    {
        if (BlackList)
            odata.blackip = BlackList->IsIncludeNet(odata.iplong, blacknet, odata.blacknet_source);
        if (odata.blackip) {
            delays.SetBlackLogin();
            m_black_counter.Increment();
        }

        if (TrustedList)
            odata.trustip = TrustedList->IsIncludeNet(odata.iplong, trustnet, odata.trustnet_source);
        if (odata.trustip) {
            delays.SetTrustLogin();
            m_trustlogin_counter.Increment();
        }

        if (WhiteList)
            odata.whiteip = WhiteList->IsIncludeNet(odata.iplong, whitenet, odata.whitenet_source);
        if (odata.whiteip) {
            delays.SetWhiteLogin();
            m_white_counter.Increment();
        }

        if (WhiteListSO)
            odata.whiteip_so = WhiteListSO->IsIncludeNet(odata.iplong, odata.whitenet_so_source);
        if (odata.whiteip_so) {
            delays.SetWhiteSOLogin();
            m_whiteso_counter.Increment();
        }

        if (IntranetZoneSO)
            odata.intranetzoneip_so = IntranetZoneSO->IsIncludeNet(odata.iplong, odata.intranetzone_so_source);
        if (odata.intranetzoneip_so) {
            delays.SetIntranetZoneSOLogin();
            m_intranetzoneso_counter.Increment();
        }

        if (TrustedZoneSO)
            odata.trustedzoneip_so = TrustedZoneSO->IsIncludeNet(odata.iplong, odata.trustedzone_so_source);
        if (odata.trustedzoneip_so) {
            delays.SetTrustedZoneSOLogin();
            m_trustedzoneso_counter.Increment();
        }

        if (LocalZoneSO)
            odata.localzoneip_so = LocalZoneSO->IsIncludeNet(odata.iplong, odata.localzone_so_source);
        if (odata.localzoneip_so) {
            delays.SetLocalZoneSOLogin();
            m_localzoneso_counter.Increment();
        }

        if (GruppedNetList)
            odata.gruppedip = GruppedNetList->IsIncludeNet(odata.iplong, gruppednet, odata.gruppednet_source);
        if (odata.gruppedip) {
            delays.SetGruppedIP();
            m_grupp_counter.Increment();
        }

        if (UnGruppedNetList)
            odata.ungruppedip = UnGruppedNetList->IsIncludeNet(odata.iplong, ungruppednet, odata.ungruppednet_source);
        if (odata.ungruppedip) {
            delays.SetUngruppedIP();
            m_ungrupp_counter.Increment();
        }

        if ((odata.gruppedip) && (!odata.ungruppedip)) //корректируем ip-адрес в соответствии со списком группировки
        {
            odata.ip_isx = odata.iplong.toStroka();
            odata.iplong = gruppednet;
            odata.is_corrected = true;
        }
    }
    ttt = CShingleTime::GetMs() - ttt;
    delays.SetDelayLst(ttt);

    //login prefix
    odata.login_prefix = GetLoginPrefix(odata.login);

    //first_n_symb_login
    odata.first_nsymb_login = odata.login.substr(4);

    //password hint
    par_it = pReqParamsNew->find("passwd");
    if (par_it == pReqParamsNew->end()) {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s\tBad request, no 'passwd' parameter", ReqInfo.messnumb.c_str());
        STATO.AddError(odata.regtime);
        DeleteParams(pReqParamsNew);
        return false;
    }
    odata.passwhint_s = par_it->second[0];
    odata.passwhint = Pack32_str2(par_it->second[0]);
    odata.passwhint_sm = ModifyHint(odata.passwhint_s);
    odata.passwhint_m = Pack32_str2(odata.passwhint_sm);

    //passwdex
    par_it = pReqParamsNew->find("passwdex");
    if (par_it != pReqParamsNew->end()) {
        odata.passwdex_s = par_it->second[0];
        odata.passwdex = Pack32_str2(odata.passwdex_s);
        odata.passwdex_sm = ModifyHint(odata.passwdex_s);
        odata.passwdex_m = Pack32_str2(odata.passwdex_sm);
    }
    odata.passwdhintall = TPackHint(odata.passwhint, odata.passwdex);
    odata.passwdhintall_m = TPackHint(odata.passwhint_m, odata.passwdex_m);

    //question hint
    par_it = pReqParamsNew->find("hintq");
    if (par_it == pReqParamsNew->end()) {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s\tBad request, no 'hintq' parameter", ReqInfo.messnumb.c_str());
        STATO.AddError(odata.regtime);
        DeleteParams(pReqParamsNew);
        return false;
    }
    odata.questhint_s = par_it->second[0];
    odata.questhint = Pack64_str2(par_it->second[0]);
    odata.questhint_sm = ModifyHint(odata.questhint_s);
    odata.questhint_m = Pack64_str2(odata.questhint_sm);

    //hintqex
    par_it = pReqParamsNew->find("hintqex");
    if (par_it != pReqParamsNew->end()) {
        odata.hintqex_s = par_it->second[0];
        odata.hintqex = Pack64_str2(odata.hintqex_s);
        odata.hintqex_sm = ModifyHint(odata.hintqex_s);
        odata.hintqex_m = Pack64_str2(odata.hintqex_sm);
    }
    odata.qhintall = TPackHint(odata.questhint, odata.hintqex);
    odata.qhintall_m = TPackHint(odata.questhint_m, odata.hintqex_m);

    //answer hint
    par_it = pReqParamsNew->find("hinta");
    if (par_it == pReqParamsNew->end()) {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s\tBad request, no 'hinta' parameter", ReqInfo.messnumb.c_str());
        STATO.AddError(odata.regtime);
        DeleteParams(pReqParamsNew);
        return false;
    }
    odata.answerhint_s = par_it->second[0];
    odata.answerhint = Pack64_str2(par_it->second[0]);
    odata.answerhint_sm = ModifyHint(odata.answerhint_s);
    odata.answerhint_m = Pack64_str2(odata.answerhint_sm);

    //hintaex
    par_it = pReqParamsNew->find("hintaex");
    if (par_it != pReqParamsNew->end()) {
        odata.hintaex_s = par_it->second[0];
        odata.hintaex = Pack64_str2(odata.hintaex_s);
        odata.hintaex_sm = ModifyHint(odata.hintaex_s);
        odata.hintaex_m = Pack64_str2(odata.hintaex_sm);
    }
    odata.ahintall = TPackHint(odata.answerhint, odata.hintaex);
    odata.ahintall_m = TPackHint(odata.answerhint_m, odata.hintaex_m);

    //hintqid
    par_it = pReqParamsNew->find("hintqid");
    if (par_it != pReqParamsNew->end()) {
        odata.hintqid_s = par_it->second[0];
        odata.hintqid = atoi(odata.hintqid_s.c_str());
    }

    //valkey
    par_it = pReqParamsNew->find("valkey");
    if (par_it != pReqParamsNew->end()) {
        odata.valkey = Trim(par_it->second[0]);
    }

    //from
    par_it = pReqParamsNew->find("from");
    if (par_it != pReqParamsNew->end()) {
        stt = Trim(par_it->second[0]);
        if (!stt.empty()) {
            odata.from_s = stt;
            if (!odata.from_s.empty()) {
                to_lower_k(odata.from_s);
                if (odata.from_s == "intpdd")
                    odata.from_pdd = true;
            }
        }
    }

    //phonenumber
    par_it = pReqParamsNew->find("phonenumber");
    if (par_it != pReqParamsNew->end()) {
        odata.phonenumber_s = par_it->second[0];
    }

    //yandexuid
    par_it = pReqParamsNew->find("yandexuid");
    if (par_it != pReqParamsNew->end()) {
        yandexuid_s = par_it->second[0];
        if (yandexuid_s.size() >= 10) {
            yandexuid_timestamp_s = yandexuid_s.substr(yandexuid_s.size() - 10, 10);
            odata.yandexuid_timestamp = atol(yandexuid_timestamp_s.c_str());
            odata.user_kuka = odata.regtime - odata.yandexuid_timestamp;
        }
    }

    //useragent
    par_it = pReqParamsNew->find("useragent");
    if (par_it != pReqParamsNew->end()) {
        odata.useragent_s = par_it->second[0];
        if (odata.useragent_s == "mobile-account-manager") {
            par_it = pReqParamsNew->find("v2_hardware_model");
            if (par_it != pReqParamsNew->end())
                odata.useragent_s = "mobile-account-manager/" + par_it->second[0];
        }
    }

    par_it = pReqParamsNew->find("v2_cookie_l_timestamp");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_cookie_l_timestamp = atoi(stt2.c_str());
            odata.v2_cookie_l_timestamp_define = true;
            if (odata.regtime > odata.v2_cookie_l_timestamp)
                odata.v2_cookie_l_timestamp_diff = odata.regtime - odata.v2_cookie_l_timestamp;
        }
    }

    par_it = pReqParamsNew->find("v2_cookie_l_login");
    if (par_it != pReqParamsNew->end()) {
        odata.v2_cookie_l_login = Trim(par_it->second[0]);
        if ((!odata.v2_cookie_l_login.empty()) && (!odata.login.empty())) {
            TString stv = odata.login;

            to_lower_k(odata.v2_cookie_l_login);
            to_lower_k(stv);
            if (odata.v2_cookie_l_login.length() == stv.length()) {
                if (memcmp(odata.v2_cookie_l_login.c_str(), stv.c_str(), stv.length()) != 0)
                    odata.v2_cookie_l_login_rate = true;

            } else {
                odata.v2_cookie_l_login_rate = true;
            }
        }
    }

    par_it = pReqParamsNew->find("v2_cookie_l_uid");
    if (par_it != pReqParamsNew->end()) {
        odata.v2_cookie_l_uid = Trim(par_it->second[0]);
        if ((!odata.v2_cookie_l_uid.empty()) && (!odata.uid.empty())) {
            TString stv = odata.uid;

            to_lower_k(odata.v2_cookie_l_uid);
            to_lower_k(stv);
            if (odata.v2_cookie_l_uid.length() == stv.length()) {
                if (memcmp(odata.v2_cookie_l_uid.c_str(), stv.c_str(), stv.length()) != 0)
                    odata.v2_cookie_l_uid_rate = true;

            } else {
                odata.v2_cookie_l_uid_rate = true;
            }
        }
    }

    par_it = pReqParamsNew->find("v2_password_validation_last_call");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_password_validation_last_call = atoi(stt2.c_str());
            odata.v2_password_validation_last_call_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_password_validation_first_call");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_password_validation_first_call = atoi(stt2.c_str());
            odata.v2_password_validation_first_call_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_sanitize_phone_last_call");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_sanitize_phone_last_call = atoi(stt2.c_str());
            odata.v2_sanitize_phone_last_call_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_sanitize_phone_first_call");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_sanitize_phone_first_call = atoi(stt2.c_str());
            odata.v2_sanitize_phone_first_call_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_track_created");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_track_created = atoi(stt2.c_str());
            odata.v2_track_created_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_captcha_checked_at");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_captcha_checked_at = atoi(stt2.c_str());
            odata.v2_captcha_checked_at_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_captcha_generated_at");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_captcha_generated_at = atoi(stt2.c_str());
            odata.v2_captcha_generated_at_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_login_validation_last_call");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_login_validation_last_call = atoi(stt2.c_str());
            odata.v2_login_validation_last_call_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_login_validation_first_call");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_login_validation_first_call = atoi(stt2.c_str());
            odata.v2_login_validation_first_call_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_suggest_login_last_call");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_suggest_login_last_call = atoi(stt2.c_str());
            odata.v2_suggest_login_last_call_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_suggest_login_first_call");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_suggest_login_first_call = atoi(stt2.c_str());
            odata.v2_suggest_login_first_call_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_account_timezone");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_account_timezone = stt2;
            odata.v2_account_timezone_define = true;
        }
    }

    par_it = pReqParamsNew->find("v2_phonenumber_hash");
    if (par_it != pReqParamsNew->end()) {
        stt2 = Trim(par_it->second[0]);
        if (!stt2.empty()) {
            odata.v2_phonenumber_hash = stt2;
            odata.v2_phonenumber_hash_define = true;
            odata.phone_ipv6 = TStringToTKIPv6(odata.v2_phonenumber_hash);
        }
    }

    if (odata.v2_password_validation_last_call_define && odata.v2_password_validation_first_call_define) {
        odata.tm1 = odata.v2_password_validation_last_call - odata.v2_password_validation_first_call;
        odata.tm1_exists = true;
    }

    if (odata.v2_sanitize_phone_last_call_define && odata.v2_sanitize_phone_first_call_define) {
        odata.tm2 = odata.v2_sanitize_phone_last_call - odata.v2_sanitize_phone_first_call;
        odata.tm2_exists = true;
    }

    if (odata.v2_track_created_define && odata.v2_captcha_checked_at_define) {
        odata.tm3 = odata.v2_captcha_checked_at - odata.v2_track_created;
        odata.tm3_exists = true;
    }

    if (odata.v2_captcha_checked_at_define && odata.v2_captcha_generated_at_define) {
        odata.tm4 = odata.v2_captcha_checked_at - odata.v2_captcha_generated_at;
        odata.tm4_exists = true;
    }

    if (odata.v2_login_validation_last_call_define && odata.v2_login_validation_first_call_define) {
        odata.tm5 = odata.v2_login_validation_last_call - odata.v2_login_validation_first_call;
        odata.tm5_exists = true;
    }

    if (odata.v2_suggest_login_last_call_define && odata.v2_suggest_login_first_call_define) {
        odata.tm6 = odata.v2_suggest_login_last_call - odata.v2_suggest_login_first_call;
        odata.tm6_exists = true;
    }

    //step1time
    par_it = pReqParamsNew->find("step1time");
    if (par_it != pReqParamsNew->end()) {
        stt = par_it->second[0];
        if (!stt.empty()) {
            step1time_s = stt;
            odata.step1time = atoi(step1time_s.c_str());
        }
    }

    //step2time
    par_it = pReqParamsNew->find("step2time");
    if (par_it != pReqParamsNew->end()) {
        stt = par_it->second[0];
        if (!stt.empty()) {
            step2time_s = stt;
            odata.step2time = atoi(step2time_s.c_str());
        }
    }

    //captchareq
    par_it = pReqParamsNew->find("captchareq");
    if (par_it != pReqParamsNew->end()) {
        captchareq_s = par_it->second[0];
        odata.captchareq = atoi(captchareq_s.c_str());
    }

    //captchacount
    par_it = pReqParamsNew->find("captchacount");
    if (par_it != pReqParamsNew->end()) {
        captchacount_s = par_it->second[0];
        odata.captchacount = atoi(captchacount_s.c_str());
    }

    //lcheck
    par_it = pReqParamsNew->find("lcheck");
    if (par_it != pReqParamsNew->end()) {
        stt = par_it->second[0];
        if (!stt.empty()) {
            lcheck_s = stt;
            odata.lcheck = atoi(lcheck_s.c_str());
        }
    }

    //utime
    par_it = pReqParamsNew->find("utime");
    if (par_it != pReqParamsNew->end())
        odata.utime_s = par_it->second[0];

    //login length
    odata.login_length = odata.login.length();

    //prefixlogin length
    odata.prefix_login_length = odata.login_prefix.length();

    //vowels_serial_count
    odata.vowels_serial_count = GetVowelsSerialCountEng(odata.login);

    //constanants_serial_count
    odata.constanants_serial_count = GetConstanantsSerialCountEng(odata.login);

    //constanants and digits serial count
    odata.constanants_digits_serial_count = GetConstanantsDigitsSerialCountEng(odata.login);

    //digits_count
    odata.digits_count = GetDigitsLoginCountEng(odata.login);

    //constatnants vowels pairs
    odata.cvpairs = GetPairConstanantsVowelsEng(odata.login);

    //otnoshenie constatnants vowels pairs to loginsize/2
    if (odata.login_length > 0)
        odata.divpaircv = (float)((float)2 * (float)odata.cvpairs / (float)odata.login_length);
    else
        odata.divpaircv = 0;

    //otnoshenie digits_count to loginsize
    if (odata.login_length > 0)
        odata.divdigits = (float)((float)odata.digits_count / (float)odata.login_length);
    else
        odata.divdigits = 0;

    odata.constanants_serial_count_iname = GetConstanantsSerialCountExt(odata.iname);
    odata.vowels_serial_count_iname = GetVowelsSerialCountExt(odata.iname);
    odata.digital_count_iname = GetDigitsLoginCount(odata.iname);
    odata.constanants_serial_count_fname = GetConstanantsSerialCountExt(odata.fname);
    odata.vowels_serial_count_fname = GetVowelsSerialCountExt(odata.fname);
    odata.digital_count_fname = GetDigitsLoginCount(odata.fname);

    //данные с кластеризатора
    {
        ui32 clust_request_time = 0;
        TString clust_login = odata.login;
        TString clust_name = odata.iname;
        TString clust_family = odata.fname;
        TString clust_password = odata.passwhint_s;
        TString clust_phone = odata.phonenumber_s;
        TString clust_iptype = odata.iplong.IsIPv4() ? "v4" : "v6";
        TString clust_reqtype = TPassportRequestTypeToTString(odata.passpreqtype, odata.passpreqtype_source);
        TString clust_v2_account_country = "";
        TString clust_useragent = odata.useragent_s;
        bool clust_is_dublicat_login = false;
        TString change_pass_s = "";
        TString upstream_s = "";

        par_it = pReqParams->find("v2_account_country");
        if (par_it != pReqParams->end())
            clust_v2_account_country = (*par_it).second[0];

        if ((!IsChangePass(odata.passpreqtype)) && (odata.dublicat_login_count > 1))
            clust_is_dublicat_login = true;

        change_pass_s = IsChangePass(odata.passpreqtype) ? "1" : "0";
        upstream_s = is_upstream_request ? "1" : "0";

        CGIEscape(clust_name);
        CGIEscape(clust_family);
        CGIEscape(clust_v2_account_country);
        CGIEscape(clust_useragent);

        poolhttpcl::TDebugTiming clust_debug_time = poolhttpcl::TDebugTiming();
        ttt = CShingleTime::GetMs();

        odata.clust_data_answer_local = {};

        ttt = CShingleTime::GetMs() - ttt;
        clust_request_time = ttt;
    }

    odata.savr = STATO.GetAverage(odata.regtime);
    odata.snow = STATO.GetNow(odata.regtime);
    if ((odata.snow.all != 0) || (odata.snow.spam != 0) || (odata.snow.error != 0) || (odata.snow.ham != 0)) {
        if ((odata.savr.all > 0) && (odata.snow.all > 0))
            odata.savr_oa = ((float)((float)odata.savr.all - (float)odata.snow.all)) / ((float)odata.savr.all);
        if ((odata.savr.spam > 0) && (odata.snow.spam > 0))
            odata.savr_os = ((float)((float)odata.savr.spam - (float)odata.snow.spam)) / ((float)odata.savr.spam);
        if ((odata.savr.error > 0) && (odata.snow.error > 0))
            odata.savr_oe = ((float)((float)odata.savr.error - (float)odata.snow.error)) / ((float)odata.savr.error);
        if ((odata.savr.ham > 0) && (odata.snow.ham > 0))
            odata.savr_oh = ((float)((float)odata.savr.ham - (float)odata.snow.ham)) / ((float)odata.savr.ham);
        if (odata.savr_oa < 0)
            odata.savr_oa = -1 * odata.savr_oa;
        if (odata.savr_os < 0)
            odata.savr_os = -1 * odata.savr_os;
        if (odata.savr_oe < 0)
            odata.savr_oe = -1 * odata.savr_oe;
        if (odata.savr_oh < 0)
            odata.savr_oh = -1 * odata.savr_oh;

        m_MutexAverage.Acquire();
        savr_ag = odata.savr_oa;
        savr_sg = odata.savr_os;
        savr_eg = odata.savr_oe;
        savr_hg = odata.savr_oh;
        savr_calc = odata.regtime;
        m_MutexAverage.Release();
    } else {
        if ((odata.regtime - savr_calc) <= 3600) {
            odata.savr_oa = savr_ag;
            odata.savr_os = savr_sg;
            odata.savr_oe = savr_eg;
            odata.savr_oh = savr_hg;
        }
    }

    ReqInfo.ip = odata.iplong.toStroka();
    ReqInfo.ip_log = odata.iplong.toStroka2();

    //geo and host
    m_Store.GetGeoAndHost(odata.iplong, geos_t, host_t);
    if (!geos_t.empty())
        geos = geos_t;
    if (!host_t.empty()) {
        host = host_t;
        delays.SetDelayHostFromTYCache();
    }

    if (host.empty()) {
        if ((RBLHostObj) && (RBLHostObj->ResolvEnable())) {
            bool resolv_okpr = false;

            ttt = CShingleTime::GetMs();

            if (m_async_resolv) {
                TResolvRecordStructExt resolv_data = TResolvRecordStructExt();

                resolv_data = AsyncResolvCache.GetHost(Numbrequest, odata.iplong);
                if (!resolv_data.m_notfound)
                    host = resolv_data.m_data.m_host;

            } else {
                if (!RBLHostObj->GetResolvData(Numbrequest, odata.iplong, host))
                    host = "";
            }

            if (!host.empty())
                resolv_okpr = true;

            ttt = CShingleTime::GetMs() - ttt;
            delays.SetDelayResolv(ttt, resolv_okpr);
        }
    }

    if (!host.empty())
        odata.ipstate.host = host; //чтобы записать в delivery.log, если регистрация - дубликат логина

    TString ipString = odata.iplong.toStroka();
    if (rblClient && ipString != "-") {
        bool geo_okpr = false;
        TString geos_temp = geos;

        ttt = CShingleTime::GetMs();

        auto responseOrError = rblClient->Perform(ipString, "frodo", NFuncClient::TRbl::GEO_ONLY, false);
        Visit(responseOrError,
              [&](const NFuncClient::TRbl::TResponse &response) mutable {
                  geo_okpr = true;

                  geos = TStringBuilder{} << response.GetIsoName() << ' ' << response.GetCity();
                  geos_as = response.GetLastAsnItem().GetOrElse("");
                  geos_tor = response.IsTor() ? TStringBuf("tor") : TStringBuf("");
              },
              [&](const NCurl::TError &error) mutable {
                  geos = "";
                  geos_as = "";
                  geos_tor = "";
                  geos = geos_temp;
                  Cerr << "rbl:" << error << Endl;
              }
        );

        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayGEO(ttt, geo_okpr);

        if (geo_okpr)
            monlogdata.AddTag("FRODO", "GEO", TSpamonLogStruct::OK, ttt);
        else
            monlogdata.AddTag("FRODO", "GEO", TSpamonLogStruct::RE, ttt);
    }

    if(AfClient) {
        NJson::TJsonValue js;

        for(const auto& [key, values]: *pReqParamsNew) {
            if(values) {
                js[key] = values.front();
            }
        }

        js["ip"] = js["v2_ip"];
        js["yid"] = js["yandexuid"];
        js["channel"] = "auth";
        js["sub_channel"] = "registration";
        js["request"] = "auth";
        js["t"] = js["time"].GetUIntegerRobust() * 1000;
        js["external_id"] = ToString(RandomNumber<ui64>());

        try {
            odata.AfResponse = std::move(AfClient->Perform(NFuncClient::TAfClient::TRequest(std::move(js))).Src);
        } catch(...) {
            Cerr << CurrentExceptionMessageWithBt() << Endl;
        }
    }

    if (!geos.empty())
        m_Store.AddGeoToIP(odata.iplong, geos);

    if (!geos.empty())
        odata.ipstate.geo = geos; //чтобы записать в delivery.log, если регистрация - дубликат логина

    if ((!geos.empty()) && (odata.v2_account_timezone_define) && (!odata.v2_account_timezone.empty()))
        odata.timezone_diff = (int)GetTimeDiff(odata.v2_account_timezone, geos) / (int)3600;

    if (!geos.empty())
        odata.is_night = IsNight(geos, odata.regtime);

    if (!geos_as.empty())
        odata.geos_as = geos_as;

    if (!geos_tor.empty())
        odata.geos_tor = geos_tor;

    if (geos.length() >= 2) {
        TString ru_geo = geos.substr(0, 2);

        if (ru_geo == "RU")
            delays.SetDelayGEORU();
    }

    //rbl rules
    if (RBLHostObj) {
        if (m_rblconf_enable) {
            ttt = CShingleTime::GetMs();
            RBLHostObj->GetWorkRules(Numbrequest, odata.iplong, odata.rbl_rulelist);
            ttt = CShingleTime::GetMs() - ttt;
            delays.SetDelayRBLRule(ttt, odata.rbl_rulelist);

            monlogdata.AddTag("FRODO", "RBL", TSpamonLogStruct::OK, ttt);
        }
    }

    //ipv6 maska
    if (odata.iplong.IsIPv6()) {
        odata.ipv6maska1 = m_Store.AddIPv6Maska1(odata.iplong.GetAddressByMask(64).AsShingle64(), 1).GetCount();
        odata.ipv6maska2 = m_Store.AddIPv6Maska2(odata.iplong.GetAddressByMask(48).AsShingle64(), 1).GetCount();
        odata.ipv6maska3 = m_Store.AddIPv6Maska3(odata.iplong.GetAddressByMask(32).AsShingle64(), 1).GetCount();

    } else {
        odata.ipv4maskaC = m_Store.AddIPv4MaskaC(odata.iplong.GetAddressByMask(24).AsShingle64(), 1).GetCount();
    }

    //dublicat login
    if ((!IsChangePass(odata.passpreqtype)) && (odata.dublicat_login_count > 1)) {
        ReqInfo.host = odata.ipstate.host;
        ReqInfo.geo = odata.ipstate.geo;
        if (RengineActionDublicatLogin(odata, pReqParamsNew, Spam, delays, Numbrequest, monlogdata, is_upstream_request,
                                       LogsGroup->GetDeliveryLog(is_upstream_request),
                                       LogsGroup->GetLogML(is_upstream_request))) {
            if (Spam) {
                if (odata.malic) {
                    ReqInfo.SpamList.push_back(TExpStruct(odata.login, uid, KPMALIC, 0, odata.from_pdd));
                    ReqInfo.weigth = KPMALIC;
                } else {
                    ReqInfo.SpamList.push_back(TExpStruct(odata.login, uid, KPSPAM, 0, odata.from_pdd));
                    ReqInfo.weigth = KPSPAM;
                }

                WriteSpamLogBack(odata.iplong.toStroka(), odata.login, odata.regtime, 0, Numbrequest);

            } else
                ReqInfo.weigth = KPHAM;

            delays.SetResult(ReqInfo.weigth);

            if (!odata.ml_answer.m_exists_data) {
                delays.SetMLResult(KPUNKNOWN);

            } else {
                if (odata.ml_answer.m_spam)
                    delays.SetMLResult(KPSPAM);
                else
                    delays.SetMLResult(KPHAM);
            }
        }

        WriteControlLog(odata.messnumb, ReqInfo.weigth, pReqParamsNew);

        DeleteParams(pReqParamsNew);

        ttt_dublicat_login = CShingleTime::GetMs() - ttt_dublicat_login;
        delays.SetDelayDublicatLogin(ttt_dublicat_login);

        return flag_ok;
    }

    //compare iname, fname and login
    cmp_iname_s = CompareTranslit(odata.iname, odata.login, 3, odata.cmp_iname, lang);
    cmp_fname_s = CompareTranslit(odata.fname, odata.login, 3, odata.cmp_fname, lang);
    odata.cmp_names = odata.cmp_iname | odata.cmp_fname;
    if (odata.cmp_names)
        odata.cmp_names_s = odata.cmp_names_s + "login=" + odata.login;
    if (odata.cmp_iname)
        odata.cmp_names_s = odata.cmp_names_s + ", " + "iname=" + cmp_iname_s;
    if (odata.cmp_fname)
        odata.cmp_names_s = odata.cmp_names_s + ", " + "fname=" + cmp_fname_s;

    //packets 1 and 2
    odata.pack1 = TPacket(odata.login, odata.iname, odata.fname, odata.passwdhintall, odata.qhintall, false, odata.cmp_names, odata.hintqid, odata.phonenumber_s, odata.email, lang, (ui8)odata.passpreqtype);
    odata.pack2 = TPacket(odata.login, odata.iname, odata.fname, odata.passwdhintall_m, odata.qhintall_m, false, odata.cmp_names, odata.hintqid, odata.phonenumber_s, odata.email, lang, (ui8)odata.passpreqtype);

    //долговременные хранилища
    ttt = CShingleTime::GetMs();

    odata.storage_long_data.Init(frodo_st::TStorageDataItemExt(odata.iplong, frodo_st::SDT_IPADDRESS, odata.iplong.toStroka()),
                                 frodo_st::TStorageDataItemExt(odata.iname_ipv6, frodo_st::SDT_INAME, odata.iname),
                                 frodo_st::TStorageDataItemExt(odata.fname_ipv6, frodo_st::SDT_FNAME, odata.fname),
                                 frodo_st::TStorageDataItemExt(odata.ifname_ipv6, frodo_st::SDT_IFNAME, odata.iname + "-" + odata.fname),
                                 frodo_st::TStorageDataItemExt(odata.phone_ipv6, frodo_st::SDT_PHONE, odata.v2_phonenumber_hash));

    TGetStorStat longstor_err_stat = TGetStorStat();
    ui32 longstor_tick = CShingleTime::GetMs();
    GetLongDataFltr(odata.storage_long_data, Numbrequest, longstor_err_stat); //!!! REQUEST TO LONGSTOR !!!
    if (longstor_err_stat.IsStorErr())
        monlogdata.AddTag("FRODO", "LG", TSpamonLogStruct::RE, CShingleTime::GetMs() - longstor_tick);
    else
        monlogdata.AddTag("FRODO", "LG", TSpamonLogStruct::OK, CShingleTime::GetMs() - longstor_tick);

    //долговременное хранилище по ip
    odata.iplong_shingle = odata.storage_long_data.m_data[frodo_st::SDT_IPADDRESS].m_rec_shingle;
    odata.ipb_day = ui32(odata.storage_long_data.m_data[frodo_st::SDT_IPADDRESS].m_stordata.m_lastday);
    odata.ipb_ham = odata.storage_long_data.m_data[frodo_st::SDT_IPADDRESS].m_stordata.m_ham;
    odata.ipb_spam85 = odata.storage_long_data.m_data[frodo_st::SDT_IPADDRESS].m_stordata.m_spam85;
    odata.ipb_spam100 = odata.storage_long_data.m_data[frodo_st::SDT_IPADDRESS].m_stordata.m_spam100;
    odata.ipb_day = (ui32)kday_t(time(NULL)) - odata.ipb_day;
    odata.ipb_all = IncMax32(odata.ipb_ham, odata.ipb_spam85, odata.ipb_spam100);
    odata.ipb_spamall = IncMax32(odata.ipb_spam85, odata.ipb_spam100);
    if (odata.ipb_all > 0)
        odata.ipb_spamrate = (float)odata.ipb_spamall / (float)odata.ipb_all;
    if (odata.storage_long_data.m_data[frodo_st::SDT_IPADDRESS].m_rec_shingle != 0) {
        longdatarqstinfo.use[frodo_st::SDT_IPADDRESS] = true;
        longdatarqstinfo.empty[frodo_st::SDT_IPADDRESS] = odata.storage_long_data.m_data[frodo_st::SDT_IPADDRESS].m_stordata.Empty();
        longdatarqstinfo.is_cache[frodo_st::SDT_IPADDRESS] = odata.storage_long_data.m_data[frodo_st::SDT_IPADDRESS].m_in_cache;
    }

    //долговременное хранилище по iname
    odata.iname_ipv6_shingle = odata.storage_long_data.m_data[frodo_st::SDT_INAME].m_rec_shingle;
    odata.inameb_day = ui32(odata.storage_long_data.m_data[frodo_st::SDT_INAME].m_stordata.m_lastday);
    odata.inameb_ham = odata.storage_long_data.m_data[frodo_st::SDT_INAME].m_stordata.m_ham;
    odata.inameb_spam85 = odata.storage_long_data.m_data[frodo_st::SDT_INAME].m_stordata.m_spam85;
    odata.inameb_spam100 = odata.storage_long_data.m_data[frodo_st::SDT_INAME].m_stordata.m_spam100;
    odata.inameb_day = (ui32)kday_t(time(NULL)) - odata.inameb_day;
    odata.inameb_all = IncMax32(odata.inameb_ham, odata.inameb_spam85, odata.inameb_spam100);
    odata.inameb_spamall = IncMax32(odata.inameb_spam85, odata.inameb_spam100);
    if (odata.inameb_all > 0)
        odata.inameb_spamrate = (float)odata.inameb_spamall / (float)odata.inameb_all;
    if (odata.storage_long_data.m_data[frodo_st::SDT_INAME].m_rec_shingle != 0) {
        longdatarqstinfo.use[frodo_st::SDT_INAME] = true;
        longdatarqstinfo.empty[frodo_st::SDT_INAME] = odata.storage_long_data.m_data[frodo_st::SDT_INAME].m_stordata.Empty();
        longdatarqstinfo.is_cache[frodo_st::SDT_INAME] = odata.storage_long_data.m_data[frodo_st::SDT_INAME].m_in_cache;
    }

    //долговременное хранилище по fname
    odata.fname_ipv6_shingle = odata.storage_long_data.m_data[frodo_st::SDT_FNAME].m_rec_shingle;
    odata.fnameb_day = ui32(odata.storage_long_data.m_data[frodo_st::SDT_FNAME].m_stordata.m_lastday);
    odata.fnameb_ham = odata.storage_long_data.m_data[frodo_st::SDT_FNAME].m_stordata.m_ham;
    odata.fnameb_spam85 = odata.storage_long_data.m_data[frodo_st::SDT_FNAME].m_stordata.m_spam85;
    odata.fnameb_spam100 = odata.storage_long_data.m_data[frodo_st::SDT_FNAME].m_stordata.m_spam100;
    odata.fnameb_day = (ui32)kday_t(time(NULL)) - odata.fnameb_day;
    odata.fnameb_all = IncMax32(odata.fnameb_ham, odata.fnameb_spam85, odata.fnameb_spam100);
    odata.fnameb_spamall = IncMax32(odata.fnameb_spam85, odata.fnameb_spam100);
    if (odata.fnameb_all > 0)
        odata.fnameb_spamrate = (float)odata.fnameb_spamall / (float)odata.fnameb_all;
    if (odata.storage_long_data.m_data[frodo_st::SDT_FNAME].m_rec_shingle != 0) {
        longdatarqstinfo.use[frodo_st::SDT_FNAME] = true;
        longdatarqstinfo.empty[frodo_st::SDT_FNAME] = odata.storage_long_data.m_data[frodo_st::SDT_FNAME].m_stordata.Empty();
        longdatarqstinfo.is_cache[frodo_st::SDT_FNAME] = odata.storage_long_data.m_data[frodo_st::SDT_FNAME].m_in_cache;
    }

    //долговременное хранилище по iname+fname
    odata.ifname_ipv6_shingle = odata.storage_long_data.m_data[frodo_st::SDT_IFNAME].m_rec_shingle;
    odata.ifnameb_day = ui32(odata.storage_long_data.m_data[frodo_st::SDT_IFNAME].m_stordata.m_lastday);
    odata.ifnameb_ham = odata.storage_long_data.m_data[frodo_st::SDT_IFNAME].m_stordata.m_ham;
    odata.ifnameb_spam85 = odata.storage_long_data.m_data[frodo_st::SDT_IFNAME].m_stordata.m_spam85;
    odata.ifnameb_spam100 = odata.storage_long_data.m_data[frodo_st::SDT_IFNAME].m_stordata.m_spam100;
    odata.ifnameb_day = (ui32)kday_t(time(NULL)) - odata.ifnameb_day;
    odata.ifnameb_all = IncMax32(odata.ifnameb_ham, odata.ifnameb_spam85, odata.ifnameb_spam100);
    odata.ifnameb_spamall = IncMax32(odata.ifnameb_spam85, odata.ifnameb_spam100);
    if (odata.ifnameb_all > 0)
        odata.ifnameb_spamrate = (float)odata.ifnameb_spamall / (float)odata.ifnameb_all;
    if (odata.storage_long_data.m_data[frodo_st::SDT_IFNAME].m_rec_shingle != 0) {
        longdatarqstinfo.use[frodo_st::SDT_IFNAME] = true;
        longdatarqstinfo.empty[frodo_st::SDT_IFNAME] = odata.storage_long_data.m_data[frodo_st::SDT_IFNAME].m_stordata.Empty();
        longdatarqstinfo.is_cache[frodo_st::SDT_IFNAME] = odata.storage_long_data.m_data[frodo_st::SDT_IFNAME].m_in_cache;
    }

    //долговременное хранилище по phone
    odata.phone_ipv6_shingle = odata.storage_long_data.m_data[frodo_st::SDT_PHONE].m_rec_shingle;
    odata.phoneb_day = ui32(odata.storage_long_data.m_data[frodo_st::SDT_PHONE].m_stordata.m_lastday);
    odata.phoneb_ham = odata.storage_long_data.m_data[frodo_st::SDT_PHONE].m_stordata.m_ham;
    odata.phoneb_spam85 = odata.storage_long_data.m_data[frodo_st::SDT_PHONE].m_stordata.m_spam85;
    odata.phoneb_spam100 = odata.storage_long_data.m_data[frodo_st::SDT_PHONE].m_stordata.m_spam100;
    odata.phoneb_day = (ui32)kday_t(time(NULL)) - odata.phoneb_day;
    odata.phoneb_all = IncMax32(odata.phoneb_ham, odata.phoneb_spam85, odata.phoneb_spam100);
    odata.phoneb_spamall = IncMax32(odata.phoneb_spam85, odata.phoneb_spam100);
    if (odata.phoneb_all > 0)
        odata.phoneb_spamrate = (float)odata.phoneb_spamall / (float)odata.phoneb_all;
    if (odata.storage_long_data.m_data[frodo_st::SDT_PHONE].m_rec_shingle != 0) {
        longdatarqstinfo.use[frodo_st::SDT_PHONE] = true;
        longdatarqstinfo.empty[frodo_st::SDT_PHONE] = odata.storage_long_data.m_data[frodo_st::SDT_PHONE].m_stordata.Empty();
        longdatarqstinfo.is_cache[frodo_st::SDT_PHONE] = odata.storage_long_data.m_data[frodo_st::SDT_PHONE].m_in_cache;
    }

    ttt = CShingleTime::GetMs() - ttt;
    delays.SetDelayLongStorage(ttt);

    //ip bases (кратковременное хранилище по ip)
    ttt = CShingleTime::GetMs();
    {
        auto start = Now();
        if (!IsChangePass(odata.passpreqtype)) {
            odata.ipstate = m_Store.AddCalcIPStatist(odata.iplong, odata.regtime, odata.login, odata.login_prefix, 1, odata.passwdhintall, 1, odata.qhintall, 1, odata.first_nsymb_login, 1, odata.ahintall, uid, odata.iname, odata.fname, odata.pack2, odata.geodata, odata.from_pdd);
            auto now = Now();
            delays.AddCalcIPStatistDelay = now - start;
            start = now;
            if (odata.ipstate.allreg_count_ip > 0)
                odata.otnosh_spam_ip = (float)(((float)odata.ipstate.spamreg_count_ip) / ((float)odata.ipstate.allreg_count_ip /*odata.ipstate.record_count*/));
            else
                odata.otnosh_spam_ip = 0;

            if (!geos.empty() && odata.ipstate.geo.empty()) //если это первая запись для данного ip, то выше данные о гео не записались (не было записи в базе, куда писать), пробуем записать в базу вновь
            {
                odata.ipstate.geo = geos;
                m_Store.AddGeoToIP(odata.iplong, geos);

                now = Now();
                delays.AddGeoToIPDelay = now - start;
                start = now;
            }
            if (!host.empty() && (host != "disabled") && odata.ipstate.host.empty()) //если это первая запись для данного ip, то выше данные о хосте не записались (не было записи в базе, куда писать), пробуем записать в базу вновь
            {
                odata.ipstate.host = host;
                m_Store.AddHostname(odata.iplong, host);
                now = Now();
                delays.AddHostnameDelay = now - start;
                start = now;
            }
        } else {
            odata.passwdchangestat = m_Store.AddElementPasswdChange(odata.regtime, odata.iplong);
            delays.AddElementPasswdChangeDelay = Now() - start;
        }
    }
    ttt = CShingleTime::GetMs() - ttt;
    delays.SetDelayGetShortStorage(ttt);
    ReqInfo.host = odata.ipstate.host;
    ReqInfo.geo = odata.ipstate.geo;

    //packet 3, 4 and 5
    odata.pack3 = TPacket3(odata.login, odata.email, odata.phonenumber_s, odata.from_s, odata.captchacount, odata.lcheck, odata.step1time, odata.step2time, odata.yandexuid_timestamp, odata.ipstate.record_count, lang, (ui8)odata.passpreqtype);
    odata.pack4 = TPacket4(odata.login, odata.email, odata.phonenumber_s, odata.from_s, odata.captchacount, odata.lcheck, odata.step1time, odata.step2time, odata.yandexuid_timestamp, odata.ipstate.record_count, odata.iname, odata.fname, odata.cmp_names, lang, (ui8)odata.passpreqtype);
    odata.pack5 = TPacket2(odata.login, odata.iname, odata.fname, odata.email, odata.nickname, odata.ipstate.record_count, odata.cmp_iname, odata.cmp_fname, lang, (ui8)odata.passpreqtype);

    //статистика за последние 300 и 1200 сек
    ttt = CShingleTime::GetMs();
    odata.ltcs = m_Store.AddGetCountFromSummDataNew(odata.regtime, odata.login_prefix, odata.first_nsymb_login, odata.pack1, odata.email, odata.nickname, odata.phonenumber_s, check_count, GetShingle(odata.useragent_s), 0, 0, 0);
    ttt = CShingleTime::GetMs() - ttt;
    delays.SetDelaySummaryData(ttt);

    //fuid
    odata.fuidcount = m_Store.AddGetFUID(odata.fuid, 1).GetCount();

    //sborka 1
    odata.packet1count = m_Store.AddGetPacket1(odata.pack1, 1).GetCount();

    //sborka2
    odata.packet2count = m_Store.AddGetPacket2(odata.pack2, 1).GetCount();

    //sborka3
    odata.packet3count = m_Store.AddGetPacket3(odata.pack3, 1).GetCount();

    //sborka4
    odata.packet4count = m_Store.AddGetPacket4(odata.pack4, 1).GetCount();

    //sborka5
    odata.packet5count = m_Store.AddGetPacket5(odata.pack5, 1).GetCount();

    delays.SetDelayPackets(odata.packet1count, odata.packet2count, odata.packet3count, odata.packet4count, odata.packet5count);

    //geostat
    odata.geostatcountcountry = m_Store.AddGetGeoCountry(odata.ipstate.geo, 1).GetCount();
    odata.geostatcount = m_Store.AddGetGeo(odata.ipstate.geo, 1).GetCount();
    odata.geostatascount = m_Store.AddGetGeoAS(odata.geos_as, 1).GetCount();

    //hoststat
    odata.hoststat_domen2level = m_Store.AddHost2Level(odata.ipstate.host, 1).GetCount();
    odata.hoststat_domen3level = m_Store.AddHost3Level(odata.ipstate.host, 1).GetCount();

    //domen
    bool est_domen = false;
    odata.domenstat = m_Store.AddDomen(odata.login, 1, odata.logindomen, est_domen).GetCount();
    if (est_domen) {
        //use pddobj
        if (!odata.logindomen.empty()) {
            ui64 pdd_shingle = ShingleFromStroka(odata.logindomen);

            if (pdd_shingle != 0) {
                if (PDDObj.GetEnable()) {
                    ttt1 = 0;
                    ttt = CShingleTime::GetMs();
                    if (!PDDObj.GetPDDInfo(pdd_shingle, odata.login_src_domen_puny, odata.pddinfo)) {
                        odata.pddinfo = {};

                    } else {
                        if (!odata.pddinfo.m_adm_login.empty()) {
                            if (bbClient) {
                                ttt1 = CShingleTime::GetMs();

                                if (THolder<NBlackbox2::TResponse> response = bbClient->GetUserInfo(NFuncClient::CBB::MakeRequest(TUid{odata.pddinfo.m_adm_login}, NBlackbox2::OPT_GET_DEFAULT_EMAIL), SysLogger())) {
                                    odata.bboxinfo.m_est_data = true;
                                    odata.bboxinfo.m_uid = NBlackbox2::TUid(response.Get()).Uid();
                                    odata.bboxinfo.m_email = NBlackbox2::TLoginInfo(response.Get()).Login();
                                    TryFromString(NBlackbox2::TKarmaInfo(response.Get()).Karma(), odata.bboxinfo.m_karma);
                                    TryFromString(NBlackbox2::TKarmaInfo(response.Get()).KarmaStatus(), odata.bboxinfo.m_karma_status);
                                    Cerr << "for login " << odata.pddinfo.m_adm_login << " " << odata.bboxinfo.toLog() << Endl;
                                } else {
                                    Cerr << "for login " << odata.pddinfo.m_adm_login << " empty response" << Endl;
                                }

                                ttt1 = CShingleTime::GetMs() - ttt1;
                                delays.SetDelayBBox(ttt1);

                                if (odata.bboxinfo.m_est_data)
                                    monlogdata.AddTag("FRODO", "BBX", TSpamonLogStruct::OK, ttt1);
                                else
                                    monlogdata.AddTag("FRODO", "BBX", TSpamonLogStruct::RE, ttt1);
                            }
                        }
                    }
                    ttt = CShingleTime::GetMs() - ttt - ttt1;
                    delays.SetDelayPDD(ttt);

                    if (odata.pddinfo.m_est_data)
                        monlogdata.AddTag("FRODO", "PDD", TSpamonLogStruct::OK, ttt);
                    else
                        monlogdata.AddTag("FRODO", "PDD", TSpamonLogStruct::RE, ttt);
                }
            }
        }
    }

    //********************************************** Invoke filter ********************************************************
    if (odata.allowuser) {
        fok = true;
        Spam = false;

    } else {
        fok = RengineActionBig(odata, pReqParamsNew, Spam, delays, Numbrequest, monlogdata, is_upstream_request,
                               LogsGroup->GetDeliveryLog(is_upstream_request),
                               LogsGroup->GetLogML(is_upstream_request));

    }

    if (fok) {
        if (Spam) {
            if (!IsChangePass(odata.passpreqtype)) //ДЛЯ ТИПА РЕГИСТРАЦИИ "СМЕНА ПАРОЛЯ" НЕ ПИШЕМ В ДВУХДНЕВНУЮ БАЗУ ПО IP
            {
                if (odata.malic)
                    m_Store.SetSpamPriznak(odata.iplong, true, odata.regtime, odata.login, KPMALIC);
                else
                    m_Store.SetSpamPriznak(odata.iplong, true, odata.regtime, odata.login, KPSPAM);
            }

            SpamListExt.clear();

            ui8 priznak = 0;
            if (odata.from_pdd)
                SET_PR_PDD(priznak);

            if (odata.malic) {
                SpamListExt.push_back(TLoginTimeExt(odata.regtime, odata.login, odata.iplong.toStroka(), 0, uid, KPMALIC, odata.geodata, priznak));
                ReqInfo.weigth = KPMALIC;
            } else {
                SpamListExt.push_back(TLoginTimeExt(odata.regtime, odata.login, odata.iplong.toStroka(), 0, uid, KPSPAM, odata.geodata, priznak));
                ReqInfo.weigth = KPSPAM;
            }

            int SpamListExtsize = 0;

            if (!IsChangePass(odata.passpreqtype)) //ДЛЯ ТИПА РЕГИСТРАЦИИ "СМЕНА ПАРОЛЯ" ИСКЛЮЧАЕМ АЛГОРИТМЫ ОБРАТНОГО ЗАМЕТЕНИЯ
            {
                ttt = CShingleTime::GetMs();

                m_Store.AllResemblances(odata.iplong, BackSpamAlg, odata, SpamListExt);
                SpamListExtsize = SpamListExt.size();

                ttt = CShingleTime::GetMs() - ttt;
                delays.SetDelayBackAlg(ttt);
            }

            SpamListExt.sort();
            SpamListExt.unique();

            if (SpamListExt.size() > 0) {
                SpamListExtIterator = SpamListExt.begin();
                while (SpamListExtIterator != SpamListExt.end()) {
                    STATO.AddSpam((*SpamListExtIterator).time());

                    ReqInfo.SpamList.push_back(TExpStruct((*SpamListExtIterator).login(), (*SpamListExtIterator).uid(), (*SpamListExtIterator).weight(), (*SpamListExtIterator).type(), (*SpamListExtIterator).is_pdd()));

                    WriteSpamLogBack((*SpamListExtIterator).ipaddress(), (*SpamListExtIterator).login(), (*SpamListExtIterator).time(), (*SpamListExtIterator).type(), Numbrequest);

                    switch ((*SpamListExtIterator).type()) {
                        case 1:
                            delays.SetDelayBackAlg_LoginResemblance();
                            break;
                        case 2:
                            delays.SetDelayBackAlg_HintPasswAnswer();
                            break;
                        case 4:
                            delays.SetDelayBackAlg_3min();
                            break;
                        case 5:
                            delays.SetDelayBackAlg_PacketTwo();
                            break;
                        case 6:
                            delays.SetDelayBackAlg_CompareIFNames();
                            break;
                    };

                    ++SpamListExtIterator;
                }
            }

        } else
            ReqInfo.weigth = KPHAM;

        delays.SetResult(ReqInfo.weigth);
    }

    //корректируем счетчики в долговременной базе по ip
    if (!IsChangePass(odata.passpreqtype)) {
        ttt = CShingleTime::GetMs();

        if (ReqInfo.SpamList.size() > 0) {
            i32 ham = 0;
            i32 spam85 = 0;
            i32 spam100 = 0;
            ui8 mainloginweight = 0;
            TExpList::iterator it;

            it = ReqInfo.SpamList.begin();
            while (it != ReqInfo.SpamList.end()) {
                if ((*it).login() == odata.login) {
                    mainloginweight = (*it).weight();
                } else {
                    switch ((*it).weight()) {
                        case KPSPAM:
                            spam85++;
                            break;
                        case KPMALIC:
                            spam100++;
                            break;
                    }
                }

                ++it;
            }

            ham = (-1) * (spam85 + spam100);
            switch (mainloginweight) {
                case KPSPAM:
                    spam85++;
                    break;
                case KPMALIC:
                    spam100++;
                    break;
            }

            if (is_upstream_request) {
                UpdateLongDataFltr(true, odata.storage_long_data, Numbrequest, kday_t(static_cast<time_t>(odata.regtime)), ham, spam85, spam100);
            }
        } else {
            if (is_upstream_request) {
                UpdateLongDataFltr(true, odata.storage_long_data, Numbrequest, kday_t(static_cast<time_t>(odata.regtime)), KHAM0);
            }
        }

        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayUpdateLongStorage(ttt);

    } else //ТИП РЕГИСТРАЦИИ - СМЕНА ПАРОЛЯ
    {
        ttt = CShingleTime::GetMs();

        if (Spam) {
            if (odata.malic) {
                if (is_upstream_request) {
                    UpdateLongDataFltr(true, odata.storage_long_data, Numbrequest, kday_t(static_cast<time_t>(odata.regtime)), KSPAM100);
                }

            } else {
                if (is_upstream_request) {
                    UpdateLongDataFltr(true, odata.storage_long_data, Numbrequest, kday_t(static_cast<time_t>(odata.regtime)), KSPAM85);
                }
            }
        } else {
            if (is_upstream_request) {
                UpdateLongDataFltr(true, odata.storage_long_data, Numbrequest, kday_t(static_cast<time_t>(odata.regtime)), KHAM0);
            }
        }

        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayUpdateLongStorage(ttt);
    }

    WriteControlLog(odata.messnumb, ReqInfo.weigth, pReqParamsNew);

    DeleteParams(pReqParamsNew);

    return flag_ok;
}

void CSoFilter::Close() {
    m_Store.Clear();

    if (FilterPool)
        FilterPool->Close();
}

void CSoFilter::Shutdown() {
    PDDObj.Shutdown();
}

TResetResponce CSoFilter::Reset() {
    TResetResponce res;
    bool flag_ok = true;

    BackSpamAlg.Reload();
    if (FilterPool)
        res = FilterPool->Reset(flag_ok);
    ReloadBlackList();
    ReloadWhiteList();
    ReloadTrustedList();
    ReloadGruppedNetList();
    ReloadUnGruppedNetList();
    ReloadLoginList();
    ReloadPrintFieldList();
    ReloadRulesStatList();

    ReloadWhiteListSO();
    ReloadIntranetZoneSO();
    ReloadTrustedZoneSO();
    ReloadLocalZoneSO();

    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL)) {
        if (flag_ok)
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "F\t%s", res.text.c_str());
        else
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\t%s", res.text.c_str());
    }

    return res;
}

void CSoFilter::ReloadBlackList(void) {
    if (BlackList)
        BlackList->ReloadFileList();
}

void CSoFilter::ReloadWhiteList(void) {
    if (WhiteList)
        WhiteList->ReloadFileList();
}

void CSoFilter::ReloadTrustedList(void) {
    if (TrustedList)
        TrustedList->ReloadFileList();
}

void CSoFilter::ReloadGruppedNetList(void) {
    if (GruppedNetList)
        GruppedNetList->ReloadFileList();
}

void CSoFilter::ReloadUnGruppedNetList(void) {
    if (UnGruppedNetList)
        UnGruppedNetList->ReloadFileList();
}

void CSoFilter::ReloadWhiteListSO(void) {
    if (WhiteListSO)
        WhiteListSO->ReloadFileList();
}

void CSoFilter::ReloadIntranetZoneSO(void) {
    if (IntranetZoneSO)
        IntranetZoneSO->ReloadFileList();
}

void CSoFilter::ReloadTrustedZoneSO(void) {
    if (TrustedZoneSO)
        TrustedZoneSO->ReloadFileList();
}

void CSoFilter::ReloadLocalZoneSO(void) {
    if (LocalZoneSO)
        LocalZoneSO->ReloadFileList();
}

void CSoFilter::ReloadLoginList(void) {
    bool load = false;
    ui32 recordcount = 0;
    TString nameslistpath = "";

    if (configobj != NULL)
        nameslistpath = configobj->ReadStroka("lists", "NamesList", "");

    m_MutexBlackWhite.Acquire();

    FILE* fhandle = NULL;
    if (!nameslistpath.empty()) {
        fhandle = fopen(nameslistpath.c_str(), "r");
        if (fhandle != NULL) {
            fclose(fhandle);

            load = true;
        } else {
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "LoginList not reading!");
        }
    } else {
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "LoginList is not set!");
    }

    if (load) {
        if (!NamesList) {
            TString errs = "";

            NamesList = MakeHolder<TNamesList>(LogsGroup, nameslistpath);
            NamesList->ReloadFileList();
            ui32 t = NamesList->GetLastLoadingMSec();
            recordcount = NamesList->GetRecordCount();
            {
                const auto newStat = FileStateWasChanged(nameslistpath, m_statNamesList, errs);
                if (newStat)
                    m_statNamesList = *newStat;
            }
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "LoginList is load in %lu msec (%u).", t, recordcount);
        } else {
            TString errs = "";

            const auto newStat = FileStateWasChanged(nameslistpath, m_statNamesList, errs);
            if (!newStat) {
                if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                    LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "LoginList no changed.");
                m_MutexBlackWhite.Release();
                return;
            } else {
                m_statNamesList = *newStat;
            }
            NamesList.Reset();
            NamesList = NULL;
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "LoginList is unload.");

            NamesList = MakeHolder<TNamesList>(LogsGroup, nameslistpath);
            NamesList->ReloadFileList();
            ui32 t = NamesList->GetLastLoadingMSec();
            recordcount = NamesList->GetRecordCount();
            if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "LoginList is load in %lu msec (%u).", t, recordcount);
        }
    }
    m_MutexBlackWhite.Release();
}

void CSoFilter::ReloadPrintFieldList() {
    TString str = "";
    int mode = 0;
    TString mode_str = "";

    m_printfieldobj = MakeHolder<TKIniFile>();
    m_printfieldobj->Init(m_printfieldfilename);
    m_printfieldobj->ReloadAll();
    mode = m_printfieldobj->ReadInteger("general", "mode", -1);
    switch (mode) {
        case 0: //print in list
            mode_str = "print in list";
            break;
        case 1: //print not include in list
            mode_str = "print not include in list";
            break;
        case 2: //print all
            mode_str = "print all";
            break;
        case 3: //not print all
            mode_str = "not print all";
            break;
        default:
            mode_str = "unknown";
    };
    str = m_printfieldobj->GetAllValueBySection("printfield");
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "PRINTFIELDLIST: mode=%d(%s); %s", mode, mode_str.c_str(), str.c_str());
}

void CSoFilter::ReloadRulesStatList() {
    TString str = "";
    TString datastr = "";

    m_rulestatlist = MakeHolder<TKIniFile>();
    m_rulestatlist->Init(m_rulestatfilename);
    m_rulestatlist->ReloadAll();

    m_Store.SetRuleStatList(m_rulestatlist.Get());

    datastr = m_rulestatlist->GetAllValueBySection("rules");
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "RULESSTATLIST: %s", datastr.c_str());
}

bool CSoFilter::PrintFieldToDlvLog(const TString& fieldname) {
    bool res = false;
    int mode = 0; //0 - print in list, 1 - print not include in list, 2 - print all, 3 - not print all

    if ((!fieldname.empty()) && (m_printfieldobj)) {
        mode = m_printfieldobj->ReadInteger("general", "mode", -1);
        switch (mode) {
            case 0: //print in list
                res = m_printfieldobj->ReadBool("printfield", fieldname, false);
                break;
            case 1: //print not include in list
                res = !m_printfieldobj->ReadBool("printfield", fieldname, false);
                break;
            case 2: //print all
                res = true;
                break;
            case 3: //not print all
                res = false;
                break;
        };
    }

    return res;
}

TString CSoFilter::GetEnableBackAlgorithm() {
    return BackSpamAlg.GetEnableAlgorithmList();
}

bool CSoFilter::GetStatHours(TReqParams* pReqParams) {
    bool res = false;
    TReqParams::iterator par_it;
    TString s = "";
    int year = 0, mon = 0, day = 0, hour = 0;
    bool yearb = false, monb = false, dayb = false, hourb = false;
    time_t t = 0;
    tm tv, tv1;
    time_t tt = 0;

    //year
    par_it = pReqParams->find("year");
    if (par_it != pReqParams->end()) {
        s = par_it->second[0];
        year = atoi(s.c_str());
        year = year - 1900;
        if (year > 0)
            yearb = true;
        else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request parameter 'year': %d", year);
    } else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'year' parameter");
    //mon
    par_it = pReqParams->find("mon");
    if (par_it != pReqParams->end()) {
        s = par_it->second[0];
        mon = atoi(s.c_str());
        mon = mon - 1;
        if ((mon >= 0) && (mon < 12))
            monb = true;
        else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request parameter 'mon': %d", mon);
    } else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'mon' parameter");
    //day
    par_it = pReqParams->find("day");
    if (par_it != pReqParams->end()) {
        s = par_it->second[0];
        day = atoi(s.c_str());
        if ((day >= 1) && (day <= 31))
            dayb = true;
        else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request parameter 'day': %d", day);
    } else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'day' parameter");
    //hour
    par_it = pReqParams->find("hour");
    if (par_it != pReqParams->end()) {
        s = par_it->second[0];
        hour = atoi(s.c_str());
        if ((hour >= 0) && (hour < 24))
            hourb = true;
        else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request parameter 'hour': %d", hour);
    } else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'hour' parameter");
    if (yearb && monb && dayb && hourb) {
        tt = time(NULL);
        tv1 = *localtime(&tt);
        memset(&tv, 0, sizeof(tv));
        tv.tm_year = year;
        tv.tm_mon = mon;
        tv.tm_mday = day;
        tv.tm_hour = hour;
        tv.tm_isdst = tv1.tm_isdst;
        t = mktime(&tv);
        STATO.GetData(year, mon, day, hour, t);
        res = true;
    }

    return res;
}

bool CSoFilter::GetStatHoursI(TReqParams* pReqParams, TStatDataSetS& statlist, TString& firsttime) {
    bool res = false;
    TReqParams::iterator par_it;
    TString s = "";
    int year = 0, mon = 0, day = 0, hour = 0;
    bool yearb = false, monb = false, dayb = false, hourb = false;
    time_t t = 0;
    tm tv, tv1;
    time_t tt = 0;

    firsttime = "";
    //year
    par_it = pReqParams->find("year");
    if (par_it != pReqParams->end()) {
        s = par_it->second[0];
        year = atoi(s.c_str());
        year = year - 1900;
        if (year > 0)
            yearb = true;
        else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request parameter 'year': %d", year);
    } else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'year' parameter");
    //mon
    par_it = pReqParams->find("mon");
    if (par_it != pReqParams->end()) {
        s = par_it->second[0];
        mon = atoi(s.c_str());
        mon = mon - 1;
        if ((mon >= 0) && (mon < 12))
            monb = true;
        else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request parameter 'mon': %d", mon);
    } else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'mon' parameter");
    //day
    par_it = pReqParams->find("day");
    if (par_it != pReqParams->end()) {
        s = par_it->second[0];
        day = atoi(s.c_str());
        if ((day >= 1) && (day <= 31))
            dayb = true;
        else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request parameter 'day': %d", day);
    } else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'day' parameter");
    //hour
    par_it = pReqParams->find("hour");
    if (par_it != pReqParams->end()) {
        s = par_it->second[0];
        hour = atoi(s.c_str());
        if ((hour >= 0) && (hour < 24))
            hourb = true;
        else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request parameter 'hour': %d", hour);
    } else if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "F\tBad request - no 'hour' parameter");

    firsttime = IntToStroka(year + 1900) + "." + IntToStroka(mon + 1) + "." + IntToStroka(day) + " " + IntToStroka(hour) + ":XX";

    if (yearb && monb && dayb && hourb) {
        tt = time(NULL);
        tv1 = *localtime(&tt);
        memset(&tv, 0, sizeof(tv));
        tv.tm_year = year;
        tv.tm_mon = mon;
        tv.tm_mday = day;
        tv.tm_hour = hour;
        tv.tm_isdst = tv1.tm_isdst;
        t = mktime(&tv);
        STATO.GetDataI(year, mon, day, hour, t, statlist);
        res = true;
    }

    return res;
}

void CSoFilter::Midnight() {
    m_Store.Midnight();
    AllowUser.Midnight();
    PDDObj.Midnight();
    AsyncResolvCache.Midnight();
}

TString CSoFilter::CorrectLogins(TKIPv6 ip, TString login, ui32 karma) {
    TString res = "";
    i32 ham0 = 0;
    i32 spam85 = 0;
    i32 spam100 = 0;
    time_t currtime = time(NULL);
    bool stor_err = false;

    if (ip.Undefined())
        ip = m_Store.GetDubLoginStat(login).GetIP();

    if (!ip.Undefined()) {
        res = m_Store.CorrectLogins(ip, login, karma, ham0, spam85, spam100);
        //printf("ham0=%d, spam85=%d, spam100=%d\n", ham0, spam85, spam100);

        CorrectLongDataIncrFltr(frodo_st::SDT_IPADDRESS, ip, ip.toStroka(), stor_err, kday_t(currtime), ham0, spam85, spam100);

    } else {
        res = "'" + login + "': unknown ip.\n";
    }

    return res;
}

int CSoFilter::GetLoginsInfo(TKIPv6 ip, TString& login) {
    int res = KPUNKNOWN;

    //if (ip.Undefined())
    ip = m_Store.GetDubLoginStat(login).GetIP();

    if (!ip.Undefined())
        res = m_Store.LoginInfo(ip, login);

    return res;
}

TString CSoFilter::GetWhiteBlackStatMon() {
    TString res = "";

    res = res + "<FLTR:";
    res = res + IntToStroka(m_white_counter.GetDiff()) + "/" + IntToStroka(m_black_counter.GetDiff()) + "/" + IntToStroka(m_grupp_counter.GetDiff()) + "/" + IntToStroka(m_ungrupp_counter.GetDiff()) + "/" + IntToStroka(m_trustlogin_counter.GetDiff()) + ",";
    res = res + IntToStroka(m_whiteso_counter.GetDiff()) + "/" + IntToStroka(m_intranetzoneso_counter.GetDiff()) + "/" + IntToStroka(m_trustedzoneso_counter.GetDiff()) + "/" + IntToStroka(m_localzoneso_counter.GetDiff());
    res = res + ">";

    return res;
}

bool CSoFilter::RengineActionDublicatLogin(
        TOData& odata,
        TReqParams* pReqParams,
        bool& Spam,
        TDelayClass& delays,
        const TString& Numbrequest,
        TSpamonLogStruct& monlogdata,
        bool is_upstream_request,
        const TLog& deliveryLog,
        const TLog& mlLog) {
    bool res = false;
    int memory_index = 0;
    int filterindex = 0;
    TRengineElement* tre = NULL;
    ui32 ttt = 0;
    TString ipsectext = "";
    TString skey = "";
    TString svalue = "";
    TReqParams::iterator par_it;
    TString ml_lang = "";
    TString ml_geo = "";
    TString ml_inam = "";
    TString ml_fnam = "";
    TString ml_rtype = "";
    THashMap<TString, TString> mllog_data;
    TExtRengineData ext_fltr_data;
    ui32 last_filter_result = 0;
    TString last_rule_text0 = "";
    TString last_rule_text1 = "";
    TString change_res_by_ml = "";
    TString ml_ip6mask = "";
    TString ml_ip4mask = "";
    ui64 check_field_tick = 0;
    ui32 check_field_tick_ms = 0;
    ui32 check_message_tick_ms = 0;
    ui32 prepare_tick_ms = 0;

    odata.ml_data.SetMessage();

    if (FilterPool)
        memory_index = FilterPool->GetNumberSection(odata.iplong.AsShingle32());
    ttt = CShingleTime::GetMs();
    if (FilterPool)
        tre = FilterPool->GetFilter();
    if (tre != NULL) {
        if ((FilterPool) && (FilterPool->GetRulesMonStat() != NULL))
            FilterPool->GetRulesMonStat()->AddFilterCall(tre->GetRulesCS());

        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayFilterGet(ttt);

        TRengine& m_hSp = tre->GetFilterHandle();

        for (size_t k = 0; k < 2; k++) {
            m_hSp.InitMessage(odata.messnumb, nullptr, nullptr, "", TSpClass::UNKNOWN, SysLogger());
            mllog_data.clear();
            ext_fltr_data.Clear();
            ttt = CShingleTime::GetMs();

            mllog_data["dubl"] = "yes";

            if (odata.whiteip)
                ipsectext = ipsectext + "wht='" + odata.whitenet_source + "' ";
            if (odata.blackip)
                ipsectext = ipsectext + "blk='" + odata.blacknet_source + "' ";
            if (odata.gruppedip)
                ipsectext = ipsectext + "grp='" + odata.gruppednet_source + "' ";
            if (odata.ungruppedip)
                ipsectext = ipsectext + "ungrp='" + odata.ungruppednet_source + "' ";
            if (odata.whiteip_so)
                ipsectext = ipsectext + "wiso='" + odata.whitenet_so_source + "' ";
            if (odata.intranetzoneip_so)
                ipsectext = ipsectext + "izso='" + odata.intranetzone_so_source + "' ";
            if (odata.trustedzoneip_so)
                ipsectext = ipsectext + "tzso='" + odata.trustedzone_so_source + "' ";
            if (odata.localzoneip_so)
                ipsectext = ipsectext + "lzso='" + odata.localzone_so_source + "' ";

            check_field_tick = 0;
            check_field_tick_ms = 0;
            check_message_tick_ms = 0;
            prepare_tick_ms = 0;
            prepare_tick_ms = CShingleTime::GetMs();
            //***** START WORK FILTER *****
            filterindex = tre->GetIndex();
            m_hSp.AddStat("fidx", IntToStroka(filterindex) + "=" + tre->GetRulesCS());
            m_hSp.AddStat("rtyp", TPassportRequestTypeToTString(odata.passpreqtype, odata.passpreqtype_source));
            ml_rtype = TPassportRequestTypeToTString(odata.passpreqtype, odata.passpreqtype_source);
            mllog_data["rtyp"] = TPassportRequestTypeToTString(odata.passpreqtype, odata.passpreqtype_source);

            m_hSp.AddStat("ruid", odata.remote_uid);
            m_hSp.AddStat("ip  ", odata.iplong.toStroka());
            mllog_data["ip"] = odata.iplong.toStroka();

            m_hSp.AddStat("inet", ipsectext);
            if (odata.is_corrected)
                m_hSp.AddStat("ip_i", odata.ip_isx);
            m_hSp.AddStat("uid ", odata.uid);
            mllog_data["uid"] = odata.uid;

            m_hSp.AddStat("host", odata.ipstate.host);

            m_hSp.AddStat("geos", odata.ipstate.geo + "(night=" + BoolToStroka2(odata.is_night) + ") AS='" + odata.geos_as + "' tor='" + odata.geos_tor + "'");
            ml_geo = odata.ipstate.geo;
            mllog_data["geos"] = odata.ipstate.geo + "(night=" + BoolToStroka2(odata.is_night) + ") AS='" + odata.geos_as + "' tor='" + odata.geos_tor + "'";

            if (odata.iplong.IsIPv6()) {
                m_hSp.AddStat("ip6m", IntToStroka(odata.ipv6maska1) + ", " + IntToStroka(odata.ipv6maska2) + ", " + IntToStroka(odata.ipv6maska3));
                ml_ip6mask = IntToStroka(odata.ipv6maska1) + "," + IntToStroka(odata.ipv6maska2) + "," + IntToStroka(odata.ipv6maska3);
                mllog_data["ip6m"] = ml_ip6mask;

            } else {
                m_hSp.AddStat("ip4m", IntToStroka(odata.ipv4maskaC));
                ml_ip4mask = IntToStroka(odata.ipv4maskaC);
                mllog_data["ip4m"] = ml_ip4mask;
            }

            m_hSp.AddStat("lang", odata.langstr);
            ml_lang = odata.langstr;
            mllog_data["lang"] = odata.langstr;

            m_hSp.AddStat("rtim", TimeToStr(odata.regtime) + " (" + IntToStroka(odata.regtime) + ")");

            if (!IsChangePass(odata.passpreqtype)) {
                if (odata.login_corr_exists)
                    m_hSp.AddStat("logn", odata.login + " (corr:" + IntToStroka(odata.login_corr_weigth) + ")");
                else
                    m_hSp.AddStat("logn", odata.login + " (corr:-)");

            } else {
                m_hSp.AddStat("logn", odata.login);
            }
            mllog_data["logn"] = odata.login;

            m_hSp.AddStat("pass", odata.passwhint_s + ", passwdex: " + odata.passwdex_s + ", addit: " + odata.passwdhintall.GetStr());
            mllog_data["pass"] = odata.passwhint_s + ", passwdex: " + odata.passwdex_s + ", addit: " + odata.passwdhintall.GetStr();

            m_hSp.AddStat("hqid", odata.hintqid_s);
            m_hSp.AddStat("ques", odata.questhint_s + ", hintqex: " + odata.hintqex_s + ", addit: " + odata.qhintall.GetStr());
            mllog_data["ques"] = odata.questhint_s + ", hintqex: " + odata.hintqex_s + ", addit: " + odata.qhintall.GetStr();

            m_hSp.AddStat("answ", odata.answerhint_s + ", hintaex: " + odata.hintaex_s + ", addit: " + odata.ahintall.GetStr());
            mllog_data["answ"] = odata.answerhint_s + ", hintaex: " + odata.hintaex_s + ", addit: " + odata.ahintall.GetStr();

            TString inamestat_s = IntToStroka(odata.constanants_serial_count_iname) + ", " + IntToStroka(odata.vowels_serial_count_iname) + ", " + IntToStroka(odata.digital_count_iname);
            if (odata.in_inamelist_cmp)
                m_hSp.AddStat("inam", odata.iname + " (TRSC: " + IntToStroka(odata.in_inamelist_cmp) + "=" + odata.s_inamelist_cmp + ", " + inamestat_s + ")");
            else
                m_hSp.AddStat("inam", odata.iname + " (" + inamestat_s + ")");
            ml_inam = inamestat_s;
            mllog_data["inam"] = odata.iname;

            TString fnamestat_s = IntToStroka(odata.constanants_serial_count_fname) + ", " + IntToStroka(odata.vowels_serial_count_fname) + ", " + IntToStroka(odata.digital_count_fname);
            if (odata.in_fnamelist_cmp)
                m_hSp.AddStat("fnam", odata.fname + " (TRSC: " + IntToStroka(odata.in_fnamelist_cmp) + "=" + odata.s_fnamelist_cmp + ", " + fnamestat_s + ")");
            else
                m_hSp.AddStat("fnam", odata.fname + " (" + fnamestat_s + ")");
            ml_fnam = fnamestat_s;
            mllog_data["fnam"] = odata.fname;

            m_hSp.AddStat("usag", odata.useragent_s);
            mllog_data["usag"] = odata.useragent_s;

            m_hSp.AddStat("capt", "ccnt:" + IntToStroka(odata.captchacount) + ", creq:" + IntToStroka(odata.captchareq));
            mllog_data["capt"] = "ccnt:" + IntToStroka(odata.captchacount) + ", creq:" + IntToStroka(odata.captchareq);

            m_hSp.AddStat("nick", odata.nickname);
            m_hSp.AddStat("emal", odata.email);
            if ((!odata.phonenumber_s.empty()) || (!odata.v2_phonenumber_hash.empty()))
                m_hSp.AddStat("phon", odata.phonenumber_s + " (" + odata.v2_phonenumber_hash + ")");
            m_hSp.AddStat("dlgn", IntToStroka(odata.dublicat_login_count));
            m_hSp.AddStat("snow", "a:" + IntToStroka(odata.snow.all) + " (" + FloatToStr(odata.savr_oa) + "), s:" + IntToStroka(odata.snow.spam) + " (" + FloatToStr(odata.savr_os) + "), e:" + IntToStroka(odata.snow.error) + " (" + FloatToStr(odata.savr_oe) + "), h:" + IntToStroka(odata.snow.ham) + " (" + FloatToStr(odata.savr_oh) + ")");
            mllog_data["snow"] = "a:" + IntToStroka(odata.snow.all) + " (" + FloatToStr(odata.savr_oa) + "), s:" + IntToStroka(odata.snow.spam) + " (" + FloatToStr(odata.savr_os) + "), e:" + IntToStroka(odata.snow.error) + " (" + FloatToStr(odata.savr_oe) + "), h:" + IntToStroka(odata.snow.ham) + " (" + FloatToStr(odata.savr_oh) + ")";

            m_hSp.AddStat("savr", "a:" + IntToStroka(odata.savr.all) + ", s:" + IntToStroka(odata.savr.spam) + ", e:" + IntToStroka(odata.savr.error) + ", h:" + IntToStroka(odata.savr.ham));
            if (odata.passpreqtype == TP_ADMSOCIALREG)
                m_hSp.AddStat("isoc", "yes (" + odata.social_provider + ")");
            else
                m_hSp.AddStat("isoc", "no");
            m_hSp.AddStat("spst", odata.spst_answer.ToText());
            m_hSp.CheckRange("DUBLICAT_LOGIN", (int)odata.dublicat_login_count);

            m_hSp.AddStat("v2cl", IntToStroka(odata.v2_cookie_l_timestamp_diff));
            m_hSp.CheckRange("V2_COOKIE_L_TIMESTAMP_DIFF", (int)odata.v2_cookie_l_timestamp_diff);

            if (odata.v2_cookie_l_login_rate)
                SpSetRule(m_hSp, "DIFF_L_LOGIN");
            if (odata.v2_cookie_l_uid_rate)
                SpSetRule(m_hSp, "DIFF_UID_LUID");

            if (!odata.spst_answer.m_exists_data)
                SpSetRule(m_hSp, "SPST_NODATA");

            m_hSp.AddStat("cls2", odata.clust_data_answer_local.toDeliveryLog());
            if (odata.clust_data_answer_local.m_exists_data) {
                m_hSp.CheckRange("clst_spam_percent", (double)odata.clust_data_answer_local.m_cluster_spam_percent);
//                odata.ml_data.ADDField("clst_perc", tstr.c_str(), tstr.length());
            }
            //rbl rules lists (combinedbl e.t.c.)
            auto rit = odata.rbl_rulelist.begin();
            while (rit != odata.rbl_rulelist.end()) {
                if (!(*rit).empty())
                    SpSetRule(m_hSp, (*rit).c_str());

                ++rit;
            }

            //�� from
            if (odata.from_pdd)
                SpSetRule(m_hSp, "IS_PDD");

            if (odata.iplong.IsIPv6()) {
                m_hSp.CheckRange("ipv6maska64", (int)odata.ipv6maska1);
                m_hSp.CheckRange("ipv6maska48", (int)odata.ipv6maska2);
                m_hSp.CheckRange("ipv6maska32", (int)odata.ipv6maska3);

            } else {
                m_hSp.CheckRange("ipv4maskaC", (int)odata.ipv4maskaC);
            }

            if (pReqParams != NULL) {
                par_it = pReqParams->begin();
                while (par_it != pReqParams->end()) {
                    skey = (*par_it).first;
                    svalue = (*par_it).second[0];

                    if (PrintFieldToDlvLog(skey)) //�������� � ���, ���� ����
                    {
                        m_hSp.AddStat(skey, svalue);

                        if (!svalue.empty())
                            odata.ml_data.ADDField(skey, svalue.c_str(), svalue.length());
                    }

                    if (!skey.empty() /* && !svalue.empty()*/) {
                        skey = "re_" + skey;
                        check_field_tick += SpCheckFieldTick(m_hSp, skey.c_str(), svalue.c_str(), svalue.length(), "cp1251", true, false, delays.GetRuleHash());
                    }

                    ++par_it;
                }

                par_it = pReqParams->find("v2_has_cookie_l");
                if (par_it != pReqParams->end())
                    mllog_data["v2_has_cookie_l"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_old_password_quality");
                if (par_it != pReqParams->end())
                    mllog_data["v2_old_password_quality"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_is_ssl");
                if (par_it != pReqParams->end())
                    mllog_data["v2_is_ssl"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_accept_language");
                if (par_it != pReqParams->end())
                    mllog_data["v2_accept_language"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_password_validation_count");
                if (par_it != pReqParams->end())
                    mllog_data["v2_password_validation_count"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_account_country");
                if (par_it != pReqParams->end())
                    mllog_data["v2_account_country"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_password_quality");
                if (par_it != pReqParams->end())
                    mllog_data["v2_password_quality"] = (*par_it).second[0];
            }

            if (k == 1) //add machine learning result
            {
                if (odata.ml_answer.m_exists_data) {
                    m_hSp.AddStat("ml  ", "s=" + BoolToStroka(odata.ml_answer.m_spam) + ",w=" + IntToStroka(odata.ml_answer.m_weight));
                    if (odata.ml_answer.m_spam)
                        SpSetRule(m_hSp, "ML_SPAM");
                    else
                        SpSetRule(m_hSp, "ML_HAM");

                    m_hSp.CheckRange("ml_weight", odata.ml_answer.m_weight);

                } else {
                    m_hSp.AddStat("ml  ", "-");
                    SpSetRule(m_hSp, "ML_EMPTY");
                }
            }

            tre->RULEBUFF = {};
            prepare_tick_ms = CShingleTime::GetMs() - prepare_tick_ms;

            check_message_tick_ms = CShingleTime::GetMs();
            NProf::Profiler prof;
            TCheckedMessage checkedMessage;
            m_hSp.CheckMessage(prof, nullptr, checkedMessage);
            m_hSp.EndMessage(deliveryLog, mlLog);
            Spam = IsSpam(checkedMessage.spClass);
            {
                TStringOutput rulesStream(tre->RULEBUFF);
                for(auto& [src, dst]: {
                    std::make_tuple(std::cref(m_hSp.m_cur->vr_spam), std::ref(ext_fltr_data.r_sp_rules)),
                    std::make_tuple(std::cref(m_hSp.m_cur->vr_dlv), std::ref(ext_fltr_data.r_dl_rules)),
                    std::make_tuple(std::cref(m_hSp.m_cur->vr_null), std::ref(ext_fltr_data.r_nl_rules)),
                }) {
                    dst.reserve(src.size());
                    for(const TRuleCurrent& ruleCurrent : src) {
                        const TRuleDef& rule = ruleCurrent.GetDef();
                        dst.emplace_back(rule.pRuleName, rule.score);

                        if ( rule.rt != RT_ALG || !m_hSp.RulePrintList ||
                            (m_hSp.RulePrintList && m_hSp.RulePrintList->Find(rule.pRuleName))) {
                            rulesStream << rule.pRuleName << ':' << rule.score << ';';
                        }
                    }
                }

                tre->RULEBUFF = std::move(m_hSp.m_cur->ActiveComaSeparatedFilteredNullRulesNames.Str());
            }
            if(is_upstream_request && k == 1) {
                m_hSp.EndMessage(deliveryLog, mlLog);
            }
            check_message_tick_ms = CShingleTime::GetMs() - check_message_tick_ms;
            ttt = CShingleTime::GetMs() - ttt;

            if (k == 0) {
                delays.SetDelayFilterWorkPrepare(prepare_tick_ms);
                check_field_tick_ms = check_field_tick / 1000;
                delays.SetDelayFilterWorkCheckField(check_field_tick_ms);
                delays.SetDelayFilterWorkCheckMessage(check_message_tick_ms);
            } else {
                delays.SetDelayFilterWorkPrepareML(prepare_tick_ms);
                check_field_tick_ms = check_field_tick / 1000;
                delays.SetDelayFilterWorkCheckFieldML(check_field_tick_ms);
                delays.SetDelayFilterWorkCheckMessageML(check_message_tick_ms);
            }

            if (k == 1) {
                //write statistik from ML
                if (!odata.ml_answer.m_exists_data) {
                    delays.SetMLResult(KPUNKNOWN);

                } else {
                    if (odata.ml_answer.m_spam) {
                        delays.SetMLResult(KPSPAM);
                        if (last_filter_result == KPHAM)
                            delays.SetHamToSpamByML();
                        else if (last_filter_result == KPMALIC)
                            delays.SetMalicToSpamByML();

                    } else {
                        delays.SetMLResult(KPHAM);
                        if (last_filter_result == KPSPAM)
                            delays.SetSpamToHamByML();
                        else if (last_filter_result == KPMALIC)
                            delays.SetMalicToHamByML();
                    }
                }

                last_rule_text1 = ext_fltr_data.GetRSp();

                //write statistik for full result
                if (Spam) {
                    if (m_hSp.ExistsbanInternal("MALICIOUS")) {
                        if (last_filter_result == KPHAM) {
                            change_res_by_ml = "CBML_HTM";
                            delays.SetHamToMalicFinalres();
                            if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                                LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "HTM %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());

                        } else if (last_filter_result == KPSPAM) {
                            change_res_by_ml = "CBML_STM";
                            delays.SetSpamToMalicFinalres();
                            if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                                LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "STM %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());
                        }

                    } else {
                        if (last_filter_result == KPHAM) {
                            change_res_by_ml = "CBML_HTS";
                            delays.SetHamToSpamFinalres();
                            if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                                LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "HTS %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());

                        } else if (last_filter_result == KPMALIC) {
                            change_res_by_ml = "CBML_MTS";
                            delays.SetMalicToSpamFinalres();
                            if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                                LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "MTS %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());
                        }
                    }

                } else {
                    if (last_filter_result == KPSPAM) {
                        change_res_by_ml = "CBML_STH";
                        delays.SetSpamToHamFinalres();
                        if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                            LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "STH %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());

                    } else if (last_filter_result == KPMALIC) {
                        change_res_by_ml = "CBML_MTH";
                        delays.SetMalicToHamFinalres();
                        if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                            LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "MTH %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());
                    }
                }

            } else {
                //write statistik wo ML
                if (Spam) {
                    if (m_hSp.ExistsbanInternal("MALICIOUS")) {
                        delays.SetWOMLResult(KPMALIC);
                        last_filter_result = KPMALIC;

                    } else {
                        delays.SetWOMLResult(KPSPAM);
                        last_filter_result = KPSPAM;
                    }

                } else {
                    delays.SetWOMLResult(KPHAM);
                    last_filter_result = KPHAM;
                }

                last_rule_text0 = ext_fltr_data.GetRSp();
            }

            if (Spam)
                mllog_data["spam"] = "yes";
            else
                mllog_data["spam"] = "no";

            mllog_data["r_sp"] = ext_fltr_data.GetRSp();
            mllog_data["r_nl"] = ext_fltr_data.GetRNl();

            if (odata.clust_data_answer_local.m_exists_data) {
                mllog_data["cls2_number"] = odata.clust_data_answer_local.cluster_number_s();
                mllog_data["cls2_distance"] = odata.clust_data_answer_local.cluster_distance_s();
                mllog_data["cls2_radius_max"] = odata.clust_data_answer_local.cluster_radius_max_s();
                mllog_data["cls2_radius_min"] = odata.clust_data_answer_local.cluster_radius_min_s();
                mllog_data["cls2_spam_percent"] = odata.clust_data_answer_local.cluster_spam_percent_s();
            }

            if (k == 0)
                delays.SetDelayFilterWork1step(ttt);
            else
                delays.SetDelayFilterWork2step(ttt);

            if ((k == 0) && (MLPoolClients)) //mashine learning server request
            {
                ttt = CShingleTime::GetMs();

                odata.ml_data.SetDublicatLoginMode(true);
                odata.ml_data.ADDField("rules", tre->RULEBUFF.c_str(), tre->RULEBUFF.size());
                if (!ml_lang.empty())
                    odata.ml_data.ADDField("lang", ml_lang.c_str(), ml_lang.length());
                if (!ml_geo.empty())
                    odata.ml_data.ADDField("geo", ml_geo.c_str(), ml_geo.length());
                if (!ml_inam.empty())
                    odata.ml_data.ADDField("inam", ml_inam.c_str(), ml_inam.length());
                if (!ml_fnam.empty())
                    odata.ml_data.ADDField("fnam", ml_fnam.c_str(), ml_fnam.length());
                odata.ml_data.ADDField("rtyp", ml_rtype.c_str(), ml_rtype.length());
                if (!ml_ip6mask.empty())
                    odata.ml_data.ADDField("ip6m", ml_ip6mask.c_str(), ml_ip6mask.length());
                if (!ml_ip4mask.empty())
                    odata.ml_data.ADDField("ip4m", ml_ip4mask.c_str(), ml_ip4mask.length());

                if (odata.clust_data_answer_local.m_exists_data) {
                    const auto tstr = odata.clust_data_answer_local.cluster_number_s();
                    odata.ml_data.ADDField("clst_spam_percent", tstr.c_str(), tstr.length());
                }

                poolhttpcl::TDebugTiming ml_debug_time = poolhttpcl::TDebugTiming();
                MLPoolClients->RequestToServer(odata.ml_data, Numbrequest, 50, ml_debug_time);
                odata.ml_answer = odata.ml_data.ReturnData();

                ttt = CShingleTime::GetMs() - ttt;
                delays.SetDelayML(ttt, odata.ml_answer.m_err != poolhttpcl::KNONEERROR, ml_debug_time.m_wait_ms, ml_debug_time.m_connect_ms, ml_debug_time.m_request_ms, ml_debug_time.m_writelog_ms);

                switch (odata.ml_answer.m_err) {
                    case poolhttpcl::KNONEERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::OK, ttt);
                        break;
                    case poolhttpcl::KHOSTPORTERROR:
                    case poolhttpcl::KWAITERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::OTHERERR, ttt);
                        break;
                    case poolhttpcl::KCONNECTERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::CE, ttt);
                        break;
                    case poolhttpcl::KCONNECTTIMEOUTERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::CT, ttt);
                        break;
                    case poolhttpcl::KREQUESTERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::RE, ttt);
                        break;
                    case poolhttpcl::KREQUESTTIMEOUTERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::RT, ttt);
                        break;
                    case poolhttpcl::KREQUESTANSWERERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::BAD_RESPONSE, ttt);
                        break;
                };
            }
        }

        ttt = CShingleTime::GetMs();
        PrintML(Numbrequest, is_upstream_request, mllog_data);
        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayMLYT(ttt);

        if (Spam)
            odata.malic = m_hSp.ExistsbanInternal("MALICIOUS");

        res = true;

        m_Store.AddRuleStat(odata.regtime, tre->RULEBUFF.c_str()); //считаем статистику правил

        //change_res_by_ml = "CBML_MTM"; //!!!DEBUG!!!
        if (FilterPool)
            FilterPool->ReturnFilter(tre); //фильтр сработал, возвращаем его в пул фильтров
    }

    return res;
}

bool CSoFilter::RengineActionBig(
        TOData& odata,
        TReqParams* pReqParams,
        bool& Spam,
        TDelayClass& delays,
        const TString& Numbrequest,
        TSpamonLogStruct& monlogdata,
        bool is_upstream_request,
        const TLog& deliveryLog,
        const TLog& mlLog) {
    bool res = false;
    const char* field_name = NULL;
    TString skey = "";
    TString svalue = "";
    TString rulenamenew = "";
    TString rulename_statlist = "";
    int memory_index = 0;
    TRuleStatResList statruleres;
    TRuleStatResListIt srit;
    TReqParams::iterator par_it;
    int filterindex = 0;
    TRengineElement* tre = NULL;
    ui32 ttt = 0;
    TString ipsectext = "";
    TString ml_lang = "";
    TString ml_geo = "";
    TString ml_inam = "";
    TString ml_fnam = "";
    TString ml_fuid = "";
    TString ml_ipbs = "";
    TString ml_inbs = "";
    TString ml_fnbs = "";
    TString ml_ifbs = "";
    TString ml_phbs = "";
    TString ml_ifcn = "";
    TString ml_tenm = "";
    TString ml_tepl = "";
    TString ml_tefs = "";
    TString ml_teua = "";
    TString ml_teph = "";
    TString ml_rtype = "";
    TString ml_ip6mask = "";
    TString ml_ip4mask = "";
    THashMap<TString, TString> mllog_data;
    TExtRengineData ext_fltr_data;
    ui32 last_filter_result = 0;
    TString last_rule_text0 = "";
    TString last_rule_text1 = "";
    TString change_res_by_ml = "";
    ui64 check_field_tick = 0;
    ui32 check_field_tick_ms = 0;
    ui32 check_message_tick_ms = 0;
    ui32 prepare_tick_ms = 0;

    odata.ml_data.SetMessage();

    if (FilterPool)
        memory_index = FilterPool->GetNumberSection(odata.iplong.AsShingle32());
    ttt = CShingleTime::GetMs();
    if (FilterPool)
        tre = FilterPool->GetFilter();
    if (tre != NULL) {
        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayFilterGet(ttt);

        TRengine& m_hSp = tre->GetFilterHandle();

        if ((FilterPool) && (FilterPool->GetRulesMonStat() != NULL))
            FilterPool->GetRulesMonStat()->AddFilterCall(tre->GetRulesCS());

        for (size_t k = 0; k < 2; k++) {
            m_hSp.InitMessage(odata.messnumb, nullptr, nullptr, "", TSpClass::UNKNOWN, SysLogger());
            mllog_data.clear();
            ext_fltr_data.Clear();
            ttt = CShingleTime::GetMs();

            {
                const TString afResponseStr = NJson::WriteJson(odata.AfResponse);
                m_hSp.AddStat("af", afResponseStr);
                mllog_data["af"] = std::move(afResponseStr);
            }

            mllog_data["dubl"] = "no";

            if (odata.whiteip)
                ipsectext = ipsectext + "wht='" + odata.whitenet_source + "' ";
            if (odata.blackip)
                ipsectext = ipsectext + "blk='" + odata.blacknet_source + "' ";
            if (odata.gruppedip)
                ipsectext = ipsectext + "grp='" + odata.gruppednet_source + "' ";
            if (odata.ungruppedip)
                ipsectext = ipsectext + "ungrp='" + odata.ungruppednet_source + "' ";
            if (odata.whiteip_so)
                ipsectext = ipsectext + "wiso='" + odata.whitenet_so_source + "' ";
            if (odata.intranetzoneip_so)
                ipsectext = ipsectext + "izso='" + odata.intranetzone_so_source + "' ";
            if (odata.trustedzoneip_so)
                ipsectext = ipsectext + "tzso='" + odata.trustedzone_so_source + "' ";
            if (odata.localzoneip_so)
                ipsectext = ipsectext + "lzso='" + odata.localzone_so_source + "' ";

            check_field_tick = 0;
            check_field_tick_ms = 0;
            check_message_tick_ms = 0;
            prepare_tick_ms = 0;
            prepare_tick_ms = CShingleTime::GetMs();
            //***** START WORK FILTER *****
            filterindex = tre->GetIndex();
            m_hSp.AddStat("fidx", IntToStroka(filterindex) + "=" + tre->GetRulesCS());
            m_hSp.AddStat("rtyp", TPassportRequestTypeToTString(odata.passpreqtype, odata.passpreqtype_source));
            ml_rtype = TPassportRequestTypeToTString(odata.passpreqtype, odata.passpreqtype_source);
            mllog_data["rtyp"] = TPassportRequestTypeToTString(odata.passpreqtype, odata.passpreqtype_source);
            m_hSp.AddStat("ruid", odata.remote_uid);
            m_hSp.AddStat("ip  ", odata.iplong.toStroka());
            mllog_data["ip"] = odata.iplong.toStroka();
            m_hSp.AddStat("inet", ipsectext);
            if (odata.is_corrected)
                m_hSp.AddStat("ip_i", odata.ip_isx);
            m_hSp.AddStat("uid ", odata.uid);
            mllog_data["uid"] = odata.uid;
            if (!odata.ipstate.host.empty())
                m_hSp.AddStat("host", odata.ipstate.host + " (" + IntToStroka(odata.hoststat_domen2level) + ", " + IntToStroka(odata.hoststat_domen3level) + ")");
            if (!odata.ipstate.geo.empty()) {
                ml_geo = odata.ipstate.geo;
                m_hSp.AddStat("geos", odata.ipstate.geo + " (" + IntToStroka(odata.geostatcountcountry) + ", " + IntToStroka(odata.geostatcount) + ", diff=" + IntToStrokaDash(odata.timezone_diff) + "[" + odata.v2_account_timezone + "], night=" + BoolToStroka2(odata.is_night) + ") AS='" + odata.geos_as + "'(" + IntToStroka(odata.geostatascount) + ") tor='" + odata.geos_tor + "'");
                mllog_data["geos"] = odata.ipstate.geo;
            }

            if (odata.iplong.IsIPv6()) {
                m_hSp.AddStat("ip6m", IntToStroka(odata.ipv6maska1) + ", " + IntToStroka(odata.ipv6maska2) + ", " + IntToStroka(odata.ipv6maska3));
                ml_ip6mask = IntToStroka(odata.ipv6maska1) + "," + IntToStroka(odata.ipv6maska2) + "," + IntToStroka(odata.ipv6maska3);
                mllog_data["ip6m"] = ml_ip6mask;

            } else {
                m_hSp.AddStat("ip4m", IntToStroka(odata.ipv4maskaC));
                ml_ip4mask = IntToStroka(odata.ipv4maskaC);
                mllog_data["ip4m"] = ml_ip4mask;
            }

            m_hSp.AddStat("lang", odata.langstr);
            ml_lang = odata.langstr;
            mllog_data["lang"] = odata.langstr;

            if (!IsChangePass(odata.passpreqtype)) {
                if (odata.login_corr_exists)
                    m_hSp.AddStat("logn", odata.login + " (corr:" + IntToStroka(odata.login_corr_weigth) + ")");
                else
                    m_hSp.AddStat("logn", odata.login + " (corr:-)");

            } else {
                m_hSp.AddStat("logn", odata.login);
            }
            mllog_data["logn"] = odata.login;

            m_hSp.AddStat("rtim", TimeToStr(odata.regtime) + " (" + IntToStroka(odata.regtime) + ")");
            m_hSp.AddStat("pass", odata.passwhint_s + ", passwdex: " + odata.passwdex_s + ", addit: " + odata.passwdhintall.GetStr());
            mllog_data["pass"] = odata.passwhint_s + ", passwdex: " + odata.passwdex_s + ", addit: " + odata.passwdhintall.GetStr();
            m_hSp.AddStat("hqid", odata.hintqid_s);
            m_hSp.AddStat("ques", odata.questhint_s + ", hintqex: " + odata.hintqex_s + ", addit: " + odata.qhintall.GetStr());
            mllog_data["ques"] = odata.questhint_s + ", hintqex: " + odata.hintqex_s + ", addit: " + odata.qhintall.GetStr();
            m_hSp.AddStat("answ", odata.answerhint_s + ", hintaex: " + odata.hintaex_s + ", addit: " + odata.ahintall.GetStr());
            mllog_data["answ"] = odata.answerhint_s + ", hintaex: " + odata.hintaex_s + ", addit: " + odata.ahintall.GetStr();

            TString inamestat_s = IntToStroka(odata.constanants_serial_count_iname) + ", " + IntToStroka(odata.vowels_serial_count_iname) + ", " + IntToStroka(odata.digital_count_iname);
            if (odata.in_inamelist_cmp)
                m_hSp.AddStat("inam", odata.iname + " (TRSC: " + IntToStroka(odata.in_inamelist_cmp) + "=" + odata.s_inamelist_cmp + ", " + inamestat_s + ")");
            else
                m_hSp.AddStat("inam", odata.iname + " (" + inamestat_s + ")");
            ml_inam = inamestat_s;
            mllog_data["inam"] = odata.iname;

            TString fnamestat_s = IntToStroka(odata.constanants_serial_count_fname) + ", " + IntToStroka(odata.vowels_serial_count_fname) + ", " + IntToStroka(odata.digital_count_fname);
            if (odata.in_fnamelist_cmp)
                m_hSp.AddStat("fnam", odata.fname + " (TRSC: " + IntToStroka(odata.in_fnamelist_cmp) + "=" + odata.s_fnamelist_cmp + ", " + fnamestat_s + ")");
            else
                m_hSp.AddStat("fnam", odata.fname + " (" + fnamestat_s + ")");
            ml_fnam = fnamestat_s;
            mllog_data["fnam"] = odata.fname;

            if ((!odata.phonenumber_s.empty()) || (!odata.v2_phonenumber_hash.empty()))
                m_hSp.AddStat("phon", odata.phonenumber_s + " (" + odata.v2_phonenumber_hash + ")");
            m_hSp.AddStat("usag", odata.useragent_s);
            mllog_data["usag"] = odata.useragent_s;
            //m_hSp.AddStat("from", odata.from_s);
            m_hSp.AddStat("capt", "ccnt:" + IntToStroka(odata.captchacount) + ", creq:" + IntToStroka(odata.captchareq));
            mllog_data["capt"] = "ccnt:" + IntToStroka(odata.captchacount) + ", creq:" + IntToStroka(odata.captchareq);
            m_hSp.AddStat("lchk", IntToStroka(odata.lcheck));
            m_hSp.AddStat("stpt", "st1t:" + IntToStroka(odata.step1time) + ", st2t:" + IntToStroka(odata.step2time));
            m_hSp.AddStat("nick", odata.nickname);
            m_hSp.AddStat("emal", odata.email);

            m_hSp.AddStat("fuid", ui32ToStroka(odata.fuidcount) + ": '" + odata.fuid + "'");
            ml_fuid = IntToStroka(odata.fuidcount);
            mllog_data["fuid"] = IntToStroka(odata.fuidcount);

            m_hSp.AddStat("pck1", ui32ToStroka(odata.packet1count) + ": " + odata.pack1.GetDecodeData(false));
            m_hSp.AddStat("pck2", ui32ToStroka(odata.packet2count) + ": " + odata.pack2.GetDecodeData(false));
            m_hSp.AddStat("pck3", ui32ToStroka(odata.packet3count) + ": " + odata.pack3.GetDecodeData());
            m_hSp.AddStat("pck4", ui32ToStroka(odata.packet4count) + ": " + odata.pack4.GetDecodeData());
            m_hSp.AddStat("pck5", ui32ToStroka(odata.packet5count) + ": " + odata.pack5.GetDecodeData(true));
            m_hSp.AddStat("cmpn", odata.cmp_names_s);

            if (!IsChangePass(odata.passpreqtype)) {
                m_hSp.AddStat("ifcn", ui32ToStroka(odata.ipstate.count_iname) + ", " + ui32ToStroka(odata.ipstate.count_fname) + ", " + ui32ToStroka(odata.ipstate.count_both));
                ml_ifcn = IntToStroka(odata.ipstate.count_iname) + ", " + IntToStroka(odata.ipstate.count_fname) + ", " + IntToStroka(odata.ipstate.count_both);
            }

            m_hSp.AddStat("divs", "pairlz=" + FloatToStr(odata.divpaircv) + " digitslz=" + FloatToStr(odata.divdigits));
            mllog_data["divs"] = "pairlz=" + FloatToStr(odata.divpaircv) + " digitslz=" + FloatToStr(odata.divdigits);

            if (!IsChangePass(odata.passpreqtype)) {
                m_hSp.AddStat("tenm", ui32ToStroka(odata.ipstate.count_ip_equalifname300) + ", " + ui32ToStroka(odata.ipstate.count_ip_equalifname1200));
                ml_tenm = IntToStroka(odata.ipstate.count_ip_equalifname300) + ", " + IntToStroka(odata.ipstate.count_ip_equalifname1200);
            }

            if (IsChangePass(odata.passpreqtype)) {
                m_hSp.AddStat("  cn", ui32ToStroka(odata.passwdchangestat.count_record300) + ", " + ui32ToStroka(odata.passwdchangestat.count_record600) + ", " + ui32ToStroka(odata.passwdchangestat.count_record1200) + ", " + ui32ToStroka(odata.passwdchangestat.count_record3600));
                m_hSp.AddStat("cnip", ui32ToStroka(odata.passwdchangestat.count_ip_record300) + ", " + ui32ToStroka(odata.passwdchangestat.count_ip_record600) + ", " + ui32ToStroka(odata.passwdchangestat.count_ip_record1200) + ", " + ui32ToStroka(odata.passwdchangestat.count_ip_record3600));
                mllog_data["cnip"] = ui32ToStroka(odata.passwdchangestat.count_ip_record300) + ", " + ui32ToStroka(odata.passwdchangestat.count_ip_record600) + ", " + ui32ToStroka(odata.passwdchangestat.count_ip_record1200) + ", " + ui32ToStroka(odata.passwdchangestat.count_ip_record3600);
            }

            m_hSp.AddStat("ship", "5min:" + ui32ToStroka(odata.ipstate.count_ip_record300) + ", 10min:" + ui32ToStroka(odata.ipstate.count_ip_record600) + ", 1hour:" + ui32ToStroka(odata.ipstate.count_ip_record3600) + ", all:" + ui32ToStroka(odata.ipstate.record_count) + ", s:" + ui32ToStroka(odata.ipstate.spamreg_count_ip) + ", s/all:" + FloatToStr(odata.otnosh_spam_ip));
            mllog_data["ship"] = "5min:" + ui32ToStroka(odata.ipstate.count_ip_record300) + ", 10min:" + ui32ToStroka(odata.ipstate.count_ip_record600) + ", 1hour:" + ui32ToStroka(odata.ipstate.count_ip_record3600) + ", all:" + ui32ToStroka(odata.ipstate.record_count) + ", s:" + ui32ToStroka(odata.ipstate.spamreg_count_ip) + ", s/all:" + FloatToStr(odata.otnosh_spam_ip);

            m_hSp.AddStat("tepl", ui32ToStroka(odata.ltcs.stat_300.equal_prefix_login_count) + ", " + ui32ToStroka(odata.ltcs.stat_1200.equal_prefix_login_count));
            ml_tepl = IntToStroka(odata.ltcs.stat_300.equal_prefix_login_count) + ", " + IntToStroka(odata.ltcs.stat_1200.equal_prefix_login_count);
            mllog_data["tepl"] = IntToStroka(odata.ltcs.stat_300.equal_prefix_login_count) + ", " + IntToStroka(odata.ltcs.stat_1200.equal_prefix_login_count);

            m_hSp.AddStat("tefs", ui32ToStroka(odata.ltcs.stat_300.equal_first_nsymb_count) + ", " + ui32ToStroka(odata.ltcs.stat_1200.equal_first_nsymb_count));
            ml_tefs = IntToStroka(odata.ltcs.stat_300.equal_first_nsymb_count) + ", " + IntToStroka(odata.ltcs.stat_1200.equal_first_nsymb_count);
            mllog_data["tefs"] = IntToStroka(odata.ltcs.stat_300.equal_first_nsymb_count) + ", " + IntToStroka(odata.ltcs.stat_1200.equal_first_nsymb_count);

            m_hSp.AddStat("teua", ui32ToStroka(odata.ltcs.stat_300.equal_useragent_count) + ", " + ui32ToStroka(odata.ltcs.stat_1200.equal_useragent_count));
            ml_teua = IntToStroka(odata.ltcs.stat_300.equal_useragent_count) + ", " + IntToStroka(odata.ltcs.stat_1200.equal_useragent_count);
            mllog_data["teua"] = IntToStroka(odata.ltcs.stat_300.equal_useragent_count) + ", " + IntToStroka(odata.ltcs.stat_1200.equal_useragent_count);

            m_hSp.AddStat("teph", ui32ToStroka(odata.ltcs.stat_300.est_phone_count) + ", " + ui32ToStroka(odata.ltcs.stat_1200.est_phone_count));
            ml_teph = IntToStroka(odata.ltcs.stat_300.est_phone_count) + ", " + IntToStroka(odata.ltcs.stat_1200.est_phone_count);
            mllog_data["teph"] = IntToStroka(odata.ltcs.stat_300.est_phone_count) + ", " + IntToStroka(odata.ltcs.stat_1200.est_phone_count);

            m_hSp.AddStat("snow", "a:" + IntToStroka(odata.snow.all) + " (" + FloatToStr(odata.savr_oa) + "), s:" + IntToStroka(odata.snow.spam) + " (" + FloatToStr(odata.savr_os) + "), e:" + IntToStroka(odata.snow.error) + " (" + FloatToStr(odata.savr_oe) + "), h:" + IntToStroka(odata.snow.ham) + " (" + FloatToStr(odata.savr_oh) + ")");
            mllog_data["snow"] = "a:" + IntToStroka(odata.snow.all) + " (" + FloatToStr(odata.savr_oa) + "), s:" + IntToStroka(odata.snow.spam) + " (" + FloatToStr(odata.savr_os) + "), e:" + IntToStroka(odata.snow.error) + " (" + FloatToStr(odata.savr_oe) + "), h:" + IntToStroka(odata.snow.ham) + " (" + FloatToStr(odata.savr_oh) + ")";

            m_hSp.AddStat("savr", "a:" + IntToStroka(odata.savr.all) + ", s:" + IntToStroka(odata.savr.spam) + ", e:" + IntToStroka(odata.savr.error) + ", h:" + IntToStroka(odata.savr.ham));
            m_hSp.AddStat("yuid", TimeToStr(odata.yandexuid_timestamp) + " (" + IntToStroka(odata.user_kuka) + ")");

            if (odata.iplong_shingle != 0) {
                m_hSp.AddStat("ipbs", "'" + ShingleToStroka(odata.iplong_shingle) + "' " + IntToStroka(odata.ipb_day) + ", " + IntToStroka(odata.ipb_ham) + ", " + IntToStroka(odata.ipb_spam85) + ", " + IntToStroka(odata.ipb_spam100) + ", " + FloatToStr(odata.ipb_spamrate));
                mllog_data["ipbs"] = "'" + ShingleToStroka(odata.iplong_shingle) + "' " + IntToStroka(odata.ipb_day) + ", " + IntToStroka(odata.ipb_ham) + ", " + IntToStroka(odata.ipb_spam85) + ", " + IntToStroka(odata.ipb_spam100) + ", " + FloatToStr(odata.ipb_spamrate);
            } else
                m_hSp.AddStat("ipbs", "-");

            if (odata.iname_ipv6_shingle != 0) {
                m_hSp.AddStat("inbs", "'" + ShingleToStroka(odata.iname_ipv6_shingle) + "' " + IntToStroka(odata.inameb_day) + ", " + IntToStroka(odata.inameb_ham) + ", " + IntToStroka(odata.inameb_spam85) + ", " + IntToStroka(odata.inameb_spam100) + ", " + FloatToStr(odata.inameb_spamrate));
                mllog_data["inbs"] = "'" + ShingleToStroka(odata.iname_ipv6_shingle) + "' " + IntToStroka(odata.inameb_day) + ", " + IntToStroka(odata.inameb_ham) + ", " + IntToStroka(odata.inameb_spam85) + ", " + IntToStroka(odata.inameb_spam100) + ", " + FloatToStr(odata.inameb_spamrate);
            } else
                m_hSp.AddStat("inbs", "-");

            if (odata.fname_ipv6_shingle != 0) {
                m_hSp.AddStat("fnbs", "'" + ShingleToStroka(odata.fname_ipv6_shingle) + "' " + IntToStroka(odata.fnameb_day) + ", " + IntToStroka(odata.fnameb_ham) + ", " + IntToStroka(odata.fnameb_spam85) + ", " + IntToStroka(odata.fnameb_spam100) + ", " + FloatToStr(odata.fnameb_spamrate));
                mllog_data["fnbs"] = "'" + ShingleToStroka(odata.fname_ipv6_shingle) + "' " + IntToStroka(odata.fnameb_day) + ", " + IntToStroka(odata.fnameb_ham) + ", " + IntToStroka(odata.fnameb_spam85) + ", " + IntToStroka(odata.fnameb_spam100) + ", " + FloatToStr(odata.fnameb_spamrate);
            } else
                m_hSp.AddStat("fnbs", "-");

            if (odata.ifname_ipv6_shingle != 0) {
                m_hSp.AddStat("ifbs", "'" + ShingleToStroka(odata.ifname_ipv6_shingle) + "' " + IntToStroka(odata.ifnameb_day) + ", " + IntToStroka(odata.ifnameb_ham) + ", " + IntToStroka(odata.ifnameb_spam85) + ", " + IntToStroka(odata.ifnameb_spam100) + ", " + FloatToStr(odata.ifnameb_spamrate));
                mllog_data["ifbs"] = "'" + ShingleToStroka(odata.ifname_ipv6_shingle) + "' " + IntToStroka(odata.ifnameb_day) + ", " + IntToStroka(odata.ifnameb_ham) + ", " + IntToStroka(odata.ifnameb_spam85) + ", " + IntToStroka(odata.ifnameb_spam100) + ", " + FloatToStr(odata.ifnameb_spamrate);
            } else
                m_hSp.AddStat("ifbs", "-");

            if (odata.phone_ipv6_shingle != 0) {
                m_hSp.AddStat("phbs", "'" + ShingleToStroka(odata.phone_ipv6_shingle) + "' " + IntToStroka(odata.phoneb_day) + ", " + IntToStroka(odata.phoneb_ham) + ", " + IntToStroka(odata.phoneb_spam85) + ", " + IntToStroka(odata.phoneb_spam100) + ", " + FloatToStr(odata.phoneb_spamrate));
                mllog_data["phbs"] = "'" + ShingleToStroka(odata.phone_ipv6_shingle) + "' " + IntToStroka(odata.phoneb_day) + ", " + IntToStroka(odata.phoneb_ham) + ", " + IntToStroka(odata.phoneb_spam85) + ", " + IntToStroka(odata.phoneb_spam100) + ", " + FloatToStr(odata.phoneb_spamrate);
            } else
                m_hSp.AddStat("phbs", "-");

            ml_ipbs = IntToStroka(odata.ipb_day) + ", " + IntToStroka(odata.ipb_ham) + ", " + IntToStroka(odata.ipb_spam85) + ", " + IntToStroka(odata.ipb_spam100) + ", " + FloatToStr(odata.ipb_spamrate);
            ml_inbs = IntToStroka(odata.inameb_day) + ", " + IntToStroka(odata.inameb_ham) + ", " + IntToStroka(odata.inameb_spam85) + ", " + IntToStroka(odata.inameb_spam100) + ", " + FloatToStr(odata.inameb_spamrate);
            ml_fnbs = IntToStroka(odata.fnameb_day) + ", " + IntToStroka(odata.fnameb_ham) + ", " + IntToStroka(odata.fnameb_spam85) + ", " + IntToStroka(odata.fnameb_spam100) + ", " + FloatToStr(odata.fnameb_spamrate);
            ml_ifbs = IntToStroka(odata.ifnameb_day) + ", " + IntToStroka(odata.ifnameb_ham) + ", " + IntToStroka(odata.ifnameb_spam85) + ", " + IntToStroka(odata.ifnameb_spam100) + ", " + FloatToStr(odata.ifnameb_spamrate);
            ml_phbs = IntToStroka(odata.phoneb_day) + ", " + IntToStroka(odata.phoneb_ham) + ", " + IntToStroka(odata.phoneb_spam85) + ", " + IntToStroka(odata.phoneb_spam100) + ", " + FloatToStr(odata.phoneb_spamrate);

            if (odata.passpreqtype == TP_ADMSOCIALREG)
                m_hSp.AddStat("isoc", "yes (" + odata.social_provider + ")");
            else
                m_hSp.AddStat("isoc", "no");
            m_hSp.AddStat("spst", odata.spst_answer.ToText());

            if (!odata.logindomen.empty())
                m_hSp.AddStat("ldmn", "'" + odata.logindomen + "'('" + odata.login_src_domen_puny + "'), " + IntToStroka(odata.domenstat));

            //!!!!!!!!!!!!DEBUG!!!!!!!!!!!!!!!
            /*odata.pddinfo.m_est_data       = true;
            odata.pddinfo.m_host           = "tut.by";
            odata.pddinfo.m_last_update    = 1432633426;
            odata.pddinfo.m_firsttime      = 1415159452;
            odata.pddinfo.m_mailbox_count  = 65535;
            odata.pddinfo.m_freereg        = false;
            odata.pddinfo.m_adm_login      = "tutby-adm";
            odata.pddinfo.m_quota          = 65535;
            odata.pddinfo.m_manual_req     = true;
            odata.pddinfo.m_karma          = 50;
            odata.pddinfo.m_ip             = TKIPv6("212.98.163.242");
            odata.pddinfo.m_geo            = "ru"; */
            //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

            if (!odata.pddinfo.m_host.empty()) {
                m_hSp.AddStat("lpdd", odata.pddinfo.toLog());

                int pdd_age = odata.pddinfo.m_last_update - odata.pddinfo.m_firsttime;
                if (pdd_age >= 0) {
                    pdd_age = pdd_age / 3600 / 24;
                    m_hSp.CheckRange("pdd_age", (int)pdd_age);
                }

                m_hSp.CheckRange("pdd_mailbox", (int)odata.pddinfo.m_mailbox_count);
                m_hSp.CheckRange("pdd_karma", (int)odata.pddinfo.m_karma);

                if (odata.pddinfo.m_adm_login.length() > 0)
                    check_field_tick += SpCheckFieldTick(m_hSp, "pdd_admin", odata.pddinfo.m_adm_login.c_str(), odata.pddinfo.m_adm_login.length(), "cp1251", true, false, delays.GetRuleHash());
                if (odata.pddinfo.m_ip.toStroka2().length() > 0)
                    check_field_tick += SpCheckFieldTick(m_hSp, "pdd_ip", odata.pddinfo.m_ip.toStroka2().c_str(), odata.pddinfo.m_ip.toStroka2().length(), "cp1251", true, false, delays.GetRuleHash());
                if (odata.pddinfo.m_geo.length() > 0)
                    check_field_tick += SpCheckFieldTick(m_hSp, "pdd_geo", odata.pddinfo.m_geo.c_str(), odata.pddinfo.m_geo.length(), "cp1251", true, false, delays.GetRuleHash());
            }

            if (odata.bboxinfo.m_est_data) {
                m_hSp.AddStat("bbox", odata.bboxinfo.toLog());

                m_hSp.CheckRange("bbox_admlogin_karma", (int)odata.bboxinfo.m_karma);
                m_hSp.CheckRange("bbox_admlogin_karma_status", (int)odata.bboxinfo.m_karma_status);
            }

            m_hSp.CheckValueAllRules(FD_AF, odata.AfResponse);
            //---------- тип запроса от паспорта ------

            switch (odata.passpreqtype) {
                default:
                    break;
                case TP_UNKNOWN:
                    SpSetRule(m_hSp, "REQTYPE_UNKNOWN");
                    break;
                case TP_LIGHTREGISTER:
                    SpSetRule(m_hSp, "REQTYPE_LIGHTREGISTER");
                    break;
                case TP_REGONE:
                    //SpSetRule(m_hSp, "REQTYPE_REGONE");
                    break;
                case TP_REGISTER:
                    //SpSetRule(m_hSp, "REQTYPE_REGISTER");
                    break;
                case TP_ADMSOCIALREG:
                    SpSetRule(m_hSp, "REQTYPE_ADMSOCIALREG");
                    break;
                case TP_ADMIMPORTREG:
                    //SpSetRule(m_hSp, "REQTYPE_ADMIMPORTREG");
                    break;
                case TP_ADMREG:
                    SpSetRule(m_hSp, "REQTYPE_ADMREG");
                    break;

                case TP_CHANGEPASS_BASE:
                    SpSetRule(m_hSp, "REQTYPE_CHANGEPASS");
                    //SpSetRule(m_hSp, "REQTYPE_CHANGEPASS_BASE");
                    break;
                case TP_CHANGE_PASSWORD_FORCE:
                    SpSetRule(m_hSp, "REQTYPE_CHANGEPASS");
                    SpSetRule(m_hSp, "REQTYPE_CHANGE_PASSWORD_FORCE");
                    break;
                case TP_CHANGE_PASSWORD_STRONG:
                    SpSetRule(m_hSp, "REQTYPE_CHANGEPASS");
                    SpSetRule(m_hSp, "REQTYPE_CHANGE_PASSWORD_STRONG");
                    break;
                case TP_CHANGE_PASSWORD_VOLUNTARILY:
                    SpSetRule(m_hSp, "REQTYPE_CHANGEPASS");
                    SpSetRule(m_hSp, "REQTYPE_CHANGE_PASSWORD_VOLUNTARILY");
                    break;
                case TP_CHANGE_PASSWORD:
                    SpSetRule(m_hSp, "REQTYPE_CHANGEPASS");
                    SpSetRule(m_hSp, "REQTYPE_CHANGE_PASSWORD");
                    break;

                case TP_SIMPLEREG:
                    //SpSetRule(m_hSp, "REQTYPE_SIMPLEREG");
                    break;
                case TP_POSTREGISTRATION:
                    //SpSetRule(m_hSp, "REQTYPE_POSTREGISTRATION");
                    break;
                case TP_REQTYPE_COMPLETE:
                    SpSetRule(m_hSp, "REQTYPE_COMPLETE");
                    break;
                case TP_PHONEREG:
                    SpSetRule(m_hSp, "REQTYPE_PHONEREG");
                    break;
                case TP_ALTERNATIVEPHONE:
                    SpSetRule(m_hSp, "REQTYPE_ALTERNATIVEPHONE");
                    break;
                case TP_ALTERNATIVEHINT:
                    SpSetRule(m_hSp, "REQTYPE_ALTERNATIVEHINT");
                    break;
                case TP_UNCOMPLEATESETPASWD:
                    SpSetRule(m_hSp, "REQTYPE_UNCOMPLEATESETPASWD");
                    break;
                case TP_COMPLEATE_PDD:
                    SpSetRule(m_hSp, "REQTYPE_COMPLEATE_PDD");
                    break;
                case TP_DIRECTORYREG:
                    SpSetRule(m_hSp, "REQTYPE_DIRECTORYREG");
                    break;
            };

            //rbl rules lists (combinedbl e.t.c.)
            TRBLHostClass::TRBLWorkRuleListIt rit = odata.rbl_rulelist.begin();
            while (rit != odata.rbl_rulelist.end()) {
                if (!(*rit).empty())
                    SpSetRule(m_hSp, (*rit).c_str());

                ++rit;
            }

            //по from
            if (odata.from_pdd)
                SpSetRule(m_hSp, "IS_PDD");

            if (odata.timezone_diff >= 0)
                m_hSp.CheckRange("tm_diff", odata.timezone_diff);
            if (odata.is_night)
                SpSetRule(m_hSp, "TM_NIGHT");

            TString tms1 = "", tms2 = "", tms3 = "", tms4 = "", tms5 = "", tms6 = "";

            if ((odata.tm1 < 0) || (odata.tm2 < 0) || (odata.tm3 < 0) || (odata.tm4 < 0) || (odata.tm5 < 0))
                SpSetRule(m_hSp, "ALARM_TIMING_NEGATIVE");
            if (odata.tm1_exists) {
                tms1 = IntToStrokaS(odata.tm1);
                m_hSp.CheckRange("v2_password_validation_last_call-v2_password_validation_first_call", odata.tm1);
            } else
                tms1 = "-";
            if (odata.tm2_exists) {
                tms2 = IntToStrokaS(odata.tm2);
                m_hSp.CheckRange("v2_sanitize_phone_last_call-v2_sanitize_phone_first_call", odata.tm2);
            } else
                tms2 = "-";
            if (odata.tm3_exists) {
                tms3 = IntToStrokaS(odata.tm3);
                m_hSp.CheckRange("v2_captcha_checked_at-v2_track_created", odata.tm3);
            } else
                tms3 = "-";
            if (odata.tm4_exists) {
                tms4 = IntToStrokaS(odata.tm4);
                m_hSp.CheckRange("v2_captcha_checked_at-v2_captcha_generated_at", odata.tm4);
            } else
                tms4 = "-";
            if (odata.tm5_exists) {
                tms5 = IntToStrokaS(odata.tm5);
                m_hSp.CheckRange("v2_login_validation_last_call-v2_login_validation_first_call", odata.tm5);
            } else
                tms5 = "-";
            if (odata.tm6_exists) {
                tms6 = IntToStrokaS(odata.tm6);
                m_hSp.CheckRange("v2_suggest_login_last_call-v2_suggest_login_first_call", odata.tm6);
            } else
                tms6 = "-";
            m_hSp.AddStat("tmng", "tm1=" + tms1 + " tm2=" + tms2 + " tm3=" + tms3 + " tm4=" + tms4 + " tm5=" + tms5 + " tm6=" + tms6);
            mllog_data["tmng"] = "tm1=" + tms1 + " tm2=" + tms2 + " tm3=" + tms3 + " tm4=" + tms4 + " tm5=" + tms5 + " tm6=" + tms6;

            m_hSp.AddStat("v2cl", IntToStroka(odata.v2_cookie_l_timestamp_diff));
            m_hSp.CheckRange("V2_COOKIE_L_TIMESTAMP_DIFF", (int)odata.v2_cookie_l_timestamp_diff);

            if (odata.v2_cookie_l_login_rate)
                SpSetRule(m_hSp, "DIFF_L_LOGIN");
            if (odata.v2_cookie_l_uid_rate)
                SpSetRule(m_hSp, "DIFF_UID_LUID");

            //---------- данные с спамстата -----------
            if (odata.spst_answer.m_exists_data) {
                if (odata.spst_answer.m_today_autoban)
                    SpSetRule(m_hSp, "SPST_TODAY_AUTOBAN");
                if (odata.spst_answer.m_today_manualban)
                    SpSetRule(m_hSp, "SPST_TODAY_MANUALBAN");
                if (odata.spst_answer.m_today_white)
                    SpSetRule(m_hSp, "SPST_TODAY_WHITE");
                if (odata.spst_answer.m_today_rbl)
                    SpSetRule(m_hSp, "SPST_TODAY_RBL");
                m_hSp.CheckRange("spst_today_ham", (int)odata.spst_answer.m_today_ham);
                m_hSp.CheckRange("spst_today_spam", (int)odata.spst_answer.m_today_spam);
                m_hSp.CheckRange("spst_today_malic", (int)odata.spst_answer.m_today_malic);
                m_hSp.CheckRange("spst_today_percentspam", (int)odata.spst_answer.m_today_spam_percent);

                if (odata.spst_answer.m_yesterday_autoban)
                    SpSetRule(m_hSp, "SPST_YESTERDAY_AUTOBAN");
                if (odata.spst_answer.m_yesterday_manualban)
                    SpSetRule(m_hSp, "SPST_YESTERDAY_MANUALBAN");
                if (odata.spst_answer.m_yesterday_white)
                    SpSetRule(m_hSp, "SPST_YESTERDAY_WHITE");
                if (odata.spst_answer.m_yesterday_rbl)
                    SpSetRule(m_hSp, "SPST_YESTERDAY_RBL");
                m_hSp.CheckRange("spst_yesterday_ham", (int)odata.spst_answer.m_yesterday_ham);
                m_hSp.CheckRange("spst_yesterday_spam", (int)odata.spst_answer.m_yesterday_spam);
                m_hSp.CheckRange("spst_yesterday_malic", (int)odata.spst_answer.m_yesterday_malic);
                m_hSp.CheckRange("spst_yesterday_percentspam", (int)odata.spst_answer.m_yesterday_spam_percent);

                m_hSp.CheckRange("spst_history_ham", (int)odata.spst_answer.m_history_ham);
                m_hSp.CheckRange("spst_history_spam", (int)odata.spst_answer.m_history_spam);
                m_hSp.CheckRange("spst_history_rejectdays", (int)odata.spst_answer.m_history_reject);
                m_hSp.CheckRange("spst_history_norejectdays", (int)odata.spst_answer.m_history_noreject);
                m_hSp.CheckRange("spst_history_percentspam", (int)odata.spst_answer.m_history_spam_percent);
            } else {
                SpSetRule(m_hSp, "SPST_NODATA");
            }

            //---------------------------------------

            m_hSp.AddStat("cls2", odata.clust_data_answer_local.toDeliveryLog());
            if (odata.clust_data_answer_local.m_exists_data) {
                m_hSp.CheckRange("clst_spam_percent", (double)odata.clust_data_answer_local.m_cluster_spam_percent);
            }

            if (odata.blackip)
                SpSetRule(m_hSp, "IS_BLACK_LIST");
            if (odata.trustip)
                SpSetRule(m_hSp, "IS_TRUST_LIST");
            if (odata.whiteip)
                SpSetRule(m_hSp, "IS_WHITE_LIST");
            if (odata.gruppedip)
                SpSetRule(m_hSp, "IS_GRUPPEDIP_LIST");
            if (odata.ungruppedip)
                SpSetRule(m_hSp, "IS_UNGRUPPEDIP_LIST");
            if (odata.cmp_names)
                SpSetRule(m_hSp, "COMPARE_LOGINNAMES");
            if (odata.cmp_iname)
                SpSetRule(m_hSp, "COMPARE_LOGININAME");
            if (odata.cmp_fname)
                SpSetRule(m_hSp, "COMPARE_LOGINFNAME");
            if (odata.cmp_ifname)
                SpSetRule(m_hSp, "COMPARE_IFNAMES");

            if (odata.whiteip_so)
                SpSetRule(m_hSp, "IS_WHITESO_LIST");
            if (odata.intranetzoneip_so)
                SpSetRule(m_hSp, "IS_INTRZONESO_LIST");
            if (odata.trustedzoneip_so)
                SpSetRule(m_hSp, "IS_TRUSTZONESO_LIST");
            if (odata.localzoneip_so)
                SpSetRule(m_hSp, "IS_LOCALZONESO_LIST");

            if (!odata.geos_tor.empty())
                SpSetRule(m_hSp, "TOR_RBL");

            //time statrule
            m_Store.GetRuleStat(odata.regtime - 1200, statruleres, true, check_count);
            srit = statruleres.begin();
            while (srit != statruleres.end()) {
                rulenamenew = "TSTAT1200" + (*srit).rulename;
                rulename_statlist += rulenamenew + "(" + IntToStroka((*srit).count) + "), ";
                m_hSp.CheckRange(rulenamenew.c_str(), (int)(*srit).count);
                ++srit;
            }
            m_Store.GetRuleStat(odata.regtime - 300, statruleres, false, check_count);
            srit = statruleres.begin();
            while (srit != statruleres.end()) {
                rulenamenew = "TSTAT300" + (*srit).rulename;
                rulename_statlist += rulenamenew + "(" + IntToStroka((*srit).count) + "), ";
                m_hSp.CheckRange(rulenamenew.c_str(), (int)(*srit).count);
                ++srit;
            }
            statruleres.clear();

            m_hSp.AddStat("stru", rulename_statlist);

            m_hSp.CheckRange("login_long", odata.login_length);
            m_hSp.CheckRange("vowels_count", odata.vowels_serial_count);
            m_hSp.CheckRange("digits_count", odata.digits_count);
            m_hSp.CheckRange("constanants_count", odata.constanants_serial_count);
            m_hSp.CheckRange("constanants_digits_count", odata.constanants_digits_serial_count);
            m_hSp.CheckRange("prefix_login_length", odata.prefix_login_length);

            m_hSp.CheckRange("iname_constanants_serial_count", odata.constanants_serial_count_iname);
            m_hSp.CheckRange("iname_vowels_serial_count", odata.vowels_serial_count_iname);
            m_hSp.CheckRange("iname_digital_count", odata.digital_count_iname);
            m_hSp.CheckRange("fname_constanants_serial_count", odata.constanants_serial_count_fname);
            m_hSp.CheckRange("fname_vowels_serial_count", odata.vowels_serial_count_fname);
            m_hSp.CheckRange("fname_digital_count", odata.digital_count_fname);

            if (!IsChangePass(odata.passpreqtype)) {
                m_hSp.CheckRange("total_from_ip", (int)odata.ipstate.record_count);
                m_hSp.CheckRange("count_reg_fromip_lasthour", (int)odata.ipstate.count_ip_record3600);
                m_hSp.CheckRange("count_reg_fromip_last10min", (int)odata.ipstate.count_ip_record600);
                m_hSp.CheckRange("count_reg_fromip_last5min", (int)odata.ipstate.count_ip_record300);
                m_hSp.CheckRange("passw_hint_count_ip", (int)odata.ipstate.passw_hint_count);
                m_hSp.CheckRange("quest_hint_count_ip", (int)odata.ipstate.quest_hint_count);
                m_hSp.CheckRange("answer_hint_count_ip", (int)odata.ipstate.answer_hint_count);
                m_hSp.CheckRange("addit_hint_count_ip", (int)odata.ipstate.addit_hint_count);
                m_hSp.CheckRange("allreg_count_ip", (int)odata.ipstate.allreg_count_ip);
                m_hSp.CheckRange("spamreg_count_ip", (int)odata.ipstate.spamreg_count_ip);
                m_hSp.CheckRange("spamreg_count_ip/allreg_count_ip", odata.otnosh_spam_ip);
                m_hSp.CheckRange("repeat_loginprefix_ip", (int)odata.ipstate.repeat_loginprefix_ip);
                m_hSp.CheckRange("first_nsymb_login_ip", (int)odata.ipstate.first_nsymb_login_ip);
                m_hSp.CheckRange("count_iname_fromip", (int)odata.ipstate.count_iname);
                m_hSp.CheckRange("count_fname_fromip", (int)odata.ipstate.count_fname);
                m_hSp.CheckRange("count_ifname_fromip", (int)odata.ipstate.count_both);
                m_hSp.CheckRange("equalifname_300", (int)odata.ipstate.count_ip_equalifname300);
                m_hSp.CheckRange("equalifname_1200", (int)odata.ipstate.count_ip_equalifname1200);
            } else {
                m_hSp.CheckRange("count_during_300", (int)odata.passwdchangestat.count_record300);
                m_hSp.CheckRange("count_during_600", (int)odata.passwdchangestat.count_record600);
                m_hSp.CheckRange("count_during_1200", (int)odata.passwdchangestat.count_record1200);
                m_hSp.CheckRange("count_during_3600", (int)odata.passwdchangestat.count_record3600);
                m_hSp.CheckRange("count_ip_during_300", (int)odata.passwdchangestat.count_ip_record300);
                m_hSp.CheckRange("count_ip_during_600", (int)odata.passwdchangestat.count_ip_record600);
                m_hSp.CheckRange("count_ip_during_1200", (int)odata.passwdchangestat.count_ip_record1200);
                m_hSp.CheckRange("count_ip_during_3600", (int)odata.passwdchangestat.count_ip_record3600);
            }

            m_hSp.CheckRange("count_fuid", (int)odata.fuidcount);
            m_hSp.CheckRange("count_packet01", (int)odata.packet1count);
            m_hSp.CheckRange("count_packet02", (int)odata.packet2count);
            m_hSp.CheckRange("count_packet03", (int)odata.packet3count);
            m_hSp.CheckRange("count_packet04", (int)odata.packet4count);
            m_hSp.CheckRange("count_packet05", (int)odata.packet5count);
            if (!odata.ipstate.geo.empty()) {
                m_hSp.CheckRange("count_geostatcountry", (int)odata.geostatcountcountry);
                m_hSp.CheckRange("count_geostat", (int)odata.geostatcount);
                m_hSp.CheckRange("count_geostat_as", (int)odata.geostatascount);
            }
            if (!odata.ipstate.host.empty()) {
                m_hSp.CheckRange("count_host2level", (int)odata.hoststat_domen2level);
                m_hSp.CheckRange("count_host3level", (int)odata.hoststat_domen3level);
            }
            if (!odata.logindomen.empty())
                m_hSp.CheckRange("count_logindomen", (int)odata.domenstat);

            if (odata.iplong.IsIPv6()) {
                m_hSp.CheckRange("ipv6maska64", (int)odata.ipv6maska1);
                m_hSp.CheckRange("ipv6maska48", (int)odata.ipv6maska2);
                m_hSp.CheckRange("ipv6maska32", (int)odata.ipv6maska3);

            } else {
                m_hSp.CheckRange("ipv4maskaC", (int)odata.ipv4maskaC);
            }

            m_hSp.CheckRange("pairlz", odata.divpaircv);
            m_hSp.CheckRange("digitslz", odata.divdigits);

            m_hSp.CheckRange("captchacount", (int)odata.captchacount);
            m_hSp.CheckRange("captchareq", (int)odata.captchareq);
            m_hSp.CheckRange("lcheck", (int)odata.lcheck);
            m_hSp.CheckRange("step1time", (int)odata.step1time);
            m_hSp.CheckRange("step2time", (int)odata.step2time);

            m_hSp.CheckRange("dev_all", odata.savr_oa);
            m_hSp.CheckRange("dev_spam", odata.savr_os);
            m_hSp.CheckRange("dev_error", odata.savr_oe);
            m_hSp.CheckRange("dev_ham", odata.savr_oh);
            m_hSp.CheckRange("yandexuid", (int)odata.user_kuka);

            m_hSp.CheckRange("ipb_day", (int)odata.ipb_day);
            m_hSp.CheckRange("ipb_ham", (int)odata.ipb_ham);
            m_hSp.CheckRange("ipb_spam85", (int)odata.ipb_spam85);
            m_hSp.CheckRange("ipb_spam100", (int)odata.ipb_spam100);
            m_hSp.CheckRange("ipb_rspamate", odata.ipb_spamrate);

            m_hSp.CheckRange("inameb_day", (int)odata.inameb_day);
            m_hSp.CheckRange("inameb_ham", (int)odata.inameb_ham);
            m_hSp.CheckRange("inameb_spam85", (int)odata.inameb_spam85);
            m_hSp.CheckRange("inameb_spam100", (int)odata.inameb_spam100);
            m_hSp.CheckRange("inameb_rspamate", odata.inameb_spamrate);

            m_hSp.CheckRange("fnameb_day", (int)odata.fnameb_day);
            m_hSp.CheckRange("fnameb_ham", (int)odata.fnameb_ham);
            m_hSp.CheckRange("fnameb_spam85", (int)odata.fnameb_spam85);
            m_hSp.CheckRange("fnameb_spam100", (int)odata.fnameb_spam100);
            m_hSp.CheckRange("fnameb_rspamate", odata.fnameb_spamrate);

            m_hSp.CheckRange("ifnameb_day", (int)odata.ifnameb_day);
            m_hSp.CheckRange("ifnameb_ham", (int)odata.ifnameb_ham);
            m_hSp.CheckRange("ifnameb_spam85", (int)odata.ifnameb_spam85);
            m_hSp.CheckRange("ifnameb_spam100", (int)odata.ifnameb_spam100);
            m_hSp.CheckRange("ifnameb_rspamate", odata.ifnameb_spamrate);

            m_hSp.CheckRange("phoneb_day", (int)odata.phoneb_day);
            m_hSp.CheckRange("phoneb_ham", (int)odata.phoneb_ham);
            m_hSp.CheckRange("phoneb_spam85", (int)odata.phoneb_spam85);
            m_hSp.CheckRange("phoneb_spam100", (int)odata.phoneb_spam100);
            m_hSp.CheckRange("phoneb_rspamate", odata.phoneb_spamrate);

            //за последнее 300 сек
            m_hSp.CheckRange("equal_prefix_login_300", (int)odata.ltcs.stat_300.equal_prefix_login_count);
            m_hSp.CheckRange("equal_first_nsymb_300", (int)odata.ltcs.stat_300.equal_first_nsymb_count);
            m_hSp.CheckRange("equal_useragent_300", (int)odata.ltcs.stat_300.equal_useragent_count);
            //m_hSp.CheckRange("equal_pack1_300",           (int)odata.ltcs.stat_300.equal_pack1_count);
            //m_hSp.CheckRange("est_email_300",             (int)odata.ltcs.stat_300.est_email_count);
            //m_hSp.CheckRange("est_nickname_300",          (int)odata.ltcs.stat_300.est_nickname_count);
            m_hSp.CheckRange("est_phone_300", (int)odata.ltcs.stat_300.est_phone_count);
            //за последнее 1200 сек
            m_hSp.CheckRange("equal_prefix_login_1200", (int)odata.ltcs.stat_1200.equal_prefix_login_count);
            m_hSp.CheckRange("equal_first_nsymb_1200", (int)odata.ltcs.stat_1200.equal_first_nsymb_count);
            m_hSp.CheckRange("equal_useragent_1200", (int)odata.ltcs.stat_1200.equal_useragent_count);
            //m_hSp.CheckRange("equal_pack1_1200",          (int)odata.ltcs.stat_1200.equal_pack1_count);
            //m_hSp.CheckRange("est_email_1200",            (int)odata.ltcs.stat_1200.est_email_count);
            //m_hSp.CheckRange("est_nickname_1200",         (int)odata.ltcs.stat_1200.est_nickname_count);
            m_hSp.CheckRange("est_phone_1200", (int)odata.ltcs.stat_1200.est_phone_count);

            if ((odata.login.length() > 0) && ((field_name = "login") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.login.c_str(), odata.login.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.iname.length() > 0) && ((field_name = "iname") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.iname.c_str(), odata.iname.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.fname.length() > 0) && ((field_name = "fname") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.fname.c_str(), odata.fname.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.nickname.length() > 0) && ((field_name = "nickname") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.nickname.c_str(), odata.nickname.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.iplong.toStroka().length() > 0) && ((field_name = "ipaddress") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.iplong.toStroka().c_str(), odata.iplong.toStroka().length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.email.length() > 0) && ((field_name = "email") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.email.c_str(), odata.email.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.phonenumber_s.length() > 0) && ((field_name = "phonenumber") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.phonenumber_s.c_str(), odata.phonenumber_s.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.from_s.length() > 0) && ((field_name = "from") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.from_s.c_str(), odata.from_s.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.social_provider.length() > 0) && ((field_name = "socprovider") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.social_provider.c_str(), odata.social_provider.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.ipstate.geo.length() > 0) && ((field_name = "geos") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.ipstate.geo.c_str(), odata.ipstate.geo.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.geos_as.length() > 0) && ((field_name = "geos_as") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.geos_as.c_str(), odata.geos_as.length(), "cp1251", true, false, delays.GetRuleHash());
            if ((odata.ipstate.host.length() > 0) && ((field_name = "hosts") != NULL))
                check_field_tick += SpCheckFieldTick(m_hSp, field_name, odata.ipstate.host.c_str(), odata.ipstate.host.length(), "cp1251", true, false, delays.GetRuleHash());

            //регулярки по всем полям (добавляем к началу имени поля "re_")
            if (pReqParams != NULL) {
                par_it = pReqParams->begin();
                while (par_it != pReqParams->end()) {
                    skey = (*par_it).first;
                    svalue = (*par_it).second[0];

                    if (PrintFieldToDlvLog(skey)) //печатаем в лог, если надо
                    {
                        m_hSp.AddStat(skey, svalue);

                        if (!svalue.empty())
                            odata.ml_data.ADDField(skey, svalue.c_str(), svalue.length());
                    }

                    if (!skey.empty() /* && !svalue.empty()*/) {
                        skey = "re_" + skey;
                        check_field_tick += SpCheckFieldTick(m_hSp, skey.c_str(), svalue.c_str(), svalue.length(), "cp1251", true, false, delays.GetRuleHash());
                    }

                    ++par_it;
                }

                par_it = pReqParams->find("v2_has_cookie_l");
                if (par_it != pReqParams->end())
                    mllog_data["v2_has_cookie_l"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_old_password_quality");
                if (par_it != pReqParams->end())
                    mllog_data["v2_old_password_quality"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_is_ssl");
                if (par_it != pReqParams->end())
                    mllog_data["v2_is_ssl"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_accept_language");
                if (par_it != pReqParams->end())
                    mllog_data["v2_accept_language"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_password_validation_count");
                if (par_it != pReqParams->end())
                    mllog_data["v2_password_validation_count"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_account_country");
                if (par_it != pReqParams->end())
                    mllog_data["v2_account_country"] = (*par_it).second[0];

                par_it = pReqParams->find("v2_password_quality");
                if (par_it != pReqParams->end())
                    mllog_data["v2_password_quality"] = (*par_it).second[0];
            }

            SpSetRule(m_hSp, odata.langstr.c_str());

            for (size_t i = 0; i < odata.valkey.length(); i++) {
                if (odata.valkey[i] == '1')
                    SpSetRule(m_hSp, ("VALKEY" + IntToStroka(i + 1)).c_str());
            }

            if (odata.in_inamelist > 0) {
                char tbuff[32];

                if (snprintf(tbuff, sizeof(tbuff) - 1, "IS_INAMELIST_%02u", odata.in_inamelist) > 0)
                    SpSetRule(m_hSp, tbuff);
            }
            if (odata.in_fnamelist > 0) {
                char tbuff[32];

                if (snprintf(tbuff, sizeof(tbuff) - 1, "IS_FNAMELIST_%02u", odata.in_fnamelist) > 0)
                    SpSetRule(m_hSp, tbuff);
            }
            if (odata.in_inamelist_cmp > 0) {
                char tbuff[32];

                if (snprintf(tbuff, sizeof(tbuff) - 1, "IS_INAMELIST_TRSC_%02u", odata.in_inamelist_cmp) > 0)
                    SpSetRule(m_hSp, tbuff);
            }
            if (odata.in_fnamelist_cmp > 0) {
                char tbuff[32];

                if (snprintf(tbuff, sizeof(tbuff) - 1, "IS_FNAMELIST_TRSC_%02u", odata.in_fnamelist_cmp) > 0)
                    SpSetRule(m_hSp, tbuff);
            }

            if (k == 1) //add machine learning result
            {
                if (odata.ml_answer.m_exists_data) {
                    m_hSp.AddStat("ml  ", "s=" + BoolToStroka(odata.ml_answer.m_spam) + ",w=" + IntToStroka(odata.ml_answer.m_weight));
                    if (odata.ml_answer.m_spam)
                        SpSetRule(m_hSp, "ML_SPAM");
                    else
                        SpSetRule(m_hSp, "ML_HAM");

                    m_hSp.CheckRange("ml_weight", odata.ml_answer.m_weight);

                } else {
                    m_hSp.AddStat("ml  ", "-");
                    SpSetRule(m_hSp, "ML_EMPTY");
                }
            }

            tre->RULEBUFF = {};
            prepare_tick_ms = CShingleTime::GetMs() - prepare_tick_ms;

            check_message_tick_ms = CShingleTime::GetMs();
            NProf::Profiler prof;
            TCheckedMessage checkedMessage;
            m_hSp.CheckMessage(prof, nullptr, checkedMessage);
            Spam = IsSpam(checkedMessage.spClass);
            {
                TStringOutput rulesStream(tre->RULEBUFF);
                for(auto& [src, dst]: {
                        std::make_tuple(std::cref(m_hSp.m_cur->vr_spam), std::ref(ext_fltr_data.r_sp_rules)),
                        std::make_tuple(std::cref(m_hSp.m_cur->vr_dlv), std::ref(ext_fltr_data.r_dl_rules)),
                        std::make_tuple(std::cref(m_hSp.m_cur->vr_null), std::ref(ext_fltr_data.r_nl_rules)),
                }) {
                    dst.reserve(src.size());
                    for(const TRuleCurrent& ruleCurrent : src) {
                        const TRuleDef& rule = ruleCurrent.GetDef();
                        dst.emplace_back(rule.pRuleName, rule.score);

                        if ( rule.rt != RT_ALG || !m_hSp.RulePrintList ||
                             (m_hSp.RulePrintList && m_hSp.RulePrintList->Find(rule.pRuleName))) {
                            rulesStream << rule.pRuleName << ':' << rule.score << ';';
                        }
                    }
                }

                tre->RULEBUFF = std::move(m_hSp.m_cur->ActiveComaSeparatedFilteredNullRulesNames.Str());
            }
            if(is_upstream_request && k == 1) {
                m_hSp.EndMessage(deliveryLog, mlLog);
            }
            check_message_tick_ms = CShingleTime::GetMs() - check_message_tick_ms;
            ttt = CShingleTime::GetMs() - ttt;

            if (k == 0) {
                delays.SetDelayFilterWorkPrepare(prepare_tick_ms);
                check_field_tick_ms = check_field_tick / 1000;
                delays.SetDelayFilterWorkCheckField(check_field_tick_ms);
                delays.SetDelayFilterWorkCheckMessage(check_message_tick_ms);
            } else {
                delays.SetDelayFilterWorkPrepareML(prepare_tick_ms);
                check_field_tick_ms = check_field_tick / 1000;
                delays.SetDelayFilterWorkCheckFieldML(check_field_tick_ms);
                delays.SetDelayFilterWorkCheckMessageML(check_message_tick_ms);
            }

            if (k == 1) {
                //write statistik from ML
                if (!odata.ml_answer.m_exists_data) {
                    delays.SetMLResult(KPUNKNOWN);

                } else {
                    if (odata.ml_answer.m_spam) {
                        delays.SetMLResult(KPSPAM);
                        if (last_filter_result == KPHAM)
                            delays.SetHamToSpamByML();
                        else if (last_filter_result == KPMALIC)
                            delays.SetMalicToSpamByML();

                    } else {
                        delays.SetMLResult(KPHAM);
                        if (last_filter_result == KPSPAM)
                            delays.SetSpamToHamByML();
                        else if (last_filter_result == KPMALIC)
                            delays.SetMalicToHamByML();
                    }
                }

                last_rule_text1 = ext_fltr_data.GetRSp();

                //write statistik for full result
                if (Spam) {
                    if (m_hSp.ExistsbanInternal("MALICIOUS")) {
                        if (last_filter_result == KPHAM) {
                            change_res_by_ml = "CBML_HTM";
                            delays.SetHamToMalicFinalres();
                            if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                                LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "HTM %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());

                        } else if (last_filter_result == KPSPAM) {
                            change_res_by_ml = "CBML_STM";
                            delays.SetSpamToMalicFinalres();
                            if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                                LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "STM %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());
                        }

                    } else {
                        if (last_filter_result == KPHAM) {
                            change_res_by_ml = "CBML_HTS";
                            delays.SetHamToSpamFinalres();
                            if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                                LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "HTS %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());

                        } else if (last_filter_result == KPMALIC) {
                            change_res_by_ml = "CBML_MTS";
                            delays.SetMalicToSpamFinalres();
                            if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                                LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "MTS %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());
                        }
                    }

                } else {
                    if (last_filter_result == KPSPAM) {
                        change_res_by_ml = "CBML_STH";
                        delays.SetSpamToHamFinalres();
                        if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                            LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "STH %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());

                    } else if (last_filter_result == KPMALIC) {
                        change_res_by_ml = "CBML_MTH";
                        delays.SetMalicToHamFinalres();
                        if ((LogsGroup != NULL) && (LogsGroup->GetLogMoveML() != NULL))
                            LogsGroup->GetLogMoveML()->WriteMessageAndDataStatus(KMESSAGE, "MTH %s FW1='%s', FW2='%s'", Numbrequest.c_str(), last_rule_text0.c_str(), last_rule_text1.c_str());
                    }
                }

            } else {
                //write statistik wo ML
                if (Spam) {
                    if (m_hSp.ExistsbanInternal("MALICIOUS")) {
                        delays.SetWOMLResult(KPMALIC);
                        last_filter_result = KPMALIC;

                    } else {
                        delays.SetWOMLResult(KPSPAM);
                        last_filter_result = KPSPAM;
                    }

                } else {
                    delays.SetWOMLResult(KPHAM);
                    last_filter_result = KPHAM;
                }

                last_rule_text0 = ext_fltr_data.GetRSp();
            }

            if (Spam)
                mllog_data["spam"] = "yes";
            else
                mllog_data["spam"] = "no";

            mllog_data["r_sp"] = ext_fltr_data.GetRSp();
            mllog_data["r_nl"] = ext_fltr_data.GetRNl();

            if (k == 0)
                delays.SetDelayFilterWork1step(ttt);
            else
                delays.SetDelayFilterWork2step(ttt);

            if ((k == 0) && (MLPoolClients)) //mashine learning server request
            {
                ttt = CShingleTime::GetMs();

                odata.ml_data.SetDublicatLoginMode(false);
                odata.ml_data.ADDField("rules", tre->RULEBUFF.c_str(), tre->RULEBUFF.size());
                if (!ml_lang.empty())
                    odata.ml_data.ADDField("lang", ml_lang.c_str(), ml_lang.length());
                if (!ml_geo.empty())
                    odata.ml_data.ADDField("geo", ml_geo.c_str(), ml_geo.length());
                if (!ml_inam.empty())
                    odata.ml_data.ADDField("inam", ml_inam.c_str(), ml_inam.length());
                if (!ml_fnam.empty())
                    odata.ml_data.ADDField("fnam", ml_fnam.c_str(), ml_fnam.length());
                if (!ml_fuid.empty())
                    odata.ml_data.ADDField("fuid", ml_fuid.c_str(), ml_fuid.length());
                if (!ml_ipbs.empty())
                    odata.ml_data.ADDField("ipbs", ml_ipbs.c_str(), ml_ipbs.length());
                if (!ml_inbs.empty())
                    odata.ml_data.ADDField("inbs", ml_inbs.c_str(), ml_inbs.length());
                if (!ml_fnbs.empty())
                    odata.ml_data.ADDField("fnbs", ml_fnbs.c_str(), ml_fnbs.length());
                if (!ml_ifbs.empty())
                    odata.ml_data.ADDField("ifbs", ml_ifbs.c_str(), ml_ifbs.length());
                if (!ml_phbs.empty())
                    odata.ml_data.ADDField("phbs", ml_phbs.c_str(), ml_phbs.length());
                if (!ml_ifcn.empty())
                    odata.ml_data.ADDField("ifcn", ml_ifcn.c_str(), ml_ifcn.length());
                if (!ml_tenm.empty())
                    odata.ml_data.ADDField("tenm", ml_tenm.c_str(), ml_tenm.length());
                if (!ml_tepl.empty())
                    odata.ml_data.ADDField("tepl", ml_tepl.c_str(), ml_tepl.length());
                if (!ml_tefs.empty())
                    odata.ml_data.ADDField("tefs", ml_tefs.c_str(), ml_tefs.length());
                if (!ml_teua.empty())
                    odata.ml_data.ADDField("teua", ml_teua.c_str(), ml_teua.length());
                if (!ml_teph.empty())
                    odata.ml_data.ADDField("teph", ml_teph.c_str(), ml_teph.length());
                odata.ml_data.ADDField("rtyp", ml_rtype.c_str(), ml_rtype.length());
                if (!ml_ip6mask.empty())
                    odata.ml_data.ADDField("ip6m", ml_ip6mask.c_str(), ml_ip6mask.length());
                if (!ml_ip4mask.empty())
                    odata.ml_data.ADDField("ip4m", ml_ip4mask.c_str(), ml_ip4mask.length());

                poolhttpcl::TDebugTiming ml_debug_time = poolhttpcl::TDebugTiming();
                MLPoolClients->RequestToServer(odata.ml_data, Numbrequest, 50, ml_debug_time);
                odata.ml_answer = odata.ml_data.ReturnData();

                ttt = CShingleTime::GetMs() - ttt;
                delays.SetDelayML(ttt, odata.ml_answer.m_err != poolhttpcl::KNONEERROR, ml_debug_time.m_wait_ms, ml_debug_time.m_connect_ms, ml_debug_time.m_request_ms, ml_debug_time.m_writelog_ms);

                switch (odata.ml_answer.m_err) {
                    case poolhttpcl::KNONEERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::OK, ttt);
                        break;
                    case poolhttpcl::KHOSTPORTERROR:
                    case poolhttpcl::KWAITERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::OTHERERR, ttt);
                        break;
                    case poolhttpcl::KCONNECTERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::CE, ttt);
                        break;
                    case poolhttpcl::KCONNECTTIMEOUTERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::CT, ttt);
                        break;
                    case poolhttpcl::KREQUESTERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::RE, ttt);
                        break;
                    case poolhttpcl::KREQUESTTIMEOUTERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::RT, ttt);
                        break;
                    case poolhttpcl::KREQUESTANSWERERROR:
                        monlogdata.AddTag("FRODO", "ML", TSpamonLogStruct::BAD_RESPONSE, ttt);
                        break;
                };
            }
        }

        ttt = CShingleTime::GetMs();
        PrintML(Numbrequest, is_upstream_request, mllog_data);
        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayMLYT(ttt);

        if (Spam)
            odata.malic = m_hSp.ExistsbanInternal("MALICIOUS");

        res = true;

        m_Store.AddRuleStat(odata.regtime, tre->RULEBUFF.c_str()); //считаем статистику правил

        //change_res_by_ml = "CBML_STS"; //!!!DEBUG!!!
        if (FilterPool)
            FilterPool->ReturnFilter(tre); //фильтр сработал, возвращаем его в пул фильтров
    }

    return res;
}

void CSoFilter::WriteSpamLogBack(const TString& ips, const TString& login, time_t t, ui8 algtype, const TString& Numbrequest) {
    TString times = "";

    times = TimeToStrNoProbel(t);
    if ((LogsGroup != NULL) && (LogsGroup->GetLogSpamBack() != NULL))
        LogsGroup->GetLogSpamBack()->WriteMessage("%40s %25s %12llu(%s) %3d %39s\n", ips.c_str(), login.c_str(), t, times.c_str(), algtype, Numbrequest.c_str());
}

void CSoFilter::PrintML(const TString& /*Numbrequest*/, bool is_upstream_request, const THashMap<TString, TString>& data) {
    TString res_txt = "";
    THashMap<TString, TString>::const_iterator it;
    std::list<TString> ident_list;
    std::list<TString>::iterator il;
    bool need_flush = false;

    ident_list.push_back("dubl");
    ident_list.push_back("rtyp");
    ident_list.push_back("ip");
    ident_list.push_back("uid");
    ident_list.push_back("geos");
    ident_list.push_back("lang");
    ident_list.push_back("logn");
    ident_list.push_back("pass");
    ident_list.push_back("ques");
    ident_list.push_back("answ");
    ident_list.push_back("inam");
    ident_list.push_back("fnam");
    ident_list.push_back("usag");
    ident_list.push_back("capt");
    ident_list.push_back("spam");
    ident_list.push_back("r_sp");
    ident_list.push_back("r_nl");
    ident_list.push_back("fuid");
    ident_list.push_back("divs");
    ident_list.push_back("cnip");
    ident_list.push_back("ship");
    ident_list.push_back("tepl");
    ident_list.push_back("tefs");
    ident_list.push_back("teua");
    ident_list.push_back("teph");
    ident_list.push_back("snow");
    ident_list.push_back("ipbs");
    ident_list.push_back("inbs");
    ident_list.push_back("fnbs");
    ident_list.push_back("ifbs");
    ident_list.push_back("phbs");
    ident_list.push_back("tmng");
    ident_list.push_back("v2_has_cookie_l");
    ident_list.push_back("v2_old_password_quality");
    ident_list.push_back("v2_is_ssl");
    ident_list.push_back("v2_accept_language");
    ident_list.push_back("v2_password_validation_count");
    ident_list.push_back("v2_account_country");
    ident_list.push_back("v2_password_quality");
    ident_list.push_back("ip4m");
    ident_list.push_back("ip6m");
    ident_list.push_back("clst_number");
    ident_list.push_back("clst_distance");
    ident_list.push_back("clst_radius_max");
    ident_list.push_back("clst_radius_min");
    ident_list.push_back("clst_spam_percent");

    res_txt += "tskv\t";
    res_txt += "tskv_format=" + ytml_label + "\t";
    res_txt += "unixtime=" + IntToStroka(time(NULL)) + "\t";

    il = ident_list.begin();
    while (il != ident_list.end()) {
        if (!(*il).empty()) {
            it = data.find(*il);
            if (it != data.end())
                res_txt += (*it).first + "=" + (*it).second + "\t";
            else
                res_txt += *il + "=\t";
        }

        ++il;
    }

    if (LogsGroup) {
        LogsGroup->GetLogML(is_upstream_request) << res_txt << '\n';

        mlytMutex.Acquire();

        mlyt_writecnt++;
        if (mlyt_writecnt >= 10) {
            mlyt_writecnt = 0;
            need_flush = true;
        }

        mlytMutex.Release();

        if (need_flush)
            LogsGroup->GetLogML(is_upstream_request) << Flush;
    }
}

TString CSoFilter::GetCPSFiltersList() {
    TString res = "";

    if (FilterPool)
        res = FilterPool->GetCPSList();

    return res;
}

ui32 CSoFilter::GetAccesibleFiltersCount() {
    ui32 res = 0;

    if (FilterPool)
        res = FilterPool->GetAccessibleFilterCount();

    return res;
}

void CSoFilter::EnableResolving(bool enable) {
    HostResolv.SetBlock(enable);
}

bool CSoFilter::GetResolvingState() {
    return HostResolv.GetBlock();
}

bool CSoFilter::AddAllowUserLogin(const TString& login, ui32 lifetime) {
    AllowUser.AddLogin(login, lifetime);

    return true;
}

bool CSoFilter::RemoveAllowUserLogin(const TString& login) {
    return AllowUser.RemoveLogin(login);
}

TAllowUserData CSoFilter::GetAllowUser(const TString& login) {
    return AllowUser.Get(login);
}

ui32 CSoFilter::AllowUserCount() {
    return AllowUser.Size();
}

void CSoFilter::WriteControlLog(const TString& messid, ui8 spamtype, TReqParams* ListParams) {
    if ((LogsGroup != NULL) && (LogsGroup->GetControlLog() != NULL)) {
        TString control_str = "";
        TReqParams::iterator par_it;
        TRulesList paramlist;
        TRulesList::iterator rit;

        switch (spamtype) {
            case KPHAM:
                control_str = control_str + "********** MESSID: " + messid + ", SPAMTYPE: HAM ************\n";
                break;
            case KPSPAM:
                control_str = control_str + "********** MESSID: " + messid + ", SPAMTYPE: SPAM ***********\n";
                break;
            case KPMALIC:
                control_str = control_str + "********** MESSID: " + messid + ", SPAMTYPE: MALIC **********\n";
                break;
        };
        if (ListParams != NULL) {
            par_it = ListParams->begin();
            while (par_it != ListParams->end()) {
                paramlist.push_back(RemoveCR(par_it->first) + ": '" + RemoveCR(par_it->second[0]) + "'");
                //control_str = control_str + RemoveCR(par_it->first) + ": '" + RemoveCR(par_it->second[0]) + "'\n";
                ++par_it;
            }
        }
        paramlist.sort();
        rit = paramlist.begin();
        while (rit != paramlist.end()) {
            control_str = control_str + (*rit) + "\n";

            ++rit;
        }

        control_str = control_str + "************************************ END MESS *******************************************\n";
        LogsGroup->GetControlLog()->WriteMessageAndDataBUFF(control_str.c_str(), control_str.size());
    }
}

ui64 CSoFilter::SpCheckFieldTick(TRengine& sph, const char* pFieldName, const char* pField, int FieldLen, const char* coding, bool fValid, bool fMime, TRuleInfoHash* /*ruleshash*/) {
    ui64 res = 0;

    res = CShingleTime::GetMicroSec();

    sph.CheckField(pFieldName, {pField, size_t(FieldLen)}, coding, fValid, fMime);

    res = CShingleTime::GetMicroSec() - res;

    return res;
}

void CSoFilter::GetUdnsServicesIPData(const TString& NumbRequest, TKIPv6 ip, TSummDataUdnsList& stat_list) {
    stat_list.clear();
    if (RBLHostObj)
        RBLHostObj->GetAllStat(NumbRequest, ip, stat_list);
}

TString CSoFilter::GetUDNSMonData() {
    TString res = "";

    if (RBLHostObj)
        res = RBLHostObj->GetMonData();

    return res;
}

TString CSoFilter::GetPDDMonData() {
    TString res = "";

    res = res + PDDObj.GetMonData();

    return res;
}

TString CSoFilter::GetMonStat() {
    TString res = "";

    //filters counters
    res += GetWhiteBlackStatMon();

    //filterpool
    if ((FilterPool) && (FilterPool->GetRulesMonStat() != NULL))
        res += "<RULS:" + FilterPool->GetRulesMonStat()->GetUniqRulesCount() + ">";

    //PDD mondata
    res += GetPDDMonData();

    //UDNS mondata
    res += GetUDNSMonData();

    return res;
}

ui32 CSoFilter::GetLongDataFltr(frodo_st::TStorageData& longdata, const TString& Numbrequest, TGetStorStat& err_stat) {
    ui32 res = CShingleTime::GetMs();

    if (pStorNoSql)
        (pStorNoSql)->GetLongDataFltr(longdata, Numbrequest, err_stat);

    res = CShingleTime::GetMs() - res;

    return res;
}

ui32 CSoFilter::UpdateLongDataFltr(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, TKTypeSpam spamt) {
    ui32 res = CShingleTime::GetMs();

    if (pStorNoSql)
        (pStorNoSql)->UpdateLongData(is_incrs, longdata, Numbrequest, day, spamt);

    res = CShingleTime::GetMs() - res;

    return res;
}

ui32 CSoFilter::UpdateLongDataFltr(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100) {
    ui32 res = CShingleTime::GetMs();

    if (pStorNoSql)
        (pStorNoSql)->UpdateLongData(is_incrs, longdata, Numbrequest, day, ham, spam85, spam100);

    res = CShingleTime::GetMs() - res;

    return res;
}

ui32 CSoFilter::CorrectLongDataIncrFltr(frodo_st::TStorageDataType reqtype, TKIPv6 ip, const TString& source, bool& stor_err, kday_t day, i32 ham, i32 spam85, i32 spam100) {
    ui32 res = 0;
    frodo_st::TStorageData storage_long_data;
    frodo_st::TStorageDataItemExt ipv = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IPADDRESS, "");
    frodo_st::TStorageDataItemExt iname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_INAME, "");
    frodo_st::TStorageDataItemExt fname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_FNAME, "");
    frodo_st::TStorageDataItemExt ifname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IFNAME, "");
    frodo_st::TStorageDataItemExt phone_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_PHONE, "");

    switch (reqtype) {
        case frodo_st::SDT_END:
            break;
        case frodo_st::SDT_IPADDRESS:
            ipv = frodo_st::TStorageDataItemExt(ip, reqtype, source);
            break;
        case frodo_st::SDT_INAME:
            iname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
            break;
        case frodo_st::SDT_FNAME:
            fname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
            break;
        case frodo_st::SDT_IFNAME:
            ifname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
            break;
        case frodo_st::SDT_PHONE:
            phone_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
            break;
    };

    storage_long_data.Init(ipv, iname_v, fname_v, ifname_v, phone_v);

    res = CShingleTime::GetMs();

    if (pStorNoSql)
        (pStorNoSql)->UpdateLongDataDirect(true, storage_long_data, "-", day, ham, spam85, spam100); //������, ����� �� �������������� �����!?

    res = CShingleTime::GetMs() - res;

    switch (reqtype) {
        case frodo_st::SDT_END:
            break;
        case frodo_st::SDT_IPADDRESS:
            stor_err = ipv.m_err;
            break;
        case frodo_st::SDT_INAME:
            stor_err = iname_v.m_err;
            break;
        case frodo_st::SDT_FNAME:
            stor_err = fname_v.m_err;
            break;
        case frodo_st::SDT_IFNAME:
            stor_err = ifname_v.m_err;
            break;
        case frodo_st::SDT_PHONE:
            stor_err = phone_v.m_err;
            break;
    };

    return res;
}

TString CSoFilter::ViewResolvWebStat(const TString& ipfromcache_form) {
    TString res = "";

    if ((RBLHostObj) && (RBLHostObj->ResolvEnable())) {
        if ((m_async_resolv))
            res = AsyncResolvCache.GetWebStat(ipfromcache_form);
        else
            res = "Async mode - disabled!";

    } else {
        res = "Resolv disabled!";
    }

    return res;
}

TString CSoFilter::GetRslvIPFromCache(TKIPv6 ip) {
    TString res = "";

    if ((RBLHostObj) && (RBLHostObj->ResolvEnable())) {
        if ((m_async_resolv))
            res = AsyncResolvCache.GetRslvIPFromCache(ip);
        else
            res = "Async mode - disabled!";

    } else {
        res = "Resolv disabled!";
    }

    return res;
}
