#pragma once

#include "sostore.h"
#include "stato.h"
#include "tlogsgroup.h"
#include <mail/so/spamstop/tools/so-common/tspamstatclient.h>
#include "tkclasses.h"
#include <contrib/deprecated/udns/udns.h>
#include <library/cpp/unicode/punycode/punycode.h>
#include "trenginepool.h"
#include "tallowuser.h"
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/tnetipv6.h>
#include <mail/so/spamstop/tools/so-common/get_zone_time.h>
#include <mail/so/spamstop/tools/so-common/trblhostclass.h>
#include <mail/so/spamstop/tools/so-common/tpddclientobj.h>
#include "tmachinelearning.h"
#include <mail/so/spamstop/tools/so-common/tresolvcache.h>
#include "tspamonlog.h"
#include <mail/so/spamstop/tools/so-common/tpoolhttpclients.h>
#include <mail/so/spamstop/tools/fcgiserver_base/tmakerequestbase.h>

#include <mail/so/spamstop/tools/so-clients/functional_clients/RblClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/BBShClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/AfClient.h>

//*********************************************************************************************************************************************
//                                                 TSummaryStatistik
//*********************************************************************************************************************************************

struct TSummaryStatistik {
    TRenginePoolStat renginepool;
    TTrafficCtrlStat trafficctrl_stat; //статистика регулятора трафика на входе
    TString delays_stat;               //макс.задержка обработки обращения за сутки (за последнюю неделю)
    CStat storage_counters;            //счетчики хэшей
    TString rcpstat;                   //статистика квитанций
    ui32 allow_user_count;             //count trusted users

    TSummaryStatistik() {
        delays_stat = "";
        storage_counters.Reset();
        rcpstat = "";
        allow_user_count = 0;
    }
};

//*********************************************************************************************************************************************

class CSoFilter {
public:
    static const int RENGINE_COUNT = 4;

private:
    TAtomicSharedPtr<TStorageNoSql> pStorNoSql;

    ui64 check_count;
    time_t last_reg_time{};
    TMutex m_Mutex;
    TMutex m_MutexBlackWhite;

    TString ytml_label;

    TFileStat m_statNamesList;
    THolder<TNetIPv6> BlackList;
    THolder<TNetIPv6> WhiteList;
    THolder<TNetIPv6> TrustedList;
    THolder<TNetIPv6> GruppedNetList;
    THolder<TNetIPv6> UnGruppedNetList;

    THolder<TNetIPv6> WhiteListSO;
    THolder<TNetIPv6> IntranetZoneSO;
    THolder<TNetIPv6> TrustedZoneSO;
    THolder<TNetIPv6> LocalZoneSO;

    THolder<TNamesList> NamesList;
    TBackSpam BackSpamAlg;
    TStatO STATO;
    TAllowUser AllowUser;
    TKConfig* configobj;
    TString m_printfieldfilename;
    TString m_rulestatfilename;
    THolder<TKIniFile> m_printfieldobj;
    THolder<TKIniFile> m_rulestatlist;

    TFilterProp filter_prop;
    THolder<TRenginePool> FilterPool; //пул фильтров

    float savr_ag;    //среднее отклонение по all
    float savr_sg;    //среднее отклонение по spam
    float savr_eg;    //среднее отклонение по error
    float savr_hg;    //среднее отклонение по ham
    time_t savr_calc; //момент, когда последний раз проводили расчет среднего отклонения
    TMutex m_MutexAverage;

    TLogsGroup* LogsGroup;
    TBlockClass HostResolv;
    poolhttpcl::TStatDataItem spst_last_v6;
    //TSpamstatClientProp   spamstat_prop;
    //TPoolSpamstatClients  *SPSTv6PoolClients;
    CSoStore m_Store;
    TString m_statdata;

    //TDiffCounter          m_geo_all;
    //TDiffCounter          m_geo_noempty;
    TDiffCounter m_white_counter;
    TDiffCounter m_black_counter;
    TDiffCounter m_grupp_counter;
    TDiffCounter m_ungrupp_counter;
    TDiffCounter m_trustlogin_counter;

    TDiffCounter m_whiteso_counter;
    TDiffCounter m_intranetzoneso_counter;
    TDiffCounter m_trustedzoneso_counter;
    TDiffCounter m_localzoneso_counter;

    THolder<TRBLHostClass> RBLHostObj;
    bool m_rblconf_enable;
    TResolvCache AsyncResolvCache;
    bool m_async_resolv;

    THolder<NFuncClient::TRbl> rblClient;
    THolder<NFuncClient::TAfClient> AfClient;

    NCurl::TPool CurlPool;

    TPDDClientMainN PDDObj;
    THolder<NFuncClient::CBB> bbClient;

    poolhttpcl::THttpClientProp ml_prop;
    THolder<poolhttpcl::TPoolHttpClients> MLPoolClients;

    TMutex mlytMutex;
    ui32 mlyt_writecnt;

    bool RengineActionDublicatLogin(
            TOData& odata,
            TReqParams* pReqParams,
            bool& Spam,
            TDelayClass& delays,
            const TString& Numbrequest,
            TSpamonLogStruct& monlogdata,
            bool is_upstream_request,
            const TLog& deliveryLog,
            const TLog& mlLog);
    bool RengineActionBig(
            TOData& odata,
            TReqParams* pReqParams,
            bool& Spam,
            TDelayClass& delays,
            const TString& Numbrequest,
            TSpamonLogStruct& monlogdata,
            bool is_upstream_request,
            const TLog& deliveryLog,
            const TLog& mlLog);
    void WriteSpamLogBack(const TString& ips, const TString& login, time_t t, ui8 algtype, const TString& Numbrequest); //пишем лог, куда помещаем логины, которые были заметены в процессе "обратного заметения"
    void PrintML(const TString& Numbrequest, bool is_upstream_request, const THashMap<TString, TString>& data);

private:
    ui32 GetLongDataFltr(frodo_st::TStorageData& longdata, const TString& Numbrequest, TGetStorStat& err_stat);
    ui32 UpdateLongDataFltr(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, TKTypeSpam spamt);
    ui32 UpdateLongDataFltr(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100);
    ui32 CorrectLongDataIncrFltr(frodo_st::TStorageDataType reqtype, TKIPv6 ip, const TString& source, bool& stor_err, kday_t day, i32 ham, i32 spam85, i32 spam100);

    bool GetCorrLW(bool correct_login_enable, frodo_st::TCorrLoginWeigthClass& LoginWeightObj, const TString& login, ui8& corr_weigth);

public:
    Y_SAVELOAD_DEFINE(m_Store, STATO, AllowUser, AsyncResolvCache)
    CSoFilter();

    bool InitBeforeFork(TKConfig* configobjA, TLogsGroup* LogsGroupA);
    bool InitAfterFork(TAtomicSharedPtr<TStorageNoSql> storage);

    bool Check(ui32 ReqId, TReqParams* pReqParams, TRulesList& RulesList, bool& Spam, TDelayClass& delays, TRequestInfo& ReqInfo, bool& allowuser, const TString& Numbrequest, bool is_upstream_request, frodo_st::TLongDataRqstInfo& longdatarqstinfo, TSpamonLogStruct& monlogdata, bool correct_login_enable, frodo_st::TCorrLoginWeigthClass& LoginWeightObj);
    TResetResponce Reset();
    void Close();
    void Shutdown();
    void GetStat(CStat& Stat) {
        m_Store.GetStat(Stat);
    };
    void CleanStore() {
        m_Store.Clear();
    };
    void Midnight();
    void EventTick(){
        m_Store.EventTick();
    };

    void ReloadBlackList(void);
    void ReloadWhiteList(void);
    void ReloadTrustedList(void);
    void ReloadGruppedNetList(void);
    void ReloadUnGruppedNetList(void);
    void ReloadLoginList(void);
    void ReloadPrintFieldList();
    void ReloadRulesStatList();

    void ReloadWhiteListSO(void);
    void ReloadIntranetZoneSO(void);
    void ReloadTrustedZoneSO(void);
    void ReloadLocalZoneSO(void);

    bool PrintFieldToDlvLog(const TString& fieldname);

    TString GetEnableBackAlgorithm();
    bool GetStatHours(TReqParams* pReqParams);
    bool GetStatHoursI(TReqParams* pReqParams, TStatDataSetS& statlist, TString& firsttime);

    TString CorrectLogins(TKIPv6 ip, TString login, ui32 karma);
    int GetLoginsInfo(TKIPv6 ip, TString& login);

    TString GetCPSFiltersList();
    ui32 GetAccesibleFiltersCount();

    void EnableResolving(bool enable);
    bool GetResolvingState();

    bool AddAllowUserLogin(const TString& login, ui32 lifetime);
    bool RemoveAllowUserLogin(const TString& login);
    TAllowUserData GetAllowUser(const TString& login);
    ui32 AllowUserCount();

    void WriteControlLog(const TString& messid, ui8 spamtype, TReqParams* ListParams);

    ui64 SpCheckFieldTick(TRengine& sph, const char* pFieldName, const char* pField, int FieldLen, const char* coding, bool fValid, bool fMime, TRuleInfoHash* ruleshash);
    //TString   GetGeoStatMon();
    TString GetWhiteBlackStatMon();

    void GetUdnsServicesIPData(const TString& NumbRequest, TKIPv6 ip, TSummDataUdnsList& stat_list);

    TRenginePool* GetFilterPool() {
        return FilterPool ? FilterPool.Get() : nullptr;
    }

    void PrintTwoString(const TString& field_name, const TString& str1, const TString& str2);
    TReqParams* DecodeParams(const TString& Numbrequest, TReqParams* pReqParams);
    void DeleteParams(TReqParams* pReqParamsNew);

    TSummaryStatPCN GetStatPDD() {
        return PDDObj.GetStat();
    }
    bool ReloadPDDProp() {
        return PDDObj.ReloadProperties();
    }
    bool GetPDDInfo(ui64 shingle, const TString& host, TPDDStructN& pdddata) {
        return PDDObj.GetPDDInfo(shingle, host, pdddata);
    }

    TString GetUDNSMonData();
    TString GetPDDMonData();

    TString GetMonStat();
    TString ViewResolvWebStat(const TString& ipfromcache_form);
    TString GetRslvIPFromCache(TKIPv6 ip);
};
