#include "sostore.h"
#include <mail/so/spamstop/tools/so-clients/kshingle.h>
#include <mail/so/spamstop/sp/sptop.h>

#include <utility>

#include <util/string/reverse.h>

//extern TSoConfig sptop;

//******************************************************************************
//                         CItemStore2
//******************************************************************************

template <class TKey, class TValue>
void CItemStore2<TKey, TValue>::Init(const TString& /*db*/, const TString& /*collection_base*/) {
}

template <class TKey, class TValue>
void CItemStore2<TKey, TValue>::Lock() {
    m_Mutex.Acquire();
}

template <class TKey, class TValue>
void CItemStore2<TKey, TValue>::UnLock() {
    m_Mutex.Release();
}

// TODO: Think about implementing clear function in MongoHash
template <class TKey, class TValue>
void CItemStore2<TKey, TValue>::Clear() {
    Lock();

    m_pItemToday.clear();
    m_pItemYesterday.clear();

    UnLock();
}

template <class TKey, class TValue>
bool CItemStore2<TKey, TValue>::Exists(const TKey Key, TValue /*Val*/) {
    typename TItemHash::iterator i = m_pItemToday.find(Key);
    if (i == m_pItemToday.end())
        return false;
    else
        return true;
}

template <class TKey, class TValue>
bool CItemStore2<TKey, TValue>::Add(TKey Key, TValue Val) {
    Lock();

    typename TItemHash::iterator i = m_pItemToday.find(Key);
    if (i == m_pItemToday.end()) {
        (m_pItemToday)[Key] = Val;

        UnLock();
        return true;
    } else {
        i->second.Update(Val);

        UnLock();
        return false;
    }
}

template <class TKey, class TValue>
bool CItemStore2<TKey, TValue>::Add2(TKey Key, TValue Val) {
    Lock();

    typename TItemHash::iterator i;
    /*TString s = "";

  i = m_pItemToday.begin();
  while (i != m_pItemToday.end())
  {
      s = (*i).first;
      ++i;
  }*/

    i = m_pItemToday.find(Key);
    if (i == m_pItemToday.end()) {
        (m_pItemToday)[Key] = Val;

        UnLock();
        return true;
    } else {
        i->second.Update(Val);

        UnLock();
        return false;
    }
}

template <class TKey, class TValue>
bool CItemStore2<TKey, TValue>::Del(TKey Key) {
    Lock();

    typename TItemHash::iterator i;

    i = m_pItemToday.find(Key);
    if (i != m_pItemToday.end()) {
        m_pItemToday.erase(i);
    }

    i = m_pItemYesterday.find(Key);
    if (i != m_pItemYesterday.end()) {
        m_pItemYesterday.erase(i);
    }

    UnLock();
    return true;
}

//
// Midnight
//
// TODO: Maybe take that function to external Python-script
template <class TKey, class TValue>
size_t CItemStore2<TKey, TValue>::Midnight(ui32& lock_wait_time, ui32& midnight_time, ui32& del_yesterday_time) {
    ui32 tick = 0;

    tick = CShingleTime::GetMs();
    Lock();
    lock_wait_time = CShingleTime::GetMs() - tick;

    tick = CShingleTime::GetMs();

    m_pItemYesterday = std::exchange(m_pItemToday, {});
    midnight_time = CShingleTime::GetMs() - tick;

    UnLock();

    tick = CShingleTime::GetMs();
    del_yesterday_time = CShingleTime::GetMs() - tick;

    return m_pItemYesterday.size();
}

//
// Get IP statistics
//
template <class TKey, class TValue>
void CItemStore2<TKey, TValue>::GetStat(const TKey Ip, TValue& Stat) {
    Stat.Init();

    typename TItemHash::iterator i = m_pItemToday.find(Ip);
    if (i != m_pItemToday.end())
        Stat.Update(i->second);

    i = m_pItemYesterday.find(Ip);
    if (i != m_pItemYesterday.end())
        Stat.Update(i->second);
}

//
// Get IP statistics
//
template <class TKey, class TValue>
void CItemStore2<TKey, TValue>::GetStatEx(const TKey Ip, TValue& Stat, time_t sec, bool del, ui64 RequestCount, ui32& reccount) {
    Lock();

    Stat.Init();

    reccount = 0;

    typename TItemHash::iterator i = m_pItemToday.find(Ip);
    if (i != m_pItemToday.end()) {
        i->second.TruncData(sec, del, RequestCount);
        Stat.Update(i->second);
        reccount += Stat.GetCount();
    }

    i = m_pItemYesterday.find(Ip);
    if (i != m_pItemYesterday.end()) {
        i->second.TruncData(sec, del, RequestCount);
        Stat.Update(i->second);
        reccount += Stat.GetCount();
    }

    UnLock();
}

//
// Get size
//
template <class TKey, class TValue>
size_t CItemStore2<TKey, TValue>::GetSize() {
    return (m_pItemToday.size() + m_pItemYesterday.size());
}

//
// Get size today
//
template <class TKey, class TValue>
size_t CItemStore2<TKey, TValue>::GetSizeToday() {
    return (m_pItemToday.size());
}

template <class TKey, class TValue>
TValue* CItemStore2<TKey, TValue>::Find(TKey Key) {
    TValue* res;

    res = NULL;
    typename TItemHash::iterator i = m_pItemToday.find(Key);
    if (i != m_pItemToday.end())
        res = &i->second;

    return res;
}

template <class TKey, class TValue>
TValue* CItemStore2<TKey, TValue>::FindPrev(TKey Key) {
    TValue* res;

    res = NULL;
    typename TItemHash::iterator i = m_pItemYesterday.find(Key);
    if (i != m_pItemYesterday.end())
        res = &i->second;

    return res;
}

template <class TKey, class TValue>
size_t CItemStore2<TKey, TValue>::GetSizeGreatOne() {
    typename TItemHash::iterator i;
    size_t res = 0;

    i = m_pItemToday.begin();
    while (i != m_pItemToday.end()) {
        if (i->second.GetCount() > 1)
            res++;
        ++i;
    }
    i = m_pItemYesterday.begin();
    while (i != m_pItemYesterday.end()) {
        if (i->second.GetCount() > 1)
            res++;
        ++i;
    }

    return res;
}

template <class TKey, class TValue>
size_t CItemStore2<TKey, TValue>::GetSizeTodayGreatOne() {
    typename TItemHash::iterator i;
    size_t res = 0;

    i = m_pItemToday.begin();
    while (i != m_pItemToday.end()) {
        if (i->second.GetCount() > 1)
            res++;
        ++i;
    }

    return res;
}

////////////////////////////////////////////////////////////////////////////////
//
// CSoStore
//
CSoStore::CSoStore() : IpCache(TDuration::Hours(12)) {
    m_LiveTime = CShingleTime::SECS_IN_DAY;
    LogsGroup = NULL;
    m_loadatstartup = false;
    m_todaybackup = "";
    m_yesterdaybackup = "";
}

CSoStore::~CSoStore() {
    Clear();
};

void CSoStore::Init(TLogsGroup* LogsGroupA, bool /*convert*/, TKConfig* configobjA) {
    LogsGroup = LogsGroupA;

    if (configobjA != NULL) {
        m_loadatstartup = configobjA->ReadBool("backup", "load_at_startup", false);
        m_todaybackup = configobjA->ReadStroka("backup", "today", "");
        m_yesterdaybackup = configobjA->ReadStroka("backup", "yesterday", "");

        const TString& db = configobjA->ReadStroka("mongo", "db", "passport");

        m_FUID.Init(db, "fuid");
        m_Packet1.Init(db, "packet1");
        m_Packet2.Init(db, "packet2");
        m_Packet3.Init(db, "packet3");
        m_Packet4.Init(db, "packet4");
        m_Packet5.Init(db, "packet5");
        m_DublicatLogin.Init(db, "dublicatlogin");
        m_GeoStatCountry.Init(db, "geostatcountry");
        m_GeoStat.Init(db, "geostat");
        m_GeoStatAS.Init(db, "geostatas");
        m_Host2Level.Init(db, "host2level");
        m_Host3Level.Init(db, "host3level");
        m_Domen.Init(db, "domen");
        m_IPv6Maska1.Init(db, "ip6m1");
        m_IPv6Maska2.Init(db, "ip6m2");
        m_IPv6Maska3.Init(db, "ip6m3");
        m_IPv4MaskaC.Init(db, "ip4mC");
    }
}

TIPStat CSoStore::AddCalcIPStatist(TKIPv6 Ip, time_t ip_count, const TString& login, const TString& LoginPrefix, ui16 /*loginprefix_count*/, TPackHint PasswHint, ui16 /*passwhint_count*/, TPackHint QuestHint, ui16 /*questhint_count*/, TString LoginFirstNSymb, ui16 /*loginfirstnsymb_count*/, TPackHint AnswerHint, ui32 uid, TString iname, TString fname, TPacket packet2, ui32 geodata, bool ispdd) {
    TIPStat todaystat;

    TLoginTime loginTime(ip_count, login, PasswHint, QuestHint, AnswerHint, uid, iname, fname, packet2, geodata, ispdd);
    if(TItemStatSetPtr item; IpCache.Get(Ip, item)) {
        item->Update(std::move(loginTime));
        todaystat = item->CalcStatist(ip_count, LoginPrefix, std::move(LoginFirstNSymb), PasswHint, QuestHint, AnswerHint, iname, fname);
    } else {
        auto newItem = MakeAtomicShared<CItemStatSet>(std::move(loginTime));
        todaystat = newItem->CalcStatist(ip_count, LoginPrefix, std::move(LoginFirstNSymb), PasswHint, QuestHint, AnswerHint, iname, fname);
        IpCache.Add(Ip, std::move(newItem));
    }

    return todaystat;
}

TLTCSum CSoStore::AddGetCountFromSummDataNew(time_t regtime, TString& prefix_login, TString& first_nsymb_login, TPacket /*pack1*/, TString& email, TString& nickname, TString& phone, ui64 RequestCount, ui64 useragentA, ui64 reserv1, ui64 reserv2, ui64 reserv3) {
    TLTCSum res;
    bool del = false;

    if ((RequestCount % 50) == 0)
        del = true;

    m_Sumdata.Update(TSummaryDataArray(TSummaryData(regtime, prefix_login, first_nsymb_login, email, nickname, phone, useragentA, reserv1, reserv2, reserv3)));
    res = m_Sumdata.GetCountFromNew(regtime, prefix_login, first_nsymb_login, del, useragentA, reserv1, reserv2, reserv3);

    return res;
}

TPasswdChangeStat CSoStore::AddElementPasswdChange(ui32 currenttime, TKIPv6 ip) {
    return m_PasswdChange.AddElement(currenttime, ip);
}

void CSoStore::SetRuleStatList(TKIniFile* rulestatlist) {
    m_RuleStat.SetRuleStatList(rulestatlist);
}

void CSoStore::AddRuleStat(time_t sec, const char* BUFF) {
    m_RuleStat.AddRuleStat(sec, BUFF);
}

void CSoStore::GetRuleStat(time_t sec, TRuleStatResList& res, bool del, ui64& RequestCount) {
    m_RuleStat.TruncData(sec, del, RequestCount);
    m_RuleStat.GetRuleStat(sec, res);
}

int CSoStore::LoginInfo(TKIPv6 ip, TString& login) {
    if(TItemStatSetPtr item; IpCache.Get(ip, item)) {
        return item->GetLoginInfo(login);
    }

    return KPUNKNOWN;
}

//
// Midnight
//
void CSoStore::Midnight() {
    ui32 midnighttime = 0;
    ui32 writedumptime = 0;
    TMidnightTiming timing_data;

    midnighttime = CShingleTime::GetMs();

    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "YHASH_STORE: midnight processing...");

    IpCache.EventTick();

    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight IP basa (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Ips.m_lock_wait_time, timing_data.m_Ips.m_midnight_time, timing_data.m_Ips.m_del_yesterday_time);

    m_MutexFUID.Acquire();
    m_FUID.Midnight(timing_data.m_FUID.m_lock_wait_time, timing_data.m_FUID.m_midnight_time, timing_data.m_FUID.m_del_yesterday_time);
    m_MutexFUID.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight FUID (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_FUID.m_lock_wait_time, timing_data.m_FUID.m_midnight_time, timing_data.m_FUID.m_del_yesterday_time);

    m_MutexPacket1.Acquire();
    m_Packet1.Midnight(timing_data.m_Packet1.m_lock_wait_time, timing_data.m_Packet1.m_midnight_time, timing_data.m_Packet1.m_del_yesterday_time);
    m_MutexPacket1.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight Packet1 (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Packet1.m_lock_wait_time, timing_data.m_Packet1.m_midnight_time, timing_data.m_Packet1.m_del_yesterday_time);

    m_MutexPacket2.Acquire();
    m_Packet2.Midnight(timing_data.m_Packet2.m_lock_wait_time, timing_data.m_Packet2.m_midnight_time, timing_data.m_Packet2.m_del_yesterday_time);
    m_MutexPacket2.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight Packet2 (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Packet2.m_lock_wait_time, timing_data.m_Packet2.m_midnight_time, timing_data.m_Packet2.m_del_yesterday_time);

    m_MutexPacket3.Acquire();
    m_Packet3.Midnight(timing_data.m_Packet3.m_lock_wait_time, timing_data.m_Packet3.m_midnight_time, timing_data.m_Packet3.m_del_yesterday_time);
    m_MutexPacket3.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight Packet3 (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Packet3.m_lock_wait_time, timing_data.m_Packet3.m_midnight_time, timing_data.m_Packet3.m_del_yesterday_time);

    m_MutexPacket4.Acquire();
    m_Packet4.Midnight(timing_data.m_Packet4.m_lock_wait_time, timing_data.m_Packet4.m_midnight_time, timing_data.m_Packet4.m_del_yesterday_time);
    m_MutexPacket4.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight Packet4 (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Packet4.m_lock_wait_time, timing_data.m_Packet4.m_midnight_time, timing_data.m_Packet4.m_del_yesterday_time);

    m_MutexPacket5.Acquire();
    m_Packet5.Midnight(timing_data.m_Packet5.m_lock_wait_time, timing_data.m_Packet5.m_midnight_time, timing_data.m_Packet5.m_del_yesterday_time);
    m_MutexPacket5.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight Packet5 (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Packet5.m_lock_wait_time, timing_data.m_Packet5.m_midnight_time, timing_data.m_Packet5.m_del_yesterday_time);

    m_MutexGeo.Acquire();
    m_GeoStatCountry.Midnight(timing_data.m_GeoStatCountry.m_lock_wait_time, timing_data.m_GeoStatCountry.m_midnight_time, timing_data.m_GeoStatCountry.m_del_yesterday_time);
    m_GeoStat.Midnight(timing_data.m_GeoStat.m_lock_wait_time, timing_data.m_GeoStat.m_midnight_time, timing_data.m_GeoStat.m_del_yesterday_time);
    m_GeoStatAS.Midnight(timing_data.m_GeoStatAS.m_lock_wait_time, timing_data.m_GeoStatAS.m_midnight_time, timing_data.m_GeoStatAS.m_del_yesterday_time);
    m_MutexGeo.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL)) {
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight GeoStatCountry (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_GeoStatCountry.m_lock_wait_time, timing_data.m_GeoStatCountry.m_midnight_time, timing_data.m_GeoStatCountry.m_del_yesterday_time);
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight GeoStat (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_GeoStat.m_lock_wait_time, timing_data.m_GeoStat.m_midnight_time, timing_data.m_GeoStat.m_del_yesterday_time);
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight GeoStatAS (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_GeoStatAS.m_lock_wait_time, timing_data.m_GeoStatAS.m_midnight_time, timing_data.m_GeoStatAS.m_del_yesterday_time);
    }

    m_MutexHost.Acquire();
    m_Host2Level.Midnight(timing_data.m_Host2Level.m_lock_wait_time, timing_data.m_Host2Level.m_midnight_time, timing_data.m_Host2Level.m_del_yesterday_time);
    m_Host3Level.Midnight(timing_data.m_Host3Level.m_lock_wait_time, timing_data.m_Host3Level.m_midnight_time, timing_data.m_Host3Level.m_del_yesterday_time);
    m_MutexHost.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL)) {
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight Host2Level (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Host2Level.m_lock_wait_time, timing_data.m_Host2Level.m_midnight_time, timing_data.m_Host2Level.m_del_yesterday_time);
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight Host3Level (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Host3Level.m_lock_wait_time, timing_data.m_Host3Level.m_midnight_time, timing_data.m_Host3Level.m_del_yesterday_time);
    }

    m_MutexDomen.Acquire();
    m_Domen.Midnight(timing_data.m_Domen.m_lock_wait_time, timing_data.m_Domen.m_midnight_time, timing_data.m_Domen.m_del_yesterday_time);
    m_MutexDomen.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight m_Domen (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_Domen.m_lock_wait_time, timing_data.m_Domen.m_midnight_time, timing_data.m_Domen.m_del_yesterday_time);

    m_MutexDublicatLogin.Acquire();
    m_DublicatLogin.Midnight(timing_data.m_DublicatLogin.m_lock_wait_time, timing_data.m_DublicatLogin.m_midnight_time, timing_data.m_DublicatLogin.m_del_yesterday_time);
    m_MutexDublicatLogin.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight DublicatLogin (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_DublicatLogin.m_lock_wait_time, timing_data.m_DublicatLogin.m_midnight_time, timing_data.m_DublicatLogin.m_del_yesterday_time);

    m_MutexIPv6Maska.Acquire();
    m_IPv6Maska1.Midnight(timing_data.m_IPv6Maska1.m_lock_wait_time, timing_data.m_IPv6Maska1.m_midnight_time, timing_data.m_IPv6Maska1.m_del_yesterday_time);
    m_IPv6Maska2.Midnight(timing_data.m_IPv6Maska2.m_lock_wait_time, timing_data.m_IPv6Maska2.m_midnight_time, timing_data.m_IPv6Maska2.m_del_yesterday_time);
    m_IPv6Maska3.Midnight(timing_data.m_IPv6Maska3.m_lock_wait_time, timing_data.m_IPv6Maska3.m_midnight_time, timing_data.m_IPv6Maska3.m_del_yesterday_time);
    m_MutexIPv6Maska.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL)) {
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight IPv6Maska1 (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_IPv6Maska1.m_lock_wait_time, timing_data.m_IPv6Maska1.m_midnight_time, timing_data.m_IPv6Maska1.m_del_yesterday_time);
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight IPv6Maska2 (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_IPv6Maska2.m_lock_wait_time, timing_data.m_IPv6Maska2.m_midnight_time, timing_data.m_IPv6Maska2.m_del_yesterday_time);
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight IPv6Maska3 (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_IPv6Maska3.m_lock_wait_time, timing_data.m_IPv6Maska3.m_midnight_time, timing_data.m_IPv6Maska3.m_del_yesterday_time);
    }

    m_MutexIPv4Maska.Acquire();
    m_IPv4MaskaC.Midnight(timing_data.m_IPv4MaskaC.m_lock_wait_time, timing_data.m_IPv4MaskaC.m_midnight_time, timing_data.m_IPv4MaskaC.m_del_yesterday_time);
    m_MutexIPv4Maska.Release();
    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL)) {
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "   midnight m_IPv4MaskaC (lockwait=%u msec, midnight=%u msec, del_yesterday=%u msec) - OK", timing_data.m_IPv4MaskaC.m_lock_wait_time, timing_data.m_IPv4MaskaC.m_midnight_time, timing_data.m_IPv4MaskaC.m_del_yesterday_time);
    }

    midnighttime = CShingleTime::GetMs() - midnighttime;

    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "YHASH_STORE: midnight compleate to %u msec", midnighttime);

    writedumptime = CShingleTime::GetMs();
    writedumptime = CShingleTime::GetMs() - writedumptime;
}

//
// Get general statistics
//
void CSoStore::GetStat(CStat& Stat) {
    m_MutexPacket1.Acquire();
    m_MutexPacket2.Acquire();
    m_MutexPacket3.Acquire();
    m_MutexPacket4.Acquire();
    m_MutexPacket5.Acquire();
    m_MutexDublicatLogin.Acquire();
    m_MutexGeo.Acquire();
    m_MutexHost.Acquire();
    m_MutexDomen.Acquire();
    m_MutexIPv6Maska.Acquire();
    m_MutexIPv4Maska.Acquire();

    Stat.m_IpsSize = IpCache.Size();
    Stat.m_FUIDSize = m_FUID.GetSize();
    Stat.m_FUIDSizeToday = m_FUID.GetSizeToday();
    Stat.m_Pack1Size = m_Packet1.GetSize();
    Stat.m_Pack1SizeToday = m_Packet1.GetSizeToday();
    Stat.m_Pack2Size = m_Packet2.GetSize();
    Stat.m_Pack2SizeToday = m_Packet2.GetSizeToday();
    Stat.m_Pack3Size = m_Packet3.GetSize();
    Stat.m_Pack3SizeToday = m_Packet3.GetSizeToday();
    Stat.m_Pack4Size = m_Packet4.GetSize();
    Stat.m_Pack4SizeToday = m_Packet4.GetSizeToday();
    Stat.m_Pack5Size = m_Packet5.GetSize();
    Stat.m_Pack5SizeToday = m_Packet5.GetSizeToday();
    Stat.m_GeoStatCountrySize = m_GeoStatCountry.GetSize();
    Stat.m_GeoStatCountrySizeToday = m_GeoStatCountry.GetSizeToday();
    Stat.m_GeoStatSize = m_GeoStat.GetSize();
    Stat.m_GeoStatSizeToday = m_GeoStat.GetSizeToday();
    Stat.m_GeoStatASSize = m_GeoStatAS.GetSize();
    Stat.m_GeoStatASSizeToday = m_GeoStatAS.GetSizeToday();
    Stat.m_LoginSize = m_DublicatLogin.GetSize();
    Stat.m_LoginSizeToday = m_DublicatLogin.GetSizeToday();
    Stat.m_DublicatLoginSize = m_DublicatLogin.GetSizeGreatOne();
    Stat.m_DublicatLoginSizeToday = m_DublicatLogin.GetSizeTodayGreatOne();
    Stat.m_Host2LevelSize = m_Host2Level.GetSize();
    Stat.m_Host2LevelSizeToday = m_Host2Level.GetSizeToday();
    Stat.m_Host3LevelSize = m_Host3Level.GetSize();
    Stat.m_Host3LevelSizeToday = m_Host3Level.GetSizeToday();
    Stat.m_DomenSize = m_Domen.GetSize();
    Stat.m_DomenSizeToday = m_Domen.GetSizeToday();
    Stat.m_IPv6Maska1Size = m_IPv6Maska1.GetSize();
    Stat.m_IPv6Maska1SizeToday = m_IPv6Maska1.GetSizeToday();
    Stat.m_IPv6Maska2Size = m_IPv6Maska2.GetSize();
    Stat.m_IPv6Maska2SizeToday = m_IPv6Maska2.GetSizeToday();
    Stat.m_IPv6Maska3Size = m_IPv6Maska3.GetSize();
    Stat.m_IPv6Maska3SizeToday = m_IPv6Maska3.GetSizeToday();
    Stat.m_IPv4MaskaCSize = m_IPv4MaskaC.GetSize();
    Stat.m_IPv4MaskaCSizeToday = m_IPv4MaskaC.GetSizeToday();

    m_MutexPacket1.Release();
    m_MutexPacket2.Release();
    m_MutexPacket3.Release();
    m_MutexPacket4.Release();
    m_MutexPacket5.Release();
    m_MutexDublicatLogin.Release();
    m_MutexGeo.Release();
    m_MutexHost.Release();
    m_MutexDomen.Release();
    m_MutexIPv6Maska.Release();
    m_MutexIPv4Maska.Release();
}

//
// Clean
//
void CSoStore::Clear() {
    m_MutexFUID.Acquire();
    m_FUID.Clear();
    m_MutexFUID.Release();

    m_MutexPacket1.Acquire();
    m_Packet1.Clear();
    m_MutexPacket1.Release();

    m_MutexPacket2.Acquire();
    m_Packet2.Clear();
    m_MutexPacket2.Release();

    m_MutexPacket3.Acquire();
    m_Packet3.Clear();
    m_MutexPacket3.Release();

    m_MutexPacket4.Acquire();
    m_Packet4.Clear();
    m_MutexPacket4.Release();

    m_MutexPacket5.Acquire();
    m_Packet5.Clear();
    m_MutexPacket5.Release();

    m_MutexGeo.Acquire();
    m_GeoStatCountry.Clear();
    m_GeoStat.Clear();
    m_GeoStatAS.Clear();
    m_MutexGeo.Release();

    m_MutexHost.Acquire();
    m_Host2Level.Clear();
    m_Host3Level.Clear();
    m_MutexHost.Release();

    m_MutexDublicatLogin.Acquire();
    m_DublicatLogin.Clear();
    m_MutexDublicatLogin.Release();

    m_MutexDomen.Acquire();
    m_Domen.Clear();
    m_MutexDomen.Release();

    m_MutexIPv6Maska.Acquire();
    m_IPv6Maska1.Clear();
    m_IPv6Maska2.Clear();
    m_IPv6Maska3.Clear();
    m_MutexIPv6Maska.Release();

    m_MutexIPv4Maska.Acquire();
    m_IPv4MaskaC.Clear();
    m_MutexIPv4Maska.Release();

    m_Sumdata.Clear();
    m_RuleStat.Clear();
    m_PasswdChange.Clear();
}

void CSoStore::AddHostname(TKIPv6 Ip, TString& host) {
    if(TItemStatSetPtr item; IpCache.Get(Ip, item))
        item->AddHostName(host);
}

void CSoStore::AddGeoToIP(TKIPv6 Ip, TString& geo) {
    if(TItemStatSetPtr item; IpCache.Get(Ip, item))
        item->AddGeo(geo);
}

void CSoStore::GetGeoAndHost(TKIPv6 Ip, TString& geo, TString& host) {
    geo = "";
    host = "";
    if(TItemStatSetPtr item; IpCache.Get(Ip, item))
        item->GetGeoAndHost(geo, host);
}

void CSoStore::SetSpamPriznak(TKIPv6 Ip, bool spam, time_t t, TString login, ui8 weight) {
    if(TItemStatSetPtr item; IpCache.Get(Ip, item))
        item->SetSpam(spam, t, std::move(login), weight);
}

TString CSoStore::CorrectLogin(CItemStatSet* iss, TKIPv6 ip, const TString& login, ui32 karma, i32& ham0, i32& spam85, i32& spam100) {
    ui32 lastkarma = 0;
    bool flag = false;
    TString res = "";

    if (!login.empty()) {
        if (iss->CorrectLogins(login, karma, lastkarma)) {
            flag = false;
            switch (karma) {
                case KPHAM:
                    if (ham0 < 0x7FFFFFFF)
                        ham0++;
                    flag = true;
                    break;
                case KPSPAM:
                    if (spam85 < 0x7FFFFFFF)
                        spam85++;
                    flag = true;
                    break;
                case KPMALIC:
                    if (spam100 < 0x7FFFFFFF)
                        spam100++;
                    flag = true;
                    break;
            };
            if (flag) {
                switch (lastkarma) {
                    case KPHAM:
                        if (ham0 > -0x7FFFFFFF)
                            ham0--;
                        break;
                    case KPSPAM:
                        if (spam85 > -0x7FFFFFFF)
                            spam85--;
                        break;
                    case KPMALIC:
                        if (spam100 > -0x7FFFFFFF)
                            spam100--;
                        break;
                };

                res = res + "'" + login + "' - corrected (ip='" + ip.toStroka() + "' newkarma='" + IntToStroka(karma) + "' oldkarma='" + IntToStroka(lastkarma) + "')\n";
            }
        } else {
            res = res + "'" + login + "' - not found (ip='" + ip.toStroka() + "')\n";
        }
    }

    return res;
}

TString CSoStore::CorrectLogins(TKIPv6 ip, TString login, ui32 karma, i32& ham0, i32& spam85, i32& spam100) {
    TString res = "";
    bool notfound = true;

    ham0 = 0;
    spam85 = 0;
    spam100 = 0;

    if(TItemStatSetPtr item; IpCache.Get(ip, item)) {
        res = res + CorrectLogin(item.Get(), ip, login, karma, ham0, spam85, spam100);
        notfound = false;
    }

    if (notfound)
        res = "login " + login + " not found (ip not found).";

    return res;
}

void CSoStore::AllResemblances(const TKIPv6& Ip, const TBackSpam& BackSpamAlg, const TOData& odata, TLTExtList& SpamList) {
    TVector<THolder<IResemblancer>> resemblancers(Reserve(5));
    if(BackSpamAlg.GetEnableAlgorithm(1))
        resemblancers.emplace_back(MakeHolder<TLoginResemblancer>(odata.login));
    if(BackSpamAlg.GetEnableAlgorithm(2))
        resemblancers.emplace_back(MakeHolder<THintPasswAnswerResemblancer>(odata.passwdhintall, odata.ahintall));


    if(BackSpamAlg.GetEnableAlgorithm(4)) {
        ui64 spam_count = 0;
        if(TItemStatSetPtr item; IpCache.Get(Ip, item)) {
            spam_count += item->Spam_count();
        }
        if (spam_count > 5) {
            resemblancers.emplace_back(MakeHolder<TSpamRecord_3minResemblancer>(odata.regtime));
        }
        if (BackSpamAlg.GetEnableAlgorithm(5))
            resemblancers.emplace_back(MakeHolder<TPacketTwoResemblancer>(odata.pack2));
        if (BackSpamAlg.GetEnableAlgorithm(6) && odata.ipstate.count_both > 2)
            resemblancers.emplace_back(MakeHolder<TIFNamesResemblancer>(odata.iname, odata.fname));
    }

    if(TItemStatSetPtr item; IpCache.Get(Ip, item)) {
        item->AllResemblances(Ip, resemblancers, SpamList);
    }
}

ui64 CSoStore::CalcShingle(const TString& strdata) {
    ui64 res = 0;
    char sshingle[32];
    TString stemp = "";

    if (!strdata.empty()) {
        stemp = Trim(strdata);
        to_lower_k(stemp);
        memset(sshingle, 0, sizeof(sshingle));
        calc_strcrc64(stemp.c_str(), stemp.size(), sshingle);
        sscanf(sshingle, "%lx", &res);
    }

    return res;
}

TCountValue CSoStore::AddGetFUID(const TString& fuid, ui32 count) {
    TCountValue res(0);
    ui64 shingle = CalcShingle(fuid);

    if (shingle != 0) {
        m_MutexFUID.Acquire();

        m_FUID.Add(shingle, TCountValue(count));
        m_FUID.GetStat(shingle, res);

        m_MutexFUID.Release();
    }

    return res;
}

TCountValue CSoStore::AddGetPacket1(TPacket pk, ui32 count) {
    TCountValue res(0);

    m_MutexPacket1.Acquire();

    m_Packet1.Add(pk.Shingle(), TCountValue(count));
    m_Packet1.GetStat(pk.Shingle(), res);

    m_MutexPacket1.Release();

    return res;
}

TCountValue CSoStore::AddGetPacket2(TPacket pk, ui32 count) {
    TCountValue res(0);

    m_MutexPacket2.Acquire();

    m_Packet2.Add(pk.Shingle(), TCountValue(count));
    m_Packet2.GetStat(pk.Shingle(), res);

    m_MutexPacket2.Release();

    return res;
}

TCountValue CSoStore::AddGetPacket3(TPacket3 pk, ui32 count) {
    TCountValue res(0);

    m_MutexPacket3.Acquire();

    m_Packet3.Add(pk.Shingle(), TCountValue(count));
    m_Packet3.GetStat(pk.Shingle(), res);

    m_MutexPacket3.Release();

    return res;
}

TCountValue CSoStore::AddGetPacket4(TPacket4 pk, ui32 count) {
    TCountValue res(0);

    m_MutexPacket4.Acquire();

    m_Packet4.Add(pk.Shingle(), TCountValue(count));
    m_Packet4.GetStat(pk.Shingle(), res);

    m_MutexPacket4.Release();

    return res;
}

TCountValue CSoStore::AddGetPacket5(TPacket2 pk, ui32 count) {
    TCountValue res(0);

    m_MutexPacket5.Acquire();

    m_Packet5.Add(pk.Shingle(), TCountValue(count));
    m_Packet5.GetStat(pk.Shingle(), res);

    m_MutexPacket5.Release();

    return res;
}

TCountValue CSoStore::AddGetGeoCountry(TString& geos, ui32 count) {
    TCountValue res(0);

    m_MutexGeo.Acquire();

    if (!geos.empty()) {
        ui64 shingle = 0;
        char sshingle[32];
        TString geos_t = "";
        TString geos_t2 = "";
        const char* p = NULL;
        int countsymb = 0;

        geos_t2 = Trim(geos);
        geos_t = "geocountry_" + geos_t2;
        p = strchr(geos_t2.c_str(), ' ');
        if (p != NULL) {
            countsymb = p - geos_t2.c_str();
            if (countsymb > 0)
                geos_t = "geocountry_" + TString(geos_t2.c_str(), countsymb);
        }

        calc_strcrc64(geos_t.c_str(), geos_t.length(), sshingle);
        sscanf(sshingle, "%lx", &shingle);

        m_GeoStatCountry.Add(shingle, TCountValue(count));
        m_GeoStatCountry.GetStat(shingle, res);
    }

    m_MutexGeo.Release();

    return res;
}

TCountValue CSoStore::AddGetGeo(TString& geos, ui32 count) {
    TCountValue res(0);

    m_MutexGeo.Acquire();

    if (!geos.empty()) {
        ui64 shingle = 0;
        char sshingle[32];
        TString geos_t = "geodata_" + geos;

        calc_strcrc64(geos_t.c_str(), geos_t.length(), sshingle);
        sscanf(sshingle, "%lx", &shingle);

        m_GeoStat.Add(shingle, TCountValue(count));
        m_GeoStat.GetStat(shingle, res);
    }

    m_MutexGeo.Release();

    return res;
}

TCountValue CSoStore::AddGetGeoAS(TString& geos_as, ui32 count) {
    TCountValue res(0);

    m_MutexGeo.Acquire();

    if (!geos_as.empty()) {
        ui64 shingle = 0;
        char sshingle[32];
        TString geos_t = "geoas_" + geos_as;

        calc_strcrc64(geos_t.c_str(), geos_t.length(), sshingle);
        sscanf(sshingle, "%lx", &shingle);

        m_GeoStatAS.Add(shingle, TCountValue(count));
        m_GeoStatAS.GetStat(shingle, res);
    }

    m_MutexGeo.Release();

    return res;
}

TString GetDomenNLevel(TString& host, int level) {
    TString res = host;
    TString host_t = "";
    int point_count = 0;
    bool level_ok = false;

    host_t = host;
    ReverseInPlace(host_t);
    if (!host_t.empty()) {
        for (size_t i = 0; i < host_t.length(); i++) {
            if (host_t[i] == '.')
                point_count++;
            if (point_count == level) {
                if (i > 0)
                    host_t = TString(host_t.c_str(), i);
                else
                    host_t = "";

                level_ok = true;
                break;
            }
        }
        if (level_ok) {
            ReverseInPlace(host_t);
            res = host_t;
        }
    }

    return res;
}

TCountValue CSoStore::AddHost2Level(TString& host2level, ui32 count) {
    TCountValue res(0);

    m_MutexHost.Acquire();

    if (!host2level.empty()) {
        ui64 shingle = 0;
        char sshingle[32];
        TString host_t = "";

        host_t = "hostdata_" + GetDomenNLevel(host2level, 2);

        calc_strcrc64(host_t.c_str(), host_t.length(), sshingle);
        sscanf(sshingle, "%lx", &shingle);

        m_Host2Level.Add(shingle, TCountValue(count));
        m_Host2Level.GetStat(shingle, res);
    }

    m_MutexHost.Release();

    return res;
}

TCountValue CSoStore::AddHost3Level(TString& host3level, ui32 count) {
    TCountValue res(0);

    m_MutexHost.Acquire();

    if (!host3level.empty()) {
        ui64 shingle = 0;
        char sshingle[32];
        TString host_t = "";

        host_t = "hostdata_" + GetDomenNLevel(host3level, 3);

        calc_strcrc64(host_t.c_str(), host_t.length(), sshingle);
        sscanf(sshingle, "%lx", &shingle);

        m_Host3Level.Add(shingle, TCountValue(count));
        m_Host3Level.GetStat(shingle, res);
    }

    m_MutexHost.Release();

    return res;
}

TCountValue CSoStore::AddIPv4MaskaC(ui64 ipmaska1, ui32 count) {
    TCountValue res(0);

    m_MutexIPv4Maska.Acquire();

    m_IPv4MaskaC.Add(ipmaska1, TCountValue(count));
    m_IPv4MaskaC.GetStat(ipmaska1, res);

    m_MutexIPv4Maska.Release();

    return res;
}

TCountValue CSoStore::AddIPv6Maska1(ui64 ipmaska1, ui32 count) {
    TCountValue res(0);

    m_MutexIPv6Maska.Acquire();

    m_IPv6Maska1.Add(ipmaska1, TCountValue(count));
    m_IPv6Maska1.GetStat(ipmaska1, res);

    m_MutexIPv6Maska.Release();

    return res;
}

TCountValue CSoStore::AddIPv6Maska2(ui64 ipmaska2, ui32 count) {
    TCountValue res(0);

    m_MutexIPv6Maska.Acquire();

    m_IPv6Maska2.Add(ipmaska2, TCountValue(count));
    m_IPv6Maska2.GetStat(ipmaska2, res);

    m_MutexIPv6Maska.Release();

    return res;
}

TCountValue CSoStore::AddIPv6Maska3(ui64 ipmaska3, ui32 count) {
    TCountValue res(0);

    m_MutexIPv6Maska.Acquire();

    m_IPv6Maska3.Add(ipmaska3, TCountValue(count));
    m_IPv6Maska3.GetStat(ipmaska3, res);

    m_MutexIPv6Maska.Release();

    return res;
}

TCountValue CSoStore::AddDomen(const TString& domenA, ui32 count, TString& resdomen, bool& est_domen) {
    TCountValue res(0);
    TString domen_t = "";
    const char* p = NULL;

    resdomen = "";
    est_domen = false;
    p = strchr(domenA.c_str(), '@');
    if (p != NULL)
        domen_t = TString(p + 1);
    if (!domen_t.empty()) {
        resdomen = domen_t;
        est_domen = true;

        m_MutexDomen.Acquire();

        ui64 shingle = 0;
        char sshingle[32];
        TString host_t = "";

        host_t = "domen_" + domen_t;

        calc_strcrc64(host_t.c_str(), host_t.length(), sshingle);
        sscanf(sshingle, "%lx", &shingle);

        m_Domen.Add(shingle, TCountValue(count));
        m_Domen.GetStat(shingle, res);

        m_MutexDomen.Release();
    }

    return res;
}

TCountAndIPValue CSoStore::GetDubLoginStat(TString& login) {
    TCountAndIPValue res(0, TKIPv6{});

    m_MutexDublicatLogin.Acquire();

    m_DublicatLogin.GetStat(Shingle(login), res);

    m_MutexDublicatLogin.Release();

    return res;
}

TCountAndIPValue CSoStore::AddGetDublicatLogin(TString& login, TKIPv6 ip) {
    TCountAndIPValue res(0, TKIPv6());

    m_MutexDublicatLogin.Acquire();

    m_DublicatLogin.Add2(Shingle(login), TCountAndIPValue(1, ip));
    m_DublicatLogin.GetStat(Shingle(login), res);

    m_MutexDublicatLogin.Release();

    return res;
}

//********************************************************************************************************************
